/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.utils;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DecimalProp;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.common.util.FaChangeItemUtil;

public class FaCardInitFieldUtil {
    public static final BigDecimal INIT_DECIMAL_VAL = new BigDecimal("-1");
    public static final long INIT_LONG_VAL = -1L;

    public static void restoreInitFields(DynamicObject card) {
        if (card == null) {
            return;
        }
        FaCardInitFieldUtil.restoreInitFields(new DynamicObject[]{card});
    }

    public static void restoreInitFields(DynamicObject[] cards) {
        if (cards == null || cards.length == 0) {
            return;
        }
        DynamicObjectType dt = cards[0].getDynamicObjectType();
        String entityName = dt.getName();
        Set initFields = FaChangeItemUtil.getAllInitFields((String)entityName);
        Arrays.stream(cards).forEach(v -> FaCardInitFieldUtil.restoreInitFieldsByCard(v, initFields));
    }

    private static void restoreInitFieldsByCard(DynamicObject card, Set<String> initFields) {
        DynamicObjectType dt = card.getDynamicObjectType();
        for (String field : initFields) {
            DynamicProperty property = dt.getProperty(field);
            if (property instanceof DecimalProp) {
                card.set(field, (Object)INIT_DECIMAL_VAL);
                continue;
            }
            if (!(property instanceof BasedataProp)) continue;
            card.set(Fa.id((String)field), (Object)-1L);
        }
    }
}

