/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.utils;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fa.business.depretask.DepreStatusEnum2;
import kd.fi.fa.business.po.FaDisDepreLogEntryInsertPo;
import kd.fi.fa.business.po.FaDisDepreLogEntryUpdatePo;
import kd.fi.fa.business.po.FaDisDepreLogPo;
import kd.fi.fa.business.po.FaDisDepreLogPo4Repair;
import kd.fi.fa.business.utils.FaConstants;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.common.util.ThrowableHelper;

public class FaDisDepreLogUtils {
    private static final Log logger = LogFactory.getLog(FaDisDepreLogUtils.class);
    private static String updateDisDepreLogIsNew = "update t_fa_disdepre_log set fisnew = '0' where fassetbookid = ? and fperiodid = ? and fismanual = '1' and ffromentityname='fa_new_depre' and fisnew = '1'";
    private static String updateDisDepreLogRate = "update t_fa_disdepre_log set fdepredcount = fdepredcount + ? where fid = ? ";
    private static String updateDisDepreLogEntry2Fail = "update t_fa_disdepre_task set fentrystatus = 'D'  where fid = ?  and fentrystatus = 'A'";
    private static String insertInitDisDepreLogEntry = "insert into t_fa_disdepre_task(fid,fbatchno,fids_tag,fentrystatus,fentryid) values(?,?,?,?,?)";
    private static String updateInitDisDepreLogEntry = "update t_fa_disdepre_task set fentrystatus = 'B',fconsumeinstance=?,fstarttime=? where fid = ? and fbatchno = ? and fentrystatus = 'A'";
    private static String insertDoingDisDepreLogEntry = "insert into t_fa_disdepre_task(fid,fbatchno,fids_tag,fentrystatus,fstarttime,fentryid) values(?,?,?,?,?,?)";
    private static String queryFailTaskCount = "select count(fentryid) count from t_fa_disdepre_task where fid = ? and fentrystatus in ('D','E')";
    private static String queryInitOrDoingTaskCount = "select count(fentryid) count from t_fa_disdepre_task where fid = ? and fentrystatus in ('A','B')";
    private static String updateDisDepreLogSubStatus = "update t_fa_disdepre_log set fsubstatus = '1' where fid = ? and fstatus = 'B' and fsubstatus = '0'";

    public static Long insertDisDepreLog(FaDisDepreLogPo logPo, boolean isNewTran) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"fa_disdepre_log");
        DynamicObject dailyDepreObj = new DynamicObject((DynamicObjectType)type);
        dailyDepreObj.set("org", (Object)logPo.getOrgId());
        dailyDepreObj.set("depreuse", (Object)logPo.getDepreUseId());
        dailyDepreObj.set("period", (Object)logPo.getPeriodId());
        dailyDepreObj.set("assetbook", (Object)logPo.getAssetbookId());
        if (logPo.getIsManual().booleanValue() && logPo.getFromentityname().equals("fa_new_depre")) {
            dailyDepreObj.set("isnew", (Object)"1");
        } else {
            dailyDepreObj.set("isnew", (Object)"0");
        }
        dailyDepreObj.set("status", (Object)DepreStatusEnum2.DOING.getValue());
        dailyDepreObj.set("allcount", (Object)logPo.getAllCount());
        dailyDepreObj.set("ismanual", (Object)logPo.getIsManual());
        dailyDepreObj.set("creator", (Object)logPo.getUserId());
        dailyDepreObj.set("fromentityname", (Object)logPo.getFromentityname());
        dailyDepreObj.set("createtime", (Object)new Date());
        dailyDepreObj.set("substatus", (Object)"0");
        dailyDepreObj.set("ismqdisdepre", (Object)logPo.getIsMqDisdepre());
        if (isNewTran) {
            Throwable throwable = null;
            try (TXHandle h = TX.requiresNew((String)"FaDisDepreLogUtils_insertDisDepreLog");){
                Long logId = FaDisDepreLogUtils.insertDisDepreLogDb(logPo, dailyDepreObj);
                h.commit();
                Long l = logId;
                return l;
            }
            catch (Throwable e) {
                try {
                    h.markRollback();
                    throw e;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
        return FaDisDepreLogUtils.insertDisDepreLogDb(logPo, dailyDepreObj);
    }

    public static void updateDisLogAllCount(Long disLogId, Integer allCount) {
        try (TXHandle h = TX.requiresNew((String)"FaDisDepreLogUtils_updateDisLogAllCount");){
            try {
                DynamicObject disLog = BusinessDataReader.loadSingle((Object)disLogId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fa_disdepre_log"));
                disLog.set("allcount", (Object)allCount);
                DynamicObject[] disLogArr = new DynamicObject[]{disLog};
                SaveServiceHelper.save((DynamicObject[])disLogArr);
                h.commit();
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
    }

    private static Long insertDisDepreLogDb(FaDisDepreLogPo logPo, DynamicObject dailyDepreObj) {
        if (logPo.getIsManual().booleanValue() && logPo.getFromentityname().equals("fa_new_depre")) {
            Object[] params = new Object[]{logPo.getAssetbookId(), logPo.getPeriodId()};
            DB.execute((DBRoute)DBRoute.of((String)"fa"), (String)updateDisDepreLogIsNew, (Object[])params);
        }
        Object[] rDataArr = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dailyDepreObj});
        DynamicObject rData = (DynamicObject)rDataArr[0];
        return rData.getLong("id");
    }

    public static void insertDisDepreLog4Repair(FaDisDepreLogPo4Repair logPo) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"fa_disdepre_log");
        DynamicObject dailyDepreObj = new DynamicObject((DynamicObjectType)type);
        dailyDepreObj.set("org", (Object)logPo.getOrgId());
        dailyDepreObj.set("depreuse", (Object)logPo.getDepreUseId());
        dailyDepreObj.set("period", (Object)logPo.getPeriodId());
        dailyDepreObj.set("assetbook", (Object)logPo.getAssetbookId());
        dailyDepreObj.set("isnew", (Object)"0");
        if (logPo.getEntryStatus() != null) {
            dailyDepreObj.set("status", (Object)logPo.getEntryStatus().getValue());
        }
        dailyDepreObj.set("ismanual", (Object)false);
        dailyDepreObj.set("creator", (Object)logPo.getUserId());
        dailyDepreObj.set("fromentityname", (Object)logPo.getFromentityname());
        dailyDepreObj.set("createtime", (Object)new Date());
        if (logPo.getResult() != null) {
            int resultSplitLength = logPo.getResult().length();
            if (resultSplitLength > 100) {
                resultSplitLength = 100;
            }
            dailyDepreObj.set("result", (Object)logPo.getResult().substring(0, resultSplitLength));
            dailyDepreObj.set("result_tag", (Object)logPo.getResult());
        }
        if (logPo.getComment() != null) {
            dailyDepreObj.set("comment", (Object)logPo.getComment());
        }
        try (TXHandle h = TX.requiresNew((String)"FaDisDepreLogUtils_insertDisDepreLog4Repair");){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dailyDepreObj});
                h.commit();
            }
            catch (Throwable e) {
                logger.error("\u63d2\u5165\u65e5\u5fd7\u5f02\u5e38", (Object)ThrowableHelper.toString((Throwable)e));
                h.markRollback();
            }
        }
    }

    public static void insertInitDisDepreLogEntry(FaDisDepreLogEntryInsertPo logEntryPo) {
        if (logEntryPo == null || logEntryPo.getId() == 0L) {
            return;
        }
        Object[] params = new Object[]{logEntryPo.getId(), logEntryPo.getBatchNo(), logEntryPo.getIds() == null ? " " : logEntryPo.getIds(), DepreStatusEnum2.INIT.getValue(), DB.genLongId((String)"fa_disdepre_log")};
        DB.execute((DBRoute)DBRoute.of((String)"fa"), (String)insertInitDisDepreLogEntry, (Object[])params);
    }

    public static int updateDisDepreLogEntryInit2Doing(Long disLogId, Integer batchNo, String consumeInstance, boolean isNewTran) {
        Object[] params = new Object[]{consumeInstance, new Date(), disLogId, batchNo};
        if (isNewTran) {
            Throwable throwable = null;
            try (TXHandle h = TX.requiresNew();){
                int count = DB.update((DBRoute)DBRoute.of((String)"fa"), (String)updateInitDisDepreLogEntry, (Object[])params);
                h.commit();
                int n = count;
                return n;
            }
            catch (Throwable e) {
                try {
                    h.markRollback();
                    throw e;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
        return DB.update((DBRoute)DBRoute.of((String)"fa"), (String)updateInitDisDepreLogEntry, (Object[])params);
    }

    public static void insertDoingDisDepreLogEntry(FaDisDepreLogEntryInsertPo logEntryPo) {
        if (logEntryPo == null || logEntryPo.getId() == 0L) {
            return;
        }
        Object[] params = new Object[]{logEntryPo.getId(), logEntryPo.getBatchNo(), logEntryPo.getIds() == null ? " " : logEntryPo.getIds(), DepreStatusEnum2.DOING.getValue(), new Date(), DB.genLongId((String)"fa_disdepre_log")};
        try (TXHandle h = TX.requiresNew((String)"FaDisDepreLogUtils_insertDisDepreLogEntry");){
            try {
                DB.execute((DBRoute)DBRoute.of((String)"fa"), (String)insertDoingDisDepreLogEntry, (Object[])params);
                h.commit();
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
    }

    public static void updateDisDepreLog4SubTask(FaDisDepreLogEntryUpdatePo logEntryPo, boolean isNewTran) {
        block26: {
            if (logEntryPo == null || logEntryPo.getId() == 0L) {
                return;
            }
            SqlBuilder sb = new SqlBuilder();
            sb.append("update t_fa_disdepre_task set ", new Object[0]);
            if (logEntryPo.getErrorLog() != null && logEntryPo.getErrorLog().length() != 0) {
                int splitLength = logEntryPo.getErrorLog().length();
                if (splitLength > 100) {
                    splitLength = 100;
                }
                sb.append("ferrorlog = ?,", new Object[]{logEntryPo.getErrorLog().substring(0, splitLength)});
                sb.append("ferrorlog_tag = ?,", new Object[]{logEntryPo.getErrorLog()});
            }
            if (logEntryPo.getConsumeInstance() != null) {
                sb.append("fconsumeinstance = ?,", new Object[]{logEntryPo.getConsumeInstance()});
            }
            if (logEntryPo.getEntryStatus().getValue().equals(DepreStatusEnum2.DOING.getValue())) {
                sb.append("fstarttime = ?,", new Object[]{new Date()});
            } else if (logEntryPo.getEntryStatus().getValue().equals(DepreStatusEnum2.SUC.getValue())) {
                sb.append("fids = ?,", new Object[]{" "});
                sb.append("fids_tag = ?,", new Object[]{" "});
                sb.append("fpercent = ?,", new Object[]{100L});
                sb.append("fendtime = ?,", new Object[]{new Date()});
            } else if (logEntryPo.getEntryStatus().getValue().equals(DepreStatusEnum2.INTERRUPT.getValue())) {
                sb.append("fids = ?,", new Object[]{" "});
                sb.append("fids_tag = ?,", new Object[]{" "});
                sb.append("fendtime = ?,", new Object[]{new Date()});
            } else if (logEntryPo.getEntryStatus().getValue().equals(DepreStatusEnum2.FAI.getValue())) {
                sb.append("fendtime = ?,", new Object[]{new Date()});
            }
            sb.append("fentrystatus = ?", new Object[]{logEntryPo.getEntryStatus().getValue()});
            sb.append(" where ", new Object[0]).append("fid = ?", new Object[]{logEntryPo.getId()}).append("and fbatchno = ?", new Object[]{logEntryPo.getBatchNo()});
            if (isNewTran) {
                try (TXHandle h = TX.requiresNew((String)"FaDisDepreLogUtils_updateDisDepreLog4SubTask");){
                    try {
                        FaDisDepreLogUtils.updateDisDepreLog4SubTask(sb, logEntryPo);
                        h.commit();
                        break block26;
                    }
                    catch (Throwable e) {
                        h.markRollback();
                        throw e;
                    }
                }
            }
            FaDisDepreLogUtils.updateDisDepreLog4SubTask(sb, logEntryPo);
        }
    }

    private static void updateDisDepreLog4SubTask(SqlBuilder updateTaskSb, FaDisDepreLogEntryUpdatePo logEntryPo) {
        DB.update((DBRoute)FaConstants.faDBRoute, (SqlBuilder)updateTaskSb);
        if (logEntryPo.getEntryStatus().getValue().equals(DepreStatusEnum2.SUC.getValue())) {
            Object[] params = new Object[]{logEntryPo.getCardCount(), logEntryPo.getId()};
            DB.execute((DBRoute)DBRoute.of((String)"fa"), (String)updateDisDepreLogRate, (Object[])params);
        } else if (logEntryPo.getEntryStatus().getValue().equals(DepreStatusEnum2.FAI.getValue())) {
            DB.execute((DBRoute)DBRoute.of((String)"fa"), (String)updateDisDepreLogEntry2Fail, (Object[])new Object[]{logEntryPo.getId()});
        }
    }

    public static void updateDisDepreLog4BillHead(Long disDepreId, DepreStatusEnum2 depreStatus, String result, boolean fromDoing, boolean isNewTran) {
        SqlBuilder updateDisDepreLogSb = new SqlBuilder();
        updateDisDepreLogSb.append("update t_fa_disdepre_log set ", new Object[0]);
        updateDisDepreLogSb.append("fstatus = ? ", new Object[]{depreStatus.getValue()});
        if (result != null) {
            int splitLength = result.length();
            if (splitLength > 100) {
                splitLength = 100;
            }
            updateDisDepreLogSb.append(",fresult = ? ", new Object[]{result.substring(0, splitLength)});
            updateDisDepreLogSb.append(",fresult_tag = ? ", new Object[]{result});
        }
        updateDisDepreLogSb.append(",fmodifytime = ? ", new Object[]{new Date()});
        updateDisDepreLogSb.append(",ffinishtime = ? ", new Object[]{new Date()});
        updateDisDepreLogSb.append("where fid = ? ", new Object[]{disDepreId});
        if (fromDoing) {
            updateDisDepreLogSb.append("and fstatus = 'B' ", new Object[0]);
        }
        if (isNewTran) {
            try (TXHandle h = TX.requiresNew((String)"FaDisDepreLogUtils_updateDisDepreLog4BillHead");){
                try {
                    DB.update((DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)updateDisDepreLogSb);
                    h.commit();
                }
                catch (Throwable e) {
                    h.markRollback();
                    if (DepreStatusEnum2.FAI.getValue().equals(depreStatus.getValue())) {
                        logger.error("\u63d2\u5165\u65e5\u5fd7\u5f02\u5e38", (Object)ThrowableHelper.toString((Throwable)e));
                    }
                    throw e;
                }
            }
        } else {
            DB.update((DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)updateDisDepreLogSb);
        }
    }

    public static void updateDisDepreLog4BillHeadOnError(Long disDepreId, Throwable throwable, boolean fromDoing, boolean isNewTran) {
        SqlBuilder updateDisDepreLogSb = new SqlBuilder();
        updateDisDepreLogSb.append("update t_fa_disdepre_log set ", new Object[0]);
        updateDisDepreLogSb.append("fstatus = ? ", new Object[]{DepreStatusEnum2.FAI.getValue()});
        String errMsg = throwable.getMessage();
        int splitLength = errMsg.length();
        if (splitLength > 100) {
            splitLength = 100;
        }
        updateDisDepreLogSb.append(",fresult = ? ", new Object[]{errMsg.substring(0, splitLength)});
        updateDisDepreLogSb.append(",fresult_tag = ? ", new Object[]{ThrowableHelper.toString((Throwable)throwable)});
        updateDisDepreLogSb.append(",fmodifytime = ? ", new Object[]{new Date()});
        updateDisDepreLogSb.append(",ffinishtime = ? ", new Object[]{new Date()});
        updateDisDepreLogSb.append("where fid = ? ", new Object[]{disDepreId});
        if (fromDoing) {
            updateDisDepreLogSb.append("and fstatus = 'B' ", new Object[0]);
        }
        if (isNewTran) {
            try (TXHandle h = TX.requiresNew((String)"FaDisDepreLogUtils_updateDisDepreLog4BillHead");){
                try {
                    DB.update((DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)updateDisDepreLogSb);
                    h.commit();
                }
                catch (Throwable e) {
                    h.markRollback();
                    logger.error("\u63d2\u5165\u65e5\u5fd7\u5f02\u5e38", (Object)ThrowableHelper.toString((Throwable)e));
                }
            }
        } else {
            DB.update((DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)updateDisDepreLogSb);
        }
    }

    public static int updateDisDepreLog4SubStatus(Long disDepreId) {
        Throwable throwable = null;
        try (TXHandle h = TX.requiresNew((String)"FaDisDepreLogUtils_updateDisDepreLog4SubStatus");){
            int count = DB.update((DBRoute)DBRoute.of((String)"fa"), (String)updateDisDepreLogSubStatus, (Object[])new Object[]{disDepreId});
            h.commit();
            int n = count;
            return n;
        }
        catch (Throwable e) {
            try {
                h.markRollback();
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public static boolean haveFailedTask(Long disDepreId) {
        try (DataSet dsCounts = DB.queryDataSet((String)"FaDisDepreLogUtils_isFailInEntry", (DBRoute)new DBRoute("fa"), (String)queryFailTaskCount, (Object[])new Object[]{disDepreId});){
            Long count = 0L;
            for (Row countRow : dsCounts) {
                count = countRow.getLong("count");
            }
            if (count > 0L) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public static boolean haveInitOrDoingTask(Long disDepreId) {
        try (DataSet dsCounts = DB.queryDataSet((String)"FaDisDepreLogUtils_isFailInEntry", (DBRoute)new DBRoute("fa"), (String)queryInitOrDoingTaskCount, (Object[])new Object[]{disDepreId});){
            Long count = 0L;
            for (Row countRow : dsCounts) {
                count = countRow.getLong("count");
            }
            if (count > 0L) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public static DynamicObject queryLastestDepreLog(Long bookid, Long periodId) {
        return QueryServiceHelper.queryOne((String)"fa_disdepre_log", (String)"assetbook,allcount,depredcount,creator,createtime,finishtime,status,result,result_tag", (QFilter[])new QFilter[]{new QFilter("assetbook", "=", (Object)bookid), new QFilter("period", "=", (Object)periodId), new QFilter("ismanual", "=", (Object)true), new QFilter("fromentityname", "=", (Object)"fa_new_depre"), new QFilter("isnew", "=", (Object)true)});
    }

    public static Map<Long, DynamicObject> queryLatestDepreLog4Batch(Map<Long, Set<Long>> periodIdBookIdsMap, String queryFields) {
        long startTime = System.currentTimeMillis();
        if (!queryFields.contains("assetbook")) {
            queryFields = Fa.comma((String[])new String[]{queryFields, "assetbook"});
        }
        HashMap<Long, DynamicObject> assetBookLogMap = new HashMap<Long, DynamicObject>();
        int assetBookSize = 0;
        for (Map.Entry<Long, Set<Long>> entry : periodIdBookIdsMap.entrySet()) {
            Long periodId = entry.getKey();
            Set<Long> assetBookIds = entry.getValue();
            assetBookSize += assetBookIds.size();
            DynamicObjectCollection logObjs = QueryServiceHelper.query((String)"fa_disdepre_log", (String)queryFields, (QFilter[])new QFilter[]{new QFilter("assetbook", "in", assetBookIds), new QFilter("period", "=", (Object)periodId), new QFilter("ismanual", "=", (Object)true), new QFilter("fromentityname", "=", (Object)"fa_new_depre"), new QFilter("isnew", "=", (Object)true)});
            if (logObjs == null || logObjs.isEmpty()) continue;
            for (DynamicObject log : logObjs) {
                Long assetBookId = log.getLong("assetbook");
                assetBookLogMap.put(assetBookId, log);
            }
        }
        logger.info("queryLatestDepreLog4Batch: assetBookSize[{}]; cost[{}]ms", (Object)assetBookSize, (Object)(System.currentTimeMillis() - startTime));
        return assetBookLogMap;
    }
}

