/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.fa.business.po.FaFindPeriodTreeNode;

public class FaFindPeriodHelper {
    private static final Log logger = LogFactory.getLog(FaFindPeriodHelper.class);
    private final Long periodTypeId;
    private FaFindPeriodTreeNode[] tree;
    private FaFindPeriodTreeNode[] allTreeNode;
    private int idx4Init = 0;
    private Map<Long, DynamicObject> periodMap;

    public FaFindPeriodHelper(Long periodTypeId) {
        if (periodTypeId == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u671f\u95f4\u7c7b\u578bid\u4e0d\u80fd\u4e3anull\u3002", (String)"FaFindPeriodHelper_0", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        this.periodTypeId = periodTypeId;
        this.initTree();
    }

    private void initTree() {
        this.allTreeNode = this.initAllTreeNode();
        this.tree = new FaFindPeriodTreeNode[this.allTreeNode.length + 1];
        if (this.allTreeNode.length == 0) {
            logger.info("\u6839\u636e\u671f\u95f4\u7c7b\u578bid[{}]\u672a\u627e\u5230\u4f1a\u8ba1\u671f\u95f4\u6570\u636e\u3002", (Object)this.periodTypeId);
            return;
        }
        this.buildTreeNode(1);
    }

    private void buildTreeNode(int nodeIndex) {
        if (nodeIndex * 2 < this.tree.length) {
            this.buildTreeNode(nodeIndex * 2);
        }
        this.tree[nodeIndex] = this.allTreeNode[this.idx4Init++];
        if (nodeIndex * 2 + 1 < this.tree.length) {
            this.buildTreeNode(nodeIndex * 2 + 1);
        }
    }

    private FaFindPeriodTreeNode[] initAllTreeNode() {
        SqlBuilder queryAllPeriod = new SqlBuilder();
        queryAllPeriod.append("select fid, fbegindate, fenddate from t_bd_period where ftypeid = ? and fisadjustperiod = '0' order by fid asc;", new Object[]{this.periodTypeId});
        String algoKey = this.getClass().getName();
        ArrayList<FaFindPeriodTreeNode> nodeList = new ArrayList<FaFindPeriodTreeNode>(200);
        try (DataSet allPeriod = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)queryAllPeriod);){
            for (Row row : allPeriod) {
                Long periodId = row.getLong("fid");
                Date beginDate = row.getDate("fbegindate");
                Date endDate = row.getDate("fenddate");
                FaFindPeriodTreeNode node = new FaFindPeriodTreeNode(periodId, beginDate, endDate);
                nodeList.add(node);
            }
        }
        return nodeList.toArray(new FaFindPeriodTreeNode[0]);
    }

    public Long findPeriodIdByDate(Date date) {
        if (this.allTreeNode.length == 0) {
            logger.info("\u6839\u636e\u671f\u95f4\u7c7b\u578bid[{}]\u672a\u627e\u5230\u4f1a\u8ba1\u671f\u95f4\u6570\u636e\uff0cdate=[{}]\u3002", (Object)this.periodTypeId, (Object)date);
            return 0L;
        }
        FaFindPeriodTreeNode node = this.findNode(1, date);
        if (node == null) {
            logger.info("\u672a\u627e\u5230\u671f\u95f4\u6570\u636e\uff0c\u53ef\u80fd\u662f\u672a\u7ef4\u5ea6\u5bf9\u5e94\u671f\u95f4\uff0c\u671f\u95f4\u7c7b\u578bid=[{}]\uff0cdate=[{}]\u3002", (Object)this.periodTypeId, (Object)date);
            return 0L;
        }
        return node.getPeriodId();
    }

    public FaFindPeriodTreeNode findPeriodTreeNodeByDate(Date date) {
        if (this.allTreeNode.length == 0) {
            logger.info("\u6839\u636e\u671f\u95f4\u7c7b\u578bid[{}]\u672a\u627e\u5230\u4f1a\u8ba1\u671f\u95f4\u6570\u636e\uff0cdate=[{}]\u3002", (Object)this.periodTypeId, (Object)date);
            return null;
        }
        FaFindPeriodTreeNode node = this.findNode(1, date);
        if (node == null) {
            logger.info("\u672a\u627e\u5230\u671f\u95f4\u6570\u636e\uff0c\u53ef\u80fd\u662f\u672a\u7ef4\u5ea6\u5bf9\u5e94\u671f\u95f4\uff0c\u671f\u95f4\u7c7b\u578bid=[{}]\uff0cdate=[{}]\u3002", (Object)this.periodTypeId, (Object)date);
            return null;
        }
        return node;
    }

    private FaFindPeriodTreeNode findNode(int index, Date date) {
        int compareResult = this.tree[index].compareWithDate(date);
        if (compareResult < 0) {
            if (index * 2 >= this.tree.length) {
                return null;
            }
            return this.findNode(index * 2, date);
        }
        if (compareResult > 0) {
            if (index * 2 + 1 >= this.tree.length) {
                return null;
            }
            return this.findNode(index * 2 + 1, date);
        }
        return this.tree[index];
    }

    public DynamicObject findPeriodObjByDate(Date date) {
        if (this.allTreeNode.length == 0) {
            logger.info("\u6839\u636e\u671f\u95f4\u7c7b\u578bid[{}]\u672a\u627e\u5230\u4f1a\u8ba1\u671f\u95f4\u6570\u636e\uff0cdate=[{}]\u3002", (Object)this.periodTypeId, (Object)date);
            return null;
        }
        if (this.periodMap == null) {
            this.initPeriodMap();
        }
        Long periodId = this.findPeriodIdByDate(date);
        return this.periodMap.get(periodId);
    }

    private void initPeriodMap() {
        ArrayList<Long> periodIdList = new ArrayList<Long>(this.allTreeNode.length);
        for (FaFindPeriodTreeNode node : this.allTreeNode) {
            periodIdList.add(node.getPeriodId());
        }
        DynamicObject[] periods = BusinessDataServiceHelper.load((Object[])periodIdList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_period"));
        this.periodMap = Arrays.stream(periods).collect(Collectors.toMap(v -> v.getLong("id"), v -> v));
    }
}

