/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.utils;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.workflow.component.ApprovalRecord;
import kd.fi.fa.business.billmapping.SelectParams;

public class FaFormUtils {
    private static final String COLSTREE_SELECT = "fa_colstree_select";

    public static void setModelHeadFromDO(IDataModel dataModel, DynamicObject source, Map<String, String> modelAndDOKey) {
        modelAndDOKey.forEach((modelKey, dyoKey) -> dataModel.setValue(modelKey, source.get(dyoKey)));
    }

    public static void setModelHeadFromDO(IDataModel dataModel, DynamicObject source, List<String> keys) {
        HashMap<String, String> modelAndDOKey = new HashMap<String, String>();
        keys.forEach(key -> modelAndDOKey.put((String)key, (String)key));
        FaFormUtils.setModelHeadFromDO(dataModel, source, modelAndDOKey);
    }

    public static void setModelEntryFromDOs(IDataModel dataModel, List<DynamicObject> sources, String modelEntryKey, Map<String, String> modelAndDOEntryKey) {
        sources.forEach(dyo -> {
            int index = dataModel.createNewEntryRow(modelEntryKey);
            modelAndDOEntryKey.forEach((modelKey, dyoKey) -> dataModel.setValue(modelKey, dyo.get(dyoKey), index));
        });
    }

    public static void setModelEntryFromDOs(IDataModel dataModel, DynamicObject[] sources, String modelEntryKey, Map<String, String> modelAndDOEntryKey) {
        FaFormUtils.setModelEntryFromDOs(dataModel, Arrays.stream(sources).collect(Collectors.toList()), modelEntryKey, modelAndDOEntryKey);
    }

    public static void setModelEntryFromDOs(IDataModel dataModel, DynamicObject[] sources, String modelEntryKey, List<String> entryKeys) {
        HashMap<String, String> entryKeysMap = new HashMap<String, String>();
        entryKeys.forEach(k -> entryKeysMap.put((String)k, (String)k));
        FaFormUtils.setModelEntryFromDOs(dataModel, Arrays.stream(sources).collect(Collectors.toList()), modelEntryKey, entryKeysMap);
    }

    public static void setModelEntryFromDO(IDataModel dataModel, DynamicObject source, String modelEntryKey, String dyoEntryKey, Map<String, String> modelAndDOEntryKey) {
        FaFormUtils.setModelEntryFromDOs(dataModel, (List<DynamicObject>)source.getDynamicObjectCollection(dyoEntryKey), modelEntryKey, modelAndDOEntryKey);
    }

    public static void setModelEntryFromDO(IDataModel dataModel, DynamicObject source, String modelEntryKey, String dyoEntryKey, List<String> entryKeys) {
        HashMap<String, String> entryKeysMap = new HashMap<String, String>();
        entryKeys.forEach(key -> entryKeysMap.put((String)key, (String)key));
        FaFormUtils.setModelEntryFromDO(dataModel, source, modelEntryKey, dyoEntryKey, entryKeysMap);
    }

    public static void showApprovalRecordByBillPKId(IFormView formView, String aprovalRecordControlKey, String pkId, boolean isPC) {
        ApprovalRecord approvalRecord = (ApprovalRecord)formView.getControl(aprovalRecordControlKey);
        approvalRecord.setBusinessKey(pkId);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("isPC", String.valueOf(isPC));
        approvalRecord.setParameters(parameters);
    }

    public static void updateCountLable(Label label, int count) {
        label.getView().setVisible(Boolean.valueOf(true), new String[]{label.getKey()});
        if (count < 1) {
            label.getView().setVisible(Boolean.valueOf(false), new String[]{label.getKey()});
        } else if (count < 10) {
            label.setText(String.valueOf(count));
        } else {
            label.setText("\u00b7\u00b7\u00b7");
        }
    }

    public static FormShowParameter readyColsTreePage(SelectParams params, CloseCallBack callBack) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(COLSTREE_SELECT);
        showParameter.getCustomParams().putAll(params.toMap());
        showParameter.setCloseCallBack(callBack);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        return showParameter;
    }
}

