/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.utils;

import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class FaFunctionMutexHelper {
    private static final String ALGO = "kd.fi.fa.business.utils.FaFunctionMutexHelper";
    private static final Log logger = LogFactory.getLog((String)"kd.fi.fa.business.utils.FaFunctionMutexHelper");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void lockWithBook(Long orgId, Long depreuseId, Runnable runnable) {
        DLock dLock = null;
        boolean success = false;
        try {
            String key = FaFunctionMutexHelper.key(orgId, depreuseId);
            dLock = DLock.create((String)key).fastMode();
            FaFunctionMutexHelper.tryToLock(dLock, key);
            success = true;
            try (TXHandle h = TX.required((String)key);){
                try {
                    FaFunctionMutexHelper.dbLock(key);
                    runnable.run();
                }
                catch (Exception e) {
                    h.markRollback();
                    throw e;
                }
            }
        }
        finally {
            if (dLock != null && success) {
                dLock.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void tryToLock(DLock dLock, String key) {
        boolean success = dLock.tryLock(1000L);
        int index = 0;
        while (!success && index < 300) {
            logger.info("\u7b2c" + index + "\u6b21\u83b7\u53d6\u9501\u5931\u8d25\uff0c\u6b63\u5728\u91cd\u8bd5\uff0c\u88ab\u9501\u4f4f\u7684fa\u5206\u5e03\u5f0f\u9501key: " + key);
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                logger.info("\u7ebf\u7a0b\u7b49\u5f85\u5f02\u5e38\uff1a" + e);
            }
            finally {
                ++index;
            }
        }
        if (!success) {
            logger.info("\u591a\u6b21\u5c1d\u8bd5\u83b7\u53d6\u9501\u5931\u8d25\uff0c\u88ab\u9501\u4f4f\u7684fa\u5206\u5e03\u5f0f\u9501key: " + key);
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6b63\u5728\u8fdb\u884c\u5206\u644a\uff0c\u8bf7\u7a0d\u540e\u518d\u6267\u884c\u6b64\u64cd\u4f5c\u3002", (String)"FaFunctionMutexHelper_0", (String)"fi-fa-business", (Object[])new Object[0]));
        }
    }

    private static void dbLock(String key) {
        DBRoute fa = DBRoute.of((String)"fa");
        if (!DB.execute((DBRoute)fa, (String)"update t_fa_transaction set fmodifytime = ? where fid= ?", (Object[])new Object[]{new Date(), key})) {
            DB.execute((DBRoute)fa, (String)"insert into t_fa_transaction(fid,fmodifytime) values(?,?)", (Object[])new Object[]{key, new Date()});
        }
    }

    public static String key(Long orgId, Long depreuseId) {
        return "fi/fa/" + orgId.toString() + "_" + depreuseId.toString();
    }

    public static void forceUnlock(String key) {
        DLock.forceUnlock((String[])new String[]{key});
    }
}

