/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.utils;

import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.dao.IFaFinCardDao;
import kd.fi.fa.business.dao.factory.FaFinCardDaoFactory;
import kd.fi.fa.business.dao.impl.IBizSetCardDataHandler;
import kd.fi.fa.business.utils.FaConstants;
import kd.fi.fa.common.util.Fa;

public class FaFutureChgFinRelUtils {
    private static String selectChgFinFields = Fa.comma((String[])new String[]{"id", "org", "depreuse", "chgdateperiod", "number"});
    private static final int DATA_SIZE = 999;

    public static void genCurPeriodFins4futurebus(Long assetBookId) {
        DynamicObject assetBook = BusinessDataServiceHelper.loadSingle((Object)assetBookId, (String)"fa_assetbook");
        Long orgId = assetBook.getLong("org.id");
        Long depreUseId = assetBook.getLong("depreuse.id");
        Long curPeriodId = assetBook.getLong("curperiod.id");
        Long periodtypeId = assetBook.getLong("periodtype.id");
        Long nextPeriodId = 0L;
        QFilter[] bdPeriodFilters = new QFilter[]{new QFilter("periodtype", "=", (Object)periodtypeId), new QFilter("isadjustperiod", "=", (Object)false), new QFilter("id", ">", (Object)curPeriodId)};
        DynamicObjectCollection nextPeriods = QueryServiceHelper.query((String)"bd_period", (String)"id", (QFilter[])bdPeriodFilters, (String)"id asc", (int)1);
        if (nextPeriods.size() == 1) {
            DynamicObject nextPeriod = (DynamicObject)nextPeriods.get(0);
            nextPeriodId = nextPeriod.getLong("id");
        }
        if (nextPeriodId.intValue() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5f53\u524d\u4f1a\u8ba1\u671f\u95f4\u7684\u4e0b\u4e00\u4e2a\u671f\u95f4\u6570\u636e\uff0c\u8bf7\u5148\u521d\u59cb\u5316\u4f1a\u8ba1\u671f\u95f4\u6570\u636e\u3002", (String)"FaFutureChgFinRelUtils_0", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        QFilter[] chgFinfilters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("depreuse", "=", (Object)depreUseId), new QFilter("chgdateperiod", "=", (Object)nextPeriodId), new QFilter("isgenfin", "=", (Object)"0"), new QFilter("isdeleted", "=", (Object)"0")};
        DynamicObjectCollection futureChgFinList = QueryServiceHelper.query((String)"fa_future_chg_fin_rel", (String)selectChgFinFields, (QFilter[])chgFinfilters);
        HashSet<String> numberSet = new HashSet<String>(futureChgFinList.size(), 1.0f);
        HashSet<Long> chgFinRelIdSet = new HashSet<Long>(futureChgFinList.size(), 1.0f);
        for (DynamicObject futureChgFin : futureChgFinList) {
            numberSet.add(futureChgFin.getString("number"));
            chgFinRelIdSet.add(futureChgFin.getLong("id"));
        }
        if (numberSet.size() == 0) {
            return;
        }
        int i = 0;
        HashSet<String> numSetTemp = new HashSet<String>(999, 1.0f);
        Iterator ite = numberSet.iterator();
        while (ite.hasNext()) {
            if (i == 999) {
                FaFutureChgFinRelUtils.handleFutureChgFin(assetBook, nextPeriodId, numSetTemp, chgFinRelIdSet);
                numSetTemp = new HashSet(999, 1.0f);
                i = 0;
                continue;
            }
            String number = (String)ite.next();
            numSetTemp.add(number);
            ++i;
        }
        if (!numSetTemp.isEmpty()) {
            FaFutureChgFinRelUtils.handleFutureChgFin(assetBook, nextPeriodId, numSetTemp, chgFinRelIdSet);
        }
    }

    private static void handleFutureChgFin(DynamicObject assetBook, Long nextPeriodId, Set<String> numSet, Set<Long> chgFinRelIdSet) {
        if (numSet.size() == 0) {
            return;
        }
        Long orgId = assetBook.getLong("org.id");
        Long depreUseId = assetBook.getLong("depreuse.id");
        Long assetBookId = assetBook.getLong("id");
        IFaFinCardDao fCardDao = FaFinCardDaoFactory.getInstance();
        IBizSetCardDataHandler handler = card -> FaFutureChgFinRelUtils.updateFin4chg(card);
        String[] selector = new String[]{"isneeddepre"};
        try (TXHandle h = TX.required((String)"handleFutureChgFin");){
            try {
                fCardDao.copyFinCards(orgId, assetBookId, depreUseId, nextPeriodId, numSet, handler, selector, null);
                SqlBuilder sb = new SqlBuilder();
                sb.append("update t_fa_future_chg_fin_rel set ", new Object[0]).append("fisgenfin = ?,", new Object[]{Character.valueOf('1')}).append("fmodifytime = ?", new Object[]{new Date()}).append(" where ", new Object[0]).appendIn("fid", chgFinRelIdSet.toArray());
                DB.update((DBRoute)FaConstants.faDBRoute, (SqlBuilder)sb);
                h.commit();
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
    }

    private static void updateFin4chg(DynamicObject card) {
        card.set("isneeddepre", (Object)"1");
    }
}

