/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.utils;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class FaGenBigDataUtils {
    private static final Log logger = LogFactory.getLog(FaGenBigDataUtils.class);

    public static void genCards(DynamicObject card, DynamicObject cate, int beginIndex, int endIndex, int totalAmount, List<DynamicObject> books) {
        long startTime = System.currentTimeMillis();
        ArrayList<DynamicObject> cardlist = new ArrayList<DynamicObject>(100);
        SimpleDateFormat formatMMddHHmm = new SimpleDateFormat("yyMMddHHmm");
        String timeStr = formatMMddHHmm.format(new Date());
        String number = card.getString("number");
        logger.info(String.format("------\u590d\u5236\u5b9e\u7269\u5f00\u59cb\uff1a%s,[%s,%s]\u4e00\u5171 %s \u5f20\u5b9e\u7269\u5361\u7247,\u5f00\u59cb", number, beginIndex, endIndex, totalAmount));
        for (int i = beginIndex; i < endIndex; ++i) {
            String addStr = timeStr + cate.getString("number") + i;
            DynamicObject cloneCard = (DynamicObject)new CloneUtils(true, true).clone((IDataEntityBase)card);
            cloneCard.set("billno", (Object)(card.get("billno") + "_" + addStr));
            cloneCard.set("barcode", (Object)(card.get("barcode") + "_" + addStr));
            cloneCard.set("billstatus", (Object)BillStatus.A.name());
            if (cate != null) {
                cloneCard.set("assetcat", (Object)cate);
            }
            cloneCard.set("number", (Object)(number + "_" + addStr));
            cloneCard.set("assetname", (Object)(number + "_" + addStr));
            cloneCard.set("masterid", null);
            cardlist.add(cloneCard);
        }
        long usedTime = System.currentTimeMillis() - startTime;
        logger.info(String.format("------\u7528\u65f6\uff1a---\u6279\u91cf\u751f\u6210\u5b9e\u7269  %s,[%s,%s]\u4e00\u5171 %s \u5f20\u5b9e\u7269\u5361\u7247\uff0c\u751f\u6210\u5df2\u5ba1\u6838\u7684\u8d22\u52a1\u5361\u7247\uff0c\u603b\u8017\u65f6\uff1a%s  ms\uff01", number, beginIndex, endIndex, totalAmount, usedTime));
        try (TXHandle h1 = TX.requiresNew();){
            try {
                OperationResult result = OperationServiceHelper.executeOperate((String)"submit", (String)"fa_initcard_real", (DynamicObject[])cardlist.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
                if (!result.isSuccess()) {
                    List allError = result.getAllErrorOrValidateInfo();
                    result.getAllErrorInfo();
                    StringBuilder errorInfo = new StringBuilder();
                    if (!CollectionUtils.isEmpty((Collection)allError)) {
                        for (IOperateInfo in : allError) {
                            errorInfo.append(in.getMessage());
                        }
                    }
                    throw new KDBizException(new LocaleString(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5b9e\u7269\u5361\u7247\u5931\u8d25 %1$s-%2$s\u3002", (String)"FaGenBigDataUtils_0", (String)"fi-fa-business", (Object[])new Object[0]), result.getMessage(), errorInfo.toString())).toString());
                }
                usedTime = System.currentTimeMillis() - startTime;
                logger.info(String.format("------\u7528\u65f6\uff1a---\u6279\u91cf\u4fdd\u5b58\u5b9e\u7269\u5361\u7247  %s,[%s,%s]\u4e00\u5171 %s \u5f20\u5b9e\u7269\u5361\u7247\uff0c\u751f\u6210\u5df2\u5ba1\u6838\u7684\u8d22\u52a1\u5361\u7247\uff0c\u603b\u8017\u65f6\uff1a%s  ms\uff01", number, beginIndex, endIndex, totalAmount, usedTime));
                Long orgid = card.getLong("org.id");
                if (result.isSuccess()) {
                    Object[] toAuditDataIdArray = result.getSuccessPkIds().toArray(new Long[0]);
                    MainEntityType realtype = EntityMetadataCache.getDataEntityType((String)"fa_initcard_real");
                    DynamicObject[] toAuditData = BusinessDataServiceHelper.load((Object[])toAuditDataIdArray, (DynamicObjectType)realtype);
                    usedTime = System.currentTimeMillis() - startTime;
                    logger.info(String.format("------\u7528\u65f6\uff1a---\u83b7\u53d6\u5f85\u5ba1\u6279\u5b9e\u7269\u5361\u7247  %s,[%s,%s]\u4e00\u5171 %s \u5f20\u5b9e\u7269\u5361\u7247\uff0c\u751f\u6210\u5df2\u5ba1\u6838\u7684\u8d22\u52a1\u5361\u7247\uff0c\u603b\u8017\u65f6\uff1a%s  ms\uff01", number, beginIndex, endIndex, totalAmount, usedTime));
                    OperationResult result2 = OperationServiceHelper.executeOperate((String)"audit", (String)"fa_initcard_real", (DynamicObject[])toAuditData, (OperateOption)OperateOption.create());
                    if (!result2.isSuccess()) {
                        List allError = result2.getAllErrorOrValidateInfo();
                        result2.getAllErrorInfo();
                        StringBuilder errorInfo = new StringBuilder();
                        if (!CollectionUtils.isEmpty((Collection)allError)) {
                            for (IOperateInfo in : allError) {
                                errorInfo.append(in.getMessage());
                            }
                        }
                        throw new KDBizException(new LocaleString(String.format(ResManager.loadKDString((String)"\u5ba1\u6838\u5b9e\u7269\u5361\u7247\u5931\u8d25 %1$s-%2$s\u3002", (String)"FaGenBigDataUtils_1", (String)"fi-fa-business", (Object[])new Object[0]), result.getMessage(), errorInfo.toString())).toString());
                    }
                    usedTime = System.currentTimeMillis() - startTime;
                    logger.info(String.format("------\u7528\u65f6\uff1a---\u6279\u91cf\u5ba1\u6279\u5b9e\u7269\u5361\u7247  %s,[%s,%s]\u4e00\u5171 %s \u5f20\u5b9e\u7269\u5361\u7247\uff0c\u751f\u6210\u5df2\u5ba1\u6838\u7684\u8d22\u52a1\u5361\u7247\uff0c\u603b\u8017\u65f6\uff1a%s  ms\uff01", number, beginIndex, endIndex, totalAmount, usedTime));
                    for (DynamicObject book : books) {
                        DynamicObject[] toEditFinCardData;
                        QFilter[] carFinFilter = new QFilter[]{new QFilter("realcard", "in", (Object)toAuditDataIdArray), new QFilter("billstatus", "=", (Object)"A"), new QFilter("depreuse", "=", book.get("depreuse"))};
                        DynamicObjectCollection FaInitFinCardIds = QueryServiceHelper.query((String)"fa_initcard_fin", (String)"id", (QFilter[])carFinFilter);
                        Object[] FaInitFinCardArray = new Long[FaInitFinCardIds.size()];
                        for (int i = 0; i < FaInitFinCardIds.size(); ++i) {
                            FaInitFinCardArray[i] = ((DynamicObject)FaInitFinCardIds.get(i)).getLong("id");
                        }
                        MainEntityType finCardtype = EntityMetadataCache.getDataEntityType((String)"fa_initcard_fin");
                        for (DynamicObject finCard : toEditFinCardData = BusinessDataServiceHelper.load((Object[])FaInitFinCardArray, (DynamicObjectType)finCardtype)) {
                            finCard.set("originalval", (Object)8000L);
                        }
                        usedTime = System.currentTimeMillis() - startTime;
                        logger.info(String.format("------\u7528\u65f6\uff1a---\u6279\u91cf\u83b7\u53d6\u5f85\u63d0\u4ea4\u8d22\u52a1\u5361\u7247  %s,[%s,%s]\u4e00\u5171 %s \u5f20\u5b9e\u7269\u5361\u7247\uff0c\u751f\u6210\u5df2\u5ba1\u6838\u7684\u8d22\u52a1\u5361\u7247\uff0c\u603b\u8017\u65f6\uff1a%s  ms\uff01", number, beginIndex, endIndex, totalAmount, usedTime));
                        OperationResult result3 = OperationServiceHelper.executeOperate((String)"submit", (String)"fa_initcard_fin", (DynamicObject[])toEditFinCardData, (OperateOption)OperateOption.create());
                        if (!result3.isSuccess()) {
                            List allError = result3.getAllErrorOrValidateInfo();
                            result3.getAllErrorInfo();
                            StringBuilder errorInfo = new StringBuilder();
                            if (!CollectionUtils.isEmpty((Collection)allError)) {
                                for (IOperateInfo in : allError) {
                                    errorInfo.append(in.getMessage());
                                }
                            }
                            throw new KDBizException(new LocaleString(String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u8d22\u52a1\u5361\u7247\u5931\u8d25 %1$s-%2$s\u3002", (String)"FaGenBigDataUtils_2", (String)"fi-fa-business", (Object[])new Object[0]), result.getMessage(), errorInfo.toString())).toString());
                        }
                        usedTime = System.currentTimeMillis() - startTime;
                        logger.info(String.format("------\u7528\u65f6\uff1a---\u6279\u91cf\u63d0\u4ea4\u8d22\u52a1\u5361\u7247   %s,[%s,%s]\u4e00\u5171 %s \u5f20\u5b9e\u7269\u5361\u7247\uff0c\u751f\u6210\u5df2\u5ba1\u6838\u7684\u8d22\u52a1\u5361\u7247\uff0c\u603b\u8017\u65f6\uff1a%s  ms\uff01", number, beginIndex, endIndex, totalAmount, usedTime));
                        OperationResult result4 = OperationServiceHelper.executeOperate((String)"audit", (String)"fa_initcard_fin", (DynamicObject[])toEditFinCardData, (OperateOption)OperateOption.create());
                        if (result4.isSuccess()) continue;
                        List allError = result4.getAllErrorOrValidateInfo();
                        result4.getAllErrorInfo();
                        StringBuilder errorInfo = new StringBuilder();
                        if (!CollectionUtils.isEmpty((Collection)allError)) {
                            for (IOperateInfo in : allError) {
                                errorInfo.append(in.getMessage());
                            }
                        }
                        throw new KDBizException(new LocaleString(String.format(ResManager.loadKDString((String)"\u5ba1\u6838\u8d22\u52a1\u5361\u7247\u5931\u8d25 %1$s-%2$s\u3002", (String)"FaGenBigDataUtils_3", (String)"fi-fa-business", (Object[])new Object[0]), result.getMessage(), errorInfo.toString())).toString());
                    }
                }
            }
            catch (Throwable e) {
                h1.markRollback();
                throw e;
            }
        }
        usedTime = System.currentTimeMillis() - startTime;
        logger.info(String.format("------\u7528\u65f6\uff1a---\u6279\u91cf\u5ba1\u6838\u8d22\u52a1\u5361\u7247   %s,[%s,%s]\u4e00\u5171 %s \u5f20\u5b9e\u7269\u5361\u7247\uff0c\u751f\u6210\u5df2\u5ba1\u6838\u7684\u8d22\u52a1\u5361\u7247\uff0c\u603b\u8017\u65f6\uff1a%s  ms\uff01", number, beginIndex, endIndex, totalAmount, usedTime));
    }
}

