/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;

public class FaMonthAccumDepreChgUpgradeUtils {
    public static final String FaMonthAccumDepreChgUpgradeService = "FaMonthAccumDepreChgUp2ClearGradeService";

    public static void upgradeAccumDepre2ClearBill() {
        String countNumSql = "select count(FEntrysID) as countNum from T_FA_CLRBILLENTRY_D";
        Long countNum = 0L;
        try (DataSet clrEntryDs = DB.queryDataSet((String)"upgradeAccumDepre2ClearBill", (DBRoute)DBRoute.of((String)"fa"), (String)countNumSql);){
            for (Row clrEntry : clrEntryDs) {
                countNum = clrEntry.getLong("countNum");
            }
        }
        if (countNum > 1000000L) {
            Calendar calendar = Calendar.getInstance();
            Integer year = calendar.get(1);
            FaMonthAccumDepreChgUpgradeUtils.upgradeAccumDepre2ClearBill(year - 1, year);
        } else {
            FaMonthAccumDepreChgUpgradeUtils.upgradeAccumDepre2ClearBill(null, null);
        }
    }

    public static void upgradeAccumDepre2ClearBill(Integer startYear, Integer endYear) {
        ArrayList<Long> orgIdList = new ArrayList<Long>(100);
        if (startYear != null) {
            String queryBookSql = " select FORGID orgId from t_fa_assetbook";
            try (DataSet bookDs = DB.queryDataSet((String)"upgradeAccumDepre2Fin_queryBook", (DBRoute)DBRoute.of((String)"fa"), (String)queryBookSql);){
                for (Object book : bookDs) {
                    orgIdList.add(book.getLong("orgId"));
                }
            }
        }
        HashSet<Long> upgradedIdSet = new HashSet<Long>(150000);
        SqlBuilder queryUpgradedSql = new SqlBuilder();
        queryUpgradedSql.append("select fupgradedid from t_fa_upgraded_data ", new Object[0]);
        queryUpgradedSql.append(" where fpurpose = ? ", new Object[]{FaMonthAccumDepreChgUpgradeService});
        queryUpgradedSql.append(" and fupgradedentieyname = ? ", new Object[]{"fa_clearbill"});
        DataSet bookDs = DB.queryDataSet((String)"upgradeAccumDepre2Fin_queryUpgradedSql", (DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)queryUpgradedSql);
        Object object = null;
        try {
            for (Row book : bookDs) {
                upgradedIdSet.add(book.getLong("fupgradedid"));
            }
        }
        catch (Throwable book) {
            object = book;
            throw book;
        }
        finally {
            if (bookDs != null) {
                if (object != null) {
                    try {
                        bookDs.close();
                    }
                    catch (Throwable book) {
                        ((Throwable)object).addSuppressed(book);
                    }
                } else {
                    bookDs.close();
                }
            }
        }
        SqlBuilder queryClearSql = new SqlBuilder();
        queryClearSql.append("select t.fid,t.fclearperiodid,d.faddupdepre,d.frealcardid,d.fdepreuseid ", new Object[0]);
        queryClearSql.append("from t_fa_clrbill t,t_fa_clrbillentry_d d ", new Object[0]);
        queryClearSql.append("where t.fid = d.fid and t.fbillstatus = 'C' ", new Object[0]);
        if (startYear != null && orgIdList.size() > 0) {
            queryClearSql.appendIn("and forgid ", orgIdList.toArray());
            Calendar calendar = Calendar.getInstance();
            calendar.set(1, startYear);
            calendar.set(6, 1);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            Date beginDate = calendar.getTime();
            calendar.set(1, endYear + 1);
            calendar.set(6, 1);
            Date endDate = calendar.getTime();
            queryClearSql.append(" and t.fcleardate >= ? ", new Object[]{beginDate});
            queryClearSql.append("and t.fcleardate < ? ", new Object[]{endDate});
        }
        HashMap clrPeriod2DataMap = new HashMap(1000);
        HashMap<Long, HashSet<Long>> clrPeriod2UpgradIdMap = new HashMap<Long, HashSet<Long>>(1000);
        try (DataSet dsExitSum = DB.queryDataSet((String)"upgradeAccumDepre2Fin_queryClear", (DBRoute)new DBRoute("fa"), (SqlBuilder)queryClearSql);){
            for (Row rowExistSum : dsExitSum) {
                Long clearbillId = rowExistSum.getLong("fid");
                if (upgradedIdSet.contains(clearbillId)) continue;
                Long clearPeriodId = rowExistSum.getLong("fclearperiodid");
                ArrayList<Object[]> updateDataParamter = (ArrayList<Object[]>)clrPeriod2DataMap.get(clearPeriodId);
                if (updateDataParamter == null) {
                    updateDataParamter = new ArrayList<Object[]>(10000);
                    clrPeriod2DataMap.put(clearPeriodId, updateDataParamter);
                }
                Object realMasterId = rowExistSum.get("frealcardid");
                Object depreuseid = rowExistSum.get("fdepreuseid");
                Object clrAccunDepre = rowExistSum.get("faddupdepre");
                updateDataParamter.add(new Object[]{clrAccunDepre, realMasterId, depreuseid, clearPeriodId});
                HashSet<Long> clearbillIds = (HashSet<Long>)clrPeriod2UpgradIdMap.get(clearPeriodId);
                if (clearbillIds == null) {
                    clearbillIds = new HashSet<Long>(10000);
                    clrPeriod2UpgradIdMap.put(clearPeriodId, clearbillIds);
                }
                clearbillIds.add(rowExistSum.getLong("fid"));
            }
        }
        for (Map.Entry entry : clrPeriod2DataMap.entrySet()) {
            FaMonthAccumDepreChgUpgradeUtils.updateFinForAPeriod2Clear((Long)entry.getKey(), (List)entry.getValue(), (Set)clrPeriod2UpgradIdMap.get(entry.getKey()));
        }
    }

    private static void updateFinForAPeriod2Clear(Long clearPeriodId, List<Object[]> parameters, Set<Object> clearbillIds) {
        ArrayList<Object[]> upGradedIdsParamter = null;
        if (clearbillIds != null && clearbillIds.size() > 0) {
            upGradedIdsParamter = new ArrayList<Object[]>(clearbillIds.size());
            long[] ids = DB.genLongIds((String)"t_fa_upgraded_data", (int)clearbillIds.size());
            int i = 0;
            for (Object clearbillId : clearbillIds) {
                upGradedIdsParamter.add(new Object[]{ids[i], clearbillId, "fa_clearbill", FaMonthAccumDepreChgUpgradeService});
                ++i;
            }
        }
        if (parameters.size() > 0) {
            try (TXHandle h = TX.requiresNew();){
                try {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"fa"), (String)"update t_fa_card_fin set fmonthaccumdeprechg = fmonthaccumdeprechg - ?  where frealcardmasterid = ? and fdepreuseid = ? and fbizperiodid = ? ", parameters);
                    if (upGradedIdsParamter != null && upGradedIdsParamter.size() > 0) {
                        DB.executeBatch((DBRoute)DBRoute.of((String)"fa"), (String)"insert into t_fa_upgraded_data(fid,fupgradedid,fupgradedentieyname,fpurpose) values(?,?,?,?)", upGradedIdsParamter);
                    }
                    h.commit();
                }
                catch (Throwable e) {
                    h.markRollback();
                    throw e;
                }
            }
        }
    }

    public static void upgradeAccumDepre2SplitBill() {
        SqlBuilder querySplitSql = new SqlBuilder();
        querySplitSql.append("select a.frealcardid,a.fdepreuseid,t.fsplitperiod,a.faccumdepre befaccumdepre,d.faccumdepre aftaccumdepre ", new Object[0]).append("from t_fa_assetsplitbill t,t_fa_assetsplitentry a,t_fa_assetsplitentry_d d,t_fa_card_fin f ", new Object[0]).append(" where t.fid = a.fid and a.fentryid = d.fentryid ", new Object[0]).append(" and t.fbillstatus = 'C' ", new Object[0]).append(" and a.frealcardid = d.frealcardid and a.fdepreuseid = d.fdepreuseid", new Object[0]).append(" and a.frealcardid = f.frealcardmasterid and a.fdepreuseid = f.fdepreuseid and t.fsplitperiod = f.fbizperiodid", new Object[0]).append(" and f.fmonthaccumdeprechg  = 0 ", new Object[0]);
        HashMap splitPeriod2DataMap = new HashMap(1000);
        try (DataSet splitDs = DB.queryDataSet((String)"upgradeAccumDepre2SplitBill", (DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)querySplitSql);){
            for (Row splitRow : splitDs) {
                Long splitperiod = splitRow.getLong("fsplitperiod");
                ArrayList<Object[]> updateDataParamter = (ArrayList<Object[]>)splitPeriod2DataMap.get(splitperiod);
                if (updateDataParamter == null) {
                    updateDataParamter = new ArrayList<Object[]>(10000);
                    splitPeriod2DataMap.put(splitperiod, updateDataParamter);
                }
                Object realMasterId = splitRow.get("frealcardid");
                Object depreuseid = splitRow.get("fdepreuseid");
                BigDecimal befaccumdepre = (BigDecimal)splitRow.get("befaccumdepre");
                BigDecimal aftaccumdepre = (BigDecimal)splitRow.get("aftaccumdepre");
                updateDataParamter.add(new Object[]{befaccumdepre.subtract(aftaccumdepre), realMasterId, depreuseid, splitperiod});
            }
        }
        for (Map.Entry entry : splitPeriod2DataMap.entrySet()) {
            FaMonthAccumDepreChgUpgradeUtils.updateFinForAPeriod2Split((List)entry.getValue());
        }
    }

    private static void updateFinForAPeriod2Split(List<Object[]> parameters) {
        if (parameters.size() > 0) {
            try (TXHandle h = TX.requiresNew();){
                try {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"fa"), (String)"update t_fa_card_fin set fmonthaccumdeprechg = fmonthaccumdeprechg - ?  where frealcardmasterid = ? and fdepreuseid = ? and fbizperiodid = ? ", parameters);
                    h.commit();
                }
                catch (Throwable e) {
                    h.markRollback();
                    throw e;
                }
            }
        }
    }
}

