/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.fa.business.dao.factory.FaBaseDaoFactory;

public class FaPeriodUtils {
    public static final Log logger = LogFactory.getLog(FaPeriodUtils.class);

    public static int compare2period(long periodId1, long periodId2) {
        int result = 1;
        DynamicObject period1 = FaBaseDaoFactory.getInstance("bd_period").queryOne(periodId1);
        DynamicObject period2 = FaBaseDaoFactory.getInstance("bd_period").queryOne(periodId2);
        logger.info(String.format("\u6bd4\u8f83\u8fd9\u4e24\u4e2a\u4f1a\u8ba1\u671f\u95f4\uff1a%s(%s~%s)?%s(%s~%s)", period1.get("name"), period1.get("begindate"), period1.get("enddate"), period2.get("name"), period2.get("begindate"), period2.get("enddate")));
        if (period1.get("begindate").equals(period2.get("begindate")) && period1.get("enddate").equals(period2.get("enddate"))) {
            result = 0;
        } else if (period1.getDate("begindate").after(period2.getDate("enddate")) || period1.get("begindate").equals(period2.get("enddate"))) {
            result = 1;
        } else if (period1.getDate("enddate").before(period2.getDate("begindate")) || period1.get("enddate").equals(period2.get("begindate"))) {
            result = -1;
        } else {
            result = 100;
            logger.info(String.format("\u65e0\u6cd5\u6bd4\u8f83\u8fd9\u4e24\u4e2a\u4f1a\u8ba1\u671f\u95f4\uff1a%s(%s~%s)?%s(%s~%s)", period1.get("name"), period1.get("begindate"), period1.get("enddate"), period2.get("name"), period2.get("begindate"), period2.get("enddate")));
        }
        return result;
    }

    public static List<Long> getPeriodIdByRange(long periodIdStart, long periodIdEnd) {
        DynamicObject periodStart = FaBaseDaoFactory.getInstance("bd_period").queryOne(periodIdStart);
        DynamicObject periodEnd = FaBaseDaoFactory.getInstance("bd_period").queryOne(periodIdEnd);
        DynamicObject[] periods = FaBaseDaoFactory.getInstance("bd_period").query("id", new QFilter[]{new QFilter("periodtype", "=", periodStart.getDynamicObject("periodtype").getPkValue()), new QFilter("begindate", ">=", (Object)periodStart.getDate("begindate")), new QFilter("enddate", "<=", (Object)periodEnd.getDate("enddate"))});
        ArrayList<Long> result = new ArrayList<Long>(periods.length);
        for (DynamicObject elem : periods) {
            result.add((Long)elem.getPkValue());
        }
        return result;
    }

    public static List<Long> getSameYearPeriod(DynamicObject period) {
        List<Long> result = new ArrayList<Long>();
        Long Year = period.getLong("periodyear");
        Long periodTypeId = period.getDynamicObject("periodtype").getLong("id");
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("periodyear", "=", (Object)Year));
        filters.add(new QFilter("periodtype", "=", (Object)periodTypeId));
        QFilter[] filterArr = filters.toArray(new QFilter[0]);
        String selectFields = String.join((CharSequence)",", "id");
        DynamicObjectCollection periodDys = QueryServiceHelper.query((String)"bd_period", (String)selectFields, (QFilter[])filterArr);
        if (periodDys.size() > 0) {
            result = periodDys.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        }
        return result;
    }

    public static List<QFilter> getSameYearClearPeriodFilters(Object orgId, DynamicObject period) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("billstatus", "=", (Object)BillStatus.C.toString()));
        filters.add(new QFilter("org", "=", orgId));
        filters.add(new QFilter("clearperiod", "<=", period.getPkValue()));
        List<Long> periodIds = FaPeriodUtils.getSameYearPeriod(period);
        if (periodIds.size() > 0) {
            Long maxPeriod = Collections.max(periodIds);
            Long minPeriod = Collections.min(periodIds);
            filters.add(new QFilter("clearperiod", "<=", (Object)maxPeriod));
            filters.add(new QFilter("clearperiod", ">=", (Object)minPeriod));
        } else {
            filters.add(new QFilter("clearperiod", "in", periodIds));
        }
        return filters;
    }

    public static Long getPreviousPeriodId(Long curPeriodId, Long periodtypeId) {
        QFilter[] filters = new QFilter[]{new QFilter("periodtype", "=", (Object)periodtypeId), new QFilter("id", "<", (Object)curPeriodId), new QFilter("isadjustperiod", "=", (Object)"0")};
        DynamicObjectCollection periods = QueryServiceHelper.query((String)"bd_period", (String)"id", (QFilter[])filters, (String)"id desc", (int)1);
        if (periods.size() > 0) {
            return ((DynamicObject)periods.get(0)).getLong("id");
        }
        return -1L;
    }

    public static List<Object> getLessEqualsCuPeriods(DynamicObject curPeriod) {
        QFilter[] filters = new QFilter[]{new QFilter("periodtype", "=", (Object)curPeriod.getLong("periodtype.id")), new QFilter("id", "<=", (Object)curPeriod.getLong("id")), new QFilter("periodyear", "=", (Object)curPeriod.getLong("periodyear")), new QFilter("isadjustperiod", "=", (Object)"0")};
        List ids = QueryServiceHelper.queryPrimaryKeys((String)"bd_period", (QFilter[])filters, null, (int)12);
        return ids;
    }

    public static List<Object> getLessCuPeriods(Long periodTypeId, Long curPeriodId, Long periodYear) {
        QFilter[] filters = new QFilter[]{new QFilter("periodtype", "=", (Object)periodTypeId), new QFilter("id", "<", (Object)curPeriodId), new QFilter("periodyear", "=", (Object)periodYear), new QFilter("isadjustperiod", "=", (Object)"0")};
        List ids = QueryServiceHelper.queryPrimaryKeys((String)"bd_period", (QFilter[])filters, null, (int)12);
        return ids;
    }

    public static Map<String, Long[]> getAssetBookPeriodMap(DynamicObjectCollection assetBooks, Date billDate) {
        HashMap<String, Long[]> orgDepreUse2PeriodMap = new HashMap<String, Long[]>(16);
        for (DynamicObject assetBook : assetBooks) {
            Long periodtypeId = assetBook.getLong("periodtype");
            Long[] curchg_prev_Period = new Long[2];
            long curChgPeriodId = assetBook.getLong("curperiod");
            if (billDate != null) {
                QFilter[] bdPeriodFilters2 = new QFilter[]{new QFilter("periodtype", "=", (Object)periodtypeId), new QFilter("isadjustperiod", "=", (Object)false), new QFilter("begindate", "<=", (Object)billDate), new QFilter("enddate", ">=", (Object)billDate)};
                List chgPeriodList = QueryServiceHelper.queryPrimaryKeys((String)"bd_period", (QFilter[])bdPeriodFilters2, null, (int)1);
                if (chgPeriodList == null || chgPeriodList.size() == 0) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bb0\u8d26\u65e5\u671f\u201c%1$s\u201d\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u671f\u95f4\u3002", (String)"FaPeriodUtils_0", (String)"fi-fa-business", (Object[])new Object[0]), billDate));
                }
                curChgPeriodId = (Long)chgPeriodList.get(0);
            }
            String key = assetBook.getString("org") + "_" + assetBook.getString("depreuse");
            curchg_prev_Period[0] = curChgPeriodId;
            QFilter[] bdPeriodFilters = new QFilter[]{new QFilter("periodtype", "=", (Object)periodtypeId), new QFilter("isadjustperiod", "=", (Object)false), new QFilter("id", "<", (Object)curChgPeriodId)};
            DynamicObjectCollection allPeriods = QueryServiceHelper.query((String)"bd_period", (String)"id", (QFilter[])bdPeriodFilters, (String)"id desc", (int)1);
            if (allPeriods.size() == 1) {
                DynamicObject prevPeriod = (DynamicObject)allPeriods.get(0);
                curchg_prev_Period[1] = prevPeriod.getLong("id");
            } else {
                curchg_prev_Period[1] = 0L;
            }
            orgDepreUse2PeriodMap.put(key, curchg_prev_Period);
        }
        return orgDepreUse2PeriodMap;
    }

    public static DynamicObject getFirstYearPeriod(DynamicObject period) {
        Long Year = period.getLong("periodyear");
        Long periodTypeId = period.getDynamicObject("periodtype").getLong("id");
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("periodyear", "=", (Object)Year));
        filters.add(new QFilter("periodtype", "=", (Object)periodTypeId));
        filters.add(new QFilter("periodnumber", "=", (Object)1));
        QFilter[] filterArr = filters.toArray(new QFilter[0]);
        String selectFields = String.join((CharSequence)",", "idnumber");
        DynamicObject periodDy = BusinessDataServiceHelper.loadSingle((String)"bd_period", (String)selectFields, (QFilter[])filterArr);
        return periodDy;
    }

    public static Long getBeforePeriodId(Long curPeriodId, Long periodtypeId, int distance) {
        QFilter[] filters = new QFilter[]{new QFilter("periodtype", "=", (Object)periodtypeId), new QFilter("id", "<", (Object)curPeriodId), new QFilter("isadjustperiod", "=", (Object)"0")};
        DynamicObjectCollection periods = QueryServiceHelper.query((String)"bd_period", (String)"id", (QFilter[])filters, (String)"id desc", (int)distance);
        if (periods.size() == distance) {
            return ((DynamicObject)periods.get(distance - 1)).getLong("id");
        }
        return -1L;
    }

    public static Long getYearMinPeriodId(Long curPeriodId, Long periodtypeId, Long year) {
        QFilter[] filters = new QFilter[]{new QFilter("periodtype", "=", (Object)periodtypeId), new QFilter("id", "<=", (Object)curPeriodId), new QFilter("periodyear", "=", (Object)year), new QFilter("isadjustperiod", "=", (Object)"0")};
        List ids = QueryServiceHelper.queryPrimaryKeys((String)"bd_period", (QFilter[])filters, (String)"id", (int)12);
        return (Long)ids.get(0);
    }

    public static Map<String, Date> getStartPeriodBeginDateByOrgIds(Set<Long> orgIds) {
        if (CollectionUtils.isEmpty(orgIds)) {
            return new HashMap<String, Date>(0);
        }
        HashMap<String, Date> results = new HashMap<String, Date>(orgIds.size());
        HashMap<String, Long> orgDepreuseId2PeriodIdMap = new HashMap<String, Long>(orgIds.size());
        HashMap<Long, Date> periodId2BeginDateMap = new HashMap<Long, Date>(orgIds.size());
        SqlBuilder querySql4Book = new SqlBuilder();
        querySql4Book.append("select forgid,fdepreuse,fenableperiodid from t_fa_assetbook where ", new Object[0]);
        querySql4Book.appendIn(" forgid ", (Object[])orgIds.toArray(new Long[0]));
        DataSet dataSet = DB.queryDataSet((String)"FaPeriodUtils.getStartPeriodBeginDateByOrgIds_querySql4Book", (DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)querySql4Book);
        Object object = null;
        try {
            for (Object row : dataSet) {
                Long orgId = row.getLong("forgid");
                Long depreuseId = row.getLong("fdepreuse");
                Long enablePeriodId = row.getLong("fenableperiodid");
                String key = orgId + "_" + depreuseId;
                orgDepreuseId2PeriodIdMap.put(key, enablePeriodId);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (object != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        if (!orgDepreuseId2PeriodIdMap.isEmpty()) {
            SqlBuilder querySql4Period = new SqlBuilder();
            querySql4Period.append("select fid,fbegindate from t_bd_period where ", new Object[0]);
            querySql4Period.appendIn(" fid ", (Object[])orgDepreuseId2PeriodIdMap.values().toArray(new Long[0]));
            Throwable throwable = null;
            try (DataSet dataSet2 = DB.queryDataSet((String)"FaPeriodUtils.getStartPeriodBeginDateByOrgIds_querySql4Period", (DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)querySql4Period);){
                for (Row row : dataSet2) {
                    Long periodId = row.getLong("fid");
                    Date beginDate = row.getDate("fbegindate");
                    periodId2BeginDateMap.put(periodId, beginDate);
                }
            }
            catch (Throwable row) {
                Throwable throwable2 = row;
                throw row;
            }
            if (!periodId2BeginDateMap.isEmpty()) {
                for (Map.Entry entry : orgDepreuseId2PeriodIdMap.entrySet()) {
                    String key = (String)entry.getKey();
                    Long periodId = (Long)entry.getValue();
                    Date beginDate = (Date)periodId2BeginDateMap.get(periodId);
                    results.put(key, beginDate);
                }
            }
        }
        return results;
    }
}

