/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fa.business.constants.FaRptMediateBill;
import kd.fi.fa.business.utils.FaBizUtils;
import kd.fi.fa.business.utils.PeriodUtil;
import kd.fi.fa.common.util.Fa;

public class FaRptMediateUtil {
    public static void record(String sourceBill, DynamicObject[] dataEntities) {
        if (sourceBill != null) {
            switch (sourceBill) {
                case "fa_assetsplitbill": {
                    FaRptMediateUtil.generateBySplitAudit(dataEntities);
                    break;
                }
                case "fa_mergebill": {
                    FaRptMediateUtil.generateByMergeAudit(dataEntities);
                    break;
                }
                case "fa_clearbill": {
                    FaRptMediateUtil.generateByClearAudit(dataEntities);
                    break;
                }
                case "fa_asset_devalue": {
                    FaRptMediateUtil.generateByDevalue(dataEntities);
                    break;
                }
                case "fa_change_dept": {
                    FaRptMediateUtil.generateByChangeBillAudit(dataEntities);
                    break;
                }
                case "fa_restartrealbill": {
                    FaRptMediateUtil.generateByRestartAudit(dataEntities);
                }
            }
        }
    }

    public static void generateByAssetCardAudit(Object[] pkIds) {
        MainEntityType rptMediateType = MetadataServiceHelper.getDataEntityType((String)"fa_rpt_mediate");
        QFilter qFilter = new QFilter("id", "in", (Object)pkIds);
        qFilter.and("realcard.sourceflag", "!=", (Object)"SPLIT");
        String selectFields = "id sourceid,\"fa_card_fin\" sourcetype,billno sourcebillno,org org,realcard realcard,realcard.sourceflag sourceflag,realcard.assetcat assetcat,realcard.originmethod changemode,realcard.masterid masterid,realcard.number assetnumber,period period,originalval originalvalchg,accumdepre addupdepre,decval decvalchg,auditdate createdate,finaccountdate accountingdate,basecurrency currency,depreuse depreuse";
        DynamicObjectCollection finCards = QueryServiceHelper.query((String)"fa_card_fin", (String)selectFields, (QFilter[])qFilter.toArray());
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(finCards.size());
        for (DynamicObject finCard : finCards) {
            DynamicObject rptMediate = new DynamicObject((DynamicObjectType)rptMediateType);
            for (String rptField : FaRptMediateBill.rptMediateFields) {
                if (!finCard.containsProperty(rptField)) continue;
                rptMediate.set(rptField, finCard.get(rptField));
            }
            rptMediate.set("sourcetype", (Object)"fa_card_fin");
            rptMediate.set("changetype", (Object)"2");
            rptMediate.set("createdate", (Object)new Date());
            rptMediate.set("fincard", (Object)rptMediate.getLong("sourceid"));
            result.add(rptMediate);
        }
        SaveServiceHelper.save((DynamicObject[])result.toArray(new DynamicObject[0]));
    }

    public static void generateBySplitAudit(DynamicObject[] dataEntities) {
        MainEntityType rptMediateType = MetadataServiceHelper.getDataEntityType((String)"fa_rpt_mediate");
        ArrayList<String> fincardNumber = new ArrayList<String>(dataEntities.length);
        for (DynamicObject entity : dataEntities) {
            DynamicObjectCollection aftEntry = ((DynamicObject)entity.getDynamicObjectCollection("assetsplitentry").get(0)).getDynamicObjectCollection("subassetsplitentry");
            for (int i = 1; i < aftEntry.size(); ++i) {
                fincardNumber.add(((DynamicObject)aftEntry.get(i)).getString("aft_cardnumber"));
            }
        }
        DynamicObjectCollection fincards = QueryServiceHelper.query((String)"fa_card_fin", (String)"id,number", (QFilter[])new QFilter("number", "in", fincardNumber).toArray());
        HashMap<String, Long> number2idMap = new HashMap<String, Long>(fincards.size());
        for (DynamicObject fincard : fincards) {
            number2idMap.put(fincard.getString("number"), fincard.getLong("id"));
        }
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(dataEntities.length * 2);
        for (DynamicObject entity : dataEntities) {
            String sourceBill = "fa_assetsplitbill";
            Long fid = entity.getLong("id");
            String sourceBillNo = entity.getString("billno");
            Long orgId = entity.getDynamicObject("org").getLong("id");
            Long splitPeriodId = entity.getDynamicObject("splitperiod").getLong("id");
            Date auditDate = entity.getDate("auditdate");
            Date accountDate = entity.getDate("splitdate");
            DynamicObjectCollection befEntry = entity.getDynamicObjectCollection("assetsplitentry");
            for (DynamicObject row : befEntry) {
                BigDecimal oriVal = row.getBigDecimal("bef_originalval");
                BigDecimal dpreVal = row.getBigDecimal("bef_accumdepre");
                BigDecimal decVal = row.getBigDecimal("bef_decval");
                DynamicObject befChangeMode = row.getDynamicObject("bef_changemode");
                long changeModeId = befChangeMode == null ? 0L : befChangeMode.getLong("id");
                DynamicObjectCollection aftEntry = row.getDynamicObjectCollection("subassetsplitentry");
                for (int i = 0; i < aftEntry.size(); ++i) {
                    DynamicObject subRow = (DynamicObject)aftEntry.get(i);
                    DynamicObject rptMediate_sub = new DynamicObject((DynamicObjectType)rptMediateType);
                    DynamicObject realCard_sub = subRow.getDynamicObject("aft_realcard");
                    if (i == 0) {
                        FaRptMediateUtil.initRptMediateBill(rptMediate_sub, sourceBill, fid, sourceBillNo, orgId, subRow.getDynamicObject("aft_depreuse").getLong("id"), subRow.getDynamicObject("aft_currency").getLong("id"), splitPeriodId, realCard_sub, "0", changeModeId, subRow.getBigDecimal("aft_originalval").subtract(oriVal), subRow.getBigDecimal("aft_accumdepre").subtract(dpreVal), subRow.getBigDecimal("aft_decval").subtract(decVal), auditDate, accountDate, subRow.getDynamicObject("aft_fincard").getLong("id"));
                    } else {
                        realCard_sub.set("assetcat", (Object)subRow.getDynamicObject("aft_assetcat"));
                        realCard_sub.set("sourceflag", (Object)"SPLIT");
                        realCard_sub.set("masterid", (Object)realCard_sub.getLong("id"));
                        realCard_sub.set("number", (Object)subRow.getString("aft_cardnumber"));
                        FaRptMediateUtil.initRptMediateBill(rptMediate_sub, sourceBill, fid, sourceBillNo, orgId, subRow.getDynamicObject("aft_depreuse").getLong("id"), subRow.getDynamicObject("aft_currency").getLong("id"), splitPeriodId, realCard_sub, "2", changeModeId, subRow.getBigDecimal("aft_originalval"), subRow.getBigDecimal("aft_accumdepre"), subRow.getBigDecimal("aft_decval"), auditDate, accountDate, (Long)number2idMap.get(subRow.getString("aft_cardnumber")));
                    }
                    result.add(rptMediate_sub);
                }
            }
        }
        SaveServiceHelper.save((DynamicObject[])result.toArray(new DynamicObject[0]));
    }

    public static void generateByMergeAudit(DynamicObject[] dataEntities) {
        MainEntityType rptMediateType = MetadataServiceHelper.getDataEntityType((String)"fa_rpt_mediate");
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(dataEntities.length * 2);
        for (DynamicObject entity : dataEntities) {
            String sourceBill = "fa_mergebill";
            String sourceBillNo = entity.getString("billno");
            Long fid = entity.getLong("id");
            Long orgId = entity.getDynamicObject("org").getLong("id");
            Long periodId = entity.getDynamicObject("mergeperiod").getLong("id");
            Date accountDate = entity.getDate("mergedate");
            Date createDate = entity.getDate("auditdate");
            DynamicObjectCollection inEntry = entity.getDynamicObjectCollection("inentryentity");
            for (DynamicObject inRow : inEntry) {
                DynamicObject inChangeMode = inRow.getDynamicObject("inchangemode");
                long inChangeModeId = inChangeMode == null ? 0L : inChangeMode.getLong("id");
                DynamicObject rptMediate = new DynamicObject((DynamicObjectType)rptMediateType);
                FaRptMediateUtil.initRptMediateBill(rptMediate, sourceBill, fid, sourceBillNo, orgId, inRow.getDynamicObject("indepreuse").getLong("id"), inRow.getDynamicObject("inbasecurrency").getLong("id"), periodId, inRow.getDynamicObject("inrealcard"), "2", inChangeModeId, inRow.getBigDecimal("inoriginalval"), inRow.getBigDecimal("inaccumdepre"), inRow.getBigDecimal("indecval"), createDate, accountDate, inRow.getDynamicObject("infincard").getLong("id"));
                result.add(rptMediate);
                DynamicObjectCollection outEntry = inRow.getDynamicObjectCollection("outentryentity");
                for (DynamicObject outRow : outEntry) {
                    DynamicObject outChangeMode = outRow.getDynamicObject("outchangemode");
                    long outChangeModeId = outChangeMode == null ? 0L : outChangeMode.getLong("id");
                    DynamicObject rptMediate_sub = new DynamicObject((DynamicObjectType)rptMediateType);
                    FaRptMediateUtil.initRptMediateBill(rptMediate_sub, sourceBill, fid, sourceBillNo, orgId, outRow.getDynamicObject("outdepreuse").getLong("id"), outRow.getDynamicObject("outbasecurrency").getLong("id"), periodId, outRow.getDynamicObject("outrealcard"), "0", outChangeModeId, outRow.getBigDecimal("outoriginalval").multiply(new BigDecimal(-1)), outRow.getBigDecimal("outaccumdepre").multiply(new BigDecimal(-1)), outRow.getBigDecimal("outdecval").multiply(new BigDecimal(-1)), createDate, accountDate, outRow.getDynamicObject("outfincard").getLong("id"));
                    result.add(rptMediate_sub);
                }
            }
        }
        SaveServiceHelper.save((DynamicObject[])result.toArray(new DynamicObject[0]));
    }

    public static void generateByClearAudit(DynamicObject[] dataEntities) {
        MainEntityType rptMediateType = MetadataServiceHelper.getDataEntityType((String)"fa_rpt_mediate");
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject entity : dataEntities) {
            String clearSource = entity.getString("clearsource");
            if ("SPLIT".equals(clearSource) || "MERGE".equals(clearSource) || "".equals(clearSource)) continue;
            String sourceBill = "fa_clearbill";
            Long fid = entity.getLong("id");
            String sourceBillNo = entity.getString("billno");
            Long orgId = entity.getDynamicObject("org").getLong("id");
            Long periodId = entity.getDynamicObject("clearperiod").getLong("id");
            Long changeModeId = entity.getDynamicObject("changemode").getLong("id");
            Date accountDate = entity.getDate("cleardate");
            Date createDate = entity.getDate("auditdate");
            BigDecimal mul = new BigDecimal(-1);
            DynamicObjectCollection entry = entity.getDynamicObjectCollection("detail_entry");
            for (DynamicObject row : entry) {
                DynamicObject rptMediate = new DynamicObject((DynamicObjectType)rptMediateType);
                FaRptMediateUtil.initRptMediateBill(rptMediate, sourceBill, fid, sourceBillNo, orgId, row.getDynamicObject("depreuse").getLong("id"), row.getDynamicObject("basecurrency").getLong("id"), periodId, row.getDynamicObject("realcard"), "0", changeModeId, row.getBigDecimal("assetvalue").multiply(mul), row.getBigDecimal("addupdepre").multiply(mul), row.getBigDecimal("decval").multiply(mul), createDate, accountDate, row.getDynamicObject("fincard").getLong("id"));
                result.add(rptMediate);
            }
        }
        SaveServiceHelper.save((DynamicObject[])result.toArray(new DynamicObject[0]));
    }

    public static void generateByDevalue(DynamicObject[] dataEntities) {
        MainEntityType rptMediateType = MetadataServiceHelper.getDataEntityType((String)"fa_rpt_mediate");
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject entity : dataEntities) {
            String sourceBill = "fa_asset_devalue";
            Long fid = entity.getLong("id");
            String sourceBillNo = entity.getString("billno");
            Long orgId = entity.getDynamicObject("org").getLong("id");
            Long periodId = entity.getDynamicObject("devalueperiod").getLong("id");
            Long dpreuseId = entity.getDynamicObject("depreuse").getLong("id");
            Date createDate = entity.getDate("auditdate");
            Date accountDate = entity.getDate("businessdate");
            Long currencyId = entity.getDynamicObject("currency").getLong("id");
            DynamicObjectCollection entry = entity.getDynamicObjectCollection("changebillentry");
            for (DynamicObject row : entry) {
                DynamicObject changeMode = row.getDynamicObject("changemode");
                long changeModeId = changeMode == null ? 0L : changeMode.getLong("id");
                DynamicObject rptMediate = new DynamicObject((DynamicObjectType)rptMediateType);
                FaRptMediateUtil.initRptMediateBill(rptMediate, sourceBill, fid, sourceBillNo, orgId, dpreuseId, currencyId, periodId, row.getDynamicObject("realcard"), row.getBigDecimal("decval").compareTo(new BigDecimal(0)) < 0 ? "0" : "2", changeModeId, new BigDecimal(0), new BigDecimal(0), row.getBigDecimal("decval"), createDate, accountDate, row.getDynamicObject("fincard").getLong("id"));
                result.add(rptMediate);
            }
        }
        SaveServiceHelper.save((DynamicObject[])result.toArray(new DynamicObject[0]));
    }

    public static void generateByChangeBillAudit(DynamicObject[] dataEntities) {
        MainEntityType rptMediateType = MetadataServiceHelper.getDataEntityType((String)"fa_rpt_mediate");
        ArrayList<Long> billIds = new ArrayList<Long>(dataEntities.length);
        for (DynamicObject entity : dataEntities) {
            billIds.add(entity.getLong("id"));
        }
        QFilter qFilter = new QFilter("id", "in", billIds);
        DynamicObjectCollection realEntry = QueryServiceHelper.query((String)"fa_change_dept", (String)"id,realentry.realcard realcard,realentry.aftrealcard aftrealcard", (QFilter[])qFilter.toArray());
        HashMap<String, Long> bill2realcardMap = new HashMap<String, Long>(realEntry.size());
        for (DynamicObject entry : realEntry) {
            bill2realcardMap.put(entry.getString("id") + entry.getString("aftrealcard"), entry.getLong("realcard"));
        }
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject entity : dataEntities) {
            Long fid = entity.getLong("id");
            String sourceBillNo = entity.getString("billno");
            Long orgId = entity.getDynamicObject("org").getLong("id");
            Date createDate = entity.getDate("auditdate");
            Date accountDate = entity.getDate("changedate");
            DynamicObject assetBook = FaBizUtils.getAsstBookByOrg(orgId, "periodtype");
            Long periodId = PeriodUtil.getPeriodByDate(accountDate, "id", assetBook.getLong("periodtype")).getLong("id");
            DynamicObjectCollection fieldEntry = entity.getDynamicObjectCollection("fieldentry");
            for (DynamicObject row : fieldEntry) {
                String changeField = row.getString("field");
                DynamicObject finCard = row.getDynamicObject("fincard1");
                BigDecimal orignVal = finCard.getBigDecimal("originalval");
                BigDecimal dpreVal = finCard.getBigDecimal("accumdepre");
                BigDecimal decVal = finCard.getBigDecimal("decval");
                Long dpreUseId = row.getDynamicObject("depreuse1").getLong("id");
                if ("fa_card_real.assetcat".equals(changeField)) {
                    Long currencyId = finCard.getDynamicObject("basecurrency").getLong("id");
                    DynamicObject aft_realcard = row.getDynamicObject("realcard1");
                    String sourceBill = "fa_change_assetcat";
                    DynamicObject deleteMode = row.getDynamicObject("deletemode");
                    long deleteModeId = deleteMode == null ? 0L : deleteMode.getLong("id");
                    DynamicObject bef_realcard = new DynamicObject(aft_realcard.getDynamicObjectType());
                    bef_realcard.set("assetcat", (Object)row.getLong("beforevalue"));
                    bef_realcard.set("id", bill2realcardMap.get(entity.getString("id") + aft_realcard.getString("id")));
                    bef_realcard.set("sourceflag", aft_realcard.get("sourceflag"));
                    bef_realcard.set("number", aft_realcard.get("number"));
                    bef_realcard.set("masterid", aft_realcard.get("masterid"));
                    DynamicObject bef_rptMediate = new DynamicObject((DynamicObjectType)rptMediateType);
                    FaRptMediateUtil.initRptMediateBill(bef_rptMediate, sourceBill, fid, sourceBillNo, orgId, dpreUseId, currencyId, periodId, bef_realcard, "0", deleteModeId, orignVal.multiply(BigDecimal.valueOf(-1L)), dpreVal.multiply(BigDecimal.valueOf(-1L)), decVal.multiply(BigDecimal.valueOf(-1L)), createDate, accountDate, row.getDynamicObject("fincard1").getLong("id"));
                    result.add(bef_rptMediate);
                    DynamicObject addMode = row.getDynamicObject("addmode");
                    long addModeId = addMode == null ? 0L : addMode.getLong("id");
                    DynamicObject aft_rptMediate = new DynamicObject((DynamicObjectType)rptMediateType);
                    aft_realcard.set("assetcat", (Object)row.getLong("aftervalue"));
                    FaRptMediateUtil.initRptMediateBill(aft_rptMediate, sourceBill, fid, sourceBillNo, orgId, dpreUseId, currencyId, periodId, aft_realcard, "2", addModeId, orignVal, dpreVal, decVal, createDate, accountDate, row.getDynamicObject("fincard1").getLong("id"));
                    result.add(aft_rptMediate);
                    continue;
                }
                if (!"fa_card_fin.originalval".equals(changeField)) continue;
                BigDecimal bef_val = row.getBigDecimal("beforevalue");
                BigDecimal aft_val = row.getBigDecimal("aftervalue");
                BigDecimal change_val = aft_val.subtract(bef_val);
                String changeType = bef_val.compareTo(aft_val) < 0 ? "2" : "0";
                String sourceBill = "fa_change_value";
                DynamicObject changeMode = row.getDynamicObject("changemode");
                long changeModeId = changeMode == null ? 0L : changeMode.getLong("id");
                DynamicObject rptMediate = new DynamicObject((DynamicObjectType)rptMediateType);
                FaRptMediateUtil.initRptMediateBill(rptMediate, sourceBill, fid, sourceBillNo, orgId, dpreUseId, row.getDynamicObject("basecurrency1").getLong("id"), periodId, row.getDynamicObject("realcard1"), changeType, changeModeId, change_val, BigDecimal.ZERO, BigDecimal.ZERO, createDate, accountDate, row.getDynamicObject("fincard1").getLong("id"));
                result.add(rptMediate);
            }
        }
        SaveServiceHelper.save((DynamicObject[])result.toArray(new DynamicObject[0]));
    }

    public static void generateByRestartAudit(DynamicObject[] dataEntities) {
        MainEntityType rptMediateType = MetadataServiceHelper.getDataEntityType((String)"fa_rpt_mediate");
        ArrayList<DynamicObject> needToSaveRptMediateDynObjList = new ArrayList<DynamicObject>(16);
        for (DynamicObject reStartRealBill : dataEntities) {
            needToSaveRptMediateDynObjList.addAll(FaRptMediateUtil.getNeedSaveRptMediateDynObjList(reStartRealBill));
        }
        ArrayList<String> finNumbers = new ArrayList<String>(needToSaveRptMediateDynObjList.size());
        for (DynamicObject rptmediate : needToSaveRptMediateDynObjList) {
            finNumbers.add(rptmediate.getString("assetnumber"));
        }
        QFilter qFilter = new QFilter("number", "in", finNumbers).and("originaldata", "=", (Object)"0");
        DynamicObjectCollection finCards = QueryServiceHelper.query((String)"fa_card_fin", (String)"id,number,bizperiod", (QFilter[])qFilter.toArray());
        HashMap number2idMap = new HashMap(finCards.size());
        finCards.forEach(v -> number2idMap.put(v.getString("number") + v.getString("bizperiod"), v.getLong("id")));
        for (DynamicObject rptmediate : needToSaveRptMediateDynObjList) {
            rptmediate.set("fincard", number2idMap.get(rptmediate.getString("assetnumber") + rptmediate.getString("period")));
        }
        SaveServiceHelper.save((DynamicObject[])needToSaveRptMediateDynObjList.toArray(new DynamicObject[0]));
    }

    private static List<DynamicObject> getNeedSaveRptMediateDynObjList(DynamicObject reStartRealBill) {
        DynamicObjectCollection reStartEntity = reStartRealBill.getDynamicObjectCollection("restartentity");
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(reStartEntity.size());
        for (DynamicObject reStartEntityDynObj : reStartEntity) {
            MainEntityType rptMediateType = MetadataServiceHelper.getDataEntityType((String)"fa_rpt_mediate");
            DynamicObject baseRptMediateDynObj = new DynamicObject((DynamicObjectType)rptMediateType);
            String sourceType = "fa_restartrealbill";
            baseRptMediateDynObj.set("sourcetype", (Object)sourceType);
            baseRptMediateDynObj.set("sourceid", (Object)reStartRealBill.getLong("id"));
            String sourceBillNo = reStartRealBill.getString("billno");
            baseRptMediateDynObj.set("sourcebillno", (Object)sourceBillNo);
            baseRptMediateDynObj.set("createdate", (Object)new Date());
            baseRptMediateDynObj.set("accountingdate", (Object)reStartRealBill.getDate("restartdate"));
            baseRptMediateDynObj.set("org", (Object)reStartRealBill.getLong(Fa.id((String)"org")));
            baseRptMediateDynObj.set("period", (Object)reStartRealBill.getDynamicObject("restartperiod").getLong("id"));
            baseRptMediateDynObj.set("changemode", (Object)reStartRealBill.getDynamicObject("addchangemode").getLong("id"));
            baseRptMediateDynObj.set("changetype", (Object)"2");
            baseRptMediateDynObj.set("currency", (Object)reStartEntityDynObj.getDynamicObject("basecurrency").getLong("id"));
            baseRptMediateDynObj.set("depreuse", (Object)reStartEntityDynObj.getLong(Fa.id((String)"entitydepreuse")));
            baseRptMediateDynObj.set("realcard", (Object)reStartEntityDynObj.getLong(Fa.id((String)"realcard")));
            baseRptMediateDynObj.set("assetcat", reStartEntityDynObj.getDynamicObject("realcard").getDynamicObject("assetcat").getPkValue());
            baseRptMediateDynObj.set("sourceflag", (Object)reStartEntityDynObj.getDynamicObject("realcard").getString("sourceflag"));
            baseRptMediateDynObj.set("originalvalchg", (Object)reStartEntityDynObj.getBigDecimal("restassetvalue"));
            baseRptMediateDynObj.set("addupdepre", (Object)reStartEntityDynObj.getBigDecimal("restaddupdepre"));
            baseRptMediateDynObj.set("decvalchg", (Object)reStartEntityDynObj.getBigDecimal("restdecval"));
            baseRptMediateDynObj.set("masterid", (Object)reStartEntityDynObj.getDynamicObject("realcard").getLong("masterid"));
            baseRptMediateDynObj.set("assetnumber", (Object)reStartEntityDynObj.getDynamicObject("realcard").getString("number"));
            result.add(baseRptMediateDynObj);
        }
        return result;
    }

    public static void deleteByUnaudit(String sourceBill, DynamicObject[] dataEntites) {
        if ("fa_card_fin".equals(sourceBill)) {
            ArrayList<Object[]> params = new ArrayList<Object[]>(dataEntites.length);
            for (DynamicObject fincard : dataEntites) {
                Object[] param = new Object[]{"fa_card_fin", fincard.getLong("org_id"), fincard.getLong("depreuse_id"), fincard.getLong("period_id"), fincard.getLong("realcardmasterid")};
                params.add(param);
            }
            String sql = "delete from t_fa_rpt_mediate where fsourcetype=? and forgid=? and fdepreuseid=? and fperiodid=? and fmasterid = ?";
            DB.executeBatch((DBRoute)DBRoute.of((String)"fa"), (String)sql, params);
            return;
        }
        if (sourceBill.equals("fa_change_dept")) {
            sourceBill = "fa_change%";
        }
        ArrayList<Long> ids = new ArrayList<Long>(dataEntites.length);
        for (DynamicObject entity : dataEntites) {
            ids.add(entity.getLong("id"));
        }
        QFilter qFilter = new QFilter("sourceid", "in", ids);
        qFilter.and("sourcetype", "like", (Object)sourceBill);
        DeleteServiceHelper.delete((String)"fa_rpt_mediate", (QFilter[])qFilter.toArray());
    }

    private static void initRptMediateBill(DynamicObject rptMediate, String sourceType, Long sourceBillId, String sourceBillNo, Long orgId, Long dpreuseId, Long currencyId, Long periodId, DynamicObject realCard, String changeType, Long changeModeId, BigDecimal orignVal, BigDecimal dpreVal, BigDecimal decVal, Date createDate, Date accountDate, Long fincardId) {
        rptMediate.set("sourceid", (Object)sourceBillId);
        rptMediate.set("sourcebillno", (Object)sourceBillNo);
        rptMediate.set("org", (Object)orgId);
        rptMediate.set("depreuse", (Object)dpreuseId);
        rptMediate.set("currency", (Object)currencyId);
        rptMediate.set("period", (Object)periodId);
        if (realCard != null) {
            rptMediate.set("realcard", (Object)realCard.getLong("id"));
            Object assetcat = realCard.get("assetcat");
            if (assetcat instanceof DynamicObject) {
                rptMediate.set("assetcat", (Object)((DynamicObject)assetcat).getLong("id"));
            } else if (assetcat instanceof Long) {
                rptMediate.set("assetcat", assetcat);
            }
            rptMediate.set("sourceflag", (Object)realCard.getString("sourceflag"));
            rptMediate.set("masterid", (Object)realCard.getLong("masterid"));
            rptMediate.set("assetnumber", (Object)realCard.getString("number"));
        }
        rptMediate.set("changetype", (Object)changeType);
        rptMediate.set("changemode", (Object)changeModeId);
        rptMediate.set("originalvalchg", (Object)orignVal);
        rptMediate.set("addupdepre", (Object)dpreVal);
        rptMediate.set("decvalchg", (Object)decVal);
        rptMediate.set("sourcetype", (Object)sourceType);
        rptMediate.set("createdate", (Object)createDate);
        rptMediate.set("accountingdate", (Object)accountDate);
        rptMediate.set("fincard", (Object)fincardId);
    }

    public static void updateRealcardId(Map<Object, Object> realCardIdMap) {
        ArrayList<Object[]> params = new ArrayList<Object[]>(realCardIdMap.size());
        for (Map.Entry<Object, Object> entry : realCardIdMap.entrySet()) {
            Object[] param = new Object[]{entry.getValue(), entry.getKey()};
            params.add(param);
        }
        String sql = "update t_fa_rpt_mediate set frealcardid = ? where frealcardid = ?";
        DB.executeBatch((DBRoute)DBRoute.of((String)"fa"), (String)sql, params);
    }
}

