/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.utils;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.property.AssistantProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.UserProp;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.business.SourceFlagEnum;
import kd.fi.fa.business.constants.FaChangeItem;
import kd.fi.fa.business.dao.factory.FaBillDaoFactory;
import kd.fi.fa.business.dao.impl.FaDaoOrmImpl;
import kd.fi.fa.business.enums.BusyTypeDetailEnum;
import kd.fi.fa.business.periodclose.FutureBizChecker;
import kd.fi.fa.business.utils.FaBizUtils;
import kd.fi.fa.common.util.ContextUtil;
import kd.fi.fa.common.util.Fa;

public class FaUtils {
    public static final String ALGOKEY = "kd.fi.fa.utils.FaUtils";
    public static final String TABAP = "tabap";
    public static final String SOURCEBILLID = "sourcebillid";
    public static final String AI_DAPTRACKER = "ai_daptracker";
    public static final String VOUCHERID = "voucherid";
    public static final String BILLNO = "billno";
    public static final String ID = "id";
    public static final String GL_VOUCHER = "gl_voucher";
    public static final String FA_CLRBILL = "fa_clrbill";
    private static final int BATCH_SELECT_NUM = 999;
    private static final String QUERY_MAIN_BOOK_FIELD = Fa.comma((String[])new String[]{"id", "periodtype", "basecurrency", "curperiod", "startperiod", "depresystem", "status", "org", "enable", "depreuse"});
    private static final Log logger = LogFactory.getLog(FaUtils.class);

    public static Boolean isFieldEmpty(IDataModel model, String field) {
        DynamicObject dynObj = model.getDataEntity();
        return dynObj == null || dynObj.get(field) == null;
    }

    public static String removeString_id(String str) {
        if (str.length() > 3 && str.substring(str.length() - 3).equalsIgnoreCase("_id")) {
            return str.substring(0, str.length() - 3);
        }
        return str;
    }

    public static Boolean isZero(Object num) {
        return Pattern.matches("(0+\\.0*)|(0+)", num.toString());
    }

    public static String parseDateByFormatString(Date date, String format) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat simple = new SimpleDateFormat(format);
        return simple.format(date);
    }

    public static Object[] getSelectedPks(IFormView view) {
        Object[] pkArr = null;
        ListSelectedRowCollection selectedRows = ((IListView)view).getSelectedRows();
        if (selectedRows.size() > 0) {
            pkArr = new Object[selectedRows.size()];
            for (int i = 0; i < selectedRows.size(); ++i) {
                ListSelectedRow selectedRow = selectedRows.get(i);
                pkArr[i] = selectedRow.getPrimaryKeyValue();
            }
        } else {
            pkArr = new Object[]{};
        }
        return pkArr;
    }

    public static boolean isF7(IFormView view) {
        ListShowParameter listShowParameter = (ListShowParameter)view.getFormShowParameter();
        return listShowParameter.isLookUp();
    }

    public static void showTabForm(String formId, String formName, Object pkValue, IFormView view) {
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.setPkId(pkValue);
        parameter.setCaption(formName);
        parameter.getOpenStyle().setTargetKey(TABAP);
        parameter.setParentFormId(view.getFormShowParameter().getParentFormId());
        parameter.setStatus(OperationStatus.EDIT);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setFormId(formId);
        view.showForm((FormShowParameter)parameter);
    }

    public static void showTabForm(String formId, String formName, Object pkValue, IFormView view, OperationStatus opStatus, boolean hasRight) {
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.setPkId(pkValue);
        parameter.setCaption(formName);
        parameter.getOpenStyle().setTargetKey(TABAP);
        parameter.setParentFormId(view.getFormShowParameter().getParentFormId());
        parameter.setStatus(opStatus);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setHasRight(hasRight);
        parameter.setFormId(formId);
        view.showForm((FormShowParameter)parameter);
    }

    public static Object getRowPk(Object rowPk) {
        String rowPkv = rowPk.toString();
        return FaUtils.getVouncherId(rowPkv);
    }

    public static Object getRowRealCardNo(int rowIndex, IFormView view) {
        ListSelectedRow selectedRow = ((IListView)view).getCurrentListAllRowCollection().get(rowIndex);
        String rowPk = selectedRow.getPrimaryKeyValue().toString();
        String rowEntryPk = selectedRow.getEntryPrimaryKeyValue().toString();
        return FaUtils.getRealCardId(rowPk, rowEntryPk);
    }

    public static String getVouncherId(String fid) {
        String voucherId = "";
        QFilter filterRe = new QFilter(SOURCEBILLID, "=", (Object)Long.parseLong(fid));
        QFilter[] filterRes = new QFilter[]{filterRe};
        ORM orm = ORM.create();
        DynamicObjectCollection listDO = orm.query(AI_DAPTRACKER, filterRes);
        DynamicObject relation = null;
        if (listDO == null || listDO.size() == 0) {
            return voucherId;
        }
        relation = (DynamicObject)listDO.get(0);
        String voucherid = relation.getString(VOUCHERID);
        return voucherid;
    }

    public static String getRealCardId(String fid, String rowEntryPk) {
        if (StringUtils.isEmpty((CharSequence)fid)) {
            return null;
        }
        ORM.create();
        DynamicObject realcardId = BusinessDataServiceHelper.loadSingle((Object)fid, (String)"fa_clearbill");
        DynamicObjectCollection entrys = (DynamicObjectCollection)realcardId.get("detail_entry");
        String realCardPk = "";
        for (DynamicObject entry : entrys) {
            if (!rowEntryPk.equals(String.valueOf(entry.getPkValue()))) continue;
            DynamicObject realCard = entry.getDynamicObject("realcard");
            if (realCard == null) {
                return null;
            }
            realCardPk = String.valueOf(realCard.getPkValue());
            break;
        }
        return realCardPk;
    }

    public static Map<String, String> getVouncherNumber(List<String> fids) {
        HashMap<String, String> map = new HashMap<String, String>(1);
        logger.info("\u4e0d\u901a\u8fc7\u4e1a\u52a1\u65b9\u83b7\u53d6\u51ed\u8bc1\u53f7\uff0c\u5df2\u96c6\u6210\u6807\u51c6\u63a7\u4ef6\u5904\u7406");
        return map;
    }

    public static String getDefaultOrgId(List<ComboItem> items) {
        Long currOrgId = RequestContext.get().getOrgId();
        for (int i = 0; i < items.size(); ++i) {
            Long nextId;
            if (null == items.get(i) || items.get(i).getValue().length() == 0 || (nextId = Long.valueOf(Long.parseLong(items.get(i).getValue()))).longValue() != currOrgId.longValue()) continue;
            return currOrgId.toString();
        }
        String defaultStr = items.get(0).getValue();
        return defaultStr;
    }

    public static DynamicObject getPeriodByDate(Date date, long periodType) {
        String selectField = "id,periodtype.id,periodyear,periodnumber,begindate,enddate,isadjustperiod,number,name";
        DynamicObjectCollection period = FaUtils.getPeriodByDate(date, selectField, periodType);
        if (!period.isEmpty()) {
            return (DynamicObject)period.get(0);
        }
        return null;
    }

    public static DynamicObjectCollection getPeriodByDate(Date date, String selectField, long periodType) {
        QFilter f = new QFilter("beginDate", "<=", (Object)date);
        QFilter g = new QFilter("enddate", ">=", (Object)date);
        QFilter t = new QFilter("periodtype", "=", (Object)periodType);
        QFilter i = new QFilter("isadjustperiod", "=", (Object)false);
        return QueryServiceHelper.query((String)"bd_period", (String)selectField, (QFilter[])new QFilter[]{f, g, t, i}, (String)"number");
    }

    public static boolean existsLeaseRealCard(long orgId) {
        QFilter[] initContractCardFilter = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("sourceflag", "in", (Object)new String[]{SourceFlagEnum.INITLEASECONTRACT.name()})};
        return QueryServiceHelper.exists((String)"fa_card_real", (QFilter[])initContractCardFilter);
    }

    public static boolean existsFincardByOrgAndDepreuse(long org, long depreuse) {
        QFilter orgFil = new QFilter("org", "=", (Object)org);
        QFilter depreuseFil = new QFilter("depreuse", "=", (Object)depreuse);
        QFilter endperiodFil = new QFilter("endperiod", "=", (Object)99999999999L);
        return QueryServiceHelper.exists((String)"fa_card_fin", (QFilter[])new QFilter[]{orgFil, depreuseFil, endperiodFil});
    }

    public static DynamicObjectCollection getFincardByOrgAndDepreuse(long org, long depreuse) {
        QFilter orgFil = new QFilter("org", "=", (Object)org);
        QFilter depreuseFil = new QFilter("depreuse", "=", (Object)depreuse);
        QFilter endperiodFil = new QFilter("endperiod", "=", (Object)99999999999L);
        DynamicObjectCollection fincard = QueryServiceHelper.query((String)"fa_card_fin", (String)ID, (QFilter[])new QFilter[]{orgFil, depreuseFil, endperiodFil});
        return fincard;
    }

    public static DynamicObject getMainBookByOrg(Long orgId) {
        QFilter mainF = new QFilter("ismainbook", "=", (Object)"1");
        QFilter orgF = new QFilter("org", "=", (Object)orgId);
        DynamicObject mainBook = QueryServiceHelper.queryOne((String)"fa_assetbook", (String)QUERY_MAIN_BOOK_FIELD, (QFilter[])new QFilter[]{mainF, orgF});
        return mainBook;
    }

    public static DynamicObject loadMainBookByOrg(Long orgId) {
        QFilter mainF = new QFilter("ismainbook", "=", (Object)"1");
        QFilter orgF = new QFilter("org", "=", (Object)orgId);
        return BusinessDataServiceHelper.loadSingleFromCache((String)"fa_assetbook", (QFilter[])new QFilter[]{mainF, orgF});
    }

    public static DynamicObject getMainBookDyByOrg(Long orgId) {
        QFilter mainF = new QFilter("ismainbook", "=", (Object)"1");
        QFilter orgF = new QFilter("org", "=", (Object)orgId);
        Map mainBookMap = BusinessDataServiceHelper.loadFromCache((String)"fa_assetbook", (String)QUERY_MAIN_BOOK_FIELD, (QFilter[])new QFilter[]{mainF, orgF});
        Collection mainBook = mainBookMap.values();
        if (mainBook.size() > 0) {
            return (DynamicObject)mainBook.toArray()[0];
        }
        return null;
    }

    public static Collection<DynamicObject> getMainBookDyByOrgIds(Set<Long> orgIds) {
        QFilter mainF = new QFilter("ismainbook", "=", (Object)"1");
        QFilter orgF = new QFilter("org", "in", orgIds);
        Map mainBookMap = BusinessDataServiceHelper.loadFromCache((String)"fa_assetbook", (String)QUERY_MAIN_BOOK_FIELD, (QFilter[])new QFilter[]{mainF, orgF});
        return mainBookMap.values();
    }

    public static DynamicObjectCollection getMainBookByOrgIds(Set<Long> orgIds) {
        QFilter mainF = new QFilter("ismainbook", "=", (Object)"1");
        QFilter orgF = new QFilter("org", "in", orgIds);
        DynamicObjectCollection mainBooks = QueryServiceHelper.query((String)"fa_assetbook", (String)QUERY_MAIN_BOOK_FIELD, (QFilter[])new QFilter[]{mainF, orgF});
        return mainBooks;
    }

    public static List<Long> getCurRealCard(Date date, Long orgId) {
        return FaUtils.getCurRealCard(date, orgId, Boolean.FALSE);
    }

    public static List<Long> getCurRealCard(Date date, Long orgId, Boolean includeBef) {
        DynamicObject mainBook = FaUtils.getMainBookByOrg(orgId);
        if (mainBook == null) {
            return null;
        }
        long periodType = mainBook.getLong("periodtype");
        DynamicObject period = FaUtils.getPeriodByDate(date, periodType);
        if (period == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u4e1a\u52a1\u65e5\u671f\u201c%s\u201d\u5bf9\u5e94\u7684\u671f\u95f4\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FaUtils_0", (String)"fi-fa-business", (Object[])new Object[0]), date == null ? " " : date));
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("org", "=", (Object)orgId));
        if (!includeBef.booleanValue()) {
            filters.add(new QFilter("bizperiod", "<=", period.get(ID)));
        }
        filters.add(new QFilter("endperiod", ">=", period.get(ID)));
        QFilter[] filterArr = filters.toArray(new QFilter[0]);
        DynamicObjectCollection cards = QueryServiceHelper.query((String)"fa_card_fin", (String)"realcard", (QFilter[])filterArr);
        ArrayList<Long> cardList = new ArrayList<Long>();
        for (DynamicObject card : cards) {
            cardList.add(card.getLong("realcard"));
        }
        return cardList;
    }

    public static Set<Long> getDecValCard(DynamicObject dataEntity, Long orgId, Boolean includeBef, Set<Long> readCardIds) {
        HashSet<Long> existsIds = new HashSet();
        DynamicObject org = dataEntity.getDynamicObject("org");
        DynamicObject depreuse = dataEntity.getDynamicObject("depreuse");
        Map assetBooks = BusinessDataServiceHelper.loadFromCache((String)"fa_assetbook", (String)"curperiod, depresystem", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)org.getLong(ID)), new QFilter("status", "=", (Object)BillStatus.C.toString()), new QFilter("depreuse", "=", (Object)depreuse.getLong(ID))});
        if (assetBooks == null || assetBooks.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u8d44\u4ea7\u8d26\u7c3f\u51fa\u9519\u3002", (String)"FaUtils_1", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        DynamicObject assetBook = (DynamicObject)assetBooks.values().iterator().next();
        DynamicObject currentPeriod = assetBook.getDynamicObject("curperiod");
        if (currentPeriod == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u8d44\u4ea7\u7ec4\u7ec7\u7684\u542f\u7528\u671f\u95f4\u3002", (String)"FaUtils_2", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        DynamicObject depresystem = assetBook.getDynamicObject("depresystem");
        DynamicObjectCollection assetPolicy = depresystem.getDynamicObjectCollection("assetpolicy_entry");
        existsIds = FaUtils.filterNoDecCards(dataEntity, org, depreuse, (List<DynamicObject>)assetPolicy, readCardIds);
        return existsIds;
    }

    private static Set<Long> filterNoDecCards(DynamicObject dataEntity, DynamicObject org, DynamicObject depreuse, List<DynamicObject> assetPolicy, Set<Long> readCardIds) {
        HashSet<Long> realcardids = new HashSet<Long>(10);
        DynamicObject devalueperiod = dataEntity.getDynamicObject("devalueperiod");
        QFilter orgFilter = new QFilter("org", "=", (Object)org.getLong(ID));
        QFilter periodFilter = new QFilter("bizperiod", "<=", devalueperiod.getPkValue());
        QFilter endperiodFilter = new QFilter("endperiod", ">", devalueperiod.getPkValue());
        QFilter finStatus = new QFilter("billstatus", "=", (Object)BillStatus.C.toString());
        QFilter depreuseFilter = new QFilter("depreuse", "=", depreuse.getPkValue());
        QFilter realCardFilter = new QFilter("realcardmasterid", "in", readCardIds);
        QFilter[] filters = new QFilter[]{orgFilter, periodFilter, endperiodFilter, finStatus, depreuseFilter, realCardFilter};
        DynamicObjectCollection finCards = QueryServiceHelper.query((String)"fa_card_fin", (String)String.join((CharSequence)",", "realcard", "assetcat.longnumber  longnumber", "number", "realcardmasterid"), (QFilter[])filters);
        HashSet<Long> catId = new HashSet<Long>(assetPolicy.size());
        for (DynamicObject row : assetPolicy) {
            DynamicObject entry = row.getDynamicObject("assetcat");
            catId.add(entry.getLong(ID));
        }
        DynamicObjectCollection catoryColls = QueryServiceHelper.query((String)"fa_assetcategory", (String)"id, longnumber", (QFilter[])new QFilter[]{new QFilter(ID, "in", catId)});
        HashMap<Long, String> catLongNumberMap = new HashMap<Long, String>(catoryColls.size());
        for (DynamicObject cat : catoryColls) {
            catLongNumberMap.put(cat.getLong(ID), cat.getString("longnumber"));
        }
        String DEV1 = "2";
        String DEV2 = "3";
        String DEV4 = "4";
        for (DynamicObject finCard : finCards) {
            int flg = 999;
            boolean isdevalue = false;
            String assetcat = finCard.getString("longnumber");
            if (assetcat == null) continue;
            String catLongNumber = null;
            for (DynamicObject row : assetPolicy) {
                DynamicObject cat = row.getDynamicObject("assetcat");
                catLongNumber = (String)catLongNumberMap.get(cat.getLong(ID));
                int diff = assetcat.length() - catLongNumber.length();
                if (!assetcat.startsWith(catLongNumber) || diff >= flg) continue;
                flg = diff;
                String dec = row.getString("decpolicy");
                boolean bl = isdevalue = "2".equals(dec) || "3".equals(dec) || "4".equals(dec);
                if (flg != 0) continue;
                break;
            }
            if (!isdevalue) continue;
            realcardids.add(finCard.getLong("realcardmasterid"));
        }
        return realcardids;
    }

    public static Set<String> getCurRealCard4Future(Date date, Long orgId, Boolean includeBef, Set<Long> readCardIds, Set<String> cardNumbers, BusyTypeDetailEnum busyType) {
        HashSet<String> existsNumbers = new HashSet<String>(cardNumbers.size());
        DynamicObject mainBook = FaUtils.getMainBookByOrg(orgId);
        if (mainBook == null) {
            logger.info(String.format("\u4e3b\u8d26\u7c3f\u4e3a\u7a7a\uff0corgId\uff1a%s", orgId));
            return existsNumbers;
        }
        long periodType = mainBook.getLong("periodtype");
        DynamicObject period = FaUtils.getPeriodByDate(date, periodType);
        if (period == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u4e1a\u52a1\u65e5\u671f\u201c%s\u201d\u5bf9\u5e94\u7684\u671f\u95f4\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FaUtils_0", (String)"fi-fa-business", (Object[])new Object[0]), date == null ? " " : date));
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("org", "=", (Object)orgId));
        filters.add(new QFilter("endperiod", ">", period.get(ID)));
        filters.add(new QFilter("number", "in", cardNumbers));
        if (includeBef.booleanValue()) {
            filters.add(new QFilter("finaccountdate", "<=", (Object)period.getDate("begindate")));
        } else {
            filters.add(new QFilter("finaccountdate", "<=", (Object)period.getDate("enddate")));
        }
        QFilter[] filterArr = filters.toArray(new QFilter[0]);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"fa_card_fin", (String)"fa_card_fin", (String)"number", (QFilter[])filterArr, null);){
            while (ds.hasNext()) {
                existsNumbers.add(ds.next().getString("number"));
            }
        }
        logger.info(String.format("\u4e0d\u662f\u672a\u6765\u671f\u95f4\u5165\u8d26\u7684\u5b9e\u7269\u5361\u7247id\uff1a%s", existsNumbers));
        Set<Object> futureBizRealCards = new FutureBizChecker(null, (Object)orgId, new HashSet<Object>(readCardIds), date, busyType).checkAndReturnRealCard();
        logger.info(String.format("\u5b58\u5728\u540e\u7eed\u4e1a\u52a1\u7684\u5b9e\u7269\u5361\u7247id\uff1a%s", futureBizRealCards));
        QFilter[] futureRealFilters = new QFilter[]{new QFilter(ID, "in", futureBizRealCards)};
        DynamicObjectCollection futureNumberList = QueryServiceHelper.query((String)"fa_card_real", (String)"number", (QFilter[])futureRealFilters);
        Set futureNumberSet = futureNumberList.stream().map(v -> v.getString("number")).collect(Collectors.toSet());
        existsNumbers.removeAll(futureNumberSet);
        logger.info(String.format("\u6821\u9a8c\u901a\u8fc7\u7684\u5b9e\u7269\u5361\u7247id\uff1a%s", existsNumbers));
        return existsNumbers;
    }

    @Deprecated
    public static Set<Long> getCurRealCard(Date date, Long orgId, Boolean includeBef, Set<Long> readCardIds) {
        return FaUtils.getCurRealCard(date, orgId, includeBef, readCardIds, BusyTypeDetailEnum.REAL_FIN_CHG, null);
    }

    public static Set<Long> getCurRealCard(Date date, Long orgId, Boolean includeBef, Set<Long> readCardIds, BusyTypeDetailEnum busyType, Long billDepreUseId) {
        HashSet<Long> existsIds = new HashSet<Long>();
        DynamicObject mainBook = FaUtils.getMainBookByOrg(orgId);
        if (mainBook == null) {
            logger.info(String.format("\u4e3b\u8d26\u7c3f\u4e3a\u7a7a\uff0corgId\uff1a%s", orgId));
            return existsIds;
        }
        long periodType = mainBook.getLong("periodtype");
        DynamicObject period = FaUtils.getPeriodByDate(date, periodType);
        if (period == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u4e1a\u52a1\u65e5\u671f\u201c%s\u201d\u5bf9\u5e94\u7684\u671f\u95f4\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FaUtils_3", (String)"fi-fa-business", (Object[])new Object[0]), date == null ? " " : date));
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("org", "=", (Object)orgId));
        filters.add(new QFilter("endperiod", ">", period.get(ID)));
        filters.add(new QFilter("realcardmasterid", "in", readCardIds));
        if (includeBef.booleanValue()) {
            filters.add(new QFilter("finaccountdate", "<=", (Object)period.getDate("begindate")));
        } else {
            filters.add(new QFilter("finaccountdate", "<=", (Object)period.getDate("enddate")));
        }
        QFilter[] filterArr = filters.toArray(new QFilter[0]);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"fa_card_fin", (String)"fa_card_fin", (String)"realcardmasterid", (QFilter[])filterArr, null);){
            while (ds.hasNext()) {
                existsIds.add(ds.next().getLong("realcardmasterid"));
            }
        }
        logger.info(String.format("\u4e0d\u662f\u672a\u6765\u671f\u95f4\u5165\u8d26\u7684\u5b9e\u7269\u5361\u7247id\uff1a%s", existsIds));
        Set<Object> futureBizRealCards = new FutureBizChecker(null, (Object)orgId, new HashSet<Object>(readCardIds), date, busyType, billDepreUseId).checkAndReturnRealCard();
        logger.info(String.format("\u5b58\u5728\u540e\u7eed\u4e1a\u52a1\u7684\u5b9e\u7269\u5361\u7247id\uff1a%s", futureBizRealCards));
        existsIds.removeAll(futureBizRealCards);
        logger.info(String.format("\u6821\u9a8c\u901a\u8fc7\u7684\u5b9e\u7269\u5361\u7247id\uff1a%s", existsIds));
        return existsIds;
    }

    public static Set<Long> getRealCardCurFin(Date date, Long orgId, Set<Long> readCardIds) {
        HashSet<Long> existsIds = new HashSet<Long>();
        DynamicObject mainBook = FaUtils.getMainBookByOrg(orgId);
        if (mainBook == null) {
            logger.info(String.format("\u4e3b\u8d26\u7c3f\u4e3a\u7a7a\uff0corgId\uff1a%s", orgId));
            return existsIds;
        }
        long periodType = mainBook.getLong("periodtype");
        DynamicObject period = FaUtils.getPeriodByDate(date, periodType);
        if (period == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u4e1a\u52a1\u65e5\u671f\u201c%s\u201d\u5bf9\u5e94\u7684\u671f\u95f4\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FaUtils_3", (String)"fi-fa-business", (Object[])new Object[0]), date == null ? " " : date));
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("org", "=", (Object)orgId));
        filters.add(new QFilter("endperiod", ">", period.get(ID)));
        filters.add(new QFilter("realcard", "in", readCardIds));
        filters.add(new QFilter("finaccountdate", "<=", (Object)period.getDate("enddate")));
        QFilter[] filterArr = filters.toArray(new QFilter[0]);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"fa_card_fin", (String)"fa_card_fin", (String)"realcard", (QFilter[])filterArr, null);){
            while (ds.hasNext()) {
                existsIds.add(ds.next().getLong("realcard"));
            }
        }
        logger.info(String.format("\u4e0d\u662f\u672a\u6765\u671f\u95f4\u5165\u8d26\u7684\u5b9e\u7269\u5361\u7247id\uff1a%s", existsIds));
        return existsIds;
    }

    public static Set<String> getRealCardCurFin4Numbers(Date date, Long orgId, Set<String> numbers) {
        HashSet<String> existsNumbers = new HashSet<String>();
        DynamicObject mainBook = FaUtils.getMainBookByOrg(orgId);
        if (mainBook == null) {
            logger.info(String.format("\u4e3b\u8d26\u7c3f\u4e3a\u7a7a\uff0corgId\uff1a%s", orgId));
            return existsNumbers;
        }
        long periodType = mainBook.getLong("periodtype");
        DynamicObject period = FaUtils.getPeriodByDate(date, periodType);
        if (period == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u4e1a\u52a1\u65e5\u671f\u201c%s\u201d\u5bf9\u5e94\u7684\u671f\u95f4\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FaUtils_3", (String)"fi-fa-business", (Object[])new Object[0]), date == null ? " " : date));
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("org", "=", (Object)orgId));
        filters.add(new QFilter("endperiod", ">", period.get(ID)));
        filters.add(new QFilter("number", "in", numbers));
        filters.add(new QFilter("finaccountdate", "<=", (Object)period.getDate("enddate")));
        QFilter[] filterArr = filters.toArray(new QFilter[0]);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"fa_card_fin", (String)"fa_card_fin", (String)"number", (QFilter[])filterArr, null);){
            while (ds.hasNext()) {
                existsNumbers.add(ds.next().getString("number"));
            }
        }
        logger.info(String.format("\u4e0d\u662f\u672a\u6765\u671f\u95f4\u5165\u8d26\u7684\u5b9e\u7269\u5361\u7247\u7f16\u7801\uff1a%s", existsNumbers));
        return existsNumbers;
    }

    public static void showErrorRealCardMsg(int errCount, String msg, DynamicObject card, IFormView view) {
        String part3 = ResManager.loadKDString((String)"\u8d44\u4ea7\u7f16\u7801\uff1a", (String)"FaUtils_22", (String)"fi-fa-business", (Object[])new Object[0]);
        if (card != null) {
            part3 = ResManager.loadKDString((String)"\u5361\u7247\u7f16\u53f7\uff1a", (String)"FaUtils_21", (String)"fi-fa-business", (Object[])new Object[0]);
            msg = card.getString(BILLNO);
        }
        String part1 = ResManager.loadKDString((String)"\u4e0b\u5217\u5361\u7247", (String)"FaUtils_4", (String)"fi-fa-business", (Object[])new Object[0]);
        String part2 = ResManager.loadKDString((String)"\u5b58\u5728\u540e\u7eed\u4e1a\u52a1\u6216\u8005\u662f\u672a\u6765\u671f\u95f4\u5165\u8d26\u7684\u5361\u7247\uff0c\u4e0d\u53ef\u505a\u5f53\u524d\u4e1a\u52a1\u3002", (String)"FaUtils_5", (String)"fi-fa-business", (Object[])new Object[0]);
        if (errCount == 1) {
            view.showErrorNotification(part3 + msg + " " + part2);
        } else {
            view.showMessage(part1 + part2, part3 + msg, MessageTypes.Default);
        }
    }

    public static String getErrorRealCardMsg(int errCount, String msg) {
        String part1 = ResManager.loadKDString((String)"\u4e0b\u5217\u5361\u7247", (String)"FaUtils_4", (String)"fi-fa-business", (Object[])new Object[0]);
        String part2 = ResManager.loadKDString((String)"\u662f\u672a\u6765\u671f\u95f4\u5165\u8d26\u7684\u5361\u7247\uff0c\u4e0d\u53ef\u505a\u5f53\u524d\u4e1a\u52a1\u3002", (String)"FaUtils_7", (String)"fi-fa-business", (Object[])new Object[0]);
        String part3 = ResManager.loadKDString((String)"\u5361\u7247\u7f16\u7801\uff1a", (String)"FaUtils_6", (String)"fi-fa-business", (Object[])new Object[0]);
        if (errCount == 1) {
            return part3 + msg + " " + part2;
        }
        return part1 + part2 + part3 + msg;
    }

    public static void showErrorNoDevRealCardMsg(int errCount, String msg, DynamicObject card, IFormView view) {
        if (card != null) {
            msg = card.getString(BILLNO);
        }
        String part1 = ResManager.loadKDString((String)"\u4e0b\u5217\u5361\u7247", (String)"FaUtils_4", (String)"fi-fa-business", (Object[])new Object[0]);
        String part2 = ResManager.loadKDString((String)"\u662f\u672a\u6765\u671f\u95f4\u5165\u8d26\u7684\u5361\u7247\uff0c\u6216\u8005\u6839\u636e\u8d44\u4ea7\u653f\u7b56\u4e0d\u5141\u8bb8\u51cf\u503c\u3002", (String)"FaUtils_8", (String)"fi-fa-business", (Object[])new Object[0]);
        String part3 = ResManager.loadKDString((String)"\u5361\u7247\u7f16\u7801\uff1a", (String)"FaUtils_6", (String)"fi-fa-business", (Object[])new Object[0]);
        if (errCount == 1) {
            view.showErrorNotification(part3 + msg + " " + part2);
        } else {
            view.showMessage(part1 + part2, part3 + msg, MessageTypes.Default);
        }
    }

    public static void showErrorSourceFlagRealCardMsg(int errCount, String msg, String part2, IFormView view) {
        String part1 = ResManager.loadKDString((String)"\u4e0b\u5217\u5361\u7247", (String)"FaUtils_4", (String)"fi-fa-business", (Object[])new Object[0]);
        String part3 = ResManager.loadKDString((String)"\u5361\u7247\u7f16\u7801\uff1a", (String)"FaUtils_6", (String)"fi-fa-business", (Object[])new Object[0]);
        if (errCount == 1) {
            String errMsg = String.format(ResManager.loadKDString((String)"%1$s%2$s %3$s", (String)"FaUtils_19", (String)"fi-fa-business", (Object[])new Object[0]), part3, msg, part2);
            view.showErrorNotification(errMsg);
        } else {
            String errMsg_1 = String.format(ResManager.loadKDString((String)"%1$s%2$s", (String)"FaUtils_20", (String)"fi-fa-business", (Object[])new Object[0]), part1, part2);
            String errMsg_2 = String.format(ResManager.loadKDString((String)"%1$s%2$s", (String)"FaUtils_20", (String)"fi-fa-business", (Object[])new Object[0]), part3, msg);
            view.showMessage(errMsg_1, errMsg_2, MessageTypes.Default);
        }
    }

    public static void showErrorIsCurPeriodCardMsg(int errCount, String msg, DynamicObject card, IFormView view) {
        if (card != null) {
            msg = card.getString(BILLNO);
        }
        if (errCount == 1) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u7f16\u7801\uff1a%1$s \u7684\u5361\u7247\u8d22\u52a1\u5165\u8d26\u5f53\u671f\u4e0d\u80fd\u505a\u8d44\u4ea7\u5408\u5e76\u4e1a\u52a1\uff0c\u8bf7\u76f4\u63a5\u4fee\u6539\u5361\u7247\u6216\u4e0b\u671f\u518d\u5408\u5e76\u3002", (String)"FaUtils_16", (String)"fi-fa-business", (Object[])new Object[0]), msg);
            view.showErrorNotification(errMsg);
        } else {
            String errMsg_1 = String.format(ResManager.loadKDString((String)"\u4e0b\u5217\u5361\u7247\u7684\u5361\u7247\u8d22\u52a1\u5165\u8d26\u5f53\u671f\u4e0d\u80fd\u505a\u8d44\u4ea7\u5408\u5e76\u4e1a\u52a1\uff0c\u8bf7\u76f4\u63a5\u4fee\u6539\u5361\u7247\u6216\u4e0b\u671f\u518d\u5408\u5e76\u3002", (String)"FaUtils_17", (String)"fi-fa-business", (Object[])new Object[0]), new Object[0]);
            String errMsg_2 = String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u7f16\u7801\uff1a%1$s\u3002", (String)"FaUtils_18", (String)"fi-fa-business", (Object[])new Object[0]), msg);
            view.showMessage(errMsg_1, errMsg_2, MessageTypes.Default);
        }
    }

    public static void showErrorIsLeaseContractCardMsg(int errCount, String msg, DynamicObject card, IFormView view) {
        if (card != null) {
            msg = card.getString(BILLNO);
        }
        String part1 = ResManager.loadKDString((String)"\u4e0b\u5217\u5361\u7247", (String)"FaUtils_4", (String)"fi-fa-business", (Object[])new Object[0]);
        String part2 = ResManager.loadKDString((String)"\u662f\u79df\u8d41\u5408\u540c\u751f\u6210\u7684\u8d44\u4ea7\uff0c\u4e0d\u53ef\u4ee5\u8fdb\u884c\u8be5\u4e1a\u52a1\u3002", (String)"FaUtils_11", (String)"fi-fa-business", (Object[])new Object[0]);
        String part3 = ResManager.loadKDString((String)"\u5361\u7247\u7f16\u7801\uff1a", (String)"FaUtils_6", (String)"fi-fa-business", (Object[])new Object[0]);
        if (errCount == 1) {
            view.showErrorNotification(part3 + msg + " " + part2);
        } else {
            view.showMessage(part1 + part2, part3 + msg, MessageTypes.Default);
        }
    }

    public static List<DynamicObject> getRealCard(List<String> asseNums) {
        ArrayList<DynamicObject> cardList = new ArrayList<DynamicObject>();
        if (asseNums.size() == 0) {
            return cardList;
        }
        QFilter[] filters = FaUtils.getRealCardByAsseNumfilters(asseNums);
        DynamicObject[] realCards = FaBillDaoFactory.getInstance("fa_card_real").query(filters);
        cardList = new ArrayList<DynamicObject>(Arrays.asList(realCards));
        return cardList;
    }

    public static List<DynamicObject> getRealCard(Long orgId, List<String> asseNums) {
        ArrayList<DynamicObject> cardList = new ArrayList<DynamicObject>();
        if (asseNums.size() == 0) {
            return cardList;
        }
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("number", "in", asseNums), new QFilter("isbak", "=", (Object)Character.valueOf('0')), new QFilter("bizstatus", "=", (Object)BizStatusEnum.READY), new QFilter("billstatus", "=", (Object)BillStatus.C)};
        DynamicObject[] realCards = FaBillDaoFactory.getInstance("fa_card_real").query(filters);
        cardList = new ArrayList<DynamicObject>(Arrays.asList(realCards));
        return cardList;
    }

    private static QFilter[] getRealCardByAsseNumfilters(List<String> asseNums) {
        QFilter[] filters = new QFilter[]{new QFilter("number", "in", asseNums), new QFilter("isbak", "=", (Object)Character.valueOf('0')), new QFilter("bizstatus", "=", (Object)BizStatusEnum.READY), new QFilter("billstatus", "=", (Object)BillStatus.C)};
        return filters;
    }

    public static List<DynamicObject> queryFinCards(Set<Object> realCardPKSet) {
        return FaUtils.queryFinCardList(realCardPKSet, null, null, null);
    }

    public static List<DynamicObject> queryFinCardList(Set<Object> realCardPKSet, Set<String> curstoms, Map<String, Long> number2RealIdMap, Long orgId) {
        HashSet realCardSet = new HashSet(realCardPKSet.size());
        realCardPKSet.forEach(r -> realCardSet.add(Long.parseLong(String.valueOf(r))));
        QFilter[] filters = new QFilter[]{new QFilter("realcardmasterid", "in", realCardSet)};
        String[] fieldArr = new String[]{ID, "realcard", "currency", "number", "depredamount", FaDaoOrmImpl.dot("realcard", "usestatus", "isdepre"), "originalval", "accumdepre", "decval", "netamount", "preresidualval", "preusingamount", FaDaoOrmImpl.dot("assetbook", "basecurrency"), FaDaoOrmImpl.dot("assetbook", "curperiod", ID), "depreuse", "isneeddepre", "bizperiod", "endperiod", "period", "monthdepre", "networth", "addupyeardepre", "depremethod", "assetcat", "isdynamic", "monthorigvalchg", "monthdeprechg", "yearorigvalchg", "finaccountdate", "realcardmasterid"};
        HashSet<String> fieldSet = new HashSet<String>();
        fieldSet.addAll(Arrays.asList(fieldArr));
        if (curstoms != null) {
            fieldSet.addAll(curstoms);
        }
        String selectorFin = String.join((CharSequence)",", fieldSet);
        DynamicObject[] finCards = BusinessDataServiceHelper.load((String)"fa_card_fin", (String)selectorFin, (QFilter[])filters, (String)"depreuse asc");
        Set bookIdSet = Stream.of(finCards).map(v -> v.get("assetbook_id")).collect(Collectors.toSet());
        String selectorBook = FaDaoOrmImpl.comma(ID, "curperiod", "depreuse", "org");
        QFilter[] bookfilters = new QFilter[]{new QFilter(ID, "in", bookIdSet)};
        DynamicObjectCollection books = QueryServiceHelper.query((String)"fa_assetbook", (String)selectorBook, (QFilter[])bookfilters);
        Map<Object, Long> bookMap = books.stream().collect(Collectors.toMap(v -> v.get(ID), v -> v.getLong("curperiod")));
        List<DynamicObject> finCardLst = Stream.of(finCards).filter(fincard -> FaUtils.filterFinCards((Long)bookMap.get(fincard.get("assetbook_id")), fincard)).collect(Collectors.toList());
        if (number2RealIdMap != null) {
            Object depreUseId;
            QFilter[] bookfilters2 = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("status", "=", (Object)"C")};
            DynamicObjectCollection books2 = QueryServiceHelper.query((String)"fa_assetbook", (String)selectorBook, (QFilter[])bookfilters2);
            HashMap depreuseId2FinNumSet = new HashMap(3, 1.0f);
            for (DynamicObject book : books2) {
                Set set = (Set)depreuseId2FinNumSet.get(book.getLong("depreuse"));
                if (set != null) continue;
                HashSet hashSet = new HashSet(realCardPKSet.size(), 1.0f);
                depreuseId2FinNumSet.put(book.getLong("depreuse"), hashSet);
            }
            for (DynamicObject fin : finCardLst) {
                String string = fin.getString("number");
                depreUseId = fin.getLong("depreuse.id");
                Set set = (Set)depreuseId2FinNumSet.get(depreUseId);
                if (set == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8d44\u4ea7\u8d26\u7c3f\u672a\u542f\u7528\uff0c\u8bf7\u5148\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"FaUtils_12", (String)"fi-fa-business", (Object[])new Object[0]));
                }
                set.add(string);
            }
            HashMap<Long, HashSet<String>> depreuseId2Num4noFin = new HashMap<Long, HashSet<String>>(3, 1.0f);
            for (String string : number2RealIdMap.keySet()) {
                for (Map.Entry entry : depreuseId2FinNumSet.entrySet()) {
                    Long depreUseId2 = (Long)entry.getKey();
                    Set numSet3 = (Set)entry.getValue();
                    if (numSet3.contains(string)) continue;
                    HashSet<String> numSet4noFin = (HashSet<String>)depreuseId2Num4noFin.get(depreUseId2);
                    if (numSet4noFin == null) {
                        numSet4noFin = new HashSet<String>(realCardPKSet.size(), 1.0f);
                        depreuseId2Num4noFin.put(depreUseId2, numSet4noFin);
                    }
                    numSet4noFin.add(string);
                }
            }
            for (Map.Entry entry : depreuseId2Num4noFin.entrySet()) {
                depreUseId = (Long)entry.getKey();
                Set set = (Set)entry.getValue();
                QFilter[] finfilters = new QFilter[]{new QFilter("number", "in", (Object)set), new QFilter("depreuse", "=", depreUseId), new QFilter("org", "=", (Object)orgId), new QFilter("endperiod", "=", (Object)99999999999L)};
                DynamicObject[] endFinCards = BusinessDataServiceHelper.load((String)"fa_card_fin", (String)selectorFin, (QFilter[])finfilters, null);
                finCardLst.addAll(Arrays.asList(endFinCards));
            }
        }
        return finCardLst;
    }

    @Deprecated
    public static List<DynamicObject> queryFinCards(Set<Object> realCardPKSet, Long depreuseId) {
        HashSet realCardSet = new HashSet(realCardPKSet.size());
        realCardPKSet.forEach(r -> realCardSet.add(Long.parseLong(String.valueOf(r))));
        QFilter[] filters = new QFilter[]{new QFilter("realcard", "in", realCardSet), new QFilter("depreuse", "=", (Object)depreuseId)};
        String selector = FaDaoOrmImpl.comma(ID, "realcard", "currency", "period", FaDaoOrmImpl.dot("realcard", "usestatus", "isdepre"), "originalval", "accumdepre", "decval", "netamount", "preresidualval", "preusingamount", FaDaoOrmImpl.dot("assetbook", "basecurrency"), FaDaoOrmImpl.dot("assetbook", "curperiod", ID), "depreuse", "isneeddepre", "bizperiod", "endperiod", "monthdepre", "networth", "addupyeardepre", "yearorigvalchg", "monthorigvalchg", "monthdeprechg", "depredamount", "depremethod", "assetcat");
        DynamicObject[] finCards = BusinessDataServiceHelper.load((String)"fa_card_fin", (String)selector, (QFilter[])filters);
        Set bookIdSet = Stream.of(finCards).map(v -> v.get("assetbook_id")).collect(Collectors.toSet());
        selector = FaDaoOrmImpl.comma(ID, "curperiod");
        DynamicObjectCollection books = QueryServiceHelper.query((String)"fa_assetbook", (String)selector, (QFilter[])new QFilter(ID, "in", bookIdSet).toArray());
        Map<Object, Long> bookMap = books.stream().collect(Collectors.toMap(v -> v.get(ID), v -> v.getLong("curperiod")));
        List<DynamicObject> finCardLst = Stream.of(finCards).filter(fincard -> FaUtils.filterFinCards((Long)bookMap.get(fincard.get("assetbook_id")), fincard)).collect(Collectors.toList());
        return finCardLst;
    }

    public static boolean filterFinCards(long curPeriodId, DynamicObject fincard) {
        boolean isRight;
        DynamicObject bizPeriodDyn = fincard.getDynamicObject("bizperiod");
        long periodId = 0L;
        if (fincard.getDynamicObject("period") != null) {
            periodId = fincard.getDynamicObject("period").getLong(ID);
        }
        long bizPeriodId = 0L;
        if (bizPeriodDyn != null) {
            bizPeriodId = fincard.getDynamicObject("bizperiod").getLong(ID);
        }
        long endPeriodId = 99999999999L;
        DynamicObject endPeriod = fincard.getDynamicObject("endperiod");
        if (endPeriod != null) {
            endPeriodId = endPeriod.getLong(ID);
        }
        boolean bl = isRight = bizPeriodId <= curPeriodId && curPeriodId < endPeriodId;
        if (isRight) {
            if (bizPeriodId < curPeriodId) {
                fincard.set("monthorigvalchg", (Object)BigDecimal.ZERO);
                fincard.set("monthdeprechg", (Object)BigDecimal.ZERO);
            }
            if (periodId != 0L && bizPeriodId / FaBizUtils.YEAR_PERIOD_L < curPeriodId / FaBizUtils.YEAR_PERIOD_L) {
                fincard.set("yearorigvalchg", (Object)BigDecimal.ZERO);
                fincard.set("addupyeardepre", (Object)BigDecimal.ZERO);
            }
        }
        return isRight;
    }

    public static DynamicObject getFinCardByNumberOrgAndDepreuse(String realNumber, long org, long depreuse) {
        QFilter realNumberFil = new QFilter("number", "=", (Object)realNumber);
        QFilter orgFil = new QFilter("org", "=", (Object)org);
        QFilter depreuseFil = new QFilter("depreuse", "=", (Object)depreuse);
        QFilter endPeriodFil = new QFilter("endperiod", "=", (Object)99999999999L);
        QFilter[] filters = new QFilter[]{realNumberFil, orgFil, depreuseFil, endPeriodFil};
        DynamicObject finCard = QueryServiceHelper.queryOne((String)"fa_card_fin", (String)ID, (QFilter[])filters);
        return finCard;
    }

    public static DynamicObject getOriFinCardByNumberOrgAndDepreuse(String realNumber, long orgId, long depreuseId) {
        QFilter numberFilter = new QFilter("number", "=", (Object)realNumber);
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter depreuseFilter = new QFilter("depreuse", "=", (Object)depreuseId);
        QFilter oriFilter = new QFilter("originaldata", "=", (Object)true);
        QFilter[] filters = new QFilter[]{numberFilter, orgFilter, depreuseFilter, oriFilter};
        DynamicObject finCard = QueryServiceHelper.queryOne((String)"fa_card_fin", (String)ID, (QFilter[])filters);
        return finCard;
    }

    public static void showDepreAnalyzeButton(final AbstractFormPlugin formPlugin, final String key) {
        AbstractGrid grid = (AbstractGrid)formPlugin.getControl(key);
        grid.addCellClickListener(new CellClickListener(){

            public void cellClick(CellClickEvent p0) {
                IPageCache pageCache = formPlugin.getPageCache();
                if (pageCache.get(key) == null) {
                    pageCache.put(key, System.currentTimeMillis() + ":" + 1);
                } else {
                    String[] arr = pageCache.get(key).split(":");
                    if (Integer.parseInt(arr[1]) >= 5) {
                        if (System.currentTimeMillis() - Long.parseLong(arr[0]) < 3000L) {
                            formPlugin.getView().setVisible(Boolean.valueOf(true), new String[]{"fetchdepreinfo"});
                        }
                        pageCache.remove(key);
                    } else {
                        pageCache.put(key, arr[0] + ":" + (Integer.parseInt(arr[1]) + 1));
                    }
                }
            }

            public void cellDoubleClick(CellClickEvent p0) {
            }
        });
    }

    public static String getRealCardPrint(String teplateKey) {
        String defaultTemplateId = "ROW3+Q90=V6";
        Long userId = ContextUtil.getUserId();
        if (userId == null) {
            return defaultTemplateId;
        }
        String settingData = UserConfigServiceHelper.getSetting((long)userId, (String)teplateKey);
        if (StringUtils.isNotBlank((CharSequence)settingData)) {
            Map jsonData = (Map)SerializationUtils.fromJsonString((String)settingData, Map.class);
            Object defaultTemplate = jsonData.get("template");
            Object settingId = jsonData.get("templateid");
            if (StringUtils.isBlank(settingId) && StringUtils.isNotBlank(defaultTemplate)) {
                String baseEntity = MetadataDao.getIdByNumber((String)defaultTemplate.toString(), (MetaCategory)MetaCategory.Form);
                settingId = baseEntity;
            }
            if (StringUtils.isNotBlank(settingId)) {
                defaultTemplateId = settingId.toString();
            }
        }
        return defaultTemplateId;
    }

    public static int getInitialCapacity43(int size) {
        return (int)((float)size / 0.75f + 1.0f);
    }

    @Deprecated
    public static Set<Long> getCurFinByDateAndRealCards(DynamicObject bill, String dateField, Long orgId, Set<Long> realCardIds) {
        Date date = bill.getDate(dateField);
        DynamicObject mainBook = FaUtils.getMainBookByOrg(orgId);
        if (mainBook == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u521b\u5efa\u6838\u7b97\u7ec4\u7ec7\u5bf9\u5e94\u7684\u4e3b\u8d26\u7c3f\u3002", (String)"FaUtils_13", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        long periodType = mainBook.getLong("periodtype");
        DynamicObject period = FaUtils.getPeriodByDate(date, periodType);
        if (period == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u4e1a\u52a1\u65e5\u671f\u201c%s\u201d\u5bf9\u5e94\u7684\u671f\u95f4\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FaUtils_3", (String)"fi-fa-business", (Object[])new Object[0]), date == null ? " " : date));
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("org", "=", (Object)orgId));
        filters.add(new QFilter("bizperiod", "=", (Object)period.getLong(ID)));
        if (realCardIds != null && !realCardIds.isEmpty()) {
            filters.add(new QFilter("realcard", "in", realCardIds));
        }
        QFilter[] filterArr = filters.toArray(new QFilter[0]);
        DynamicObjectCollection existsFinCard = QueryServiceHelper.query((String)"fa_card_fin", (String)"realcard", (QFilter[])filterArr);
        return existsFinCard.stream().map(v -> v.getLong("realcard")).collect(Collectors.toSet());
    }

    public static Set<String> getDepreMethodNumberByType(String type) {
        Map load = BusinessDataServiceHelper.loadFromCache((String)"fa_depremethod", (String)"number", (QFilter[])new QFilter[]{new QFilter("type", "=", (Object)type)});
        return load.values().stream().map(dynamicObject -> dynamicObject.getString("number")).collect(Collectors.toSet());
    }

    public static Set<Object> getDepreMethodByType(String type) {
        Map load = BusinessDataServiceHelper.loadFromCache((String)"fa_depremethod", (String)ID, (QFilter[])new QFilter[]{new QFilter("type", "=", (Object)type)});
        return load.keySet();
    }

    public static Set<Object> getDepreChangeItem() {
        HashSet<Object> changeItemIds = new HashSet<Object>(8);
        Map changeItems = BusinessDataServiceHelper.loadFromCache((String)"fa_change_item", (String)Fa.comma((String[])new String[]{ID, "topic", "number"}), (QFilter[])new QFilter[0]);
        for (Map.Entry changeItemMap : changeItems.entrySet()) {
            DynamicObject changeItem = (DynamicObject)changeItemMap.getValue();
            String topic = changeItem.getString("topic");
            String number = changeItem.getString("number");
            String key = topic + "." + number;
            if (!FaChangeItem.SYS_INIT_DEPRE_ITEM.contains(key)) continue;
            changeItemIds.add(changeItemMap.getKey());
        }
        return changeItemIds;
    }

    public static DynamicObject loadLeaseInitByOrgId(Long orgId) {
        return BusinessDataServiceHelper.loadSingleFromCache((String)"fa_lease_init", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId)});
    }

    public static String checkRealCardBizStatus(Set<Long> ids) {
        StringBuilder msg = new StringBuilder();
        Map realCardMap = BusinessDataServiceHelper.loadFromCache((String)"fa_card_real", (String)Fa.comma((String[])new String[]{"number", "bizstatus"}), (QFilter[])new QFilter[]{new QFilter(ID, "in", ids)});
        for (Map.Entry map : realCardMap.entrySet()) {
            DynamicObject realCard = (DynamicObject)map.getValue();
            String bizStatus = realCard.getString("bizstatus");
            if (BizStatusEnum.READY.name().equals(bizStatus)) continue;
            String number = realCard.getString("number");
            BizStatusEnum bizStatusEnum = BizStatusEnum.getBizStatusEnum(bizStatus);
            if (bizStatusEnum == null) {
                msg.append(String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u7f16\u7801\uff1a%1$s\u4e1a\u52a1\u72b6\u6001\u672a\u77e5%2$s\u3002", (String)"FaUtils_14", (String)"fi-fa-business", (Object[])new Object[0]), number, bizStatus));
                continue;
            }
            msg.append(String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u7f16\u7801\uff1a%1$s\u6b63\u5728\u8fdb\u884c%2$s\u4e1a\u52a1\u3002", (String)"FaUtils_15", (String)"fi-fa-business", (Object[])new Object[0]), number, bizStatusEnum.getName()));
        }
        return msg.toString();
    }

    public static String checkDataAssetRealCard(Set<Long> cardIds) {
        StringBuilder msg = new StringBuilder();
        DynamicObjectCollection realCards = QueryServiceHelper.query((String)"fa_card_real", (String)"number,sourceflag", (QFilter[])new QFilter[]{new QFilter(ID, "in", cardIds)});
        for (DynamicObject realCard : realCards) {
            if (!SourceFlagEnum.DATAASSET.name().equals(realCard.getString("sourceflag"))) continue;
            if (msg.length() > 0) {
                msg.append(",");
            }
            msg.append(realCard.getString("number"));
        }
        return msg.toString();
    }

    public static Collection<String> getFinCommonQueryField() {
        return Arrays.asList(ID, "realcard", "currency", "number", "basecurrency", "accumdepre", "decval", "netamount", "preresidualval", "preusingamount", "assetbook", "depreuse", "isneeddepre", "originalval", "realcardmasterid", "period", "bizperiod", "endperiod", "monthdepre", "networth", "addupyeardepre", "depremethod", "assetcat", "isdynamic", "monthorigvalchg", "monthdeprechg", "yearorigvalchg", "depredamount", "addidepreamount");
    }

    public static List<DynamicObject> queryFinCardList4BookCurPeriod(Collection<Long> realCardPKSet, Collection<String> otherFinCardFields, Collection<DynamicObject> allAssetBooks) {
        HashSet<String> fieldSet = new HashSet<String>(FaUtils.getFinCommonQueryField());
        if (otherFinCardFields != null) {
            fieldSet.addAll(otherFinCardFields);
        }
        HashMap<Long, DynamicObject> bookMap = new HashMap<Long, DynamicObject>(2);
        for (DynamicObject assetBook : allAssetBooks) {
            bookMap.put(assetBook.getLong(ID), assetBook);
        }
        String selector = String.join((CharSequence)",", fieldSet);
        ArrayList<DynamicObject> reFinCards = new ArrayList<DynamicObject>(realCardPKSet.size());
        HashSet<Long> realCardIdsTemp = new HashSet<Long>(reFinCards.size());
        int i = 0;
        for (Long realCardId : realCardPKSet) {
            if (i == 999) {
                FaUtils.loadFinCards(bookMap, selector, reFinCards, realCardIdsTemp);
                i = 0;
            }
            realCardIdsTemp.add(realCardId);
            ++i;
        }
        if (realCardIdsTemp.size() > 0) {
            FaUtils.loadFinCards(bookMap, selector, reFinCards, realCardIdsTemp);
        }
        return reFinCards;
    }

    private static void loadFinCards(Map<Long, DynamicObject> bookMap, String selector, List<DynamicObject> reFinCards, Set<Long> realCardIdsTemp) {
        DynamicObject[] finCards;
        QFilter[] filters = new QFilter[]{new QFilter("realcardmasterid", "in", realCardIdsTemp)};
        for (DynamicObject finCard : finCards = BusinessDataServiceHelper.load((String)"fa_card_fin", (String)selector, (QFilter[])filters, null)) {
            DynamicObject assetBook = bookMap.get(finCard.getLong(Fa.id((String)"assetbook")));
            boolean isRight = FaUtils.filterFinCards(assetBook.getLong(Fa.id((String)"curperiod")), finCard);
            if (!isRight) continue;
            reFinCards.add(finCard);
        }
        realCardIdsTemp.clear();
    }

    public static Object getValueFromDy(DynamicObject dy, String propertyName) {
        Object valueStr = "";
        if (dy != null) {
            DataEntityPropertyCollection propertys = dy.getDataEntityType().getProperties();
            for (IDataEntityProperty property : propertys) {
                String name = property.getName();
                if (!name.equals(propertyName)) continue;
                if (property instanceof BasedataProp || property instanceof OrgProp || property instanceof UserProp || property instanceof AssistantProp) {
                    if (dy.getDynamicObject(name) != null) {
                        valueStr = Long.parseLong(dy.getDynamicObject(name).getPkValue().toString());
                        break;
                    }
                    valueStr = 0L;
                    break;
                }
                if (property instanceof BooleanProp) {
                    boolean curValue = dy.getBoolean(name);
                    valueStr = curValue ? "1" : "0";
                    break;
                }
                if (property instanceof LongProp) {
                    valueStr = dy.getLong(propertyName);
                    break;
                }
                if (property instanceof IntegerProp) {
                    valueStr = dy.getInt(propertyName);
                    break;
                }
                if (property instanceof DecimalProp) {
                    valueStr = dy.getBigDecimal(propertyName);
                    break;
                }
                if (property instanceof DateProp) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    Date date = dy.getDate(propertyName);
                    if (date == null) {
                        valueStr = "";
                        break;
                    }
                    valueStr = sdf.format(date);
                    break;
                }
                valueStr = dy.getString(propertyName);
                break;
            }
        }
        return valueStr;
    }
}

