/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.utils;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.dlock.DLockInfo;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.fa.business.pclock.PcLockUtils;
import kd.fi.fa.business.pclock.inter.PcChildLock;
import kd.fi.fa.business.pclock.inter.PcParentLock;
import kd.fi.fa.business.pclock.po.DetailHoldLockBill;
import kd.fi.fa.business.pclock.po.HoldLockBill;
import kd.fi.fa.business.pclock.po.LockedBaseData;
import kd.fi.fa.business.pclock.po.PcChildLockParameter;
import kd.fi.fa.business.pclock.po.PcParentLockParameter;
import kd.fi.fa.business.utils.FaDB;

public final class FunctionMutexHelper {
    private static final String ALGO = "kd.fi.fa.business.utils.FunctionMutexHelper";
    private static final Log logger = LogFactory.getLog((String)"kd.fi.fa.business.utils.FunctionMutexHelper");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void lockWithOrg(Object orgId, Runnable runnable) {
        List<Object> assetBookPKs = FunctionMutexHelper.queryAssetBookIds(orgId);
        ArrayList<DLock> dLocks = new ArrayList<DLock>();
        try {
            DLock dLock = null;
            for (Object assetBookPK : assetBookPKs) {
                String key = FunctionMutexHelper.key(assetBookPK);
                dLock = DLock.create((String)key).fastMode();
                FunctionMutexHelper.tryToLock(dLock, key);
                dLocks.add(dLock);
            }
            String key = "fi/fa/org/" + orgId;
            try (TXHandle h = TX.required((String)key);){
                try {
                    runnable.run();
                }
                catch (Exception e) {
                    h.markRollback();
                    throw e;
                }
            }
        }
        finally {
            for (DLock dLock : dLocks) {
                dLock.close();
            }
        }
    }

    public static void lockWithBook(String holdLockDataName, DynamicObject assetbook, Runnable runnable) {
        FunctionMutexHelper.lockWithBook(holdLockDataName, assetbook, true, runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void lockWithBook(String holdLockDataName, DynamicObject assetbook, boolean releaseLockInSuccess, Runnable runnable) {
        PcParentLock pcParentLock = null;
        PcParentLockParameter parentLockParameter = new PcParentLockParameter();
        FunctionMutexHelper.getPcParentLockParameter(parentLockParameter, holdLockDataName, assetbook);
        boolean runnableSuccess = false;
        try {
            String key = FunctionMutexHelper.key(assetbook.getLong("id"));
            pcParentLock = PcLockUtils.createParentLock(parentLockParameter);
            pcParentLock.init(parentLockParameter);
            pcParentLock.lock();
            try (TXHandle h = TX.required((String)key);){
                try {
                    runnable.run();
                    runnableSuccess = true;
                }
                catch (Exception e) {
                    runnableSuccess = false;
                    h.markRollback();
                    throw e;
                }
            }
        }
        finally {
            try {
                boolean toRealseLock = true;
                if (!releaseLockInSuccess && runnableSuccess) {
                    toRealseLock = false;
                }
                if (pcParentLock != null && toRealseLock) {
                    PcParentLockParameter parentunLockParameter = FunctionMutexHelper.getPcParentUnLockParameter(parentLockParameter);
                    PcParentLock pcParentUnLock = PcLockUtils.createParentLock(parentunLockParameter);
                    pcParentUnLock.unlock();
                }
            }
            catch (Exception e) {
                logger.error("FunctionMutexHelper.lockWithBook.unlock", (Throwable)e);
            }
        }
    }

    public static void releaseLockWithBook(String holdLockDataName, DynamicObject assetbook) {
        PcParentLockParameter parentLockParameter = new PcParentLockParameter();
        FunctionMutexHelper.getPcParentLockParameter(parentLockParameter, holdLockDataName, assetbook);
        PcParentLockParameter parentunLockParameter = FunctionMutexHelper.getPcParentUnLockParameter(parentLockParameter);
        PcParentLock pcParentUnLock = PcLockUtils.createParentLock(parentunLockParameter);
        pcParentUnLock.unlock();
    }

    public static PcChildLock childLockWithBook(DynamicObject assetbook, String holdLockbillName, DynamicObject holdLockData) {
        PcChildLockParameter pcChildLockParameter = FunctionMutexHelper.getPcChildLockParameter(assetbook, holdLockbillName, holdLockData);
        PcChildLock pcChildLock = PcLockUtils.createChildLock(pcChildLockParameter);
        pcChildLock.lock();
        return pcChildLock;
    }

    public static PcChildLock childLockWithBookV2(DynamicObject assetbook, String holdLockbillName, List<DynamicObject> holdLockDataList, Boolean isRequiresNew) {
        PcChildLockParameter pcChildLockParameter = FunctionMutexHelper.getPcChildLockParameterV2(assetbook, holdLockbillName, holdLockDataList, isRequiresNew);
        PcChildLock pcChildLock = PcLockUtils.createChildLock(pcChildLockParameter);
        pcChildLock.lock();
        return pcChildLock;
    }

    public static List<PcChildLock> childLockWithOrg(Object orgId, String holdLockbillName, DynamicObject holdLockData) {
        QFilter qorg = new QFilter("org", "=", orgId);
        DynamicObject[] assetbooks = BusinessDataServiceHelper.load((String)"fa_assetbook", (String)"id,masterid,number", (QFilter[])qorg.toArray());
        ArrayList<PcChildLock> childLockParameterLockList = new ArrayList<PcChildLock>(assetbooks.length);
        for (DynamicObject assetbook : assetbooks) {
            PcChildLock pcChildLock = FunctionMutexHelper.childLockWithBook(assetbook, holdLockbillName, holdLockData);
            childLockParameterLockList.add(pcChildLock);
        }
        return childLockParameterLockList;
    }

    public static void readLock(Object bookId) {
        DLockInfo lockInfo = DLock.getLockInfo((String)FunctionMutexHelper.key(bookId));
        if (null != lockInfo) {
            logger.info("\u88ab\u9501\u4f4f\u7684fa\u5206\u5e03\u5f0f\u9501key: " + FunctionMutexHelper.key(bookId));
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6b63\u5728\u521d\u59cb\u5316\u3001\u8ba1\u63d0\u6298\u65e7\u3001\u6708\u7ed3\u6216\u8005\u53cd\u6708\u7ed3\uff0c\u8bf7\u7a0d\u540e\u518d\u6267\u884c\u6b64\u64cd\u4f5c\u3002", (String)"FunctionMutexHelper_0", (String)"fi-fa-business", (Object[])new Object[0]));
        }
    }

    public static void readlockWithOrg(Object orgId) {
        List<Object> assetBookPKs = FunctionMutexHelper.queryAssetBookIds(orgId);
        for (Object assetBookPK : assetBookPKs) {
            FunctionMutexHelper.readLock(assetBookPK);
        }
    }

    private static List<Object> queryAssetBookIds(Object assetUnitPK) {
        String sql = "SELECT FID FROM t_fa_assetbook WHERE FORGID = ?";
        ArrayList<Object> assetBookPks = new ArrayList<Object>();
        FaDB.queryDataSet(ds -> {
            for (Row row : ds) {
                assetBookPks.add(row.get("FID"));
            }
        }, ALGO, DBRoute.of((String)"fa"), sql, assetUnitPK);
        return assetBookPks;
    }

    private static void tryToLock(DLock dLock, String key) {
        boolean success = dLock.tryLock(1000L);
        if (!success) {
            logger.info("\u88ab\u9501\u4f4f\u7684fa\u5206\u5e03\u5f0f\u9501key: " + key);
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6b63\u5728\u521d\u59cb\u5316\u3001\u8ba1\u63d0\u6298\u65e7\u3001\u6708\u7ed3\u6216\u8005\u53cd\u6708\u7ed3\uff0c\u8bf7\u7a0d\u540e\u518d\u6267\u884c\u6b64\u64cd\u4f5c\u3002", (String)"FunctionMutexHelper_0", (String)"fi-fa-business", (Object[])new Object[0]));
        }
    }

    public static String key(Object assetBookPk) {
        return "fi/fa/" + assetBookPk.toString();
    }

    public static void forceUnlock(String key) {
        DLock.forceUnlock((String[])new String[]{key});
    }

    public static PcParentLockParameter getPcParentLockParameter(PcParentLockParameter parentLockParameter, String holdLockDataName, DynamicObject assetbook) {
        parentLockParameter.setLockedEntityName("fa_assetbook");
        parentLockParameter.setUsePurpose("default");
        LockedBaseData lockedBaseData = new LockedBaseData();
        lockedBaseData.setLockedDataId(assetbook.getLong("id"));
        lockedBaseData.setLockedDataMasterId(assetbook.getLong("masterid"));
        lockedBaseData.setLockedDataNum(assetbook.getString("id"));
        String name = assetbook.getDynamicObjectType().getName();
        lockedBaseData.setLockedEntityName(name);
        parentLockParameter.getLockedData().add(lockedBaseData);
        parentLockParameter.setFromHoldLockEntityName("fa_noentityname");
        HoldLockBill toHoldLockBill = new HoldLockBill();
        toHoldLockBill.setHoldLockEntityName(holdLockDataName);
        toHoldLockBill.setHoldLockDataId(assetbook.getLong("id"));
        toHoldLockBill.setHoldLockDataNum(assetbook.getString("id"));
        parentLockParameter.setToHoldLockBill(toHoldLockBill);
        parentLockParameter.setUpdateBaseData(true);
        parentLockParameter.setRequiresNew(true);
        return parentLockParameter;
    }

    private static PcChildLockParameter getPcChildLockParameter(DynamicObject assetbook, String holdLockbillName, DynamicObject holdLockData) {
        String number;
        PcChildLockParameter pcChildLockParameter = new PcChildLockParameter();
        String lockedEntityName = assetbook.getDynamicObjectType().getName();
        pcChildLockParameter.setLockedEntityName(lockedEntityName);
        pcChildLockParameter.setUsePurpose("default");
        pcChildLockParameter.setLockedDataMasterId(assetbook.getLong("id"));
        pcChildLockParameter.setLockedDataNum(assetbook.getString("id"));
        pcChildLockParameter.setInitEntityName("fa_noentityname");
        pcChildLockParameter.setRequiresNew(Boolean.TRUE);
        DetailHoldLockBill detailHoldLockBill = new DetailHoldLockBill();
        detailHoldLockBill.setHoldLockDataId(holdLockData.getLong("id"));
        switch (holdLockbillName) {
            case "fa_card_fin": {
                number = holdLockData.getString("number");
                break;
            }
            case "fa_change_dept": {
                number = holdLockData.getString("billno");
                break;
            }
            case "fa_clearbill": {
                number = holdLockData.getString("billno");
                break;
            }
            case "fa_dispatch_in": {
                number = holdLockData.getString("billno");
                break;
            }
            default: {
                number = holdLockData.getString("id");
            }
        }
        detailHoldLockBill.setHoldLockDataNum(number);
        detailHoldLockBill.setHoldLockEntityName(holdLockbillName);
        pcChildLockParameter.getDetailHoldLockBillSet().add(detailHoldLockBill);
        return pcChildLockParameter;
    }

    private static PcChildLockParameter getPcChildLockParameterV2(DynamicObject assetbook, String holdLockbillName, List<DynamicObject> holdLockDataList, Boolean isRequiresNew) {
        PcChildLockParameter pcChildLockParameter = new PcChildLockParameter();
        String lockedEntityName = assetbook.getDynamicObjectType().getName();
        pcChildLockParameter.setLockedEntityName(lockedEntityName);
        pcChildLockParameter.setUsePurpose("default");
        pcChildLockParameter.setLockedDataMasterId(assetbook.getLong("id"));
        pcChildLockParameter.setLockedDataNum(assetbook.getString("id"));
        pcChildLockParameter.setInitEntityName("fa_noentityname");
        pcChildLockParameter.setRequiresNew(isRequiresNew);
        for (DynamicObject holdLockData : holdLockDataList) {
            String number;
            DetailHoldLockBill detailHoldLockBill = new DetailHoldLockBill();
            detailHoldLockBill.setHoldLockDataId(holdLockData.getLong("id"));
            switch (holdLockbillName) {
                case "fa_card_fin": {
                    number = holdLockData.getString("number");
                    break;
                }
                case "fa_change_dept": {
                    number = holdLockData.getString("billno");
                    break;
                }
                case "fa_clearbill": {
                    number = holdLockData.getString("billno");
                    break;
                }
                case "fa_dispatch_in": {
                    number = holdLockData.getString("billno");
                    break;
                }
                case "fa_asset_devalue": {
                    number = holdLockData.getString("billno");
                    break;
                }
                case "fa_assetsplitbill": {
                    number = holdLockData.getString("billno");
                    break;
                }
                case "fa_card_real": {
                    number = holdLockData.getString("number");
                    break;
                }
                default: {
                    number = holdLockData.getString("id");
                }
            }
            detailHoldLockBill.setHoldLockDataNum(number);
            detailHoldLockBill.setHoldLockEntityName(holdLockbillName);
            pcChildLockParameter.getDetailHoldLockBillSet().add(detailHoldLockBill);
        }
        return pcChildLockParameter;
    }

    public static PcParentLockParameter getPcParentUnLockParameter(PcParentLockParameter pcParentLockParameter) {
        HoldLockBill preToHoldLockBill = pcParentLockParameter.getToHoldLockBill();
        pcParentLockParameter.setFromHoldLockEntityName(preToHoldLockBill.getHoldLockEntityName());
        pcParentLockParameter.setFromHoldLockDataId(preToHoldLockBill.getHoldLockDataId());
        pcParentLockParameter.getFromBizStatusList().clear();
        HoldLockBill toHoldLockBill = new HoldLockBill();
        toHoldLockBill.setHoldLockDataId(0L);
        toHoldLockBill.setHoldLockDataNum(" ");
        toHoldLockBill.setHoldLockEntityName("fa_noentityname");
        pcParentLockParameter.setToHoldLockBill(toHoldLockBill);
        return pcParentLockParameter;
    }
}

