/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.common.util.DateUtil;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.common.util.ThrowableHelper;

public class MigrateServiceUtils {
    private static final Log logger = LogFactory.getLog(MigrateServiceUtils.class);
    private static String selectBookFields = Fa.comma((String[])new String[]{"org", "periodtype"});

    public static Map<Long, Map<String, Object>> getMigratePeriodDate(List<Long> orgIds) {
        Map result;
        if (orgIds == null || orgIds.size() == 0) {
            return new HashMap<Long, Map<String, Object>>(1);
        }
        try {
            result = (Map)DispatchServiceHelper.invokeBizService((String)"imsc", (String)"dmw", (String)"EASMigrateService", (String)"GetControlDateByOrg", (Object[])new Object[]{"fa", orgIds});
        }
        catch (Exception e1) {
            logger.info(ThrowableHelper.toString((Throwable)e1));
            return new HashMap<Long, Map<String, Object>>(1);
        }
        if (result == null) {
            return new HashMap<Long, Map<String, Object>>(1);
        }
        Boolean isSuccess = (Boolean)result.get("success");
        if (!isSuccess.booleanValue()) {
            throw new KDBizException((String)result.get("message"));
        }
        Map data = (Map)result.get("data");
        boolean isAllNull = true;
        for (Map.Entry entry : data.entrySet()) {
            String dateValue = (String)entry.getValue();
            if (dateValue == null || dateValue.equals("null")) continue;
            isAllNull = false;
            break;
        }
        if (isAllNull) {
            return new HashMap<Long, Map<String, Object>>(1);
        }
        HashMap orgId2DateMap = new HashMap(data.size(), 1.0f);
        SimpleDateFormat sdf = DateUtil.getShortDate();
        for (Map.Entry entry : data.entrySet()) {
            String dateValue = (String)entry.getValue();
            if (dateValue == null) continue;
            Date date = null;
            try {
                date = sdf.parse(dateValue);
            }
            catch (ParseException e) {
                logger.error(ThrowableHelper.toString((Throwable)e));
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65e5\u671f\u8f6c\u6362\u5f02\u5e38\u201c%s\u201d", (String)"MigrateServiceUtils_1", (String)"fi-fa-business", (Object[])new Object[0]), dateValue));
            }
            orgId2DateMap.put(entry.getKey(), date);
        }
        QFilter[] depreUseFilters = new QFilter[]{new QFilter("default", "=", (Object)"1")};
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"fa_depreuse", (String)"id", (QFilter[])depreUseFilters);
        if (dynamicObject == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u6298\u65e7\u7528\u9014\u4e3a\u9ed8\u8ba4\u4e3a\u662f\u7684\u6570\u636e\u3002", (String)"MigrateServiceUtils_2", (String)"fi-fa-business", (Object[])new Object[0]), new Object[0]));
        }
        Long depreUseId = dynamicObject.getLong("id");
        QFilter[] bookFilters = new QFilter[]{new QFilter("org", "in", orgIds), new QFilter("depreuse", "=", (Object)depreUseId)};
        Map bookList = BusinessDataServiceHelper.loadFromCache((String)"fa_assetbook", (String)selectBookFields, (QFilter[])bookFilters);
        HashMap<Long, Long> orgId2PeriodtypeMap = new HashMap<Long, Long>(bookList.size(), 1.0f);
        for (Object bookObj : bookList.values()) {
            orgId2PeriodtypeMap.put(bookObj.getLong("org.id"), bookObj.getLong("periodtype.id"));
        }
        QFilter qFilterList = null;
        for (Map.Entry entry : orgId2DateMap.entrySet()) {
            Long orgId = (Long)entry.getKey();
            Date date = (Date)entry.getValue();
            Long periodidTypeId = (Long)orgId2PeriodtypeMap.get(orgId);
            QFilter dateFilter = new QFilter("beginDate", "<=", (Object)date).and(new QFilter("enddate", ">=", (Object)date)).and(new QFilter("periodtype", "=", (Object)periodidTypeId));
            if (qFilterList == null) {
                qFilterList = dateFilter;
                continue;
            }
            qFilterList.or(dateFilter);
        }
        qFilterList = qFilterList.and(new QFilter("isadjustperiod", "=", (Object)Character.valueOf('0')));
        DynamicObjectCollection periodList = QueryServiceHelper.query((String)"MigrateServiceUtils", (String)"bd_period", (String)"id,periodtype,begindate,enddate", (QFilter[])qFilterList.toArray(), null, (int)10000);
        HashMap hashMap = new HashMap(periodList.size(), 1.0f);
        for (DynamicObject period : periodList) {
            HashMap<String, Comparable<Long>> value2Map = new HashMap<String, Comparable<Long>>(4, 1.0f);
            Long periodtypeId = period.getLong("periodtype");
            value2Map.put("periodId", Long.valueOf(period.getLong("id")));
            value2Map.put("periodtypeId", periodtypeId);
            value2Map.put("begindate", DateUtil.getShortTypeDay((Date)period.getDate("begindate")));
            value2Map.put("enddate", DateUtil.getShortTypeDay((Date)period.getDate("enddate")));
            ArrayList value2MapList = (ArrayList)hashMap.get(periodtypeId);
            if (value2MapList == null) {
                value2MapList = new ArrayList(8);
                value2MapList.add(value2Map);
                hashMap.put(periodtypeId, value2MapList);
                continue;
            }
            value2MapList.add(value2Map);
        }
        HashMap<Long, Map<String, Object>> resultMap = new HashMap<Long, Map<String, Object>>(orgId2PeriodtypeMap.size(), 1.0f);
        block9: for (Map.Entry orgId2PeriodtypeId : orgId2PeriodtypeMap.entrySet()) {
            List periodListTemp;
            Long orgId = (Long)orgId2PeriodtypeId.getKey();
            Long periodtypeId = (Long)orgId2PeriodtypeId.getValue();
            Date migrateDate = (Date)orgId2DateMap.get(orgId);
            if (migrateDate == null || (periodListTemp = (List)hashMap.get(periodtypeId)) == null) continue;
            for (Map periodMap : periodListTemp) {
                Date begindate = (Date)periodMap.get("begindate");
                Date enddate = (Date)periodMap.get("enddate");
                if (migrateDate.getTime() < begindate.getTime() || migrateDate.getTime() > enddate.getTime()) continue;
                resultMap.put(orgId, periodMap);
                continue block9;
            }
        }
        return resultMap;
    }

    public static Map<Long, Map<String, Object>> getMigratePeriodDate(Set<Long> orgIds) {
        ArrayList<Long> orglist = new ArrayList<Long>(orgIds.size());
        for (Long orgId : orgIds) {
            orglist.add(orgId);
        }
        return MigrateServiceUtils.getMigratePeriodDate(orglist);
    }
}

