/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.utils;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.fa.common.util.Fa;

public class PeriodUtil {
    private static final String COMM_FIELDS = "id,periodtype,begindate,enddate";
    private static final String selectBdPeriodFields = Fa.comma((String[])new String[]{"id", "begindate", "enddate"});

    public static List<Long> queryPeriodIdRange(long startPeriodId, long endPeriodId, boolean includeAdjust) {
        QFilter[] filters = new QFilter[]{new QFilter("id", ">=", (Object)startPeriodId), new QFilter("id", "<=", (Object)endPeriodId), new QFilter("isadjustperiod", "=", (Object)includeAdjust)};
        DynamicObjectCollection periods = QueryServiceHelper.query((String)"bd_period", (String)"id", (QFilter[])filters, (String)"id asc");
        return periods.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
    }

    public static DynamicObject getNextPeriod(long periodId, boolean includeAdjust) {
        DynamicObject[] load;
        DynamicObject curPeriod = BusinessDataServiceHelper.loadSingleFromCache((Object)periodId, (String)"bd_period");
        if (curPeriod == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6839\u636eid(%s)\u627e\u4e0d\u5230\u671f\u95f4;", (String)"PeriodUtil_2", (String)"fi-fa-business", (Object[])new Object[0]), periodId));
        }
        long periodTypeId = curPeriod.getLong("periodtype.id");
        QFilter filter = new QFilter("id", ">", (Object)periodId).and("periodtype", "=", (Object)periodTypeId);
        if (!includeAdjust) {
            filter.and("isadjustperiod", "=", (Object)false);
        }
        if ((load = BusinessDataServiceHelper.load((String)"bd_period", (String)COMM_FIELDS, (QFilter[])filter.toArray(), (String)"id asc", (int)1)) == null || load.length == 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u4f1a\u8ba1\u671f\u95f4%s\u7684\u540e\u7eed\u671f\u95f4\u3002", (String)"PeriodUtil_1", (String)"fi-fa-business", (Object[])new Object[0]), curPeriod.getString("number")));
        }
        return load[0];
    }

    public static DynamicObject getPeriodDynById(Object periodId) {
        QFilter filter = new QFilter("id", "=", periodId);
        String selectFields = Fa.join((String)",", (String[])new String[]{"begindate", "enddate", "id"});
        DynamicObject periodDynObj = QueryServiceHelper.queryOne((String)"bd_period", (String)selectFields, (QFilter[])new QFilter[]{filter});
        if (Objects.nonNull(periodDynObj)) {
            return periodDynObj;
        }
        return null;
    }

    public static int getYearByPeriodId(Object periodId) {
        QFilter filter = new QFilter("id", "=", periodId);
        DynamicObject periodDyn = QueryServiceHelper.queryOne((String)"bd_period", (String)"periodyear", (QFilter[])new QFilter[]{filter});
        if (periodDyn != null) {
            return periodDyn.getInt("periodyear");
        }
        return 0;
    }

    public static DynamicObject getPeriodByDate(Date date, String selectField, long periodTypeId) {
        if (date == null) {
            throw new IllegalArgumentException("Illegal args date is null");
        }
        return (DynamicObject)ThreadCache.get((Object)(date.getTime() + "_" + periodTypeId + "_" + selectField), () -> {
            QFilter beginDateFilter = new QFilter("beginDate", "<=", (Object)date);
            QFilter endDateFilter = new QFilter("enddate", ">=", (Object)date);
            QFilter periodTypeFilter = new QFilter("periodtype", "=", (Object)periodTypeId);
            QFilter isAdjustPeriodFilter = new QFilter("isadjustperiod", "=", (Object)Character.valueOf('0'));
            return QueryServiceHelper.queryOne((String)"bd_period", (String)selectField, (QFilter[])new QFilter[]{beginDateFilter, endDateFilter, periodTypeFilter, isAdjustPeriodFilter});
        });
    }

    public static Map<Long, DynamicObject> getPeriodMapByType(String selectField, long periodTypeId) {
        HashMap<Long, DynamicObject> results = new HashMap<Long, DynamicObject>(16);
        QFilter periodTypeFilter = new QFilter("periodtype", "=", (Object)periodTypeId);
        QFilter isAdjustPeriodFilter = new QFilter("isadjustperiod", "=", (Object)Character.valueOf('0'));
        DynamicObjectCollection periods = QueryServiceHelper.query((String)"bd_period", (String)selectField, (QFilter[])new QFilter[]{periodTypeFilter, isAdjustPeriodFilter});
        if (CollectionUtils.isEmpty((Collection)periods)) {
            return results;
        }
        for (DynamicObject period : periods) {
            Long key = period.getLong("id");
            results.put(key, period);
        }
        return results;
    }

    public static Map<Long, DynamicObject> getPeriodMapByIds(String selectField, Set<Long> periodIds) {
        HashMap<Long, DynamicObject> results = new HashMap<Long, DynamicObject>(16);
        if (CollectionUtils.isEmpty(periodIds)) {
            return results;
        }
        QFilter filter = new QFilter("id", "in", periodIds);
        DynamicObjectCollection periodObjs = QueryServiceHelper.query((String)"bd_period", (String)selectField, (QFilter[])new QFilter[]{filter});
        if (CollectionUtils.isEmpty((Collection)periodObjs)) {
            return results;
        }
        for (DynamicObject period : periodObjs) {
            Long key = period.getLong("id");
            results.put(key, period);
        }
        return results;
    }

    public static DynamicObject getPeriodFullObjByDate(Date date, long periodTypeId) {
        QFilter beginDateFilter = new QFilter("beginDate", "<=", (Object)date);
        QFilter endDateFilter = new QFilter("enddate", ">=", (Object)date);
        QFilter periodTypeFilter = new QFilter("periodtype", "=", (Object)periodTypeId);
        QFilter isAdjustPeriodFilter = new QFilter("isadjustperiod", "=", (Object)Character.valueOf('0'));
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (QFilter[])new QFilter[]{beginDateFilter, endDateFilter, periodTypeFilter, isAdjustPeriodFilter});
    }

    public static long getMainBookBizPeriodPK(Object orgPK, Date bizDate) {
        DynamicObject book = BusinessDataServiceHelper.loadSingleFromCache((String)"fa_assetbook", (String)"periodtype", (QFilter[])new QFilter[]{new QFilter("org", "=", orgPK), new QFilter("ismainbook", "=", (Object)true)});
        long periodType = book.getLong("periodtype_id");
        DynamicObject pd = PeriodUtil.getPeriodByDate(bizDate, "id", periodType);
        return pd.getLong("id");
    }

    public static DynamicObject getMainBookYearMonthPeriod(Object orgId, String year, String month) {
        DynamicObject book = QueryServiceHelper.queryOne((String)"fa_assetbook", (String)"periodtype", (QFilter[])new QFilter[]{new QFilter("org", "=", orgId), new QFilter("ismainbook", "=", (Object)true)});
        long periodType = book.getLong("periodtype");
        StringBuilder sb = new StringBuilder();
        sb.append(periodType).append(year).append("0").append(month).append("0");
        DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(sb.toString()), (String)"bd_period");
        if (period == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6839\u636eid(%s)\u627e\u4e0d\u5230\u671f\u95f4;", (String)"PeriodUtil_2", (String)"fi-fa-business", (Object[])new Object[0]), sb.toString()));
        }
        return period;
    }

    public static long getBizPeriodPK(Object orgPK, Date bizDate, Long depreuseId) {
        DynamicObject book = QueryServiceHelper.queryOne((String)"fa_assetbook", (String)"periodtype", (QFilter[])new QFilter[]{new QFilter("org", "=", orgPK), new QFilter("depreuse", "=", (Object)depreuseId)});
        long periodType = book.getLong("periodtype");
        DynamicObject pd = PeriodUtil.getPeriodByDate(bizDate, "id", periodType);
        return pd.getLong("id");
    }

    public static void updateExistsFaDepreSum(List<Object[]> listUpdatObject) {
        if (CollectionUtils.isEmpty(listUpdatObject)) {
            return;
        }
    }

    public static int getDiffBetweenPeriods(long beginPeriodId, long endPeriodId, Object typeId) {
        DynamicObjectCollection col = QueryServiceHelper.query((String)"bd_period", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", ">", (Object)beginPeriodId), new QFilter("id", "<=", (Object)endPeriodId), new QFilter("periodtype", "=", typeId), new QFilter("isadjustperiod", "=", (Object)false)});
        return col.size();
    }

    public static int getDiffBetweenPeriods(Date begindate, Date enddate, Object periodtypeid) {
        DynamicObject period1 = QueryServiceHelper.queryOne((String)"bd_period", (String)"id", (QFilter[])new QFilter[]{new QFilter("periodtype.id", "=", periodtypeid), new QFilter("begindate", "<=", (Object)begindate), new QFilter("enddate", ">=", (Object)begindate)});
        DynamicObject period2 = QueryServiceHelper.queryOne((String)"bd_period", (String)"id", (QFilter[])new QFilter[]{new QFilter("periodtype.id", "=", periodtypeid), new QFilter("begindate", "<=", (Object)enddate), new QFilter("enddate", ">=", (Object)enddate)});
        return PeriodUtil.getDiffBetweenPeriods(period1.getLong("id"), period2.getLong("id"), periodtypeid);
    }

    public static int getPeriodNumberById(long periodId) {
        DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (String)"periodnumber", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)periodId)});
        if (period == null) {
            return 0;
        }
        return period.getInt("periodnumber");
    }

    public static DynamicObject getBdPeriod(Long targetPeriod) {
        QFilter filter2 = new QFilter("id", "=", (Object)targetPeriod);
        DynamicObject perioddy = QueryServiceHelper.queryOne((String)"bd_period", (String)selectBdPeriodFields, (QFilter[])new QFilter[]{filter2});
        return perioddy;
    }

    public static DynamicObjectCollection getBdPeriods(Set<Long> targetPeriods) {
        QFilter filter2 = new QFilter("id", "in", targetPeriods);
        DynamicObjectCollection perioddyList = QueryServiceHelper.query((String)"bd_period", (String)selectBdPeriodFields, (QFilter[])new QFilter[]{filter2});
        return perioddyList;
    }
}

