/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.SourceFlagEnum;
import kd.fi.fa.business.utils.FaAssetUnitAndUseDeptUnits;
import kd.fi.fa.business.utils.FaPermissionUtils;
import kd.fi.fa.common.util.DateUtil;
import kd.fi.fa.common.util.Fa;

public class RealCardValidator {
    private static final Log logger = LogFactory.getLog(RealCardValidator.class);

    public static Map<Integer, List<String>> validateForAllOption(ExtendedDataEntity[] dataEntities) {
        HashMap<Integer, List<String>> errorInfo = new HashMap<Integer, List<String>>(4);
        RealCardValidator.validateNumberRepeat(dataEntities, errorInfo);
        return errorInfo;
    }

    public static Map<Integer, List<String>> validateForSave(ExtendedDataEntity[] dataEntities) {
        HashMap<Integer, List<String>> errorInfo = new HashMap<Integer, List<String>>(4);
        List realCardList = Arrays.stream(dataEntities).map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
        boolean needCheckAccountDate = false;
        for (DynamicObject realCard : realCardList) {
            String sourceFlag = realCard.getString("sourceflag");
            if (!SourceFlagEnum.IMPORT.name().equals(sourceFlag) && !SourceFlagEnum.INITIAL.name().equals(sourceFlag)) continue;
            needCheckAccountDate = true;
            break;
        }
        if (needCheckAccountDate) {
            RealCardValidator.validateAccountDateAndPeriod(dataEntities, errorInfo);
        }
        RealCardValidator.validateHeadUseDept(dataEntities, errorInfo);
        RealCardValidator.validateAssetCat(dataEntities, errorInfo);
        RealCardValidator.validateAssetUnitIsLeaf(dataEntities, errorInfo);
        RealCardValidator.validateOriginMethodIsLeaf(dataEntities, errorInfo);
        RealCardValidator.validateUseStatusIsLeaf(dataEntities, errorInfo);
        RealCardValidator.validateUpdateImportFromLease(dataEntities, errorInfo);
        RealCardValidator.validateDataAssetPushed(dataEntities, errorInfo);
        return errorInfo;
    }

    private static void validateDataAssetPushed(ExtendedDataEntity[] dataEntities, Map<Integer, List<String>> errorInfo) {
        QFilter sourceFlagFilter;
        QFilter srcBillIdFilter;
        DynamicObjectCollection realCards;
        HashMap<Long, ExtendedDataEntity> idToCard = new HashMap<Long, ExtendedDataEntity>(dataEntities.length);
        HashMap<Long, Long> dataAssetRealCardMap = new HashMap<Long, Long>(dataEntities.length);
        HashSet<Long> dataAssetIds = new HashSet<Long>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject realCard = dataEntity.getDataEntity();
            if (!SourceFlagEnum.DATAASSET.name().equals(realCard.getString("sourceflag"))) continue;
            long dataAssetId = realCard.getLong("srcbillid");
            dataAssetIds.add(dataAssetId);
            long realCardId = realCard.getLong("id");
            idToCard.put(realCardId, dataEntity);
            dataAssetRealCardMap.put(dataAssetId, realCardId);
        }
        if (!dataAssetIds.isEmpty() && (realCards = QueryServiceHelper.query((String)"fa_card_real", (String)"id,srcbillid", (QFilter[])new QFilter[]{srcBillIdFilter = new QFilter("srcbillid", "in", dataAssetIds), sourceFlagFilter = new QFilter("sourceflag", "=", (Object)SourceFlagEnum.DATAASSET.name())})).size() > 0) {
            HashMap<Long, Long> existDataAssetRealCardMap = new HashMap<Long, Long>(realCards.size());
            for (DynamicObject realCard : realCards) {
                existDataAssetRealCardMap.put(realCard.getLong("srcbillid"), realCard.getLong("id"));
            }
            DynamicObjectCollection dataAssets = QueryServiceHelper.query((String)"fa_dataasset_card", (String)Fa.comma((String[])new String[]{"id", "billno"}), (QFilter[])new QFilter[]{new QFilter("id", "in", dataAssetIds)});
            HashMap<Long, String> dataAssetMap = new HashMap<Long, String>(dataAssets.size());
            for (DynamicObject dataAsset : dataAssets) {
                dataAssetMap.put(dataAsset.getLong("id"), dataAsset.getString("billno"));
            }
            for (Map.Entry entry : dataAssetRealCardMap.entrySet()) {
                Long dataAssetId = (Long)entry.getKey();
                Long curRealCardId = (Long)entry.getValue();
                Long existRealCardId = (Long)existDataAssetRealCardMap.get(dataAssetId);
                if (existRealCardId == null || existRealCardId.equals(curRealCardId)) continue;
                ExtendedDataEntity dataEntity = (ExtendedDataEntity)idToCard.get(curRealCardId);
                int index = dataEntity.getDataEntityIndex();
                List errMsg = errorInfo.computeIfAbsent(index, v -> new ArrayList());
                String msg = String.format(ResManager.loadKDString((String)"\u767b\u8bb0\u7f16\u53f7\u4e3a\u201c%s\u201d\u7684\u6570\u636e\u8d44\u4ea7\u5361\u7247\u5df2\u5b58\u5728\u4e0b\u6e38\u5355\u636e\u3002%n", (String)"RealCardValidator_0", (String)"fi-fa-business", (Object[])new Object[0]), dataAssetMap.get(dataAssetId));
                errMsg.add(msg);
            }
        }
    }

    public static Map<Integer, List<String>> validateForSubmit(ExtendedDataEntity[] dataEntities) {
        HashMap<Integer, List<String>> errorInfo = new HashMap<Integer, List<String>>(8);
        RealCardValidator.validateAccountDateAndPeriod(dataEntities, errorInfo);
        RealCardValidator.validateFieldValueExist(dataEntities, errorInfo);
        RealCardValidator.validateHeadUseDept(dataEntities, errorInfo);
        RealCardValidator.validateAssetCat(dataEntities, errorInfo);
        RealCardValidator.validateAssetUnitIsLeaf(dataEntities, errorInfo);
        RealCardValidator.validateOriginMethodIsLeaf(dataEntities, errorInfo);
        RealCardValidator.validateUseStatusIsLeaf(dataEntities, errorInfo);
        return errorInfo;
    }

    public static Map<Integer, List<String>> validateForUnAudit(ExtendedDataEntity[] dataEntities) {
        HashMap<Integer, List<String>> errorInfo = new HashMap<Integer, List<String>>(4);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject realCard = dataEntity.getDataEntity();
            String sourceFlag = realCard.getString("sourceflag");
            if (!SourceFlagEnum.SPLIT.name().equals(sourceFlag)) continue;
            int index = dataEntity.getDataEntityIndex();
            List errMsg = errorInfo.computeIfAbsent(index, v -> new ArrayList());
            errMsg.add(ResManager.loadKDString((String)"\u5361\u7247\u6765\u6e90\u65b9\u5f0f\u4e3a\u62c6\u5206\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"RealCardValidator_1", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        return errorInfo;
    }

    public static Map<Integer, List<String>> validateForDelete(ExtendedDataEntity[] dataEntities, OperateOption option) {
        boolean assetCardOperate;
        HashMap<Integer, List<String>> errorInfo = new HashMap<Integer, List<String>>(4);
        boolean deleteByDispatch = option.containsVariable("deleteByDispatch");
        if (!deleteByDispatch) {
            RealCardValidator.validateSourceFlag4Delete(dataEntities, errorInfo);
        }
        if (!(assetCardOperate = option.containsVariable("assetCardOperate"))) {
            RealCardValidator.validateIsGenFinCard(dataEntities, errorInfo);
        }
        RealCardValidator.validateHasSplitSetUp(dataEntities, errorInfo);
        return errorInfo;
    }

    private static void validateNumberRepeat(ExtendedDataEntity[] dataEntities, Map<Integer, List<String>> errorInfo) {
        HashMap<String, ExtendedDataEntity> checkDataMap = new HashMap<String, ExtendedDataEntity>(dataEntities.length, 1.0f);
        HashSet<String> checkDataSet = new HashSet<String>(dataEntities.length, 1.0f);
        for (ExtendedDataEntity extendedDataEntity : dataEntities) {
            DynamicObject realCardObj = extendedDataEntity.getDataEntity();
            String fNumber = realCardObj.getString("number");
            if (null == fNumber || null == realCardObj.getString("sourceflag") || "DISPATCH".equals(realCardObj.getString("sourceflag"))) continue;
            checkDataMap.put(fNumber, extendedDataEntity);
            boolean addResult = checkDataSet.add(fNumber);
            if (addResult) continue;
            int index = extendedDataEntity.getDataEntityIndex();
            List errMsg = errorInfo.computeIfAbsent(index, v -> new ArrayList());
            errMsg.add(String.format(ResManager.loadKDString((String)"\u672c\u6279\u6570\u636e\u4e2d\uff0c\u5b58\u5728\u91cd\u590d\u7684\u8d44\u4ea7\u7f16\u7801\u201c%s\u201d\u3002", (String)"RealCardValidator_2", (String)"fi-fa-business", (Object[])new Object[0]), fNumber));
        }
        if (!checkDataSet.isEmpty()) {
            QFilter qNumber = new QFilter("number", "in", checkDataSet);
            QFilter qIsBak = new QFilter("isbak", "=", (Object)Boolean.FALSE);
            QFilter qIsClearAll = new QFilter("bizstatus", "!=", (Object)"DELETE");
            DynamicObjectCollection queryResult = QueryServiceHelper.query((String)"fa_card_real", (String)Fa.comma((String[])new String[]{"id", "number", "masterid"}), (QFilter[])new QFilter[]{qNumber, qIsBak, qIsClearAll});
            for (DynamicObject queryCard : queryResult) {
                String number = queryCard.getString("number");
                ExtendedDataEntity extendedDataEntity = (ExtendedDataEntity)checkDataMap.get(number);
                if (null == extendedDataEntity) {
                    logger.info("extendedDataEntity checkDataMap:", (Object)((Object)checkDataMap).toString());
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u5b58\u5728\u91cd\u590d\u7684\u8d44\u4ea7\u7f16\u7801\u201c%s\u201d\u3002", (String)"RealCardValidator_3", (String)"fi-fa-business", (Object[])new Object[0]), number));
                }
                if (null == extendedDataEntity.getDataEntity()) {
                    logger.info("extendedDataEntity.getDataEntity() checkDataMap:", (Object)((Object)checkDataMap).toString());
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u5b58\u5728\u91cd\u590d\u7684\u8d44\u4ea7\u7f16\u7801\u201c%s\u201d\u3002", (String)"RealCardValidator_3", (String)"fi-fa-business", (Object[])new Object[0]), number));
                }
                DynamicObject realCard = extendedDataEntity.getDataEntity();
                Long id = realCard.getLong("masterid");
                if (id == 0L) {
                    id = realCard.getLong("id");
                }
                if (id.equals(queryCard.get("masterid"))) continue;
                String msgCaption = String.format(ResManager.loadKDString((String)"\u5b58\u5728\u91cd\u590d\u7684\u8d44\u4ea7\u7f16\u7801\u201c%s\u201d\u3002", (String)"RealCardValidator_4", (String)"fi-fa-business", (Object[])new Object[0]), number);
                int index = extendedDataEntity.getDataEntityIndex();
                List errMsg = errorInfo.computeIfAbsent(index, v -> new ArrayList());
                errMsg.add(msgCaption);
            }
        }
    }

    private static void validateHasSplitSetUp(ExtendedDataEntity[] dataEntities, Map<Integer, List<String>> errorInfo) {
        ArrayList<Long> realCardIds = new ArrayList<Long>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject realCard = dataEntity.getDataEntity();
            long realCardId = realCard.getLong("id");
            realCardIds.add(realCardId);
        }
        HashSet hasSetUpIds = new HashSet();
        DataSet splitSetUp = QueryServiceHelper.queryDataSet((String)"RealCardValidator.validateHasDepreSplitSetUp", (String)"fa_depresplitsetup", (String)"realcard", (QFilter[])new QFilter[]{new QFilter("realcard", "in", realCardIds)}, null);
        splitSetUp.forEach(v -> hasSetUpIds.add(v.getLong("realcard")));
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject realCard = dataEntity.getDataEntity();
            long realCardId = realCard.getLong("id");
            if (!hasSetUpIds.contains(realCardId)) continue;
            int index = dataEntity.getDataEntityIndex();
            List errMsg = errorInfo.computeIfAbsent(index, v -> new ArrayList());
            errMsg.add(ResManager.loadKDString((String)"\u5b58\u5728\u6298\u65e7\u5206\u644a\u8bbe\u7f6e\uff0c\u8bf7\u5148\u5220\u9664\u5bf9\u5e94\u8bbe\u7f6e\u3002", (String)"RealCardValidator_5", (String)"fi-fa-business", (Object[])new Object[0]));
        }
    }

    private static void validateIsGenFinCard(ExtendedDataEntity[] dataEntities, Map<Integer, List<String>> errorInfo) {
        ArrayList<Long> realCardIds = new ArrayList<Long>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject realCard = dataEntity.getDataEntity();
            long realCardId = realCard.getLong("id");
            realCardIds.add(realCardId);
        }
        HashSet genFinIds = new HashSet();
        DataSet finCards = QueryServiceHelper.queryDataSet((String)"RealCardValidator.validateIsGenFinCard", (String)"fa_card_fin", (String)"realcard", (QFilter[])new QFilter[]{new QFilter("realcard", "in", realCardIds)}, null);
        finCards.forEach(v -> genFinIds.add(v.getLong("realcard")));
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject realCard = dataEntity.getDataEntity();
            long realCardId = realCard.getLong("id");
            if (!genFinIds.contains(realCardId)) continue;
            int index = dataEntity.getDataEntityIndex();
            List errMsg = errorInfo.computeIfAbsent(index, v -> new ArrayList());
            errMsg.add(ResManager.loadKDString((String)"\u5b58\u5728\u4e0b\u6e38\u8d22\u52a1\u5361\u7247\uff0c\u4e0d\u5141\u8bb8\u624b\u5de5\u5220\u9664\u3002", (String)"RealCardValidator_6", (String)"fi-fa-business", (Object[])new Object[0]));
        }
    }

    private static void validateSourceFlag4Delete(ExtendedDataEntity[] dataEntities, Map<Integer, List<String>> errorInfo) {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject realCard = dataEntity.getDataEntity();
            DynamicObject originMethod = realCard.getDynamicObject("originmethod");
            if (originMethod == null) continue;
            int index = dataEntity.getDataEntityIndex();
            List errMsg = errorInfo.computeIfAbsent(index, v -> new ArrayList());
            String sourceFlag = realCard.getString("sourceflag");
            if (SourceFlagEnum.DISPATCH.name().equals(sourceFlag)) {
                errMsg.add(ResManager.loadKDString((String)"\u5361\u7247\u6765\u6e90\u65b9\u5f0f\u4e3a\u8c03\u62e8\uff0c\u4e0d\u5141\u8bb8\u624b\u5de5\u5220\u9664\u3002", (String)"RealCardValidator_7", (String)"fi-fa-business", (Object[])new Object[0]));
                continue;
            }
            if (SourceFlagEnum.SPLIT.name().equals(sourceFlag)) {
                errMsg.add(ResManager.loadKDString((String)"\u5361\u7247\u6765\u6e90\u65b9\u5f0f\u4e3a\u62c6\u5206\uff0c\u4e0d\u5141\u8bb8\u624b\u5de5\u5220\u9664\u3002", (String)"RealCardValidator_8", (String)"fi-fa-business", (Object[])new Object[0]));
                continue;
            }
            if (!SourceFlagEnum.INVENTORYPROFIT.name().equals(sourceFlag)) continue;
            errMsg.add(ResManager.loadKDString((String)"\u5361\u7247\u6765\u6e90\u65b9\u5f0f\u4e3a\u201c\u76d8\u76c8\u201d\uff0c\u4e0d\u5141\u8bb8\u624b\u5de5\u5220\u9664\u3002", (String)"RealCardValidator_9", (String)"fi-fa-business", (Object[])new Object[0]));
        }
    }

    private static void validateAssetCat(ExtendedDataEntity[] dataEntities, Map<Integer, List<String>> errorInfo) {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            boolean isLeaf;
            DynamicObject realCard = dataEntity.getDataEntity();
            DynamicObject assetCat = realCard.getDynamicObject("assetcat");
            if (assetCat == null || (isLeaf = assetCat.getBoolean("isleaf"))) continue;
            int index = dataEntity.getDataEntityIndex();
            List errMsg = errorInfo.computeIfAbsent(index, v -> new ArrayList());
            errMsg.add(String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u7c7b\u522b\u201c%s\u201d\u4e3a\u975e\u660e\u7ec6\u7c7b\u522b\uff0c\u8bf7\u5f55\u5165\u660e\u7ec6\u8d44\u4ea7\u7c7b\u522b\u3002", (String)"RealCardValidator_10", (String)"fi-fa-business", (Object[])new Object[0]), assetCat.getString("number")));
        }
    }

    private static void validateHeadUseDept(ExtendedDataEntity[] dataEntities, Map<Integer, List<String>> errorInfo) {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            long deptId;
            DynamicObject assetUnit;
            DynamicObject org;
            boolean checkResult;
            DynamicObject realCard = dataEntity.getDataEntity();
            DynamicObject headUseDept = realCard.getDynamicObject("headusedept");
            if (headUseDept == null || (checkResult = FaAssetUnitAndUseDeptUnits.checkUseDeptByAssetUnit(org = realCard.getDynamicObject("org"), assetUnit = realCard.getDynamicObject("assetunit"), deptId = headUseDept.getLong("id")))) continue;
            int index = dataEntity.getDataEntityIndex();
            List errMsg = errorInfo.computeIfAbsent(index, v -> new ArrayList());
            errMsg.add(ResManager.loadKDString((String)"\u4f7f\u7528\u90e8\u95e8\u5f53\u524d\u8d44\u4ea7\u7ec4\u7ec7\u4e0d\u53ef\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u90e8\u95e8\u3002", (String)"RealCardValidator_11", (String)"fi-fa-business", (Object[])new Object[0]));
        }
    }

    private static void validateFieldValueExist(ExtendedDataEntity[] dataEntities, Map<Integer, List<String>> errorInfo) {
        ArrayList<Long> cardUseStatusIds = new ArrayList<Long>(dataEntities.length);
        ArrayList<Long> cardOriginMethodIds = new ArrayList<Long>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject realCard = dataEntity.getDataEntity();
            long useStatusId = realCard.getLong(Fa.id((String)"usestatus"));
            cardUseStatusIds.add(useStatusId);
            long originMethodId = realCard.getLong(Fa.id((String)"originmethod"));
            cardOriginMethodIds.add(originMethodId);
        }
        DynamicObjectCollection useStatus = QueryServiceHelper.query((String)"fa_usestatus", (String)"id", (QFilter[])new QFilter("id", "in", cardUseStatusIds).toArray());
        Set useStatusIdSet = useStatus.stream().map(v -> v.getLong("id")).collect(Collectors.toSet());
        DynamicObjectCollection changeMode = QueryServiceHelper.query((String)"fa_changemode", (String)"id", (QFilter[])new QFilter("id", "in", cardOriginMethodIds).toArray());
        Set changeModeIdSet = changeMode.stream().map(v -> v.getLong("id")).collect(Collectors.toSet());
        for (ExtendedDataEntity dataEntity : dataEntities) {
            long originMethodId;
            int index = dataEntity.getDataEntityIndex();
            List errMsg = errorInfo.computeIfAbsent(index, v -> new ArrayList());
            DynamicObject realCard = dataEntity.getDataEntity();
            long useStatusId = realCard.getLong(Fa.id((String)"usestatus"));
            if (!useStatusIdSet.contains(useStatusId)) {
                errMsg.add(ResManager.loadKDString((String)"\u201c\u4f7f\u7528\u72b6\u6001\u201d\u503c\u4e3a\u7a7a\u6216\u4e0d\u662f\u76f8\u5e94\u57fa\u7840\u8d44\u6599\u7684\u503c\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165\u3002", (String)"RealCardValidator_12", (String)"fi-fa-business", (Object[])new Object[0]));
            }
            if (changeModeIdSet.contains(originMethodId = realCard.getLong(Fa.id((String)"originmethod")))) continue;
            errMsg.add(ResManager.loadKDString((String)"\u201c\u6765\u6e90\u65b9\u5f0f\u201d\u503c\u4e3a\u7a7a\u6216\u4e0d\u662f\u76f8\u5e94\u57fa\u7840\u8d44\u6599\u7684\u503c\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165\u3002", (String)"RealCardValidator_13", (String)"fi-fa-business", (Object[])new Object[0]));
        }
    }

    private static void validateAccountDateAndPeriod(ExtendedDataEntity[] dataEntities, Map<Integer, List<String>> errorInfo) {
        HashSet<Date> minBeginDateSet = new HashSet<Date>(8);
        HashMap<Long, Date> minTypeDateMap = new HashMap<Long, Date>(8);
        RealCardValidator.getMinPeriodTypeDate(minBeginDateSet, minTypeDateMap);
        if (minBeginDateSet.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u671f\u95f4\u6570\u636e\uff0c\u8bf7\u5148\u7ef4\u62a4\u4f1a\u8ba1\u671f\u95f4\u3002", (String)"RealCardValidator_14", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        Map<Long, Date> orgDateMap = RealCardValidator.getAssetBookPeriodTypeDate(dataEntities, minTypeDateMap);
        Date minMaxDate = Collections.min(minBeginDateSet);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            int index = dataEntity.getDataEntityIndex();
            List errMsg = errorInfo.computeIfAbsent(index, v -> new ArrayList());
            DynamicObject realCard = dataEntity.getDataEntity();
            Date realAccountDate = realCard.getDate("realaccountdate");
            if (realAccountDate == null) {
                errMsg.add(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u542f\u7528\u65e5\u671f\u201d\u3002", (String)"RealCardValidator_15", (String)"fi-fa-business", (Object[])new Object[0]));
                continue;
            }
            boolean justRealCard = realCard.getBoolean("justrealcard");
            String sourceFlag = realCard.getString("sourceflag");
            boolean initCard = realCard.getBoolean("initialcard");
            if (justRealCard || initCard || SourceFlagEnum.DISPATCH.name().equals(sourceFlag) || SourceFlagEnum.SPLIT.name().equals(sourceFlag)) continue;
            long orgId = realCard.getLong(Fa.id((String)"org"));
            Date assetBookDate = orgDateMap.get(orgId);
            if (assetBookDate != null) {
                if (DateUtil.compareShortDate((Date)assetBookDate, (Date)realAccountDate) <= 0) continue;
                errMsg.add(String.format(ResManager.loadKDString((String)"\u5b9e\u7269\u542f\u7528\u65e5\u671f\u5e94\u665a\u4e8e\u5bf9\u5e94\u4f1a\u8ba1\u671f\u95f4\u7c7b\u578b\u7684\u6700\u65e9\u65f6\u95f4\u201c%s\u201d\u3002", (String)"RealCardValidator_16", (String)"fi-fa-business", (Object[])new Object[0]), assetBookDate));
                continue;
            }
            if (minMaxDate == null) {
                errMsg.add(String.format(ResManager.loadKDString((String)"\u5b9e\u7269\u542f\u7528\u65e5\u671f\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u4f1a\u8ba1\u671f\u95f4\u201c%s\u201d\u3002", (String)"RealCardValidator_17", (String)"fi-fa-business", (Object[])new Object[0]), realAccountDate));
                continue;
            }
            if (DateUtil.compareShortDate((Date)minMaxDate, (Date)realAccountDate) <= 0) continue;
            errMsg.add(String.format(ResManager.loadKDString((String)"\u5b9e\u7269\u542f\u7528\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u6240\u6709\u4f1a\u8ba1\u671f\u95f4\u7c7b\u578b\u7684\u6700\u5c0f\u65f6\u95f4:%s\u3002", (String)"RealCardValidator_18", (String)"fi-fa-business", (Object[])new Object[0]), minMaxDate));
        }
    }

    private static void getMinPeriodTypeDate(Set<Date> minBeginDateSet, Map<Long, Date> minTypeDateMap) {
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"fa.RealCardValidator.getMinPeriodTypeDateList", (String)"bd_period", (String)"begindate, periodtype", null, null);){
            DataSet minBeginDate = dataSet.groupBy(new String[]{"periodtype"}).min("begindate").finish();
            for (Row row : minBeginDate) {
                Date beginDate = row.getDate("begindate");
                minBeginDateSet.add(beginDate);
                minTypeDateMap.put(row.getLong("periodtype"), beginDate);
            }
        }
    }

    private static Map<Long, Date> getAssetBookPeriodTypeDate(ExtendedDataEntity[] dataEntities, Map<Long, Date> minTypeDateMap) {
        List realCardList = Arrays.stream(dataEntities).map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
        Set orgIds = realCardList.stream().map(v -> v.getLong(Fa.id((String)"org"))).collect(Collectors.toSet());
        DynamicObjectCollection assetBooks = QueryServiceHelper.query((String)"fa_assetbook", (String)"periodtype,org", (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds)});
        HashMap<Long, Date> orgDateMap = new HashMap<Long, Date>(assetBooks.size());
        for (DynamicObject book : assetBooks) {
            Long periodTypeId = book.getLong("periodtype");
            Long orgId = book.getLong("org");
            Date periodTypeDate = minTypeDateMap.get(periodTypeId);
            Date orgDate = (Date)orgDateMap.get(orgId);
            if (orgDate != null) {
                if (DateUtil.compareShortDate((Date)orgDate, (Date)periodTypeDate) >= 0) continue;
                orgDateMap.put(orgId, periodTypeDate);
                continue;
            }
            orgDateMap.put(orgId, periodTypeDate);
        }
        return orgDateMap;
    }

    private static void validateAssetUnitIsLeaf(ExtendedDataEntity[] dataEntities, Map<Integer, List<String>> errorInfo) {
        DynamicObject realCard;
        long assetUnitId;
        List<Long> assetUnitLeafList;
        if (dataEntities.length == 1 && (assetUnitLeafList = FaPermissionUtils.getLeafOrgs(false, Collections.singletonList(assetUnitId = (realCard = dataEntities[0].getDataEntity()).getLong(Fa.id((String)"assetunit"))), "09")).isEmpty()) {
            List errMsg = errorInfo.computeIfAbsent(0, v -> new ArrayList());
            errMsg.add(ResManager.loadKDString((String)"\u5f53\u524d\u8d44\u4ea7\u7ec4\u7ec7\u975e\u672b\u7ea7\u8282\u70b9\uff0c\u4e0d\u80fd\u65b0\u589e\u5b9e\u7269\u5361\u7247\u3002", (String)"RealCardValidator_19", (String)"fi-fa-business", (Object[])new Object[0]));
        }
    }

    private static void validateOriginMethodIsLeaf(ExtendedDataEntity[] dataEntities, Map<Integer, List<String>> errorInfo) {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            boolean isleaf;
            DynamicObject realCard = dataEntity.getDataEntity();
            DynamicObject originMethod = realCard.getDynamicObject("originmethod");
            if (originMethod == null || (isleaf = originMethod.getBoolean("isleaf"))) continue;
            int index = dataEntity.getDataEntityIndex();
            List errMsg = errorInfo.computeIfAbsent(index, v -> new ArrayList());
            errMsg.add(String.format(ResManager.loadKDString((String)"\u6765\u6e90\u65b9\u5f0f\u201c%s\u201d\u975e\u53f6\u5b50\u8282\u70b9\uff0c\u8bf7\u5f55\u5165\u660e\u7ec6\u6765\u6e90\u65b9\u5f0f\u3002", (String)"RealCardValidator_20", (String)"fi-fa-business", (Object[])new Object[0]), originMethod.getString("number")));
        }
    }

    private static void validateUseStatusIsLeaf(ExtendedDataEntity[] dataEntities, Map<Integer, List<String>> errorInfo) {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            boolean isleaf;
            DynamicObject realCard = dataEntity.getDataEntity();
            DynamicObject useStatus = realCard.getDynamicObject("usestatus");
            if (useStatus == null || (isleaf = useStatus.getBoolean("isleaf"))) continue;
            int index = dataEntity.getDataEntityIndex();
            List errMsg = errorInfo.computeIfAbsent(index, v -> new ArrayList());
            errMsg.add(String.format(ResManager.loadKDString((String)"\u4f7f\u7528\u72b6\u6001\u3010%s\u3011\u975e\u53f6\u5b50\u8282\u70b9\uff0c\u8bf7\u5f55\u5165\u660e\u7ec6\u4f7f\u7528\u72b6\u6001\u3002", (String)"RealCardValidator_21", (String)"fi-fa-business", (Object[])new Object[0]), useStatus.getString("number")));
        }
    }

    private static void validateUpdateImportFromLease(ExtendedDataEntity[] dataEntities, Map<Integer, List<String>> errorInfo) {
        HashMap<Long, ExtendedDataEntity> idToCard = new HashMap<Long, ExtendedDataEntity>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            boolean fromLease;
            DynamicObject realCard = dataEntity.getDataEntity();
            if (!realCard.containsProperty("isimport") || !realCard.getBoolean("isimport")) continue;
            boolean fromDatabase = realCard.getDataEntityState().getFromDatabase();
            String sourceFlag = realCard.getString("sourceflag");
            boolean bl = fromLease = SourceFlagEnum.INITLEASECONTRACT.name().equals(sourceFlag) || SourceFlagEnum.LEASECONTRACT.name().equals(sourceFlag);
            if (!fromDatabase || !fromLease) continue;
            idToCard.put(realCard.getLong("id"), dataEntity);
        }
        if (!idToCard.isEmpty()) {
            Set realCardIds = idToCard.keySet();
            String queryField = String.join((CharSequence)",", "id", Fa.dot((String[])new String[]{"assetcat", "id"}), "assetname", "assetamount", Fa.dot((String[])new String[]{"unit", "id"}), Fa.dot((String[])new String[]{"supplier", "id"}), Fa.dot((String[])new String[]{"storeplace", "id"}));
            DynamicObjectCollection realCardByData = QueryServiceHelper.query((String)"fa_card_real", (String)queryField, (QFilter[])new QFilter[]{new QFilter("id", "in", realCardIds)});
            for (DynamicObject realCard4DB : realCardByData) {
                long realCardId = realCard4DB.getLong("id");
                ExtendedDataEntity dataEntity = (ExtendedDataEntity)idToCard.get(realCardId);
                DynamicObject saveRealCard = dataEntity.getDataEntity();
                int index = dataEntity.getDataEntityIndex();
                List errMsg = errorInfo.computeIfAbsent(index, v -> new ArrayList());
                if (realCard4DB.getLong(Fa.dot((String[])new String[]{"assetcat", "id"})) != saveRealCard.getLong(Fa.dot((String[])new String[]{"assetcat", "id"}))) {
                    errMsg.add(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u79df\u8d41\u5408\u540c\u4e0b\u63a8\u7684\u521d\u59cb\u5316\u5b9e\u7269\u5361\u7247\u548c\u79df\u8d41\u5408\u540c\u4e0b\u63a8\u7684\u5b9e\u7269\u5361\u7247\u4e2d\u7684\u8d44\u4ea7\u7c7b\u522b\u4e0d\u80fd\u4fee\u6539\u3002\r\n", (String)"RealCardValidator_22", (String)"fi-fa-business", (Object[])new Object[0]));
                }
                if (!realCard4DB.getString("assetname").equals(saveRealCard.getString("assetname"))) {
                    errMsg.add(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u79df\u8d41\u5408\u540c\u4e0b\u63a8\u7684\u521d\u59cb\u5316\u5b9e\u7269\u5361\u7247\u548c\u79df\u8d41\u5408\u540c\u4e0b\u63a8\u7684\u5b9e\u7269\u5361\u7247\u4e2d\u7684\u8d44\u4ea7\u540d\u79f0\u4e0d\u80fd\u4fee\u6539\u3002\r\n", (String)"RealCardValidator_23", (String)"fi-fa-business", (Object[])new Object[0]));
                }
                if (realCard4DB.getBigDecimal("assetamount").compareTo(saveRealCard.getBigDecimal("assetamount")) != 0) {
                    errMsg.add(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u79df\u8d41\u5408\u540c\u4e0b\u63a8\u7684\u521d\u59cb\u5316\u5b9e\u7269\u5361\u7247\u548c\u79df\u8d41\u5408\u540c\u4e0b\u63a8\u7684\u5b9e\u7269\u5361\u7247\u4e2d\u7684\u8d44\u4ea7\u6570\u91cf\u4e0d\u80fd\u4fee\u6539\u3002\r\n", (String)"RealCardValidator_24", (String)"fi-fa-business", (Object[])new Object[0]));
                }
                if (realCard4DB.getLong(Fa.dot((String[])new String[]{"unit", "id"})) != saveRealCard.getLong(Fa.dot((String[])new String[]{"unit", "id"}))) {
                    errMsg.add(ResManager.loadKDString((String)"\u201c\u521d\u59cb\u5316\u79df\u8d41\u5408\u540c\u201d\u4e0b\u63a8\u7684\u201c\u521d\u59cb\u5316\u5b9e\u7269\u5361\u7247\u201d\u548c\u201c\u79df\u8d41\u5408\u540c\u201d\u4e0b\u63a8\u7684\u201c\u5b9e\u7269\u5361\u7247\u201d\u4e2d\u7684\u8ba1\u91cf\u5355\u4f4d\u4e0d\u80fd\u4fee\u6539\u3002%n", (String)"RealCardValidator_25", (String)"fi-fa-business", (Object[])new Object[0]));
                }
                if (realCard4DB.getLong(Fa.dot((String[])new String[]{"supplier", "id"})) != saveRealCard.getLong(Fa.dot((String[])new String[]{"supplier", "id"}))) {
                    errMsg.add(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u79df\u8d41\u5408\u540c\u4e0b\u63a8\u7684\u521d\u59cb\u5316\u5b9e\u7269\u5361\u7247\u548c\u79df\u8d41\u5408\u540c\u4e0b\u63a8\u7684\u5b9e\u7269\u5361\u7247\u4e2d\u7684\u4f9b\u5e94\u5546\u4e0d\u80fd\u4fee\u6539\u3002\r\n", (String)"RealCardValidator_26", (String)"fi-fa-business", (Object[])new Object[0]));
                }
                if (realCard4DB.getLong(Fa.dot((String[])new String[]{"storeplace", "id"})) == saveRealCard.getLong(Fa.dot((String[])new String[]{"storeplace", "id"}))) continue;
                errMsg.add(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u79df\u8d41\u5408\u540c\u4e0b\u63a8\u7684\u521d\u59cb\u5316\u5b9e\u7269\u5361\u7247\u548c\u79df\u8d41\u5408\u540c\u4e0b\u63a8\u7684\u5b9e\u7269\u5361\u7247\u4e2d\u7684\u5b58\u653e\u5730\u70b9\u4e0d\u80fd\u4fee\u6539\u3002\r\n", (String)"RealCardValidator_27", (String)"fi-fa-business", (Object[])new Object[0]));
            }
        }
    }
}

