/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.validator.changeitem;

import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.constants.FaChangeItem;

public class ChangeItemSelectValidator {
    public static boolean hasOriginalChange(DynamicObjectCollection changeItems) {
        for (DynamicObject itemBody : changeItems) {
            DynamicObject item = itemBody.getDynamicObject("fbasedataid");
            Object pkValue = item.getPkValue();
            String number = item.getString("number");
            String topic = item.getString("topic");
            if (!"originalval".equals(number) && !"preresidualval".equals(number) || !"fa_card_fin".equals(topic)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasPreUsingAmountChange(DynamicObjectCollection changeItems) {
        for (DynamicObject itemBody : changeItems) {
            DynamicObject item = itemBody.getDynamicObject("fbasedataid");
            Object pkValue = item.getPkValue();
            String number = item.getString("number");
            String topic = item.getString("topic");
            if (!"preusingamount".equals(number) || !"fa_card_fin".equals(topic)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDepreChangeItem(DynamicObject changeItem) {
        String topic = changeItem.getString("topic");
        String number = changeItem.getString("number");
        String key = topic + "." + number;
        return FaChangeItem.SYS_INIT_DEPRE_ITEM.contains(key);
    }

    public static DynamicObjectCollection queryDepreChangeItem() {
        QFilter originalvalFilter = new QFilter("number", "=", (Object)"originalval").and(new QFilter("topic", "=", (Object)"fa_card_fin"));
        QFilter preresidualvalFilter = new QFilter("number", "=", (Object)"preresidualval").and(new QFilter("topic", "=", (Object)"fa_card_fin"));
        QFilter preusingamountFilter = new QFilter("number", "=", (Object)"preusingamount").and(new QFilter("topic", "=", (Object)"fa_card_fin"));
        QFilter usestatusFilter = new QFilter("number", "=", (Object)"usestatus").and(new QFilter("topic", "=", (Object)"fa_card_real"));
        QFilter depremethodFilter = new QFilter("number", "=", (Object)"depremethod").and(new QFilter("topic", "=", (Object)"fa_card_fin"));
        QFilter realaccountdateFilter = new QFilter("number", "=", (Object)"realaccountdate").and(new QFilter("topic", "=", (Object)"fa_card_real"));
        QFilter filter = originalvalFilter.or(preresidualvalFilter).or(preusingamountFilter).or(usestatusFilter).or(depremethodFilter).or(realaccountdateFilter);
        DynamicObjectCollection depreChangeItems = QueryServiceHelper.query((String)"fa_change_item", (String)"id,number,topic", (QFilter[])filter.toArray());
        return depreChangeItems;
    }

    public static void validate(Set<Object> selectChangeItems, DynamicObjectCollection depreChangeItems) {
        Set depreChgItemIds = depreChangeItems.stream().map(v -> v.get("id")).collect(Collectors.toSet());
        DynamicObject countDate = depreChangeItems.stream().filter(v -> "realaccountdate".equals(v.getString("number")) && "fa_card_real".equals(v.getString("topic"))).findFirst().get();
        if (selectChangeItems.size() > 1 && selectChangeItems.contains(countDate.get("id"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u542f\u7528\u65e5\u671f\u4e0d\u80fd\u4e0e\u5176\u5b83\u9879\u76ee\u7ec4\u5408\u53d8\u66f4", (String)"ChangeItemSelectValidator_0", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        boolean hasRemoved = selectChangeItems.removeAll(depreChgItemIds);
        if (hasRemoved && !selectChangeItems.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u540c\u65f6\u5305\u542b\u5f71\u54cd\u6298\u65e7\u7684\u53d8\u66f4\u9879\u76ee\u548c\u4e0d\u5f71\u54cd\u6298\u65e7\u7684\u53d8\u66f4\u9879\u76ee\u3002", (String)"ChangeItemSelectValidator_1", (String)"fi-fa-business", (Object[])new Object[0]));
        }
    }

    public static void validate(Set<Object> selectChangeItems) {
        ChangeItemSelectValidator.validate(selectChangeItems, ChangeItemSelectValidator.queryDepreChangeItem());
    }
}

