/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.validator.lease;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;

public class DiscountRateValidator {
    public static List<String> validateForSave(DynamicObject discountRate) {
        List<String> errorInfo = DiscountRateValidator.validateMustInput(discountRate);
        if (!errorInfo.isEmpty()) {
            return errorInfo;
        }
        errorInfo = DiscountRateValidator.validateData(discountRate);
        if (!errorInfo.isEmpty()) {
            return errorInfo;
        }
        return Collections.emptyList();
    }

    private static List<String> validateMustInput(DynamicObject discountRate) {
        DynamicObjectCollection entry;
        Date effectiveDate;
        DynamicObject currency;
        String name;
        String number;
        ArrayList<String> errorInfo = new ArrayList<String>(4);
        DynamicObject org = discountRate.getDynamicObject("org");
        if (org == null) {
            errorInfo.add(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6838\u7b97\u7ec4\u7ec7\u201d\u3002", (String)"DiscountRateValidator_0", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)(number = discountRate.getString("number")))) {
            errorInfo.add(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7f16\u7801\u201d\u3002", (String)"DiscountRateValidator_1", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)(name = discountRate.getString("name")))) {
            errorInfo.add(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u540d\u79f0\u201d\u3002", (String)"DiscountRateValidator_2", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if ((currency = discountRate.getDynamicObject("currency")) == null) {
            errorInfo.add(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5e01\u522b\u201d\u3002", (String)"DiscountRateValidator_3", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if ((effectiveDate = discountRate.getDate("effectivedate")) == null) {
            errorInfo.add(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u751f\u6548\u65e5\u671f\u201d\u3002", (String)"DiscountRateValidator_4", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if ((entry = discountRate.getDynamicObjectCollection("entryentity")) == null || entry.isEmpty()) {
            errorInfo.add(ResManager.loadKDString((String)"\u6298\u73b0\u7387\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DiscountRateValidator_5", (String)"fi-fa-business", (Object[])new Object[0]));
            return errorInfo;
        }
        for (int i = 0; i < entry.size(); ++i) {
            BigDecimal annualizedRate;
            int term;
            DynamicObject row = (DynamicObject)entry.get(i);
            String describe = row.getString("describe");
            if (StringUtils.isBlank((CharSequence)describe)) {
                errorInfo.add(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\uff1a\u8bf7\u586b\u5199\u201c\u63cf\u8ff0\u201d\u3002", (String)"DiscountRateValidator_6", (String)"fi-fa-business", (Object[])new Object[0]), i + 1));
            }
            if ((term = row.getInt("term")) <= 0) {
                errorInfo.add(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\uff1a\u8bf7\u586b\u5199\u201c\u671f\u9650\uff08\u6708\uff09\u201d\u3002", (String)"DiscountRateValidator_7", (String)"fi-fa-business", (Object[])new Object[0]), i + 1));
            }
            if ((annualizedRate = row.getBigDecimal("annualizedrate")) != null && BigDecimal.ZERO.compareTo(annualizedRate) < 0) continue;
            errorInfo.add(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\uff1a\u8bf7\u586b\u5199\u201c\u5e74\u5316\u6298\u73b0\u7387\u201d\u3002", (String)"DiscountRateValidator_8", (String)"fi-fa-business", (Object[])new Object[0]), i + 1));
        }
        return errorInfo;
    }

    private static List<String> validateData(DynamicObject discountRate) {
        ArrayList<String> errorInfo = new ArrayList<String>(4);
        DynamicObject currency = discountRate.getDynamicObject("currency");
        boolean currencyEnable = currency.getBoolean("enable");
        if (!currencyEnable) {
            errorInfo.add(ResManager.loadKDString((String)"\u5e01\u522b\u4e3a\u7981\u7528\u72b6\u6001\uff0c\u4e0d\u53ef\u4f7f\u7528\u3002", (String)"DiscountRateValidator_9", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        DynamicObjectCollection entry = discountRate.getDynamicObjectCollection("entryentity");
        int preTerm = -1;
        for (DynamicObject row : entry) {
            int term = row.getInt("term");
            if (preTerm == -1) {
                preTerm = term;
                continue;
            }
            if (term > preTerm) continue;
            int seq = row.getInt("seq");
            errorInfo.add(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\uff1a\u201c\u671f\u9650\uff08\u6708\uff09\u201d\u5fc5\u987b\u5927\u4e8e\u4e0a\u4e00\u884c\u3002", (String)"DiscountRateValidator_10", (String)"fi-fa-business", (Object[])new Object[0]), seq));
            break;
        }
        return errorInfo;
    }
}

