/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.validator.lease;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.validate.BillStatus;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.fa.business.enums.lease.InvoiceType;
import kd.fi.fa.business.enums.lease.LeaseContractSourceType;
import kd.fi.fa.business.enums.lease.PayPoint;
import kd.fi.fa.business.enums.lease.TransitionPlan;
import kd.fi.fa.business.lease.utils.LeaseUtil;
import kd.fi.fa.business.utils.SystemParamHelper;
import kd.fi.fa.common.util.DateUtil;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.common.util.Tuple;

public class LeaseContractValidator {
    private static final int AMOUNT_MAX_VALID_NUMBER = 19;
    private static final String ENABLE = "1";

    public static List<String> validateContractForImport(DynamicObject leaseContract) {
        List<String> errorInfoList = LeaseContractValidator.validateMustInput4Submit(leaseContract);
        if (!errorInfoList.isEmpty()) {
            return errorInfoList;
        }
        errorInfoList = LeaseContractValidator.validateForGeneratePayPlan(leaseContract);
        if (!errorInfoList.isEmpty()) {
            return errorInfoList;
        }
        return LeaseContractValidator.validateContractData(leaseContract);
    }

    public static List<String> validateContractForSave(DynamicObject leaseContract) {
        return LeaseContractValidator.validateMustInput4Save(leaseContract);
    }

    public static List<String> validateContractForSubmit(DynamicObject leaseContract) {
        List<String> errorInfoList = LeaseContractValidator.validateMustInput4Submit(leaseContract);
        if (!errorInfoList.isEmpty()) {
            return errorInfoList;
        }
        errorInfoList = LeaseContractValidator.validateForGeneratePayPlan(leaseContract);
        if (!errorInfoList.isEmpty()) {
            return errorInfoList;
        }
        errorInfoList = LeaseContractValidator.validateContractData(leaseContract);
        if (!errorInfoList.isEmpty()) {
            return errorInfoList;
        }
        return LeaseContractValidator.validateContractAmountMaxValue(leaseContract);
    }

    public static List<String> validateContractForAudit(DynamicObject leaseContract) {
        return new ArrayList<String>(0);
    }

    public static List<String> validateInitContractForImport(DynamicObject leaseContract) {
        List<String> errorInfo = LeaseContractValidator.validateContractForImport(leaseContract);
        if (!errorInfo.isEmpty()) {
            return errorInfo;
        }
        errorInfo.addAll(LeaseContractValidator.validateInitContractForSubmit(leaseContract));
        return errorInfo;
    }

    public static List<String> validateInitContractForSubmit(DynamicObject leaseContract) {
        return LeaseContractValidator.validateInitContractData(leaseContract);
    }

    public static List<String> validateInitContractForAudit(DynamicObject leaseContract) {
        ArrayList<String> errorInfo = new ArrayList<String>(2);
        errorInfo.addAll(LeaseContractValidator.validateInitContractLeaseLiabOriAndPayPlan(leaseContract));
        errorInfo.addAll(LeaseContractValidator.validateLeaseLiabAndLeaseLiabOri(leaseContract));
        return errorInfo;
    }

    public static List<String> validateInitContractForUnAudit(DynamicObject leaseContract) {
        ArrayList<String> errorInfo = new ArrayList<String>(1);
        DynamicObject org = leaseContract.getDynamicObject("org");
        long orgId = org.getLong("id");
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId)};
        DynamicObject mainBook = BusinessDataServiceHelper.loadSingleFromCache((String)"fa_lease_init", (String)"status", (QFilter[])filters);
        String status = mainBook.getString("status");
        if (BillStatus.C.name().equals(status)) {
            errorInfo.add(ResManager.loadKDString((String)"\u5bf9\u5e94\u7ec4\u7ec7\u5df2\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u53cd\u5ba1\u6838\u5931\u8d25\u3002", (String)"LeaseContractValidator_0", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        return errorInfo;
    }

    public static List<String> validateForGeneratePayPlan(DynamicObject leaseContract) {
        List<String> errorInfo = LeaseContractValidator.validateMustInput4GenPayPlan(leaseContract);
        if (!errorInfo.isEmpty()) {
            return errorInfo;
        }
        errorInfo = LeaseContractValidator.validatePayRuleDate(leaseContract);
        if (!errorInfo.isEmpty()) {
            return errorInfo;
        }
        return new ArrayList<String>(0);
    }

    public static List<String> validateForPush(List<DynamicObject> leaseContracts) {
        ArrayList<String> errInitNumber = new ArrayList<String>(8);
        ArrayList<String> errorInfo = new ArrayList<String>(4);
        ArrayList errNumber = new ArrayList(10);
        HashSet<Long> orgIds = new HashSet<Long>(2);
        HashMap<Long, String> id2Number = new HashMap<Long, String>(leaseContracts.size(), 1.0f);
        for (DynamicObject dynamicObject : leaseContracts) {
            long leaseContractId = dynamicObject.getLong("id");
            String number = dynamicObject.getString("number");
            id2Number.put(leaseContractId, number);
            if ("B".equals(dynamicObject.getString("sourcetype"))) {
                errInitNumber.add(number);
            }
            orgIds.add(dynamicObject.getLong(Fa.id((String)"org")));
        }
        LeaseContractValidator.checkLeaseInitPeriod2BookPeriod(errorInfo, orgIds);
        if (!errInitNumber.isEmpty()) {
            String errInitNumbers = String.join((CharSequence)", ", errInitNumber);
            errorInfo.add(String.format(ResManager.loadKDString((String)"\u5408\u540c\u53f7\uff1a%s \u4e3a\u521d\u59cb\u5316\u5408\u540c\uff0c\u8bf7\u901a\u8fc7\u521d\u59cb\u5316\u5408\u540c\u4e0b\u63a8\u3002", (String)"LeaseContractValidator_1", (String)"fi-fa-business", (Object[])new Object[0]), errInitNumbers));
        }
        DynamicObjectCollection realCards = QueryServiceHelper.query((String)"fa_card_real", (String)"srcbillid", (QFilter[])new QFilter[]{new QFilter("srcbillid", "in", id2Number.keySet())});
        for (DynamicObject realCard : realCards) {
            long srcBillId = realCard.getLong("srcbillid");
            if (!id2Number.containsKey(srcBillId)) continue;
            errNumber.add(id2Number.get(srcBillId));
        }
        if (!errNumber.isEmpty()) {
            String string = String.join((CharSequence)", ", errNumber);
            errorInfo.add(String.format(ResManager.loadKDString((String)"\u5408\u540c\u53f7\uff1a%s \u5b58\u5728\u540e\u7eed\u5b9e\u7269\u5361\u7247\uff0c\u4e0b\u63a8\u5931\u8d25\u3002", (String)"LeaseContractValidator_2", (String)"fi-fa-business", (Object[])new Object[0]), string));
        }
        return errorInfo;
    }

    private static void checkLeaseInitPeriod2BookPeriod(List<String> errorInfo, Set<Long> orgIds) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("select a.fname from t_fa_lease_init a inner join t_fa_assetbook b on a.forgid = b.forgid and b.fismainbook = '1'", new Object[0]);
        sql.append(" where a.fenableperiodid > b.fcurrentperiodid", new Object[0]);
        sql.appendIn(" and a.forgid", orgIds.toArray());
        DataSet dataSet = DB.queryDataSet((String)"leaseContractPushCard", (DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)sql);
        StringBuffer sb = new StringBuffer();
        while (dataSet.hasNext()) {
            Row next = dataSet.next();
            String orgName = next.getString("fname");
            if (sb.length() > 0) {
                sb.append("\uff0c");
            }
            sb.append(orgName);
        }
        if (sb.length() > 0) {
            errorInfo.add(String.format(ResManager.loadKDString((String)"\u4e0b\u63a8\u5931\u8d25\uff0c\u4ee5\u4e0b\u6838\u7b97\u7ec4\u7ec7\u8d26\u7c3f\u5f53\u524d\u671f\u95f4\u65e9\u4e8e\u79df\u8d41\u521d\u59cb\u5316\u7684\u542f\u7528\u671f\u95f4\uff1a%s", (String)"LeaseContractValidator_3", (String)"fi-fa-business", (Object[])new Object[0]), sb));
        }
    }

    public static List<String> validateForPushByInit(List<DynamicObject> leaseContracts) {
        ArrayList<String> errorInfo = new ArrayList<String>(4);
        ArrayList<String> errNumber = new ArrayList<String>(10);
        for (DynamicObject contract : leaseContracts) {
            long masterId = contract.getLong("masterid");
            boolean push = BFTrackerServiceHelper.isPush((String)"fa_lease_contract_init", (Long)masterId);
            if (!push) continue;
            errNumber.add(contract.getString("number"));
        }
        if (!errNumber.isEmpty()) {
            String errNumbers = String.join((CharSequence)", ", errNumber);
            errorInfo.add(String.format(ResManager.loadKDString((String)"\u5408\u540c\u53f7\uff1a%s \u5b58\u5728\u540e\u7eed\u5b9e\u7269\u5361\u7247\uff0c\u4e0b\u63a8\u5931\u8d25\u3002", (String)"LeaseContractValidator_2", (String)"fi-fa-business", (Object[])new Object[0]), errNumbers));
        }
        return errorInfo;
    }

    public static List<String> validateForLinkQuery(List<DynamicObject> leaseContracts) {
        ArrayList<String> errorInfo = new ArrayList<String>(4);
        ArrayList<Long> contractIds = new ArrayList<Long>(leaseContracts.size());
        for (DynamicObject contract : leaseContracts) {
            long settleShareSrcId = contract.getLong("settlesharesrcid");
            if (settleShareSrcId != 0L) {
                contractIds.add(settleShareSrcId);
                continue;
            }
            contractIds.add(contract.getLong("id"));
        }
        QFilter filter = new QFilter("leasecontract", "in", contractIds);
        DynamicObjectCollection rentSettle = QueryServiceHelper.query((String)"fa_lease_rent_settle", (String)"leasecontract", (QFilter[])new QFilter[]{filter});
        Set existContractId = rentSettle.stream().map(v -> v.getLong("leasecontract")).collect(Collectors.toSet());
        ArrayList<String> errNumber = new ArrayList<String>(10);
        for (DynamicObject contract : leaseContracts) {
            long id = contract.getLong("settlesharesrcid");
            if (id == 0L) {
                id = contract.getLong("id");
            }
            if (existContractId.contains(id)) continue;
            String number = contract.getString("number");
            errNumber.add(number);
        }
        if (!errNumber.isEmpty()) {
            String errNumbers = String.join((CharSequence)", ", errNumber);
            errorInfo.add(String.format(ResManager.loadKDString((String)"\u5408\u540c\u53f7\uff1a%s \u6ca1\u6709\u5173\u8054\u6570\u636e\u3002", (String)"LeaseContractValidator_4", (String)"fi-fa-business", (Object[])new Object[0]), errNumbers));
        }
        return errorInfo;
    }

    private static List<String> validateContractAmountMaxValue(DynamicObject leaseContract) {
        BigDecimal leaseAssets;
        String leaseAssetsStr;
        int leaseAssetsValidNum;
        ArrayList<String> errorInfoList = new ArrayList<String>(2);
        BigDecimal leaseLiab = leaseContract.getBigDecimal("leaseliab");
        String leaseLiabStr = leaseLiab.toPlainString();
        int leaseLiabValidNum = leaseLiabStr.replace(".", StringUtils.getEmpty()).length();
        if (leaseLiabValidNum > 19) {
            errorInfoList.add(ResManager.loadKDString((String)"\u201c\u79df\u8d41\u8d1f\u503a\u73b0\u503c\u201d\u8d85\u8fc7\u6700\u5927\u503c\u3002", (String)"LeaseContractValidator_5", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if ((leaseAssetsValidNum = (leaseAssetsStr = (leaseAssets = leaseContract.getBigDecimal("leaseassets")).toPlainString()).replace(".", StringUtils.getEmpty()).length()) > 19) {
            errorInfoList.add(ResManager.loadKDString((String)"\u201c\u4f7f\u7528\u6743\u8d44\u4ea7\u539f\u503c\u201d\u8d85\u8fc7\u6700\u5927\u503c\u3002", (String)"LeaseContractValidator_6", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        return errorInfoList;
    }

    private static List<String> validateMustInput4Save(DynamicObject leaseContract) {
        ArrayList<String> errorInfoList = new ArrayList<String>(17);
        String number = leaseContract.getString("number");
        if (StringUtils.isEmpty((String)number)) {
            errorInfoList.add(ResManager.loadKDString((String)"\u201c\u5408\u540c\u53f7\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LeaseContractValidator_7", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if (!errorInfoList.isEmpty()) {
            return errorInfoList;
        }
        return new ArrayList<String>(0);
    }

    private static List<String> validateMustInput4Submit(DynamicObject leaseContract) {
        Date leaseEndDate;
        Date leaseStartDate;
        BigDecimal assetAmount;
        DynamicObject unit;
        DynamicObject storePlace;
        String assetName;
        DynamicObject assetCat;
        DynamicObject leaser;
        String name;
        String number;
        DynamicObject org;
        ArrayList<String> errorInfoList = new ArrayList<String>(17);
        DynamicObject assetUnit = leaseContract.getDynamicObject("assetunit");
        if (assetUnit == null) {
            errorInfoList.add(ResManager.loadKDString((String)"\u201c\u8d44\u4ea7\u7ec4\u7ec7\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LeaseContractValidator_8", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if ((org = leaseContract.getDynamicObject("org")) == null) {
            errorInfoList.add(ResManager.loadKDString((String)"\u201c\u6838\u7b97\u7ec4\u7ec7\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LeaseContractValidator_9", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((String)(number = leaseContract.getString("number")))) {
            errorInfoList.add(ResManager.loadKDString((String)"\u201c\u5408\u540c\u53f7\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LeaseContractValidator_7", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((String)(name = leaseContract.getString("name")))) {
            errorInfoList.add(ResManager.loadKDString((String)"\u201c\u5408\u540c\u540d\u79f0\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LeaseContractValidator_10", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if ((leaser = leaseContract.getDynamicObject("leaser")) == null) {
            errorInfoList.add(ResManager.loadKDString((String)"\u201c\u51fa\u79df\u65b9\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LeaseContractValidator_11", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if ((assetCat = leaseContract.getDynamicObject("assetcat")) == null) {
            errorInfoList.add(ResManager.loadKDString((String)"\u201c\u8d44\u4ea7\u7c7b\u522b\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LeaseContractValidator_12", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((String)(assetName = leaseContract.getString("assetname")))) {
            errorInfoList.add(ResManager.loadKDString((String)"\u201c\u8d44\u4ea7\u540d\u79f0\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LeaseContractValidator_13", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if ((storePlace = leaseContract.getDynamicObject("storeplace")) == null) {
            errorInfoList.add(ResManager.loadKDString((String)"\u201c\u5b58\u653e\u5730\u70b9\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LeaseContractValidator_14", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if ((unit = leaseContract.getDynamicObject("unit")) == null) {
            errorInfoList.add(ResManager.loadKDString((String)"\u201c\u8ba1\u91cf\u5355\u4f4d\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LeaseContractValidator_15", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if ((assetAmount = leaseContract.getBigDecimal("assetamount")).compareTo(BigDecimal.ZERO) <= 0) {
            errorInfoList.add(ResManager.loadKDString((String)"\u201c\u6570\u91cf\u201d\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"LeaseContractValidator_16", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if ((leaseStartDate = leaseContract.getDate("leasestartdate")) == null) {
            errorInfoList.add(ResManager.loadKDString((String)"\u201c\u8d77\u79df\u65e5\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LeaseContractValidator_17", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if ((leaseEndDate = leaseContract.getDate("leaseenddate")) == null) {
            errorInfoList.add(ResManager.loadKDString((String)"\u201c\u79df\u8d41\u7ed3\u675f\u65e5\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LeaseContractValidator_18", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        return errorInfoList;
    }

    private static List<String> validateMustInput4GenPayPlan(DynamicObject leaseContract) {
        DynamicObject currency;
        Date leaseEndDate;
        ArrayList<String> errorInfo = new ArrayList<String>(10);
        Date leaseStartDate = leaseContract.getDate("leasestartdate");
        if (leaseStartDate == null) {
            errorInfo.add(ResManager.loadKDString((String)"\u201c\u8d77\u79df\u65e5\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LeaseContractValidator_17", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if ((leaseEndDate = leaseContract.getDate("leaseenddate")) == null) {
            errorInfo.add(ResManager.loadKDString((String)"\u201c\u79df\u8d41\u7ed3\u675f\u65e5\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LeaseContractValidator_18", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if ((currency = leaseContract.getDynamicObject("currency")) == null) {
            errorInfo.add(ResManager.loadKDString((String)"\u83b7\u53d6\u6838\u7b97\u7ec4\u7ec7\u672c\u4f4d\u5e01\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6838\u7b97\u7ec4\u7ec7\u662f\u5426\u4e3a\u7a7a\uff0c\u6216\u8bbe\u7f6e\u201c\u79df\u8d41\u521d\u59cb\u5316\u201d\u3002", (String)"LeaseContractValidator_19", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        DynamicObjectCollection ruleEntry = leaseContract.getDynamicObjectCollection("payruleentryentity");
        for (int i = 0; i < ruleEntry.size(); ++i) {
            BigDecimal amount;
            String invoiceType;
            int relativePayDate;
            Date endDate;
            Date startDate;
            String frequency;
            DynamicObject row = (DynamicObject)ruleEntry.get(i);
            DynamicObject payItem = row.getDynamicObject("rule_payitem");
            if (payItem == null) {
                errorInfo.add(String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u89c4\u5219\u7b2c%s\u884c\uff1a\u201c\u4ed8\u6b3e\u9879\u76ee\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LeaseContractValidator_20", (String)"fi-fa-business", (Object[])new Object[0]), i + 1));
            }
            if (StringUtils.isEmpty((String)(frequency = row.getString("frequency")))) {
                errorInfo.add(String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u89c4\u5219\u7b2c%s\u884c\uff1a\u201c\u9891\u7387\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LeaseContractValidator_21", (String)"fi-fa-business", (Object[])new Object[0]), i + 1));
            }
            if ((startDate = row.getDate("rule_startdate")) == null) {
                errorInfo.add(String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u89c4\u5219\u7b2c%s\u884c\uff1a\u201c\u53d7\u76ca\u671f_\u8d77\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LeaseContractValidator_22", (String)"fi-fa-business", (Object[])new Object[0]), i + 1));
            }
            if ((endDate = row.getDate("rule_enddate")) == null) {
                errorInfo.add(String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u89c4\u5219\u7b2c%s\u884c\uff1a\u201c\u53d7\u76ca\u671f_\u6b62\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LeaseContractValidator_23", (String)"fi-fa-business", (Object[])new Object[0]), i + 1));
            }
            String payPoint = row.getString("paypoint");
            if (!PayPoint.A.name().equals(payPoint) && !PayPoint.B.name().equals(payPoint)) {
                errorInfo.add(String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u89c4\u5219\u7b2c%s\u884c\uff1a\u201c\u652f\u4ed8\u8d77\u70b9\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LeaseContractValidator_24", (String)"fi-fa-business", (Object[])new Object[0]), i + 1));
            }
            if ((relativePayDate = row.getInt("relativepaydate")) == 0) {
                errorInfo.add(String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u89c4\u5219\u7b2c%s\u884c\uff1a\u201c\u7b2c\u51e0\u5929\u652f\u4ed8\u201d\u4e0d\u80fd\u4e3a0\u3002", (String)"LeaseContractValidator_25", (String)"fi-fa-business", (Object[])new Object[0]), i + 1));
            }
            if (StringUtils.isEmpty((String)(invoiceType = row.getString("rule_invoicetype")))) {
                errorInfo.add(String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u89c4\u5219\u7b2c%s\u884c\uff1a\u201c\u53d1\u7968\u7c7b\u578b\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LeaseContractValidator_26", (String)"fi-fa-business", (Object[])new Object[0]), i + 1));
            }
            if ((amount = row.getBigDecimal("amount")) != null && BigDecimal.ZERO.compareTo(amount) < 0) continue;
            errorInfo.add(String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u89c4\u5219\u7b2c%s\u884c\uff1a\u201c\u91d1\u989d\u201d\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"LeaseContractValidator_27", (String)"fi-fa-business", (Object[])new Object[0]), i + 1));
        }
        return errorInfo;
    }

    private static List<String> validateContractData(DynamicObject leaseContract) {
        ArrayList<String> errorInfoList = new ArrayList<String>(13);
        BigDecimal assetAmount = leaseContract.getBigDecimal("assetamount");
        Date leaseStartDate = leaseContract.getDate("leasestartdate");
        Date leaseEndDate = leaseContract.getDate("leaseenddate");
        Date freeLeaseStartDate = leaseContract.getDate("freeleasestartdate");
        Date leaseTermStartDate = leaseContract.getDate("leasetermstartdate");
        boolean isExempt = leaseContract.getBoolean("isexempt");
        boolean isStock = LeaseUtil.isStockContract(leaseTermStartDate, isExempt);
        String transitionPlan = leaseContract.getString("transitionplan");
        BigDecimal discountRate = leaseContract.getBigDecimal("discountrate");
        DynamicObjectCollection ruleEntry = leaseContract.getDynamicObjectCollection("payruleentryentity");
        errorInfoList.addAll(LeaseContractValidator.validateOrgRelation(leaseContract));
        if (assetAmount.compareTo(BigDecimal.ZERO) <= 0) {
            errorInfoList.add(ResManager.loadKDString((String)"\u201c\u6570\u91cf\u201d\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"LeaseContractValidator_16", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if (leaseStartDate.compareTo(leaseEndDate) >= 0) {
            errorInfoList.add(ResManager.loadKDString((String)"\u201c\u79df\u8d41\u7ed3\u675f\u65e5\u201d\u5fc5\u987b\u665a\u4e8e\u201c\u8d77\u79df\u65e5\u201d\u3002", (String)"LeaseContractValidator_28", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if (freeLeaseStartDate != null && freeLeaseStartDate.compareTo(leaseStartDate) >= 0) {
            errorInfoList.add(ResManager.loadKDString((String)"\u201c\u514d\u79df\u671f\u5f00\u59cb\u65e5\u201d\u5fc5\u987b\u65e9\u4e8e\u201c\u8d77\u79df\u65e5\u201d\u3002", (String)"LeaseContractValidator_29", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if (!isExempt && discountRate.compareTo(BigDecimal.ZERO) <= 0) {
            errorInfoList.add(ResManager.loadKDString((String)"\u201c\u5e74\u6298\u73b0\u7387\u201d\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"LeaseContractValidator_30", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if (isStock && StringUtils.isEmpty((String)transitionPlan)) {
            errorInfoList.add(ResManager.loadKDString((String)"\u5b58\u91cf\u5408\u540c\u7684\u201c\u8fc7\u6e21\u65b9\u6848\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LeaseContractValidator_31", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if (!isStock && StringUtils.isNotEmpty((String)transitionPlan)) {
            errorInfoList.add(ResManager.loadKDString((String)"\u975e\u5b58\u91cf\u5408\u540c\u4e0d\u80fd\u5f55\u5165\u201c\u8fc7\u6e21\u65b9\u6848\u201d\u3002", (String)"LeaseContractValidator_32", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if (ruleEntry.isEmpty()) {
            errorInfoList.add(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u81f3\u5c11\u4e00\u884c\u201c\u4f7f\u7528\u6743\u7c7b\u201d\u6216\u201c\u79df\u8d41\u8d1f\u503a\u7c7b\u201d\u4ed8\u6b3e\u89c4\u5219\u3002", (String)"LeaseContractValidator_33", (String)"fi-fa-business", (Object[])new Object[0]));
        } else {
            boolean hasItem = false;
            for (DynamicObject rule : ruleEntry) {
                String acctClass;
                DynamicObject payItem = rule.getDynamicObject("rule_payitem");
                if (payItem == null || !"A".equals(acctClass = payItem.getString("accountingclass")) && !"B".equals(acctClass)) continue;
                hasItem = true;
                break;
            }
            if (!hasItem) {
                errorInfoList.add(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u81f3\u5c11\u4e00\u884c\u201c\u4f7f\u7528\u6743\u7c7b\u201d\u6216\u201c\u79df\u8d41\u8d1f\u503a\u7c7b\u201d\u4ed8\u6b3e\u89c4\u5219\u3002", (String)"LeaseContractValidator_33", (String)"fi-fa-business", (Object[])new Object[0]));
            }
        }
        return errorInfoList;
    }

    private static List<String> validateInitContractData(DynamicObject leaseContract) {
        Date sysSwitchDate;
        ArrayList<String> errorInfo = new ArrayList<String>(13);
        DynamicObject leaseInit = LeaseContractValidator.getLeaseInitFromCache(leaseContract);
        if (leaseInit == null) {
            errorInfo.add(ResManager.loadKDString((String)"\u8bf7\u5148\u521b\u5efa\u6838\u7b97\u7ec4\u7ec7\u7684\u79df\u8d41\u521d\u59cb\u5316\u3002", (String)"LeaseContractValidator_34", (String)"fi-fa-business", (Object[])new Object[0]));
            return errorInfo;
        }
        String status = leaseInit.getString("status");
        if (BillStatus.C.name().equals(status)) {
            errorInfo.add(ResManager.loadKDString((String)"\u5bf9\u5e94\u7ec4\u7ec7\u79df\u8d41\u521d\u59cb\u5316\u5df2\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u4e0d\u53ef\u4ee5\u65b0\u589e\u521d\u59cb\u5316\u5408\u540c\u3002", (String)"LeaseContractValidator_35", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if ((sysSwitchDate = leaseContract.getDate("sysswitchdate")) == null) {
            errorInfo.add(ResManager.loadKDString((String)"\u7cfb\u7edf\u5207\u6362\u65e5\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5148\u521b\u5efa\u6838\u7b97\u7ec4\u7ec7\u7684\u8d44\u4ea7\u4e3b\u8d26\u7c3f\u3002", (String)"LeaseContractValidator_36", (String)"fi-fa-business", (Object[])new Object[0]));
        } else if (sysSwitchDate.compareTo(leaseInit.getDate("systemswitchday")) != 0) {
            errorInfo.add(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u79df\u8d41\u5408\u540c\u7cfb\u7edf\u5207\u6362\u65e5\u4e0e\u79df\u8d41\u521d\u59cb\u5316\u7cfb\u7edf\u5207\u6362\u65e5\u4e0d\u4e00\u81f4\u3002", (String)"LeaseContractValidator_37", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        Date initConfirmDate = leaseContract.getDate("initconfirmdate");
        if (initConfirmDate != null && DateUtil.compareDate((Date)initConfirmDate, (Date)sysSwitchDate) >= 0) {
            errorInfo.add(ResManager.loadKDString((String)"\u521d\u59cb\u786e\u8ba4\u65e5\u5927\u4e8e\u6216\u7b49\u4e8e\u7cfb\u7edf\u5207\u6362\u65e5\uff0c\u8bf7\u901a\u8fc7\u65b0\u589e\u5408\u540c\u5f55\u5165\u3002", (String)"LeaseContractValidator_38", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        boolean isExempt = leaseContract.getBoolean("isexempt");
        int depreMonths = LeaseContractValidator.getDepreMonths(leaseContract);
        if (isExempt && depreMonths > 12) {
            errorInfo.add(ResManager.loadKDString((String)"\u201c\u9002\u7528\u79df\u8d41\u671f\uff08\u6708\uff09\u201d\u5927\u4e8e12\u4e2a\u6708\uff0c\u4e0d\u80fd\u8bbe\u4e3a\u8c41\u514d\u5408\u540c\u3002", (String)"LeaseContractValidator_39", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        errorInfo.addAll(LeaseContractValidator.validateInitContractFinInfo(leaseContract, leaseInit));
        return errorInfo;
    }

    private static int getDepreMonths(DynamicObject leaseContract) {
        String sourceType = leaseContract.getString("sourcetype");
        Date leaseEndDate = leaseContract.getDate("leaseenddate");
        String transitionPlan = leaseContract.getString("transitionplan");
        Date tempDate = leaseContract.getDate("initconfirmdate");
        if (LeaseContractSourceType.A.name().equals(sourceType) && (TransitionPlan.A.name().equals(transitionPlan) || TransitionPlan.C.name().equals(transitionPlan))) {
            tempDate = leaseContract.getDate("leasetermstartdate");
        }
        if (tempDate == null || leaseEndDate == null) {
            return 0;
        }
        boolean monthRoundUp = LeaseContractValidator.getLeaseMonthRoundUpFromSysParam(leaseContract);
        int depreMonths = DateUtil.getDiffMonthsByLocalDate((Date)tempDate, (Date)leaseEndDate, (boolean)true, (boolean)monthRoundUp);
        return depreMonths;
    }

    private static boolean getLeaseMonthRoundUpFromSysParam(DynamicObject leaseContract) {
        DynamicObject org = leaseContract.getDynamicObject("org");
        long orgId = 0L;
        if (org != null) {
            orgId = org.getLong("id");
        }
        return SystemParamHelper.getBooleanParam("leasemonthroundup", orgId, false);
    }

    private static List<String> validateInitContractFinInfo(DynamicObject leaseContract, DynamicObject leaseInit) {
        int periodNumber;
        BigDecimal addUpYearInterest;
        BigDecimal accumInterest;
        BigDecimal addUpYearRent;
        BigDecimal accumRent;
        BigDecimal assetsYearDepre;
        BigDecimal assetsAccumDepre;
        BigDecimal leaseAssets;
        ArrayList<String> errorInfo = new ArrayList<String>(10);
        boolean isExempt = leaseContract.getBoolean("isexempt");
        if (isExempt) {
            errorInfo.addAll(LeaseContractValidator.validateLockedFields4Exempt(leaseContract));
            return errorInfo;
        }
        BigDecimal leaseLiabOri = leaseContract.getBigDecimal("leaseliabori");
        BigDecimal leaseLiab = leaseContract.getBigDecimal("leaseliab");
        if (BigDecimal.ZERO.compareTo(leaseLiab) > 0) {
            errorInfo.add(ResManager.loadKDString((String)"\u201c\u79df\u8d41\u8d1f\u503a\u73b0\u503c\u201d\u4e0d\u80fd\u4e3a\u8d1f\u6570\u3002", (String)"LeaseContractValidator_40", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if (BigDecimal.ZERO.compareTo(leaseLiabOri) < 0 ^ BigDecimal.ZERO.compareTo(leaseLiab) < 0) {
            errorInfo.add(ResManager.loadKDString((String)"\u201c\u79df\u8d41\u8d1f\u503a\u73b0\u503c\u201d\u4e0e\u201c\u79df\u8d41\u8d1f\u503a\u539f\u503c\u201d\u5fc5\u987b\u540c\u65f6\u5927\u4e8e0\u6216\u540c\u65f6\u7b49\u4e8e0\u3002", (String)"LeaseContractValidator_41", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if (BigDecimal.ZERO.compareTo(leaseAssets = leaseContract.getBigDecimal("leaseassets")) > 0) {
            errorInfo.add(ResManager.loadKDString((String)"\u201c\u4f7f\u7528\u6743\u8d44\u4ea7\u539f\u503c\u201d\u4e0d\u80fd\u4e3a\u8d1f\u6570\u3002", (String)"LeaseContractValidator_42", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if (BigDecimal.ZERO.compareTo(assetsAccumDepre = leaseContract.getBigDecimal("assetsaccumdepre")) > 0) {
            errorInfo.add(ResManager.loadKDString((String)"\u201c\u4f7f\u7528\u6743\u8d44\u4ea7\u7d2f\u8ba1\u6298\u65e7\u201d\u4e0d\u80fd\u4e3a\u8d1f\u6570\u3002", (String)"LeaseContractValidator_43", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if (assetsAccumDepre.compareTo(leaseAssets) > 0) {
            errorInfo.add(ResManager.loadKDString((String)"\u201c\u4f7f\u7528\u6743\u8d44\u4ea7\u7d2f\u8ba1\u6298\u65e7\u201d\u4e0d\u80fd\u5927\u4e8e\u201c\u4f7f\u7528\u6743\u8d44\u4ea7\u539f\u503c\u201d\u3002", (String)"LeaseContractValidator_44", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if (BigDecimal.ZERO.compareTo(assetsYearDepre = leaseContract.getBigDecimal("assetsaddupyeardepre")) > 0) {
            errorInfo.add(ResManager.loadKDString((String)"\u201c\u4f7f\u7528\u6743\u8d44\u4ea7\u672c\u5e74\u7d2f\u8ba1\u6298\u65e7\u201d\u4e0d\u80fd\u4e3a\u8d1f\u6570\u3002", (String)"LeaseContractValidator_45", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if (assetsYearDepre.compareTo(assetsAccumDepre) > 0) {
            errorInfo.add(ResManager.loadKDString((String)"\u201c\u4f7f\u7528\u6743\u8d44\u4ea7\u672c\u5e74\u7d2f\u8ba1\u6298\u65e7\u201d\u4e0d\u80fd\u5927\u4e8e\u201c\u4f7f\u7528\u6743\u8d44\u4ea7\u7d2f\u8ba1\u6298\u65e7\u201d\u3002", (String)"LeaseContractValidator_46", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        int depreMonths = leaseContract.getInt("depremonths");
        int hasDepreMonths = leaseContract.getInt("hasdepremonths");
        if (hasDepreMonths < 0) {
            errorInfo.add(ResManager.loadKDString((String)"\u201c\u5df2\u6298\u65e7\u671f\u95f4\uff08\u6708\uff09\u201d\u4e0d\u80fd\u4e3a\u8d1f\u6570\u3002", (String)"LeaseContractValidator_47", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if (hasDepreMonths > depreMonths) {
            errorInfo.add(ResManager.loadKDString((String)"\u201c\u5df2\u6298\u65e7\u671f\u95f4\uff08\u6708\uff09\u201d\u4e0d\u80fd\u5927\u4e8e\u201c\u9002\u7528\u79df\u8d41\u671f\uff08\u6708\uff09\u201d\u3002", (String)"LeaseContractValidator_48", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if (BigDecimal.ZERO.compareTo(assetsAccumDepre) < 0 ^ hasDepreMonths > 0) {
            errorInfo.add(ResManager.loadKDString((String)"\u201c\u4f7f\u7528\u6743\u8d44\u4ea7\u7d2f\u8ba1\u6298\u65e7\u201d\u4e0e\u201c\u5df2\u6298\u65e7\u671f\u95f4\uff08\u6708\uff09\u201d\u5fc5\u987b\u540c\u65f6\u5927\u4e8e0\u6216\u540c\u65f6\u7b49\u4e8e0\u3002", (String)"LeaseContractValidator_49", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if (BigDecimal.ZERO.compareTo(accumRent = leaseContract.getBigDecimal("accumrent")) > 0) {
            errorInfo.add(ResManager.loadKDString((String)"\u201c\u7d2f\u8ba1\u79df\u91d1\u201d\u4e0d\u80fd\u4e3a\u8d1f\u6570\u3002", (String)"LeaseContractValidator_50", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if (BigDecimal.ZERO.compareTo(accumRent) < 0 && leaseAssets.compareTo(leaseLiab) < 0) {
            errorInfo.add(ResManager.loadKDString((String)"\u7d2f\u8ba1\u79df\u91d1\u5927\u4e8e0\uff0c\u201c\u4f7f\u7528\u6743\u8d44\u4ea7\u539f\u503c\u201d\u4e0d\u80fd\u5c0f\u4e8e\u201c\u79df\u8d41\u8d1f\u503a\u73b0\u503c\u201d\u3002", (String)"LeaseContractValidator_51", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if (BigDecimal.ZERO.compareTo(addUpYearRent = leaseContract.getBigDecimal("addupyearrent")) > 0) {
            errorInfo.add(ResManager.loadKDString((String)"\u201c\u672c\u5e74\u7d2f\u8ba1\u79df\u91d1\u201d\u4e0d\u80fd\u4e3a\u8d1f\u6570\u3002", (String)"LeaseContractValidator_52", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if (addUpYearRent.compareTo(accumRent) > 0) {
            errorInfo.add(ResManager.loadKDString((String)"\u201c\u672c\u5e74\u7d2f\u8ba1\u79df\u91d1\u201d\u4e0d\u80fd\u5927\u4e8e\u201c\u7d2f\u8ba1\u79df\u91d1\u201d\u3002", (String)"LeaseContractValidator_53", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if (BigDecimal.ZERO.compareTo(accumInterest = leaseContract.getBigDecimal("accuminterest")) > 0) {
            errorInfo.add(ResManager.loadKDString((String)"\u201c\u7d2f\u8ba1\u5229\u606f\u201d\u4e0d\u80fd\u4e3a\u8d1f\u6570\u3002", (String)"LeaseContractValidator_54", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if (BigDecimal.ZERO.compareTo(addUpYearInterest = leaseContract.getBigDecimal("addupyearinterest")) > 0) {
            errorInfo.add(ResManager.loadKDString((String)"\u201c\u672c\u5e74\u7d2f\u8ba1\u5229\u606f\u201d\u4e0d\u80fd\u4e3a\u8d1f\u6570\u3002", (String)"LeaseContractValidator_55", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if (addUpYearInterest.compareTo(accumInterest) > 0) {
            errorInfo.add(ResManager.loadKDString((String)"\u201c\u672c\u5e74\u7d2f\u8ba1\u5229\u606f\u201d\u4e0d\u80fd\u5927\u4e8e\u201c\u7d2f\u8ba1\u5229\u606f\u201d\u3002", (String)"LeaseContractValidator_56", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if ((periodNumber = leaseInit.getInt("curperiod.periodnumber")) == 1 && BigDecimal.ZERO.compareTo(assetsYearDepre) < 0) {
            errorInfo.add(ResManager.loadKDString((String)"\u79df\u8d41\u521d\u59cb\u5316\u5f53\u524d\u57281\u671f\uff0c\u4e0d\u5141\u8bb8\u5f55\u5165\u201c\u4f7f\u7528\u6743\u8d44\u4ea7\u672c\u5e74\u7d2f\u8ba1\u6298\u65e7\u201d\u3002", (String)"LeaseContractValidator_57", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if (periodNumber == 1 && BigDecimal.ZERO.compareTo(addUpYearRent) < 0) {
            errorInfo.add(ResManager.loadKDString((String)"\u79df\u8d41\u521d\u59cb\u5316\u5f53\u524d\u57281\u671f\uff0c\u4e0d\u5141\u8bb8\u5f55\u5165\u201c\u672c\u5e74\u7d2f\u8ba1\u79df\u91d1\u201d\u3002", (String)"LeaseContractValidator_58", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if (periodNumber == 1 && BigDecimal.ZERO.compareTo(addUpYearInterest) < 0) {
            errorInfo.add(ResManager.loadKDString((String)"\u79df\u8d41\u521d\u59cb\u5316\u5f53\u524d\u57281\u671f\uff0c\u4e0d\u5141\u8bb8\u5f55\u5165\u201c\u672c\u5e74\u7d2f\u8ba1\u5229\u606f\u201d\u3002", (String)"LeaseContractValidator_59", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        return errorInfo;
    }

    private static List<String> validateLockedFields4Exempt(DynamicObject leaseContract) {
        BigDecimal addUpYearInterest;
        BigDecimal accumInterest;
        BigDecimal addUpYearRent;
        BigDecimal accumRent;
        int hasDepreMonths;
        BigDecimal assetsAddUpYearDepre;
        BigDecimal assetsAccumDepre;
        BigDecimal leaseAssets;
        BigDecimal leaseLiab;
        BigDecimal leaseLiabOri;
        BigDecimal dailyDiscountRate;
        ArrayList<String> errorInfo = new ArrayList<String>(12);
        boolean isExempt = leaseContract.getBoolean("isexempt");
        if (!isExempt) {
            return errorInfo;
        }
        BigDecimal discountRate = leaseContract.getBigDecimal("discountrate");
        if (BigDecimal.ZERO.compareTo(discountRate) != 0) {
            errorInfo.add(ResManager.loadKDString((String)"\u8c41\u514d\u5408\u540c\u4e0d\u5141\u8bb8\u5f55\u5165\u201c\u5e74\u6298\u73b0\u7387\u201d\u3002", (String)"LeaseContractValidator_60", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if (BigDecimal.ZERO.compareTo(dailyDiscountRate = leaseContract.getBigDecimal("dailydiscountrate")) != 0) {
            errorInfo.add(ResManager.loadKDString((String)"\u8c41\u514d\u5408\u540c\u4e0d\u5141\u8bb8\u5f55\u5165\u201c\u65e5\u6298\u73b0\u7387\u201d\u3002", (String)"LeaseContractValidator_61", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if (BigDecimal.ZERO.compareTo(leaseLiabOri = leaseContract.getBigDecimal("leaseliabori")) != 0) {
            errorInfo.add(ResManager.loadKDString((String)"\u8c41\u514d\u5408\u540c\u4e0d\u5141\u8bb8\u5f55\u5165\u201c\u79df\u8d41\u8d1f\u503a\u539f\u503c\u201d\u3002", (String)"LeaseContractValidator_62", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if (BigDecimal.ZERO.compareTo(leaseLiab = leaseContract.getBigDecimal("leaseliab")) != 0) {
            errorInfo.add(ResManager.loadKDString((String)"\u8c41\u514d\u5408\u540c\u4e0d\u5141\u8bb8\u5f55\u5165\u201c\u79df\u8d41\u8d1f\u503a\u73b0\u503c\u201d\u3002", (String)"LeaseContractValidator_63", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if (BigDecimal.ZERO.compareTo(leaseAssets = leaseContract.getBigDecimal("leaseassets")) != 0) {
            errorInfo.add(ResManager.loadKDString((String)"\u8c41\u514d\u5408\u540c\u4e0d\u5141\u8bb8\u5f55\u5165\u201c\u4f7f\u7528\u6743\u8d44\u4ea7\u539f\u503c\u201d\u3002", (String)"LeaseContractValidator_64", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if (BigDecimal.ZERO.compareTo(assetsAccumDepre = leaseContract.getBigDecimal("assetsaccumdepre")) != 0) {
            errorInfo.add(ResManager.loadKDString((String)"\u8c41\u514d\u5408\u540c\u4e0d\u5141\u8bb8\u5f55\u5165\u201c\u4f7f\u7528\u6743\u8d44\u4ea7\u7d2f\u8ba1\u6298\u65e7\u201d\u3002", (String)"LeaseContractValidator_65", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if (BigDecimal.ZERO.compareTo(assetsAddUpYearDepre = leaseContract.getBigDecimal("assetsaddupyeardepre")) != 0) {
            errorInfo.add(ResManager.loadKDString((String)"\u8c41\u514d\u5408\u540c\u4e0d\u5141\u8bb8\u5f55\u5165\u201c\u4f7f\u7528\u6743\u8d44\u4ea7\u672c\u5e74\u7d2f\u8ba1\u6298\u65e7\u201d\u3002", (String)"LeaseContractValidator_66", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if ((hasDepreMonths = leaseContract.getInt("hasdepremonths")) != 0) {
            errorInfo.add(ResManager.loadKDString((String)"\u8c41\u514d\u5408\u540c\u4e0d\u5141\u8bb8\u5f55\u5165\u201c\u5df2\u6298\u65e7\u671f\u95f4\uff08\u6708\uff09\u201d\u3002", (String)"LeaseContractValidator_67", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if (BigDecimal.ZERO.compareTo(accumRent = leaseContract.getBigDecimal("accumrent")) != 0) {
            errorInfo.add(ResManager.loadKDString((String)"\u8c41\u514d\u5408\u540c\u4e0d\u5141\u8bb8\u5f55\u5165\u201c\u7d2f\u8ba1\u79df\u91d1\u201d\u3002", (String)"LeaseContractValidator_68", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if (BigDecimal.ZERO.compareTo(addUpYearRent = leaseContract.getBigDecimal("addupyearrent")) != 0) {
            errorInfo.add(ResManager.loadKDString((String)"\u8c41\u514d\u5408\u540c\u4e0d\u5141\u8bb8\u5f55\u5165\u201c\u672c\u5e74\u7d2f\u8ba1\u79df\u91d1\u201d\u3002", (String)"LeaseContractValidator_69", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if (BigDecimal.ZERO.compareTo(accumInterest = leaseContract.getBigDecimal("accuminterest")) != 0) {
            errorInfo.add(ResManager.loadKDString((String)"\u8c41\u514d\u5408\u540c\u4e0d\u5141\u8bb8\u5f55\u5165\u201c\u7d2f\u8ba1\u5229\u606f\u201d\u3002", (String)"LeaseContractValidator_70", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if (BigDecimal.ZERO.compareTo(addUpYearInterest = leaseContract.getBigDecimal("addupyearinterest")) != 0) {
            errorInfo.add(ResManager.loadKDString((String)"\u8c41\u514d\u5408\u540c\u4e0d\u5141\u8bb8\u5f55\u5165\u201c\u672c\u5e74\u7d2f\u8ba1\u5229\u606f\u201d\u3002", (String)"LeaseContractValidator_71", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        return errorInfo;
    }

    private static List<String> validatePayRuleDate(DynamicObject leaseContract) {
        ArrayList<String> errorInfo = new ArrayList<String>(10);
        boolean isExempt = leaseContract.getBoolean("isexempt");
        DynamicObjectCollection payRuleEntry = leaseContract.getDynamicObjectCollection("payruleentryentity");
        if (!isExempt && payRuleEntry.isEmpty()) {
            errorInfo.add(ResManager.loadKDString((String)"\u4ed8\u6b3e\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LeaseContractValidator_72", (String)"fi-fa-business", (Object[])new Object[0]));
            return errorInfo;
        }
        long orgId = leaseContract.getDynamicObject("org").getLong("id");
        Date leaseStartDate = leaseContract.getDate("leasestartdate");
        Date leaseEndDate = leaseContract.getDate("leaseenddate");
        Date initConfirmDate = leaseContract.getDate("initconfirmdate");
        Date leaseTermStartDate = leaseContract.getDate("leasetermstartdate");
        boolean isStock = LeaseUtil.isStockContract(leaseTermStartDate, isExempt);
        String transitionPlan = leaseContract.getString("transitionplan");
        String sourceType = leaseContract.getString("sourcetype");
        HashMap payItemDateRange = new HashMap(16);
        for (int i = 0; i < payRuleEntry.size(); ++i) {
            Date endDate;
            BigDecimal amount;
            DynamicObject row = (DynamicObject)payRuleEntry.get(i);
            String invoiceType = row.getString("rule_invoicetype");
            boolean deductible = row.getBoolean("rule_deductible");
            if (InvoiceType.COMMON.getValue().equals(invoiceType) && deductible) {
                errorInfo.add(String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u89c4\u5219\u7b2c%s\u884c\uff1a\u201c\u53d1\u7968\u7c7b\u578b\u201d\u4e3a\u666e\u901a\u53d1\u7968\uff0c\u4e0d\u53ef\u62b5\u6263\u3002", (String)"LeaseContractValidator_73", (String)"fi-fa-business", (Object[])new Object[0]), i + 1));
            }
            BigDecimal taxRate = row.getBigDecimal("rule_taxrate");
            BigDecimal tax = row.getBigDecimal("rule_tax");
            if (!deductible) {
                if (BigDecimal.ZERO.compareTo(taxRate) < 0 ^ BigDecimal.ZERO.compareTo(tax) < 0) {
                    errorInfo.add(String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u89c4\u5219\u7b2c%s\u884c\uff1a\u201c\u53ef\u62b5\u6263\u201d\u4e3a\u5426\uff0c\u201c\u7a0e\u7387\u201d\u3001\u201c\u7a0e\u989d\u201d\u5fc5\u987b\u540c\u65f6\u5927\u4e8e0\u6216\u540c\u65f6\u7b49\u4e8e0\u3002", (String)"LeaseContractValidator_74", (String)"fi-fa-business", (Object[])new Object[0]), i + 1));
                }
            } else {
                if (BigDecimal.ZERO.compareTo(taxRate) >= 0) {
                    errorInfo.add(String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u89c4\u5219\u7b2c%s\u884c\uff1a\u201c\u53ef\u62b5\u6263\u201d\u4e3a\u662f\uff0c\u201c\u7a0e\u7387\u201d\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"LeaseContractValidator_75", (String)"fi-fa-business", (Object[])new Object[0]), i + 1));
                }
                if (BigDecimal.ZERO.compareTo(tax) >= 0) {
                    errorInfo.add(String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u89c4\u5219\u7b2c%s\u884c\uff1a\u201c\u53ef\u62b5\u6263\u201d\u4e3a\u662f\uff0c\u201c\u7a0e\u989d\u201d\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"LeaseContractValidator_76", (String)"fi-fa-business", (Object[])new Object[0]), i + 1));
                }
            }
            if (tax.compareTo(amount = row.getBigDecimal("amount")) > 0) {
                errorInfo.add(String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u89c4\u5219\u7b2c%s\u884c\uff1a\u201c\u7a0e\u989d\u201d\u4e0d\u80fd\u5927\u4e8e\u201c\u542b\u7a0e\u91d1\u989d\u201d\u3002", (String)"LeaseContractValidator_77", (String)"fi-fa-business", (Object[])new Object[0]), i + 1));
            }
            DynamicObject payItem = row.getDynamicObject("rule_payitem");
            String acctClass = payItem.getString("accountingclass");
            Date startDate = row.getDate("rule_startdate");
            if ("A".equals(acctClass)) {
                if (DateUtil.compareDate((Date)leaseStartDate, (Date)startDate) > 0) {
                    errorInfo.add(String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u89c4\u5219\u7b2c%s\u884c\uff1a\u201c\u53d7\u76ca\u671f_\u8d77\u201d\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u201c\u8d77\u79df\u65e5\u201d\u3002", (String)"LeaseContractValidator_78", (String)"fi-fa-business", (Object[])new Object[0]), i + 1));
                }
            } else {
                HashSet<String> exceptTransitionPlan = new HashSet<String>(Arrays.asList(TransitionPlan.A.name(), TransitionPlan.C.name()));
                if (DateUtil.compareDate((Date)initConfirmDate, (Date)startDate) > 0 && !exceptTransitionPlan.contains(transitionPlan)) {
                    errorInfo.add(String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u89c4\u5219\u7b2c%s\u884c\uff1a\u201c\u53d7\u76ca\u671f_\u8d77\u201d\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u201c\u521d\u59cb\u786e\u8ba4\u65e5\u201d\u3002", (String)"LeaseContractValidator_79", (String)"fi-fa-business", (Object[])new Object[0]), i + 1));
                }
            }
            if (LeaseContractSourceType.A.name().equals(sourceType)) {
                Date firstExecDate = LeaseUtil.getFirstExecDateFromSysParam(orgId);
                if (isStock && DateUtil.compareDate((Date)startDate, (Date)firstExecDate) < 0 && TransitionPlan.B.name().equals(transitionPlan)) {
                    String firstExecDateStr = DateUtil.getShortDate().format(firstExecDate);
                    errorInfo.add(String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u89c4\u5219\u7b2c%1$s\u884c\uff1a\u5f53\u524d\u7ec4\u7ec7\u91c7\u7528\u201c\u7b80\u5316\u8ffd\u6eaf\u6cd52\u201d\u4f5c\u4e3a\u5b58\u91cf\u5408\u540c\u8fc7\u6e21\u65b9\u6848\uff0c\u4ed8\u6b3e\u89c4\u5219\u7684\u201c\u53d7\u76ca\u671f_\u8d77\u201d\u987b\u5927\u4e8e\u7b49\u4e8e\u9996\u6b21\u6267\u884c\u65e5[%2$s]\u3002", (String)"LeaseContractValidator_80", (String)"fi-fa-business", (Object[])new Object[0]), i + 1, firstExecDateStr));
                }
            }
            if (DateUtil.compareDate((Date)leaseEndDate, (Date)(endDate = row.getDate("rule_enddate"))) < 0) {
                errorInfo.add(String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u89c4\u5219\u7b2c%s\u884c\uff1a\u201c\u53d7\u76ca\u671f_\u6b62\u201d\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u201c\u79df\u8d41\u7ed3\u675f\u65e5\u201d\u3002", (String)"LeaseContractValidator_81", (String)"fi-fa-business", (Object[])new Object[0]), i + 1));
            }
            if (DateUtil.compareDate((Date)startDate, (Date)endDate) >= 0) {
                errorInfo.add(String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u89c4\u5219\u7b2c%s\u884c\uff1a\u201c\u53d7\u76ca\u671f_\u8d77\u201d\u5fc5\u987b\u5c0f\u4e8e\u201c\u53d7\u76ca\u671f_\u6b62\u201d\u3002", (String)"LeaseContractValidator_82", (String)"fi-fa-business", (Object[])new Object[0]), i + 1));
                continue;
            }
            String payItemNumber = payItem.getString("number");
            if (!payItemDateRange.containsKey(payItemNumber)) {
                payItemDateRange.put(payItemNumber, new ArrayList());
            }
            List dateRangeList = (List)payItemDateRange.get(payItemNumber);
            dateRangeList.add(new Tuple((Object)startDate, (Object)endDate));
        }
        for (Map.Entry entry : payItemDateRange.entrySet()) {
            boolean isOverlap = DateUtil.isOverlap((List)((List)entry.getValue()));
            if (!isOverlap) continue;
            errorInfo.add(String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u89c4\u5219\u4e2d\uff0c\u4ed8\u6b3e\u9879\u76ee[%s]\u5b58\u5728\u91cd\u53e0\u7684\u53d7\u76ca\u671f\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"LeaseContractValidator_83", (String)"fi-fa-business", (Object[])new Object[0]), entry.getKey()));
        }
        return errorInfo;
    }

    private static List<String> validateOrgRelation(DynamicObject leaseContract) {
        long orgId;
        ArrayList<String> errorInfo = new ArrayList<String>(1);
        long assetUnitId = leaseContract.getLong(Fa.id((String)"assetunit"));
        List fromOrgIds = OrgUnitServiceHelper.getFromOrgs((String)"09", (Long)assetUnitId, (String)"10", (boolean)true);
        if (!fromOrgIds.contains(orgId = leaseContract.getLong(Fa.id((String)"org")))) {
            errorInfo.add(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e0d\u5728\u5f53\u524d\u8d44\u4ea7\u7ec4\u7ec7\u7684\u53ef\u7528\u7ec4\u7ec7\u8303\u56f4\u5185\uff0c\u8bf7\u5148\u914d\u7f6e\u4e1a\u52a1\u5355\u5143\u95f4\u534f\u4f5c\u3002", (String)"LeaseContractValidator_84", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        return errorInfo;
    }

    private static List<String> validateInitContractLeaseLiabOriAndPayPlan(DynamicObject leaseContract) {
        BigDecimal leaseLiab;
        ArrayList<String> errorInfo = new ArrayList<String>(2);
        boolean isExempt = leaseContract.getBoolean("isexempt");
        if (isExempt) {
            return errorInfo;
        }
        Date sysSwitchDate = leaseContract.getDate("sysswitchdate");
        DynamicObjectCollection planEntry = leaseContract.getDynamicObjectCollection("payplanentryentity");
        BigDecimal totalUnpaidRent = BigDecimal.ZERO;
        boolean existPayPlanAfterSysSwitchDate = false;
        for (DynamicObject row : planEntry) {
            DynamicObject payItem;
            String acctClass;
            Date planPayDate = row.getDate("planpaydate");
            if (DateUtil.compareDate((Date)planPayDate, (Date)sysSwitchDate) < 0 || !"A".equals(acctClass = (payItem = row.getDynamicObject("plan_payitem")).getString("accountingclass"))) continue;
            if (DateUtil.compareDate((Date)planPayDate, (Date)sysSwitchDate) > 0) {
                existPayPlanAfterSysSwitchDate = true;
            }
            BigDecimal unpaidRent = row.getBigDecimal("unpaidrent");
            totalUnpaidRent = totalUnpaidRent.add(unpaidRent);
        }
        BigDecimal leaseLiabOri = leaseContract.getBigDecimal("leaseliabori");
        if (leaseLiabOri.compareTo(totalUnpaidRent) != 0) {
            errorInfo.add(String.format(ResManager.loadKDString((String)"\u201c\u79df\u8d41\u8d1f\u503a\u539f\u503c\u201d\u4e0e\u4ed8\u6b3e\u8ba1\u5212\u4e2d\u7cfb\u7edf\u5207\u6362\u65e5\u4e4b\u540e\u7684\u672a\u4ed8\u79df\u91d1\u603b\u989d[%s]\u4e0d\u4e00\u81f4\uff0c\u8bf7\u8c03\u6574\u201c\u79df\u8d41\u8d1f\u503a\u539f\u503c\u201d\u6216\u8005\u201c\u4ed8\u6b3e\u89c4\u5219\u201d\u3002", (String)"LeaseContractValidator_85", (String)"fi-fa-business", (Object[])new Object[0]), totalUnpaidRent.stripTrailingZeros().toPlainString()));
        }
        if ((leaseLiab = leaseContract.getBigDecimal("leaseliab")).compareTo(leaseLiabOri) != 0 && !existPayPlanAfterSysSwitchDate) {
            errorInfo.add(ResManager.loadKDString((String)"\u201c\u79df\u8d41\u8d1f\u503a\u539f\u503c\u201d\u4e0e\u201c\u79df\u8d41\u8d1f\u503a\u73b0\u503c\u201d\u4e0d\u76f8\u7b49\u65f6\uff0c\u81f3\u5c11\u8981\u6709\u4e00\u7b14\u79df\u8d41\u8d1f\u503a\u7c7b\u4ed8\u6b3e\u8ba1\u5212\u7684\u201c\u8ba1\u5212\u4ed8\u6b3e\u65e5\u201d\u665a\u4e8e\u201c\u7cfb\u7edf\u5207\u6362\u65e5\u201d\u3002", (String)"LeaseContractValidator_86", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        return errorInfo;
    }

    private static List<String> validateLeaseLiabAndLeaseLiabOri(DynamicObject leaseContract) {
        BigDecimal leaseLiabOri;
        ArrayList<String> errorInfo = new ArrayList<String>(1);
        BigDecimal leaseLiab = leaseContract.getBigDecimal("leaseliab");
        if (leaseLiab.compareTo(leaseLiabOri = leaseContract.getBigDecimal("leaseliabori")) < 0) {
            return errorInfo;
        }
        if (BigDecimal.ZERO.compareTo(leaseLiab) == 0 && BigDecimal.ZERO.compareTo(leaseLiabOri) == 0) {
            return errorInfo;
        }
        if (leaseLiab.compareTo(leaseLiabOri) > 0) {
            errorInfo.add(ResManager.loadKDString((String)"\u201c\u79df\u8d41\u8d1f\u503a\u73b0\u503c\u201d\u4e0d\u80fd\u5927\u4e8e\u201c\u79df\u8d41\u8d1f\u503a\u539f\u503c\u201d\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u6709\u8bef\u3002", (String)"LeaseContractValidator_87", (String)"fi-fa-business", (Object[])new Object[0]));
            return errorInfo;
        }
        Date sysSwitchDate = leaseContract.getDate("sysswitchdate");
        DynamicObjectCollection payPlanEntry = leaseContract.getDynamicObjectCollection("payplanentryentity");
        for (DynamicObject row : payPlanEntry) {
            DynamicObject payItem = row.getDynamicObject("plan_payitem");
            String acctClass = payItem.getString("accountingclass");
            if (!"A".equals(acctClass)) continue;
            Date startDate = row.getDate("plan_startdate");
            DynamicObject payRuleRow = LeaseUtil.getPayRuleRow(leaseContract, payItem.getLong("id"), startDate);
            String payPoint = payRuleRow.getString("paypoint");
            Date planPayDate = row.getDate("planpaydate");
            if (DateUtil.compareDate((Date)planPayDate, (Date)sysSwitchDate) <= 0) continue;
            if (PayPoint.A.name().equals(payPoint)) {
                Date firstDayOfPayMonth = DateUtil.getMinDateOfMonth((Date)planPayDate);
                if (DateUtil.compareDate((Date)sysSwitchDate, (Date)firstDayOfPayMonth) >= 0) continue;
                errorInfo.add(String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba1\u5212[%s]\u671f\u521d\u4ed8\u6b3e\uff0c\u4e14\u201c\u8ba1\u5212\u4ed8\u6b3e\u65e5\u201d\u5728\u201c\u7cfb\u7edf\u5207\u6362\u65e5\u201d\u6240\u5728\u6708\u4efd\u4e4b\u540e\uff0c\u201c\u79df\u8d41\u8d1f\u503a\u73b0\u503c\u201d\u4e0d\u80fd\u7b49\u4e8e\u201c\u79df\u8d41\u8d1f\u503a\u539f\u503c\u201d\u3002", (String)"LeaseContractValidator_88", (String)"fi-fa-business", (Object[])new Object[0]), row.getString("plannumber")));
                continue;
            }
            errorInfo.add(String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba1\u5212\u201c%s\u201d\u671f\u672b\u4ed8\u6b3e\uff0c\u4e14\u201c\u8ba1\u5212\u4ed8\u6b3e\u65e5\u201d\u4e0d\u7b49\u4e8e\u201c\u7cfb\u7edf\u5207\u6362\u65e5\u201d\uff0c\u201c\u79df\u8d41\u8d1f\u503a\u73b0\u503c\u201d\u4e0d\u80fd\u7b49\u4e8e\u201c\u79df\u8d41\u8d1f\u503a\u539f\u503c\u201d\u3002", (String)"LeaseContractValidator_89", (String)"fi-fa-business", (Object[])new Object[0]), row.getString("plannumber")));
        }
        return errorInfo;
    }

    private static DynamicObject getLeaseInitFromCache(DynamicObject leaseContract) {
        long orgId = leaseContract.getLong(Fa.id((String)"org"));
        QFilter[] mainBookFilters = new QFilter[]{new QFilter("org", "=", (Object)orgId)};
        String selectFields = Fa.comma((String[])new String[]{"status", Fa.dot((String[])new String[]{"curperiod", "periodnumber"}), "systemswitchday"});
        return BusinessDataServiceHelper.loadSingleFromCache((String)"fa_lease_init", (String)selectFields, (QFilter[])mainBookFilters);
    }
}

