/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.validator.lease;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.validate.BillStatus;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.fa.business.enums.lease.RentSettleSourceType;
import kd.fi.fa.business.utils.FaDepreUtil;
import kd.fi.fa.common.util.Fa;

public class UndoTerminationValidator {
    private final List<Long> contractIds;

    public UndoTerminationValidator(List<Long> contractIds) {
        this.contractIds = contractIds;
    }

    public List<String> validate() {
        List<String> errorInfo = this.validateMustInput();
        if (!errorInfo.isEmpty()) {
            return errorInfo;
        }
        return this.validateData();
    }

    private List<String> validateMustInput() {
        ArrayList<String> errorInfo = new ArrayList<String>(1);
        if (this.contractIds == null || this.contractIds.isEmpty()) {
            errorInfo.add(ResManager.loadKDString((String)"\u65e0\u7b26\u5408\u6761\u4ef6\u7684\u5408\u540c\u3002", (String)"UndoTerminationValidator_0", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        return errorInfo;
    }

    private List<String> validateData() {
        ArrayList<String> errorInfo = new ArrayList<String>(10);
        String contractFields = Fa.comma((String[])new String[]{"id", "clearbill", "renewalcontractid", "leaseenddate", "leaseterminationdate", "isexempt"});
        DynamicObjectCollection contracts = QueryServiceHelper.query((String)"fa_lease_contract", (String)contractFields, (QFilter[])new QFilter("id", "in", this.contractIds).toArray());
        Map<Long, DynamicObject> contractMap = contracts.stream().collect(Collectors.toMap(v -> v.getLong("id"), v -> v));
        if (!contractMap.keySet().containsAll(this.contractIds)) {
            this.contractIds.removeAll(contractMap.keySet());
            errorInfo.add(String.format(ResManager.loadKDString((String)"\u6839\u636e\u5408\u540cid\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5408\u540c\u6570\u636e\uff1a%s\u3002", (String)"UndoTerminationValidator_1", (String)"fi-fa-business", (Object[])new Object[0]), this.contractIds.toArray()));
            return errorInfo;
        }
        ArrayList<Object> clearBillIds = new ArrayList<Object>(this.contractIds.size());
        ArrayList<Long> renewalContractIds = new ArrayList<Long>(this.contractIds.size());
        ArrayList<Long> terminationContractIds = new ArrayList<Long>(this.contractIds.size());
        for (DynamicObject contract : contracts) {
            long clearBillId = contract.getLong("clearbill");
            long renewalContractId = contract.getLong("renewalcontractid");
            if (clearBillId != 0L) {
                clearBillIds.add(clearBillId);
            }
            if (renewalContractId != 0L) {
                renewalContractIds.add(renewalContractId);
            }
            terminationContractIds.add(contract.getLong("id"));
        }
        Set<Long> hasVoucherClearBills = FaDepreUtil.hasVoucher(clearBillIds, "fa_clearbill");
        Set<Long> hasRealCardContracts = this.hasRealCard(renewalContractIds);
        Set<Long> hasRentSettleContracts = this.hasRentSettle(renewalContractIds);
        Set<Long> notStagingContracts = this.isNotStagingContract(renewalContractIds);
        Set<Long> hasVoucherReversalRentSettle = this.hasVoucher4ReversalRentSettle(terminationContractIds);
        int seq = 1;
        for (Long leaseContractId : this.contractIds) {
            DynamicObject contract = contractMap.get(leaseContractId);
            long clearBillId = contract.getLong("clearbill");
            long renewalContractId = contract.getLong("renewalcontractid");
            if (clearBillId != 0L && hasVoucherClearBills.contains(clearBillId)) {
                errorInfo.add(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff1a\u6e05\u7406\u5355\u5df2\u7ecf\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u5141\u8bb8\u64a4\u9500\u7ec8\u6b62\u3002", (String)"UndoTerminationValidator_2", (String)"fi-fa-business", (Object[])new Object[0]), seq));
            }
            if (renewalContractId != 0L) {
                if (hasRealCardContracts.contains(renewalContractId)) {
                    errorInfo.add(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff1a\u7eed\u79df\u5408\u540c\u5df2\u7ecf\u4e0b\u63a8\u5361\u7247\uff0c\u4e0d\u5141\u8bb8\u64a4\u9500\u7ec8\u6b62\u3002", (String)"UndoTerminationValidator_3", (String)"fi-fa-business", (Object[])new Object[0]), seq));
                }
                if (hasRentSettleContracts.contains(renewalContractId)) {
                    errorInfo.add(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff1a\u7eed\u79df\u5408\u540c\u5df2\u7ecf\u751f\u6210\u644a\u9500\u4e0e\u8ba1\u606f\uff0c\u4e0d\u5141\u8bb8\u64a4\u9500\u7ec8\u6b62\u3002", (String)"UndoTerminationValidator_4", (String)"fi-fa-business", (Object[])new Object[0]), seq));
                }
                if (notStagingContracts.contains(renewalContractId)) {
                    errorInfo.add(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff1a\u7eed\u79df\u5408\u540c\u4e0d\u662f\u6682\u5b58\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u64a4\u9500\u7ec8\u6b62\u3002", (String)"UndoTerminationValidator_5", (String)"fi-fa-business", (Object[])new Object[0]), seq));
                }
            }
            if (hasVoucherReversalRentSettle.contains(leaseContractId)) {
                errorInfo.add(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff1a\u51b2\u9500\u7684\u644a\u9500\u4e0e\u8ba1\u606f\u8bb0\u5f55\u5df2\u7ecf\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u5141\u8bb8\u64a4\u9500\u7ec8\u6b62\u3002", (String)"UndoTerminationValidator_6", (String)"fi-fa-business", (Object[])new Object[0]), seq));
            }
            ++seq;
        }
        return errorInfo;
    }

    private Set<Long> hasRealCard(List<Long> contractIds) {
        Map targetBills = BFTrackerServiceHelper.findTargetBills((String)"fa_lease_contract", (Long[])contractIds.toArray(new Long[0]));
        Map initTargetBills = BFTrackerServiceHelper.findTargetBills((String)"fa_lease_contract_init", (Long[])contractIds.toArray(new Long[0]));
        HashSet cardIds = new HashSet(contractIds.size());
        if (targetBills.get("fa_card_real") != null) {
            cardIds.addAll((Collection)targetBills.get("fa_card_real"));
        }
        if (initTargetBills.get("fa_card_real") != null) {
            cardIds.addAll((Collection)initTargetBills.get("fa_card_real"));
        }
        if (cardIds.size() > 0) {
            QFilter filter = new QFilter("id", "in", cardIds);
            DynamicObjectCollection realCards = QueryServiceHelper.query((String)"fa_card_real", (String)"srcbillid", (QFilter[])filter.toArray());
            return realCards.stream().map(v -> v.getLong("srcbillid")).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    private Set<Long> hasRentSettle(List<Long> contractIds) {
        QFilter filter = new QFilter("leasecontract", "in", contractIds);
        DynamicObjectCollection rentSettles = QueryServiceHelper.query((String)"fa_lease_rent_settle", (String)"leasecontract", (QFilter[])filter.toArray());
        return rentSettles.stream().map(v -> v.getLong("leasecontract")).collect(Collectors.toSet());
    }

    private Set<Long> isNotStagingContract(List<Long> contractIds) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", contractIds), new QFilter("status", "!=", (Object)BillStatus.A.toString())};
        DynamicObjectCollection contracts = QueryServiceHelper.query((String)"fa_lease_contract", (String)"id", (QFilter[])filters);
        return contracts.stream().map(v -> v.getLong("id")).collect(Collectors.toSet());
    }

    private Set<Long> hasVoucher4ReversalRentSettle(List<Long> terminationContractIds) {
        String selectFields = Fa.comma((String[])new String[]{"id", "leasecontract"});
        QFilter[] rentSettleFilter = new QFilter[]{new QFilter("leasecontract", "in", terminationContractIds), new QFilter("sourcetype", "=", (Object)RentSettleSourceType.B.name())};
        DynamicObjectCollection reversalRentSettle = QueryServiceHelper.query((String)"fa_lease_rent_settle", (String)selectFields, (QFilter[])rentSettleFilter);
        if (reversalRentSettle.isEmpty()) {
            return new HashSet<Long>(1);
        }
        Map<Long, Long> rentSettleContractMap = reversalRentSettle.stream().collect(Collectors.toMap(v -> v.getLong("id"), v -> v.getLong("leasecontract")));
        ArrayList<Object> rentSettleIds = new ArrayList<Object>(rentSettleContractMap.keySet());
        Set<Long> hasVoucherRentSettleIds = FaDepreUtil.hasVoucher(rentSettleIds, "fa_lease_rent_settle");
        HashSet<Long> contractIds = new HashSet<Long>(hasVoucherRentSettleIds.size());
        for (Long rentSettleId : hasVoucherRentSettleIds) {
            contractIds.add(rentSettleContractMap.get(rentSettleId));
        }
        return contractIds;
    }
}

