/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.cache;

import java.util.ArrayList;
import java.util.Date;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.fa.cache.FaThreadCacheKey;
import kd.fi.fa.common.util.Fa;

public class FaImportCardThreadCacheUtil {
    public static DynamicObject getAssetBook(Object orgId, Object depreuseId) {
        return (DynamicObject)ThreadCache.get((Object)FaThreadCacheKey.getAssetBookKey(orgId, depreuseId), () -> {
            DynamicObject assetBook = BusinessDataServiceHelper.loadSingle((String)"fa_assetbook", (String)Fa.join((String)",", (String[])new String[]{"status", "curperiod", "startperiod", "basecurrency", "periodtype", "depresystem"}), (QFilter[])new QFilter[]{new QFilter("org.id", "=", orgId), new QFilter("depreuse.id", "=", depreuseId)});
            return assetBook;
        });
    }

    public static DynamicObject getAssetBookById(Object id) {
        return (DynamicObject)ThreadCache.get((Object)("getAssetBookById" + id), () -> {
            DynamicObject assetBook = BusinessDataServiceHelper.loadSingle((String)"fa_assetbook", (String)"periodtype", (QFilter[])new QFilter[]{new QFilter("id", "=", id)});
            return assetBook;
        });
    }

    public static DynamicObject getRealCard(Object orgId, String realNumber) {
        return (DynamicObject)ThreadCache.get((Object)FaThreadCacheKey.getRealCardKey(orgId, realNumber), () -> {
            DynamicObject realCard = BusinessDataServiceHelper.loadSingle((String)"fa_card_real", (String)String.join((CharSequence)",", "id", "headusedept", "assetcat", "billno", "sourceflag", "realaccountdate", "billstatus"), (QFilter[])new QFilter[]{new QFilter("org", "=", orgId), new QFilter("number", "=", (Object)realNumber)});
            return realCard;
        });
    }

    public static DynamicObject getBizPeriod(Object periodTypeId, Date finAccountDate) {
        return (DynamicObject)ThreadCache.get((Object)FaThreadCacheKey.getBizPeriodKey(periodTypeId, finAccountDate), () -> {
            DynamicObject bizPeriod = QueryServiceHelper.queryOne((String)"bd_period", (String)"id, periodnumber", (QFilter[])new QFilter[]{new QFilter("periodtype", "=", periodTypeId), new QFilter("begindate", "<=", (Object)finAccountDate), new QFilter("enddate", ">=", (Object)finAccountDate)});
            return bizPeriod;
        });
    }

    public static long getBaicCurrency(Object orgPk) {
        if (orgPk == null) {
            return 0L;
        }
        return (Long)ThreadCache.get((Object)FaThreadCacheKey.getExistValidateOrgKey(orgPk), () -> {
            DynamicObject book = QueryServiceHelper.queryOne((String)"fa_assetbook", (String)"basecurrency", (QFilter[])new QFilter[]{new QFilter("org", "=", orgPk), new QFilter("ismainbook", "=", (Object)Boolean.TRUE)});
            if (book != null) {
                long baseCurrencyId = book.getLong("basecurrency");
                return baseCurrencyId;
            }
            return 0L;
        });
    }

    public static boolean getAsetValidate(long assetCatePk, long orgPks) {
        return (Boolean)ThreadCache.get((Object)FaThreadCacheKey.getAsetValidateKey(assetCatePk, orgPks), () -> {
            DynamicObjectCollection exists = QueryServiceHelper.query((String)"fa_assetcategory", (String)"id", (QFilter[])new QFilter[]{BaseDataServiceHelper.getBaseDataFilter((String)"fa_assetcategory", (Long)orgPks)});
            ArrayList<Long> assetIds = new ArrayList<Long>();
            for (DynamicObject exit : exists) {
                assetIds.add(exit.getLong("id"));
            }
            if (assetIds.contains(assetCatePk)) {
                return true;
            }
            return false;
        });
    }
}

