/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.fa.business.depretask.DepreSplitDetailUtils;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.formplugin.AbstractDepreSplitSetUpForm;
import kd.fi.fa.formplugin.DSField;

public class CardSplitSetupFormPlugin
extends AbstractDepreSplitSetUpForm {
    private static final String CACHE_INIT = "cache_init";
    private static final String KEY_ENTITY_NAME = "fa_card_split_setup";
    private static final String KEY_ENTRY = "assentry";
    private static final String FIELD_ORG_DUTY = "orgduty";
    private static final String FIELD_PERCENT = "percent";
    private static final String FIELD_BEGIN_PERIOD = "beginperiod";
    private static final String FIELD_STATUS = "status";

    public void getEntityType(GetEntityTypeEventArgs e) {
        if (this.getPageCache().get(CACHE_INIT) == null) {
            this.getPageCache().put(CACHE_INIT, "true");
            MainEntityType entityType = e.getOriginalEntityType();
            List<DynamicObject> splitSetupList = this.queryDepreSplitSetup();
            FormShowParameter param = this.getView().getFormShowParameter();
            String orgIdStr = (String)param.getCustomParam("orgId");
            long orgId = Long.parseLong(orgIdStr);
            String depreUseIdStr = (String)param.getCustomParam("depreUseId");
            long depreUseId = Long.parseLong(depreUseIdStr);
            Map splitSchemaMap = DepreSplitDetailUtils.queryDepreSplitSchema((long)orgId, (long)depreUseId);
            if (splitSetupList == null && splitSchemaMap == null) {
                return;
            }
            ArrayList<DynamicObject> assTypeList = new ArrayList<DynamicObject>();
            HashSet<Long> assTypeIdSet = new HashSet<Long>(16);
            if (splitSetupList != null) {
                for (DynamicObject splitSetup : splitSetupList) {
                    DynamicObjectCollection assTypesEntries = splitSetup.getDynamicObjectCollection("asstypes");
                    for (DynamicObject assTypeEntry : assTypesEntries) {
                        DynamicObject assType = assTypeEntry.getDynamicObject("fbasedataid");
                        long id = assType.getLong("id");
                        if (assTypeIdSet.contains(id)) continue;
                        assTypeList.add(assType);
                        assTypeIdSet.add(id);
                    }
                }
            }
            if (splitSchemaMap != null) {
                Set keySet = splitSchemaMap.keySet();
                for (DynamicObject dyn : keySet) {
                    long id = dyn.getLong("id");
                    if (assTypeIdSet.contains(id)) continue;
                    assTypeList.add(dyn);
                }
            }
            List<DSField> dsFields = this.parseDsFields(assTypeList);
            this.reBuildModelAndGrid(dsFields, entityType, true);
            this.getPageCache().put("DSFields", SerializationUtils.toJsonString(dsFields));
            e.setNewEntityType(entityType);
        } else if (this.getPageCache().get("DSFields") != null) {
            List dsFields = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get("DSFields"), DSField.class);
            MainEntityType entityType = e.getOriginalEntityType();
            this.reBuildModelAndGrid(dsFields, entityType, false);
            e.setNewEntityType(entityType);
        }
    }

    public void afterCreateNewData(EventObject e) {
        List<DynamicObject> splitSetupList = this.queryDepreSplitSetup();
        FormShowParameter param = this.getView().getFormShowParameter();
        String orgIdStr = (String)param.getCustomParam("orgId");
        long orgId = Long.parseLong(orgIdStr);
        String depreUseIdStr = (String)param.getCustomParam("depreUseId");
        long depreUseId = Long.parseLong(depreUseIdStr);
        Map splitSchemaMap = DepreSplitDetailUtils.queryDepreSplitSchema((long)orgId, (long)depreUseId);
        if (splitSetupList == null && splitSchemaMap == null) {
            this.hideAllPreField();
            return;
        }
        List dsFields = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get("DSFields"), DSField.class);
        HashMap<String, String> assFieldKeys = new HashMap<String, String>(dsFields.size());
        for (DSField ds : dsFields) {
            assFieldKeys.put(ds.getEntityId(), ds.getFieldKey());
        }
        this.fillSplitSetupAss(splitSetupList, assFieldKeys);
        this.fillSplitSchemaAss(splitSchemaMap, assFieldKeys);
    }

    private void fillSplitSetupAss(List<DynamicObject> splitSetupList, Map<String, String> assFieldKeys) {
        if (splitSetupList == null) {
            return;
        }
        int index = 0;
        AbstractFormDataModel mode = (AbstractFormDataModel)this.getModel();
        mode.deleteEntryData(KEY_ENTRY);
        mode.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        for (DynamicObject splitSetup : splitSetupList) {
            DynamicObject beginPeriod = splitSetup.getDynamicObject(FIELD_BEGIN_PERIOD);
            String status = splitSetup.getString(FIELD_STATUS);
            DynamicObjectCollection entry = splitSetup.getDynamicObjectCollection(KEY_ENTRY);
            for (DynamicObject row : entry) {
                DynamicObject orgDuty = row.getDynamicObject(FIELD_ORG_DUTY);
                BigDecimal percent = row.getBigDecimal(FIELD_PERCENT);
                DynamicObjectCollection subEntry = row.getDynamicObjectCollection("asssubentry");
                for (DynamicObject subRow : subEntry) {
                    String assType = subRow.getString("asstype");
                    long assId = subRow.getLong("assid");
                    vs.set(assFieldKeys.get(assType), (Object)assId, index);
                }
                vs.set(FIELD_ORG_DUTY, orgDuty.getPkValue(), index);
                vs.set(FIELD_PERCENT, (Object)percent, index);
                vs.set(FIELD_BEGIN_PERIOD, beginPeriod.getPkValue(), index);
                vs.set(FIELD_STATUS, (Object)status, index);
                ++index;
            }
        }
        mode.batchCreateNewEntryRow(KEY_ENTRY, vs);
        mode.endInit();
    }

    private void fillSplitSchemaAss(Map<DynamicObject, String> splitSchemaMap, Map<String, String> assFieldKeys) {
        if (splitSchemaMap == null) {
            return;
        }
        FormShowParameter param = this.getView().getFormShowParameter();
        String finCardIdStr = (String)param.getCustomParam("finCardId");
        long finCardId = Long.parseLong(finCardIdStr);
        DynamicObject finCard = BusinessDataServiceHelper.loadSingleFromCache((Object)finCardId, (String)"fa_card_fin");
        long realCardId = finCard.getDynamicObject("realcard").getLong("id");
        DynamicObject realCard = BusinessDataServiceHelper.loadSingleFromCache((Object)realCardId, (String)"fa_card_real");
        DynamicObjectCollection entry = this.getModel().getEntryEntity(KEY_ENTRY);
        Map<String, String> assMap = this.formatSplitSchemaMap(splitSchemaMap);
        if (entry.isEmpty()) {
            this.getModel().batchCreateNewEntryRow(KEY_ENTRY, 1);
            this.fillEntryRowSchemeAss(assMap, assFieldKeys, realCard, finCard, 0);
            this.getModel().setValue(FIELD_PERCENT, (Object)new BigDecimal("100"), 0);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{FIELD_ORG_DUTY, FIELD_BEGIN_PERIOD, FIELD_STATUS});
        } else {
            for (int i = 0; i < entry.size(); ++i) {
                this.fillEntryRowSchemeAss(assMap, assFieldKeys, realCard, finCard, i);
            }
        }
    }

    private void fillEntryRowSchemeAss(Map<String, String> assMap, Map<String, String> assFieldKeys, DynamicObject realCard, DynamicObject finCard, int index) {
        for (Map.Entry<String, String> entry : assMap.entrySet()) {
            String assKey = entry.getKey();
            String entryFieldKey = assFieldKeys.get(assKey);
            String cardFieldKey = entry.getValue();
            Object value = this.getModel().getValue(entryFieldKey, index);
            if (value != null) continue;
            String[] split = cardFieldKey.split("\\.");
            String cardType = split[0];
            String prop = split[1];
            Set<String> realCardProps = this.getEntityProperties(realCard);
            Set<String> finCardProps = this.getEntityProperties(finCard);
            if ("realcard".equals(cardType) && realCardProps.contains(prop)) {
                value = realCard.get(prop);
            } else if ("fincard".equals(cardType) && finCardProps.contains(prop)) {
                value = finCard.get(prop);
            }
            if (!(value instanceof DynamicObject)) continue;
            long id = ((DynamicObject)value).getLong("id");
            this.getModel().setValue(entryFieldKey, (Object)id, index);
        }
    }

    private Map<String, String> formatSplitSchemaMap(Map<DynamicObject, String> splitSchemaMap) {
        HashMap<String, String> assMap = new HashMap<String, String>(splitSchemaMap.size());
        for (Map.Entry<DynamicObject, String> entry : splitSchemaMap.entrySet()) {
            DynamicObject assDyn = entry.getKey();
            String fieldKey = entry.getValue();
            String valueType = assDyn.getString("valuetype");
            if ("1".equals(valueType)) {
                String entityKey = assDyn.getString("valuesource.number");
                assMap.put(entityKey, fieldKey);
                continue;
            }
            if (!"2".equals(valueType)) continue;
            String assistantId = assDyn.getString("assistanttype.id");
            assMap.put(assistantId, fieldKey);
        }
        return assMap;
    }

    private Set<String> getEntityProperties(DynamicObject dyn) {
        DataEntityPropertyCollection properties = dyn.getDataEntityType().getProperties();
        return properties.stream().map(v -> v.getName()).collect(Collectors.toSet());
    }

    private void reBuildModelAndGrid(List<DSField> dsFields, MainEntityType mainEntityType, boolean rebuildGrid) {
        EntryProp entry = (EntryProp)mainEntityType.getProperty(KEY_ENTRY);
        this.setFactorColumnMeta(dsFields, mainEntityType, entry);
        this.drawGrid(dsFields, rebuildGrid);
    }

    private void drawGrid(List<DSField> refList, boolean rebuildGrid) {
        Map<String, Object> statusCol;
        Map<String, Object> periodCol;
        ArrayList<Map<String, Object>> cols = new ArrayList<Map<String, Object>>();
        cols.add(this.createSeqColumn());
        cols.add(this.createDeptUseColumn());
        Map<String, Object> percentCol = this.createPercentColumn();
        if (percentCol != null) {
            cols.add(percentCol);
        }
        if (refList != null) {
            for (DSField ref : refList) {
                Map<String, Object> col = this.createBaseDataColumn(ref);
                cols.add(col);
            }
        }
        if ((periodCol = this.createBeginPeriodColumn()) != null) {
            cols.add(periodCol);
        }
        if ((statusCol = this.createStatusColumn()) != null) {
            cols.add(statusCol);
        }
        if (rebuildGrid) {
            HashMap<String, Object> meta = new HashMap<String, Object>(4);
            meta.put("rk", "rk");
            meta.put("seq", "fseq");
            meta.put("columns", cols);
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            clientViewProxy.preInvokeControlMethod(KEY_ENTRY, "createGridColumns", new Object[]{meta});
        }
    }

    private Map<String, Object> createBeginPeriodColumn() {
        EntryFieldAp entryField = new EntryFieldAp();
        entryField.setKey(FIELD_BEGIN_PERIOD);
        entryField.setName(new LocaleString(ResManager.loadKDString((String)"\u751f\u6548\u671f\u95f4", (String)"CardSplitSetupFormPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0])));
        entryField.setFieldTextAlign("center");
        entryField.setTextAlign("center");
        entryField.setAlignSelf("center");
        entryField.setWidth(new LocaleString("120"));
        entryField.setLock("");
        BasedataField baseData = new BasedataField();
        baseData.setBaseEntityId("bd_period");
        baseData.setKey(FIELD_BEGIN_PERIOD);
        entryField.setField((Field)baseData);
        return (Map)entryField.createColumns().get(0);
    }

    private Map<String, Object> createStatusColumn() {
        EntryFieldAp entryField = new EntryFieldAp();
        entryField.setKey(FIELD_STATUS);
        entryField.setName(new LocaleString(ResManager.loadKDString((String)"\u6570\u636e\u72b6\u6001", (String)"CardSplitSetupFormPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0])));
        entryField.setFieldTextAlign("center");
        entryField.setTextAlign("center");
        entryField.setAlignSelf("center");
        entryField.setWidth(new LocaleString("100"));
        entryField.setLock("");
        ComboField comboField = new ComboField();
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        items.add(new ComboItem(1, new LocaleString(ResManager.loadKDString((String)"\u6682\u5b58", (String)"CardSplitSetupFormPlugin_2", (String)"fi-fa-formplugin", (Object[])new Object[0])), "A"));
        items.add(new ComboItem(2, new LocaleString(ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4", (String)"CardSplitSetupFormPlugin_3", (String)"fi-fa-formplugin", (Object[])new Object[0])), "B"));
        items.add(new ComboItem(3, new LocaleString(ResManager.loadKDString((String)"\u5df2\u5ba1\u6838", (String)"CardSplitSetupFormPlugin_4", (String)"fi-fa-formplugin", (Object[])new Object[0])), "C"));
        comboField.setItems(items);
        comboField.setKey(FIELD_STATUS);
        entryField.setField((Field)comboField);
        return (Map)entryField.createColumns().get(0);
    }

    private List<DSField> parseDsFields(List<DynamicObject> assTypeList) {
        int i = 0;
        int j = 0;
        ArrayList<DSField> dsFields = new ArrayList<DSField>(assTypeList.size());
        for (DynamicObject assType : assTypeList) {
            String valueType = assType.getString("valuetype");
            DSField dsField = new DSField();
            dsField.setDataType(valueType);
            if ("1".equals(valueType)) {
                dsField.setEntityId(assType.getString("valuesource.number"));
                dsField.setFieldKey("basedata" + i);
                dsField.setFieldName(new LocaleString(assType.getString("valuesource.name")));
                ++i;
            } else if ("2".equals(valueType)) {
                dsField.setEntityId(assType.getString("assistanttype.id"));
                dsField.setFieldKey("assistant" + j);
                dsField.setFieldName(new LocaleString(assType.getString("assistanttype.name")));
                ++j;
            }
            dsFields.add(dsField);
        }
        return dsFields;
    }

    private List<DynamicObject> queryDepreSplitSetup() {
        QFilter[] filters;
        FormShowParameter param = this.getView().getFormShowParameter();
        String realCardStr = (String)param.getCustomParam("realCardIds");
        List realCardIds = SerializationUtils.fromJsonStringToList((String)realCardStr, Long.class);
        String depreUseIdStr = (String)param.getCustomParam("depreUseId");
        long depreUseId = Long.parseLong(depreUseIdStr);
        String selectFields = Fa.join((String)",", (String[])new String[]{"asstypes", FIELD_BEGIN_PERIOD, FIELD_STATUS, "assentry.assinfo", "assentry.orgduty", "assentry.percent", "assentry.asssubentry", "asssubentry.asstype", "asssubentry.assid"});
        Map depreSplitSetUpMap = BusinessDataServiceHelper.loadFromCache((String)"fa_depresplitsetup", (String)selectFields, (QFilter[])(filters = new QFilter[]{new QFilter("realcard", "in", (Object)realCardIds), new QFilter("depreuse", "=", (Object)depreUseId)}));
        if (depreSplitSetUpMap == null || depreSplitSetUpMap.isEmpty()) {
            return null;
        }
        return depreSplitSetUpMap.values().stream().sorted(Comparator.comparing(p -> p.getInt("beginperiod.number"))).collect(Collectors.toList());
    }

    private void hideAllPreField() {
        int preFieldNum = 16;
        ArrayList<String> preFields = new ArrayList<String>(preFieldNum * 2);
        for (int i = 0; i < preFieldNum; ++i) {
            preFields.add("basedata" + i);
            preFields.add("assistant" + i);
        }
        this.getView().setVisible(Boolean.valueOf(false), preFields.toArray(new String[0]));
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
    }
}

