/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.validate.BillStatus;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.OrgEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.enums.BusyTypeDetailEnum;
import kd.fi.fa.business.utils.FaBizUtils;
import kd.fi.fa.business.utils.FaChangeModeConfUtil;
import kd.fi.fa.business.utils.FaPermissionUtils;
import kd.fi.fa.business.utils.FaUtils;
import kd.fi.fa.common.util.DateUtil;
import kd.fi.fa.common.util.TypeConverUtil;
import kd.fi.fa.formplugin.FaBillBaseFormPlugin;
import kd.fi.fa.formplugin.importhandler.ClearApplyBillImportHandler;
import kd.fi.fa.utils.FaF7DeptUtils;
import kd.fi.fa.utils.FaFormPermissionUtil;
import kd.fi.fa.utils.FaQFilter;

public class ClearApplyBillFormPlugin
extends FaBillBaseFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit realCardEdit = (BasedataEdit)this.getView().getControl("realcard");
        realCardEdit.addBeforeF7SelectListener(v -> FaQFilter.realCardQFilter(this.getModel(), v));
        OrgEdit orgF7 = (OrgEdit)this.getControl("org");
        if (orgF7 != null) {
            orgF7.setIsOnlyDisplayOrgLeaves(true);
            orgF7.addBeforeF7SelectListener(listener -> FaF7DeptUtils.orgDelegateAssetUnit(listener, this.getModel()));
        }
        BasedataEdit assetUnit = (BasedataEdit)this.getControl("assetunit");
        assetUnit.addBeforeF7SelectListener(evt -> FaFormPermissionUtil.beforeAssetUnitSelectV2(this.getView().getPageId(), evt, "fa_clearapplybill"));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setClearApplyBizDate();
        this.getModel().setDataChanged(false);
    }

    private void setClearApplyBizDate() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"titlepanelflex"});
            return;
        }
        Long acctOrg = org.getLong("id");
        DynamicObject mainBook = FaBizUtils.getAsstBookByOrg((Long)acctOrg);
        if (mainBook == null) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u672a\u8bbe\u7f6e\u4e3b\u8d26\u7c3f", (String)"ClearApplyBillFormPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]), org.getString("name")));
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"titlepanelflex"});
            return;
        }
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"titlepanelflex"});
        DateEdit clearDateEdit = (DateEdit)this.getView().getControl("cleardate");
        Date bookBeginDate = (Date)mainBook.get("begindate");
        Date sysDate = KDDateUtils.now();
        clearDateEdit.setMinDate(bookBeginDate);
        if (this.getView().getFormShowParameter().getStatus().equals((Object)OperationStatus.ADDNEW)) {
            if (DateUtil.compareShortDate((Date)sysDate, (Date)bookBeginDate) < 0) {
                this.getModel().setValue("cleardate", (Object)bookBeginDate);
            } else {
                this.getModel().setValue("cleardate", (Object)sysDate);
            }
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        this.getView().close();
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object isChangingMainOrg = this.getModel().getContextVariable("isChangingMainOrg");
        List assetUnits = FaPermissionUtils.getAllPermissionAsseUnitsV2((String)this.getView().getPageId(), (String)"fa_clearapplybill");
        Long orgId = FaPermissionUtils.getDefaultAcctOrg((List)assetUnits);
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (isChangingMainOrg == null && parentView != null && parentView.toString().indexOf("FormView-fa_mainpage_grid") == 0) {
            this.getModel().setValue("assetunit", (Object)orgId);
            this.getModel().setValue("org", (Object)orgId);
        }
        IDataModel model = this.getModel();
        model.setValue("billstatus", (Object)BillStatus.A);
        model.setValue("changemode", (Object)FaChangeModeConfUtil.getChangeModeDefaultValue((Long)orgId, (String)"fa_clearapplybill"));
        model.setValue("handler", model.getValue("creator"));
        this.isWorkflowVisial();
        if (this.getView() == null || parentView == null) {
            return;
        }
        FaFormPermissionUtil.selectDefaultOrg(model, (IPageCache)parentView.getService(IPageCache.class), "fa_clearbill");
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        IDataModel model = this.getModel();
        DynamicObjectCollection entry = model.getEntryEntity("clrapplybill_entry");
        boolean clearBillIsAudit = false;
        model.getValue("id");
        Object pk = model.getValue("id");
        HashMap<Long, String> numbersAndIsClearAll = new HashMap<Long, String>();
        if (pk != null) {
            QFilter srcbillQ = new QFilter("srcbill", "=", (Object)TypeConverUtil.ObjToLong((Object)pk));
            DynamicObjectCollection clearBills = QueryServiceHelper.query((String)"fa_clearbill", (String)"billstatus,detail_entry.realcard,detail_entry.isclearall", (QFilter[])new QFilter[]{srcbillQ});
            for (DynamicObject clearBill : clearBills) {
                clearBillIsAudit = "C".equals(clearBill.getString("billstatus"));
                numbersAndIsClearAll.put(clearBill.getLong("detail_entry.realcard"), clearBill.getString("detail_entry.isclearall"));
            }
        }
        for (DynamicObject dyn : entry) {
            BigDecimal assetQty = dyn.getDynamicObject("realcard").getBigDecimal("assetamount");
            dyn.set("assetqty", (Object)assetQty);
            if (!clearBillIsAudit || !"2".equals(numbersAndIsClearAll.get(dyn.getLong("realcard_id")))) continue;
            dyn.set("assetqty", (Object)assetQty.add(dyn.getBigDecimal("clearqty")));
        }
        this.initEnable();
        this.isWorkflowVisial();
    }

    private void isWorkflowVisial() {
        String sql = "SELECT FKEY FROM T_WF_PROCDEF b WHERE  b.FENTRABILLID = ?";
        List dataSet = (List)DB.query((DBRoute)DBRoute.workflow, (String)sql, (Object[])new String[]{"fa_clearapplybill"}, rh -> {
            ArrayList<String> dataList = new ArrayList<String>(rh.getRow());
            while (rh.next()) {
                dataList.add(rh.getString("FKEY"));
            }
            return dataList;
        });
        if (dataSet.isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"workflowview"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        IDataModel model = this.getModel();
        if ("realcard".equalsIgnoreCase(name)) {
            ChangeData changeData = e.getChangeSet()[0];
            int index = changeData.getRowIndex();
            DynamicObject card = (DynamicObject)model.getValue("realcard", index);
            if (card != null) {
                Date date = (Date)model.getValue("cleardate");
                long orgId = (Long)model.getValue("org_id");
                HashSet<Long> cardIds = new HashSet<Long>(1);
                cardIds.add(card.getLong("id"));
                String msg = FaUtils.checkRealCardBizStatus(cardIds);
                if (!msg.isEmpty()) {
                    model.setValue("realcard", null, index);
                    model.setValue("measureunit", null, index);
                    model.setValue("clearqty", null, index);
                    model.setValue("assetqty", null, index);
                    this.getView().showErrorNotification(msg);
                    return;
                }
                Set existCards = FaUtils.getCurRealCard((Date)date, (Long)orgId, (Boolean)false, cardIds, (BusyTypeDetailEnum)BusyTypeDetailEnum.REAL_FIN_CHG, null);
                if (!existCards.containsAll(cardIds)) {
                    model.setValue("realcard", null, index);
                    model.setValue("measureunit", null, index);
                    model.setValue("clearqty", null, index);
                    model.setValue("assetqty", null, index);
                    FaUtils.showErrorRealCardMsg((int)1, null, (DynamicObject)card, (IFormView)this.getView());
                    return;
                }
                model.setValue("measureunit", card.getDynamicObject("unit").get("id"), index);
                BigDecimal assetQty = card.getBigDecimal("assetamount");
                model.setValue("clearqty", (Object)assetQty, index);
                model.setValue("assetqty", (Object)assetQty, index);
                this.initEnable();
            } else {
                model.setValue("measureunit", null, index);
                model.setValue("clearqty", null, index);
            }
        } else if ("org".equals(name)) {
            this.setClearApplyBizDate();
        }
        super.propertyChanged(e);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        String billstatus = (String)this.getModel().getValue("billstatus");
        if ("C".equalsIgnoreCase(billstatus)) {
            e.setCheckDataChange(false);
        }
    }

    private void initEnable() {
        IDataModel model = this.getModel();
        int entryRowCount = this.getModel().getEntryRowCount("clrapplybill_entry");
        for (int i = 0; i < entryRowCount; ++i) {
            DynamicObject card = (DynamicObject)this.getModel().getValue("realcard", i);
            if (card == null) continue;
            BigDecimal assetQty = card.getBigDecimal("assetamount");
            if (assetQty.compareTo(BigDecimal.ONE) == 0) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"clearqty"});
                continue;
            }
            this.getView().setEnable(Boolean.TRUE, i, new String[]{"clearqty"});
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        ClearApplyBillImportHandler clearApplyBillImportHandler = new ClearApplyBillImportHandler();
        clearApplyBillImportHandler.dataCheck(e);
        super.beforeImportData(e);
    }

    public void initImportData(InitImportDataEventArgs e) {
        super.initImportData(e);
        this.importCheckCodeRule("fa_clearapplybill", e, "assetunit");
    }

    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        new ClearApplyBillImportHandler().setData2Model(this.getModel());
    }
}

