/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin;

import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.validate.BillStatus;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.business.utils.FaDepreAdjustUtils;
import kd.fi.fa.business.utils.FaPermissionUtils;
import kd.fi.fa.business.utils.FaUtils;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.formplugin.FaRealCardF7Plugin;
import kd.fi.fa.formplugin.importhandler.DepreAdjustBillImportHandler;
import kd.fi.fa.utils.FaQFilter;

public class DepreAdjustBillEditPlugin
extends AbstractFormPlugin {
    private Long depreUseId = null;

    public void beforeImportData(BeforeImportDataEventArgs e) {
        new DepreAdjustBillImportHandler().beforeImportData(e);
    }

    public void afterImportData(ImportDataEventArgs e) {
        new DepreAdjustBillImportHandler().afterImportData(this.getModel(), e);
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject org;
        IDataModel model = this.getModel();
        Object customParam = this.getView().getFormShowParameter().getCustomParam("depreuse");
        if (customParam != null) {
            this.depreUseId = Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("depreuse"));
        }
        if ((org = (DynamicObject)model.getValue("org")) != null) {
            this.initByOrg();
        }
    }

    void initByOrg() {
        IDataModel model = this.getModel();
        DynamicObject[] books = this.getBooks();
        if (books.length > 0) {
            Set assetBookDepreUses = Arrays.stream(books).map(v -> v.getDynamicObject("depreuse").getPkValue()).collect(Collectors.toSet());
            DynamicObject book = books[0];
            if (assetBookDepreUses.contains(this.depreUseId)) {
                for (DynamicObject assetBook : books) {
                    Object depreUsePk = assetBook.getDynamicObject("depreuse").getPkValue();
                    if (!depreUsePk.equals(this.depreUseId)) continue;
                    book = assetBook;
                }
            } else {
                Optional<DynamicObject> optional = Stream.of(books).filter(v -> v.getBoolean("ismainbook")).findFirst();
                if (optional.isPresent()) {
                    book = optional.get();
                }
            }
            model.setValue("depreuse", book.getDynamicObject("depreuse").getPkValue());
            model.setValue("period", book.getDynamicObject("curperiod").getPkValue());
            model.setValue("currency", book.getDynamicObject("basecurrency").getPkValue());
            this.lockEntry(false);
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e0d\u5b58\u5728\u5df2\u542f\u7528\u7684\u8d44\u4ea7\u8d26\u7c3f\u3002", (String)"DepreAdjustBillEditPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            this.lockEntry(true);
        }
    }

    DynamicObject[] getBooks() {
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        QFilter filter = new QFilter("org", "=", org.getPkValue());
        filter = filter.and(new QFilter("status", "=", (Object)BillStatus.C.toString()));
        String fields = Fa.join((String)",", (String[])new String[]{"ismainbook", "depreuse", "curperiod", "basecurrency"});
        DynamicObject[] books = BusinessDataServiceHelper.load((String)"fa_assetbook", (String)fields, (QFilter[])filter.toArray());
        return books;
    }

    private DynamicObject[] getAssetBooksByPerm() {
        List orgIds = FaPermissionUtils.getPermissionLeafOrgIdsV2((String)this.getView().getPageId(), (String)"fa_depreadjustbill", (String)"47156aff000000ac", (String)"10");
        QFilter[] filters = new QFilter[]{new QFilter("org", "in", (Object)orgIds), new QFilter("status", "=", (Object)BillStatus.C.toString())};
        DynamicObject[] assetBooks = BusinessDataServiceHelper.load((String)"fa_assetbook", (String)Fa.join((String)",", (String[])new String[]{"org", "depreuse", "curperiod"}), (QFilter[])filters);
        return assetBooks;
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        BasedataEdit orgF7 = (BasedataEdit)this.getControl("org");
        orgF7.addBeforeF7SelectListener(v -> this.setF7Filter(v, this::getOrgF7Filter));
        BasedataEdit depreuseF7 = (BasedataEdit)this.getControl("depreuse");
        depreuseF7.addBeforeF7SelectListener(v -> this.setF7Filter(v, this::getDepreuseF7Filter));
        BasedataEdit realCardF7 = (BasedataEdit)this.getControl("realcard");
        realCardF7.addBeforeF7SelectListener(v -> FaQFilter.realCardQFilter(this.getModel(), v));
    }

    private void setF7Filter(BeforeF7SelectEvent e, Supplier<QFilter> filterFn) {
        ListShowParameter showParam = (ListShowParameter)e.getFormShowParameter();
        ListFilterParameter filterParam = showParam.getListFilterParameter();
        filterParam.getQFilters().add(filterFn.get());
    }

    QFilter getDepreuseF7Filter() {
        DynamicObject[] assetBooks = this.getBooks();
        Set depreuseIdSet = Stream.of(assetBooks).map(v -> v.get("depreuse.id")).collect(Collectors.toSet());
        return new QFilter("id", "in", depreuseIdSet);
    }

    QFilter getOrgF7Filter() {
        DynamicObject[] assetBooks = this.getAssetBooksByPerm();
        Set orgIdSet = Stream.of(assetBooks).map(v -> v.get("org.id")).collect(Collectors.toSet());
        return new QFilter("id", "in", orgIdSet);
    }

    QFilter getRealCardF7Filter() {
        IDataModel model = this.getModel();
        int rowCount = model.getEntryRowCount("entryentity");
        HashSet<Object> rCardPkSelected = new HashSet<Object>();
        for (int i = 0; i < rowCount; ++i) {
            DynamicObject realCard = (DynamicObject)model.getValue("realcard", i);
            if (realCard == null) continue;
            rCardPkSelected.add(realCard.getPkValue());
        }
        return new QFilter("bizstatus", "=", (Object)BizStatusEnum.READY).or(new QFilter("bizstatus", "=", (Object)BizStatusEnum.DEPREADJUST)).and("id", "not in", rCardPkSelected).and(new QFilter("org", "=", ((DynamicObject)model.getValue("org")).getPkValue())).and(new QFilter("isbak", "=", (Object)"0"));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        IDataModel model = this.getModel();
        if ("realcard".equalsIgnoreCase(propName)) {
            ChangeData changeData = e.getChangeSet()[0];
            DynamicObject realcard = (DynamicObject)changeData.getNewValue();
            if (realcard == null) {
                return;
            }
            int rowIndex = changeData.getRowIndex();
            String bizStatusCheckMsg = FaUtils.checkRealCardBizStatus(Collections.singleton(realcard.getLong("id")));
            if (!bizStatusCheckMsg.isEmpty()) {
                model.setValue("realcard", null, rowIndex);
                model.setValue("bfrdepreamount", null, rowIndex);
                model.setValue("aftdepreamount", null, rowIndex);
                this.getView().showErrorNotification(bizStatusCheckMsg);
                return;
            }
            Object periodPK = ((DynamicObject)model.getValue("period")).getPkValue();
            Object orgPk = ((DynamicObject)model.getValue("org")).getPkValue();
            Object depreUsePk = ((DynamicObject)model.getValue("depreuse")).getPkValue();
            HashMap<Object, String> cardId2Number = new HashMap<Object, String>(2);
            cardId2Number.put(realcard.getPkValue(), realcard.getString("number"));
            String finCheckMsg = FaRealCardF7Plugin.checkFinCardByDepreAdjust(orgPk, depreUsePk, periodPK, cardId2Number);
            if (finCheckMsg != null) {
                this.getView().showErrorNotification(finCheckMsg);
                model.setValue("realcard", null, changeData.getRowIndex());
                model.setValue("bfrdepreamount", null, changeData.getRowIndex());
                model.setValue("aftdepreamount", null, changeData.getRowIndex());
                return;
            }
            String msg = FaDepreAdjustUtils.getAlreadyDepAdjustCardMsg((Object)orgPk, (Object)depreUsePk, (Object)periodPK, cardId2Number.keySet());
            if (msg != null) {
                this.getView().showErrorNotification(msg);
                model.setValue("realcard", null, changeData.getRowIndex());
                model.setValue("bfrdepreamount", null, changeData.getRowIndex());
                model.setValue("aftdepreamount", null, changeData.getRowIndex());
                return;
            }
            QFilter[] filters = new QFilter[]{new QFilter("realcardmasterid", "=", realcard.getPkValue()), new QFilter("depreuse.id", "=", ((DynamicObject)model.getValue("depreuse")).getPkValue()), new QFilter("bizperiod.id", "=", periodPK), new QFilter("originaldata", "=", (Object)false)};
            DynamicObject fincard = QueryServiceHelper.queryOne((String)"fa_card_fin", (String)"monthdepre", (QFilter[])filters);
            model.setValue("bfrdepreamount", (Object)fincard.getBigDecimal("monthdepre"), rowIndex);
            model.setValue("aftdepreamount", (Object)fincard.getBigDecimal("monthdepre"), rowIndex);
        }
        if ("org".equalsIgnoreCase(propName)) {
            model.setValue("depreuse", null);
            model.setValue("period", null);
            model.getEntryEntity("entryentity").clear();
            this.initByOrg();
        }
        if ("depreuse".equalsIgnoreCase(propName)) {
            this.bookChanged(e);
        }
        if ("depreuse".equals(propName)) {
            this.getModel().deleteEntryData("entryentity");
        }
    }

    private void bookChanged(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        DynamicObject depreuse = (DynamicObject)model.getValue("depreuse");
        if (depreuse == null) {
            this.lockEntry(true);
            return;
        }
        this.lockEntry(false);
        String fields = "id,curperiod";
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", org.getPkValue()), new QFilter("depreuse", "=", depreuse.getPkValue())};
        DynamicObject assetBook = BusinessDataServiceHelper.loadSingle((String)"fa_assetbook", (String)fields, (QFilter[])filters);
        model.setValue("period", assetBook.getDynamicObject("curperiod").getPkValue());
    }

    protected void lockEntry(boolean isLock) {
        this.getView().setEnable(Boolean.valueOf(!isLock), new String[]{"advconap"});
    }
}

