/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin;

import java.math.BigDecimal;
import java.util.EventObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;

public class DepreMethodEditPlugin
extends AbstractFormPlugin {
    private static final String ENTRY_YEAR = "entry_year";
    private static final String ENTRY_PERIOD = "entry_period";
    private static final String YEAR_DEPRE_AMOUNT = "yeardepreamount";
    private static final String PERIOD_DEPRE_AMOUNT = "perioddepreamount";
    private static final int MONTHOFYEAR = 12;
    private static final int MAX_YEAR_DEPRE_AMOUNT = 100;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"customformula"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        if (ctlSource.getKey().equalsIgnoreCase("customformula")) {
            this.showCustomFormulaForm();
        }
    }

    private void showCustomFormulaForm() {
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
    }

    public void propertyChanged(PropertyChangedArgs arg) {
        String prop = arg.getProperty().getName();
        IDataModel model = this.getModel();
        if (YEAR_DEPRE_AMOUNT.equalsIgnoreCase(prop)) {
            int depreYearCount = (Integer)arg.getChangeSet()[0].getNewValue();
            if (depreYearCount > 100) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6298\u65e7\u5e74\u9650\u4e0d\u80fd\u5927\u4e8e%s\u3002", (String)"DepreMethodEditPlugin_9", (String)"fi-fa-formplugin", (Object[])new Object[0]), 100));
            }
            model.setValue(PERIOD_DEPRE_AMOUNT, (Object)(depreYearCount * 12));
            model.deleteEntryData(ENTRY_YEAR);
            if (depreYearCount > 0) {
                model.batchCreateNewEntryRow(ENTRY_YEAR, depreYearCount);
                for (int i = 0; i < depreYearCount; ++i) {
                    model.setValue("yearnumber", (Object)(i + 1), i);
                }
            }
        } else if ("yeardeprerate".equalsIgnoreCase(prop)) {
            if (arg.getChangeSet()[0].getNewValue().equals(new BigDecimal("1"))) {
                return;
            }
            BigDecimal yearDepreRate = (BigDecimal)arg.getChangeSet()[0].getNewValue();
            if (yearDepreRate != BigDecimal.ZERO) {
                model.deleteEntryData(ENTRY_PERIOD);
                model.batchCreateNewEntryRow(ENTRY_PERIOD, 12);
                BigDecimal periodDepreRate = yearDepreRate.divide(new BigDecimal(12), 4, 4);
                for (int i = 0; i < 11; ++i) {
                    model.setValue("periodnumber", (Object)(i + 1), i);
                    model.setValue("periodDepreRate", (Object)periodDepreRate, i);
                }
                model.setValue("periodnumber", (Object)12, 11);
                model.setValue("periodDepreRate", (Object)this.calcTailValue(ENTRY_PERIOD, "periodDepreRate", yearDepreRate), 11);
                this.getView().updateView("flex_deprerate");
            }
        } else if ("perioddeprerate".equalsIgnoreCase(prop)) {
            // empty if block
        }
    }

    private BigDecimal calcTailValue(String entryName, String colName, BigDecimal summary) {
        IDataModel model = this.getModel();
        int entryRowCount = model.getEntryRowCount(entryName);
        BigDecimal summaryExceptTheLast = BigDecimal.ZERO;
        for (int i = 0; i < entryRowCount - 1; ++i) {
            summaryExceptTheLast = summaryExceptTheLast.add((BigDecimal)model.getValue(colName, i));
        }
        return summary.subtract(summaryExceptTheLast);
    }
}

