/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.AfterGetSourceDataEventArgs;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class DisposalConvertPaybillPlugin
extends AbstractConvertPlugIn {
    private Map<String, String> propertyMap = new HashMap<String, String>(16);
    private String PAYEE = "payee";
    private String PAYEETYPE = "payeetype";

    public void afterGetSourceData(AfterGetSourceDataEventArgs e) {
        super.afterGetSourceData(e);
        Map properties = e.getFldProperties();
        if (properties.containsKey(this.PAYEE)) {
            String payeePosition = ((DynamicProperty)properties.get(this.PAYEE)).getName();
            this.propertyMap.put(this.PAYEE, payeePosition);
        }
        if (properties.containsKey(this.PAYEETYPE)) {
            String payeeTypePosition = ((DynamicProperty)properties.get(this.PAYEETYPE)).getName();
            this.propertyMap.put(this.PAYEETYPE, payeeTypePosition);
        }
    }

    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntity[] billDataEntitys;
        super.afterConvert(e);
        String targetEntityNumber = this.getTgtMainType().getName();
        for (ExtendedDataEntity billDataEntity : billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber)) {
            DynamicObject sourcebill;
            DynamicObject targetBill = billDataEntity.getDataEntity();
            List scrData = (List)billDataEntity.getValue("ConvertSource");
            if (scrData.size() <= 0 || (sourcebill = (DynamicObject)scrData.get(0)) == null) continue;
            String payeePosition = this.propertyMap.get(this.PAYEE);
            String payeeTypePosition = this.propertyMap.get(this.PAYEETYPE);
            String payeeType = null;
            Long payeeId = 0L;
            if (StringUtils.isNotEmpty((CharSequence)payeeTypePosition)) {
                payeeType = sourcebill.getString(payeeTypePosition);
            }
            if (StringUtils.isNotEmpty((CharSequence)payeePosition)) {
                payeeId = sourcebill.getLong(payeePosition);
            }
            if (StringUtils.isNotEmpty((CharSequence)payeeType) && payeeId != 0L) {
                DynamicObject payer = BusinessDataServiceHelper.loadSingle((Object)payeeId, (String)payeeType);
                if (payer == null) continue;
                targetBill.set("payee", (Object)payer);
                String billname = payer.getString("name");
                targetBill.set("payeename", (Object)billname);
                continue;
            }
            targetBill.set("payee", null);
            targetBill.set("payeename", (Object)"");
        }
    }
}

