/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin;

import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.validate.BillStatus;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.fa.business.utils.FaMutexRequireUtil;
import kd.fi.fa.business.utils.FaPermissionUtils;
import kd.fi.fa.business.utils.FaUtils;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.utils.FaBillImportOrgCheckUtil;
import kd.fi.fa.utils.FaFormPermissionUtil;

public class FaAssetBookEditPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject evn) {
        super.registerListener(evn);
        IDataModel model = this.getModel();
        this.addItemClickListeners(new String[]{"tbmain"});
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener(evt -> FaFormPermissionUtil.beforeOrgSelect_newPermissionLeafOrgV2(this.getView(), evt, "fa_assetbook", "10"));
        BasedataEdit period = (BasedataEdit)this.getControl("startperiod");
        period.addBeforeF7SelectListener(e -> {
            long periodType = (Long)model.getValue("periodtype_id");
            QFilter typeF = new QFilter("periodtype", "=", (Object)periodType);
            QFilter adjustFilter = new QFilter("isadjustperiod", "=", (Object)false);
            ListShowParameter showPar = (ListShowParameter)e.getFormShowParameter();
            List qFilters = showPar.getListFilterParameter().getQFilters();
            qFilters.add(typeF);
            qFilters.add(adjustFilter);
            boolean isDefault = model.getDataEntity().getBoolean(Fa.dot((String[])new String[]{"depreuse", "default"}));
            if (isDefault) {
                Long orgId = (Long)model.getValue(Fa.id((String)"org"));
                DynamicObject leaseInit = QueryServiceHelper.queryOne((String)"fa_lease_init", (String)"startperiod", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId)});
                if (leaseInit != null) {
                    qFilters.add(new QFilter("id", "<=", (Object)leaseInit.getLong("startperiod")));
                }
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter;
        Object initGuideOrgId;
        IDataModel dataModel = this.getModel();
        if ("fa_assetbook".equals(dataModel.getDataEntityType().toString())) {
            dataModel.setValue("status", (Object)BillStatus.B.toString());
        }
        if ((initGuideOrgId = (formShowParameter = this.getView().getFormShowParameter()).getCustomParam("initGuide.orgId")) != null) {
            dataModel.setValue("org", initGuideOrgId);
            dataModel.setValue("depreuse", QueryServiceHelper.queryOne((String)"fa_depreuse", (String)"id", (QFilter[])new QFilter("number", "=", (Object)"01").toArray()).get("id"));
            this.setBookName(dataModel);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        String property = e.getProperty().getName();
        if ("startperiod".equalsIgnoreCase(property)) {
            Object enablePeriod = e.getChangeSet()[0].getNewValue();
            model.setValue("curperiod", enablePeriod);
        } else if ("depreuse".equals(property)) {
            this.setEnable(true);
            this.requireMutexBatch();
        } else if ("org".equals(property)) {
            this.setEnable(true);
            this.requireMutexBatch();
        } else if ("depresystem".equals(property)) {
            model.setValue("startperiod", null);
            model.setValue("curperiod", null);
            Object depreSystem = model.getValue("depresystem");
            if (Objects.nonNull(depreSystem)) {
                Long depresystem = ((DynamicObject)depreSystem).getLong("id");
                String fileds = "basecurrency,exchangetable,periodtype";
                QFilter qFilter = new QFilter("id", "in", (Object)depresystem);
                DynamicObject dyo = QueryServiceHelper.queryOne((String)"fa_depresystem", (String)fileds, (QFilter[])new QFilter[]{qFilter});
                if (dyo.getLong("basecurrency") != 0L) {
                    model.setValue("basecurrency", (Object)dyo.getLong("basecurrency"));
                }
                if (dyo.getLong("exchangetable") != 0L) {
                    model.setValue("exchangetable", (Object)dyo.getLong("exchangetable"));
                }
                if (dyo.getLong("periodtype") != 0L) {
                    model.setValue("periodtype", (Object)dyo.getLong("periodtype"));
                }
            }
        } else if ("periodtype".equalsIgnoreCase(property)) {
            model.setValue("startperiod", null);
        }
    }

    private void requireMutexBatch() {
        DynamicObject assetBook;
        DynamicObject depreUse;
        String org = this.getPageCache().get(((Object)((Object)this)).getClass().getName());
        if (org != null) {
            FaMutexRequireUtil.batchRelease((String)"fa_assetbook", Collections.singletonList(Long.parseLong(org)), (String)"leaseInit2AssetBook", (String)"add");
        }
        if ((depreUse = (assetBook = this.getModel().getDataEntity()).getDynamicObject("depreuse")) == null) {
            return;
        }
        boolean isDefault = depreUse.getBoolean("default");
        if (isDefault) {
            Long orgId = assetBook.getLong(Fa.id((String)"org"));
            Set lockIds = FaMutexRequireUtil.requireMutexBatch((String)"fa_assetbook", Collections.singletonList(orgId), (String)"leaseInit2AssetBook", (String)"add");
            if (lockIds.isEmpty()) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u6b63\u5728\u7f16\u8f91\u79df\u8d41\u521d\u59cb\u5316\uff0c\u6682\u65f6\u4e0d\u80fd\u7f16\u8f91\u8be5\u7ec4\u7ec7\u7684\u4e3b\u8d26\u7c3f\u4fe1\u606f\u3002", (String)"FaAssetBookEditPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                this.setEnable(false);
                return;
            }
            this.getPageCache().put(((Object)((Object)this)).getClass().getName(), orgId.toString());
            String field = Fa.comma((String[])new String[]{"depresystem", "basecurrency", "exchangetable", "periodtype", "curperiod"});
            DynamicObject leaseInit = QueryServiceHelper.queryOne((String)"fa_lease_init", (String)field, (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId)});
            if (leaseInit != null) {
                IDataModel model = this.getModel();
                model.setValue("depresystem", (Object)leaseInit.getLong("depresystem"));
                model.setValue("basecurrency", (Object)leaseInit.getLong("basecurrency"));
                model.setValue("exchangetable", (Object)leaseInit.getLong("exchangetable"));
                model.setValue("periodtype", (Object)leaseInit.getLong("periodtype"));
                model.setValue("startperiod", (Object)leaseInit.getLong("curperiod"));
                this.setEnable(false);
                IFormView view = this.getView();
                view.setEnable(Boolean.valueOf(true), new String[]{"startperiod"});
                view.setEnable(Boolean.valueOf(true), new String[]{"name"});
                view.setEnable(Boolean.valueOf(true), new String[]{"number"});
            }
        }
        this.setBookName(this.getModel());
    }

    private void setEnable(boolean canEditor) {
        IFormView view = this.getView();
        view.setEnable(Boolean.valueOf(canEditor), new String[]{"depresystem"});
        view.setEnable(Boolean.valueOf(canEditor), new String[]{"basecurrency"});
        view.setEnable(Boolean.valueOf(canEditor), new String[]{"exchangetable"});
        view.setEnable(Boolean.valueOf(canEditor), new String[]{"periodtype"});
        view.setEnable(Boolean.valueOf(canEditor), new String[]{"startperiod"});
        view.setEnable(Boolean.valueOf(canEditor), new String[]{"number"});
        view.setEnable(Boolean.valueOf(canEditor), new String[]{"name"});
    }

    public void pageRelease(EventObject e) {
        String org = this.getPageCache().get(((Object)((Object)this)).getClass().getName());
        if (org != null) {
            FaMutexRequireUtil.batchRelease((String)"fa_assetbook", Collections.singletonList(Long.parseLong(org)), (String)"leaseInit2AssetBook", (String)"add");
        }
    }

    public void setBookName(IDataModel model) {
        DynamicObject org = (DynamicObject)model.getValue("org");
        DynamicObject depreuse = (DynamicObject)model.getValue("depreuse");
        if (org != null && depreuse != null) {
            model.setValue("name", (Object)(org.getString("name") + depreuse.getString("name")));
            model.setValue("number", (Object)(org.getString("number") + depreuse.getString("number")));
        } else {
            model.setValue("name", null);
            model.setValue("number", null);
        }
        if (depreuse != null) {
            model.setValue("ismainbook", (Object)depreuse.getBoolean("default"));
        }
    }

    public void afterBindData(EventObject e) {
        List orgIds;
        IDataModel model = this.getModel();
        long org = (Long)model.getValue("org_id");
        if (OperationStatus.ADDNEW == this.getView().getFormShowParameter().getStatus() && !(orgIds = FaPermissionUtils.getPermissionLeafOrgIdsV2((String)this.getView().getPageId(), (String)"fa_assetbook", (String)"47156aff000000ac", (String)"10")).contains(org) && orgIds.size() > 0) {
            model.setValue("org", orgIds.get(0));
            return;
        }
        if (OperationStatus.EDIT == this.getView().getFormShowParameter().getStatus()) {
            long depreuse = (Long)model.getValue("depreuse_id");
            boolean existsFinCard = FaUtils.existsFincardByOrgAndDepreuse((long)org, (long)depreuse);
            boolean leaseRealCard = FaUtils.existsLeaseRealCard((long)org);
            if ((existsFinCard || leaseRealCard) && !this.getView().getFormShowParameter().getStatus().equals((Object)OperationStatus.ADDNEW)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"org"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"depreuse"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"depresystem"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"startperiod"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"basecurrency"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"exchangetable"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"periodtype"});
            }
        }
    }

    public void initImportData(InitImportDataEventArgs e) {
        super.initImportData(e);
        List data = e.getSourceDataList();
        FaBillImportOrgCheckUtil.checkOrgPermission(this.getView().getPageId(), e, "fa_assetbook", "org", "10");
        HashSet<String> queryPeriodTypeNums = new HashSet<String>(10);
        HashSet<String> queryOrgNums = new HashSet<String>(data.size());
        HashSet<String> queryDepreNums = new HashSet<String>(10);
        HashSet periodNums = new HashSet(data.size());
        for (Map map : data) {
            Map pt = (Map)map.get("periodtype");
            String number = (String)pt.get("number");
            queryPeriodTypeNums.add(number);
            Map org = (Map)map.get("org");
            String orgnum = (String)org.get("number");
            queryOrgNums.add(orgnum);
            Map depreUse = (Map)map.get("depreuse");
            String depreUseNum = (String)depreUse.get("number");
            queryDepreNums.add(depreUseNum);
            Map sp = (Map)map.get("startperiod");
            periodNums.add(sp.get("number"));
        }
        DynamicObjectCollection periodTypeArray = QueryServiceHelper.query((String)"bd_period_type", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "in", queryPeriodTypeNums)});
        Map<String, DynamicObject> periodTypeMap = this.convertDynamicObjectArray2Map(periodTypeArray);
        DynamicObjectCollection periodArray = QueryServiceHelper.query((String)"bd_period", (String)"id,number,periodtype,isadjustperiod", (QFilter[])new QFilter[]{new QFilter("number", "in", periodNums), new QFilter("periodtype.number", "in", queryPeriodTypeNums)});
        HashMap<String, DynamicObject> periodMap = new HashMap<String, DynamicObject>(periodArray.size());
        for (DynamicObject obj : periodArray) {
            String periodNum = obj.getString("number");
            Long periodtype = obj.getLong("periodtype");
            periodMap.put(periodNum + "/" + periodtype, obj);
        }
        DynamicObjectCollection bosOrgArray = QueryServiceHelper.query((String)"bos_org", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("number", "in", queryOrgNums)});
        Map<String, DynamicObject> bosOrgMap = this.convertDynamicObjectArray2Map(bosOrgArray);
        DynamicObjectCollection depreUseArray = QueryServiceHelper.query((String)"fa_depreuse", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("number", "in", queryDepreNums)});
        Map<String, DynamicObject> depreUseMap = this.convertDynamicObjectArray2Map(depreUseArray);
        int index = -1;
        for (Map map : data) {
            ++index;
            Map pt = (Map)map.get("periodtype");
            Map sp = (Map)map.get("startperiod");
            DynamicObject ls = periodTypeMap.get(pt.get("number"));
            if (ls == null) {
                e.addCancelMessage(Integer.valueOf(index), Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u8be5\u671f\u95f4\u7c7b\u578b\uff0c\u8bf7\u786e\u8ba4\u5f55\u5165\u662f\u5426\u6b63\u786e\u3002", (String)"FaAssetBookEditPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                continue;
            }
            DynamicObject loadSingle = (DynamicObject)periodMap.get((String)sp.get("number") + "/" + ls.get("id"));
            if (loadSingle == null) {
                e.addCancelMessage(Integer.valueOf(index), Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u8be5\u4f1a\u8ba1\u671f\u95f4\uff0c\u8bf7\u786e\u8ba4\u5f55\u5165\u662f\u5426\u6b63\u786e\u3002", (String)"FaAssetBookEditPlugin_2", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                continue;
            }
            boolean adjustPeriod = loadSingle.getBoolean("isadjustperiod");
            if (adjustPeriod) {
                e.addCancelMessage(Integer.valueOf(index), Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u542f\u7528\u671f\u95f4\u201c%s\u201d\u4e0d\u80fd\u4e3a\u8c03\u6574\u671f\u3002", (String)"FaAssetBookEditPlugin_3", (String)"fi-fa-formplugin", (Object[])new Object[]{sp.get("number")}));
                continue;
            }
            sp.put("id", loadSingle.get("id").toString());
            Object ismb = map.get("ismainbook");
            Map org = (Map)map.get("org");
            String orgnum = (String)org.get("number");
            DynamicObject orgs = bosOrgMap.get(orgnum);
            if (orgs == null) {
                e.addCancelMessage(Integer.valueOf(index), Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a%s\u7684\u7ec4\u7ec7\u3002", (String)"FaAssetBookEditPlugin_4", (String)"fi-fa-formplugin", (Object[])new Object[]{orgnum}));
                continue;
            }
            Map depreUse = (Map)map.get("depreuse");
            String depreUseNum = (String)depreUse.get("number");
            DynamicObject depreuseObj = depreUseMap.get(depreUseNum);
            if (depreuseObj == null) {
                e.addCancelMessage(Integer.valueOf(index), Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a%s\u7684\u6298\u65e7\u7528\u9014\u3002", (String)"FaAssetBookEditPlugin_5", (String)"fi-fa-formplugin", (Object[])new Object[]{depreUseNum}));
                continue;
            }
            DynamicObject existsBook = BusinessDataServiceHelper.loadSingle((String)"fa_assetbook", (String)"id,org,status,depreuse", (QFilter[])new QFilter[]{new QFilter("org", "=", orgs.get("id")), new QFilter("depreuse", "=", (Object)depreuseObj.getLong("id"))});
            if (existsBook != null) continue;
        }
    }

    private Map<String, DynamicObject> convertDynamicObjectArray2Map(DynamicObjectCollection array) {
        if (array == null || array.size() == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, DynamicObject> dynamicMap = new HashMap<String, DynamicObject>(array.size(), 1.0f);
        for (DynamicObject obj : array) {
            dynamicMap.put(obj.getString("number"), obj);
        }
        return dynamicMap;
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
        Map sourceData = e.getSourceData();
        Map depresystem = (Map)sourceData.get("depresystem");
        Map org = (Map)sourceData.get("org");
        String orgNumber = (String)org.get("number");
        Object number = depresystem.get("number");
        depresystem.put("importprop", "id");
        QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)orgNumber), new QFilter("status", "=", (Object)BillStatus.C)};
        DynamicObject orgObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (QFilter[])filters);
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"fa_depresystem", (Long)orgObject.getLong("id"));
        QFilter numberFilter = new QFilter("number", "=", number);
        DynamicObjectCollection policies = QueryServiceHelper.query((String)"fa_depresystem", (String)"id,number,createorg", (QFilter[])new QFilter[]{baseDataFilter, numberFilter});
        if (policies.isEmpty()) {
            e.setCancel(true);
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a%s\u7684\u53ef\u7528\u8d44\u4ea7\u653f\u7b56\u3002", (String)"FaAssetBookEditPlugin_6", (String)"fi-fa-formplugin", (Object[])new Object[]{number}));
            return;
        }
        if (policies.size() == 1) {
            depresystem.put("id", ((DynamicObject)policies.get(0)).getLong("id"));
        } else {
            Long depreId = null;
            for (DynamicObject policy : policies) {
                long createorg = policy.getLong("createorg");
                if (createorg != orgObject.getLong("id")) continue;
                depreId = policy.getLong("id");
                break;
            }
            if (depreId == null || depreId.equals(0L)) {
                e.setCancel(true);
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e0b\u5b58\u5728\u591a\u4e2a\u7f16\u7801\u4e3a%s\u7684\u8d44\u4ea7\u653f\u7b56\u3002", (String)"FaAssetBookEditPlugin_7", (String)"fi-fa-formplugin", (Object[])new Object[]{number}));
                return;
            }
            depresystem.put("id", depreId);
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        Object startPeriod = this.getModel().getValue("startperiod");
        DynamicObject assetBook = this.getModel().getDataEntity();
        String number = assetBook.getString("number");
        String name = assetBook.getString("name");
        DynamicObject org = assetBook.getDynamicObject("org");
        DynamicObject depreUse = assetBook.getDynamicObject("depreuse");
        boolean fromDatabase = assetBook.getDataEntityState().getFromDatabase();
        if (!fromDatabase) {
            this.getModel().setValue("curperiod", startPeriod);
            if (StringUtils.isEmpty((CharSequence)name)) {
                assetBook.set("name", (Object)(org.getString("name") + depreUse.getString("name")));
            }
            if (StringUtils.isEmpty((CharSequence)number)) {
                assetBook.set("number", (Object)(org.getString("number") + depreUse.getString("number")));
            }
        } else {
            DynamicObject fromDbBook = BusinessDataServiceHelper.loadSingleFromCache((Object)assetBook.getPkValue(), (String)"fa_assetbook");
            if (StringUtils.isEmpty((CharSequence)number)) {
                assetBook.set("number", (Object)fromDbBook.getString("number"));
            }
            if (StringUtils.isEmpty((CharSequence)name)) {
                assetBook.set("name", (Object)fromDbBook.getString("name"));
            }
        }
        this.getModel().setValue("ismainbook", (Object)depreUse.getBoolean("default"));
    }
}

