/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Image;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.fa.business.SourceFlagEnum;
import kd.fi.fa.common.util.ContextUtil;
import kd.fi.fa.common.util.ImageUtil;
import kd.fi.fa.utils.FaAddHeadPicture;
import kd.fi.fa.utils.FaStorekeeperMatchUtil;
import kd.fi.fa.utils.FapUtils;

public class FaAssetWithdrawalPlugin
extends AbstractFormPlugin {
    private static final String FIELD_REAL_CARD = "realcard";
    private static final String FIELD_UNIT = "unit";
    private static final String FIELD_AMOUNT = "amount";
    private static final String ENTRY_ASSET_DRAWBACK = "assetdrawbackentry";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit realcard = (BasedataEdit)this.getControl(FIELD_REAL_CARD);
        realcard.addBeforeF7SelectListener(evt -> {
            DynamicObject assetOrg;
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            List filters = param.getListFilterParameter().getQFilters();
            QFilter qbillstatus = new QFilter("billstatus", "=", (Object)"C");
            QFilter qbizstatus = new QFilter("bizstatus", "=", (Object)"READY");
            filters.add(qbillstatus);
            filters.add(qbizstatus);
            DynamicObject applier = (DynamicObject)this.getModel().getValue("applier");
            if (applier != null) {
                QFilter qapplier = new QFilter("headuseperson", "=", applier.get("id"));
                filters.add(qapplier);
            }
            if ((assetOrg = (DynamicObject)this.getModel().getValue("assetorg")) != null) {
                QFilter qAssetOrg = new QFilter("assetunit", "=", assetOrg.getPkValue());
                filters.add(qAssetOrg);
            }
            filters.add(new QFilter("sourceflag", "!=", (Object)SourceFlagEnum.DATAASSET.name()));
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ASSET_DRAWBACK);
            Set cardIdSet = entryEntity.stream().map(v -> v.get("realcard.id")).filter(v -> v != null).collect(Collectors.toSet());
            ((QFilter)filters.get(0)).and(new QFilter("id", "not in", cardIdSet));
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String realcardId = (String)showParameter.getCustomParam("realcardid");
        String assetunitId = (String)showParameter.getCustomParam("assetunitid");
        String cardStatus = (String)showParameter.getCustomParam("cardstatus");
        if (!"READY".equalsIgnoreCase(cardStatus)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5b9e\u7269\u5361\u7247\u4e0d\u662f\u5c31\u7eea\u72b6\u6001\uff0c\u65e0\u6cd5\u8fdb\u884c\u9000\u5e93\u64cd\u4f5c\u3002", (String)"FaAssetWithdrawalPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            this.getModel().setDataChanged(false);
            this.getView().close();
            return;
        }
        Long userId = ContextUtil.getUserId();
        this.getModel().setValue("applier", (Object)userId);
        DynamicObject sender = (DynamicObject)this.getModel().getValue("applier");
        String pictureField = sender.getString("picturefield");
        String imageFullUrl = ImageUtil.getImageTruePath((String)pictureField);
        Image userImage = (Image)this.getControl("picturefield");
        userImage.setUrl(imageFullUrl);
        Map<String, Object> dpt = FaAddHeadPicture.getDptNameByUserId(userId);
        this.getModel().setValue("applierdept", dpt.get("dpt"));
        if ((Long)dpt.get("dpt") == 0L) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8be5\u7528\u6237\u6ca1\u6709\u90e8\u95e8\uff0c\u65e0\u6cd5\u8fdb\u884c\u8d44\u4ea7\u9000\u5e93\u3002", (String)"FaAssetWithdrawalPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            this.getView().close();
            return;
        }
        Map depParent = OrgUnitServiceHelper.getCompanyfromOrg((Object)dpt.get("dpt"));
        if (depParent == null || depParent.isEmpty()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8be5\u7528\u6237\u6ca1\u6709\u516c\u53f8\uff0c\u65e0\u6cd5\u8fdb\u884c\u8d44\u4ea7\u9000\u5e93\u3002", (String)"FaAssetWithdrawalPlugin_2", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            this.getView().close();
            return;
        }
        this.getModel().setValue("applierorg", depParent.get("id"));
        this.getModel().setValue("assetorg", (Object)assetunitId);
        DynamicObject storekeeper = FapUtils.checkStoreKeeper(this.getView(), Long.parseLong(assetunitId));
        if (storekeeper == null) {
            return;
        }
        this.getModel().setValue("signer", (Object)storekeeper);
        this.initEntity(realcardId);
    }

    private void initEntity(String realcardId) {
        if (StringUtils.isNotEmpty((String)realcardId)) {
            IDataModel dataModel = this.getModel();
            dataModel.batchCreateNewEntryRow(ENTRY_ASSET_DRAWBACK, 1);
            dataModel.setValue(FIELD_REAL_CARD, (Object)realcardId, 0);
            String selectFields = "storeplace,id,assetcat";
            DynamicObject realcard = QueryServiceHelper.queryOne((String)"fa_card_real", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(realcardId))});
            Long storeKeeperId = FaStorekeeperMatchUtil.getStoreKeeperId(realcard, (String)this.getView().getFormShowParameter().getCustomParam("assetunitid"));
            if (storeKeeperId == -1L) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8be5\u8d44\u4ea7\u7ec4\u7ec7\u6ca1\u6709\u53ef\u7528\u7684\u5e93\u7ba1\u5458\u3002", (String)"FaAssetWithdrawalPlugin_3", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                this.getModel().setDataChanged(false);
                this.getView().close();
                return;
            }
            dataModel.setValue("storekeeper", (Object)storeKeeperId);
            Object storeplaceId = realcard.get("storeplace");
            dataModel.setValue("store_place", storeplaceId, 0);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        DynamicObject sender = (DynamicObject)this.getModel().getValue("applier");
        String pictureField = sender.getString("picturefield");
        String imageFullUrl = ImageUtil.getImageTruePath((String)pictureField);
        Image userImage = (Image)this.getControl("picturefield");
        userImage.setUrl(imageFullUrl);
        Map<String, Object> dpt = FaAddHeadPicture.getDptNameByUserId((Long)sender.getPkValue());
        this.getModel().setValue("applierdept", dpt.get("dpt"));
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ASSET_DRAWBACK);
        if (entryEntity == null || entryEntity.isEmpty()) {
            return;
        }
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject dyn = (DynamicObject)entryEntity.get(i);
            DynamicObject realCard = dyn.getDynamicObject(FIELD_REAL_CARD);
            if (realCard == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5b9e\u7269\u5361\u7247\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"FaAssetWithdrawalPlugin_4", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            }
            DynamicObject unit = realCard.getDynamicObject(FIELD_UNIT);
            BigDecimal assetAmount = realCard.getBigDecimal("assetamount");
            this.getModel().setValue(FIELD_UNIT, unit.getPkValue(), i);
            this.getModel().setValue(FIELD_AMOUNT, (Object)assetAmount, i);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        if (FIELD_REAL_CARD.equals(propName)) {
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (newValue == null) {
                this.getModel().setValue(FIELD_UNIT, null, rowIndex);
                this.getModel().setValue(FIELD_AMOUNT, null, rowIndex);
                this.getModel().setValue("store_place", null, rowIndex);
            } else {
                DynamicObject unit = newValue.getDynamicObject(FIELD_UNIT);
                BigDecimal assetAmount = newValue.getBigDecimal("assetamount");
                DynamicObject storeplace = newValue.getDynamicObject("storeplace");
                DynamicObject realCard = QueryServiceHelper.queryOne((String)"fa_card_real", (String)"id,storeplace,assetcat", (QFilter[])new QFilter("id", "=", (Object)newValue.getLong("id")).toArray());
                String assetUnitId = ((DynamicObject)this.getModel().getValue("assetorg")).getString("id");
                Long storekeeper = FaStorekeeperMatchUtil.getStoreKeeperId(realCard, assetUnitId);
                this.getModel().setValue(FIELD_UNIT, unit.getPkValue(), rowIndex);
                this.getModel().setValue(FIELD_AMOUNT, (Object)assetAmount, rowIndex);
                this.getModel().setValue("store_place", (Object)storeplace, rowIndex);
                this.getModel().setValue("storekeeper", (Object)storekeeper, rowIndex);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().getModel().setDataChanged(false);
        IFormView view = this.getView();
        DynamicObject bill = view.getModel().getDataEntity();
        if (bill.getString("billstatus").equals(BillStatus.D.toString())) {
            view.setVisible(Boolean.FALSE, new String[]{"sava"});
            view.setVisible(Boolean.FALSE, new String[]{"bar_submit"});
        }
    }
}

