/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin;

import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.fa.business.SourceFlagEnum;
import kd.fi.fa.business.utils.FaPermissionUtils;
import kd.fi.fa.common.util.ContextUtil;

public class FaCardRealSearchByCodePlugin
extends AbstractFormPlugin {
    private static final String COPYCARD = "copyCard";
    private static final String BTNSAVE = "btnsave";
    private static final String BTNCLOSE = "btnclose";
    private static final String BTN_SEARCH = "search";
    private static final String BTN_COPY = "copy";
    private static final String BTN_COPY_AND_BATCH_CREATE = "copyandbatchcreate";
    private static final String REALCARDID = "realcardId";
    private static final String UPDATEVIEW = "updateview";
    private static final String BATCH = "batch";
    private static final String LABELAP = "labelap";
    private static final String LABELAP1 = "labelap1";
    private static final String LABELAP2 = "labelap2";
    private static final String LABELAP3 = "labelap3";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{BTNSAVE, LABELAP, LABELAP1, LABELAP2, LABELAP3, BTN_COPY, BTN_COPY_AND_BATCH_CREATE});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String updateview = (String)parameter.getCustomParam(UPDATEVIEW);
        if (null != updateview) {
            IDataModel dataModel = this.getView().getModel();
            dataModel.setValue("billno", null);
            dataModel.setValue("number", null);
            dataModel.setValue("barcode", null);
            dataModel.setValue("billstatus", (Object)"A");
            dataModel.setValue("bizstatus", (Object)"ADD");
            Date date = new Date();
            dataModel.setValue("auditdate", null);
            dataModel.setValue("createtime", (Object)date);
            dataModel.setValue("modifytime", (Object)date);
            dataModel.setValue("auditor", null);
            dataModel.setValue("sourceflag", (Object)SourceFlagEnum.SCAN);
            dataModel.setValue("creator", (Object)ContextUtil.getUserId());
            dataModel.setValue("modifier", (Object)ContextUtil.getUserId());
            dataModel.setValue("masterid", (Object)0);
            dataModel.setValue("billhead_lk", null);
            dataModel.setValue("initialcard", (Object)Boolean.FALSE);
            dataModel.setValue("srcbillnumber", null);
            dataModel.setValue("picturefield", null);
            dataModel.setValue("sourceentryid", (Object)0);
            dataModel.setValue("sourceentrysplitseq", (Object)0);
            dataModel.setValue("srcbillid", (Object)0);
            dataModel.setValue("srcbillentityname", null);
            dataModel.setValue("mergedcard", (Object)Boolean.FALSE);
            dataModel.setValue("headuseperson", null);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        if (BTNSAVE.equals(key) || BTNCLOSE.equals(key)) {
            this.getModel().setDataChanged(Boolean.FALSE.booleanValue());
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (BTN_SEARCH.equals(key)) {
            Object productCode = this.getModel().getValue("productcode");
            if (ObjectUtils.isEmpty((Object)productCode)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u8d44\u4ea7\u7f16\u7801/\u6761\u5f62\u7801\u3002", (String)"FaCardRealSearchByCodePlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                return;
            }
            List assetUnits = FaPermissionUtils.getAllPermissionAsseUnitsV2((String)this.getView().getPageId(), (String)"fa_card_real");
            QFilter numberFilter = new QFilter("number", "=", productCode);
            QFilter barcodeFilter = new QFilter("barcode", "=", productCode);
            QFilter isbakFilter = new QFilter("isbak", "=", (Object)"0");
            QFilter assetUnitFilter = new QFilter("assetunit", "in", (Object)assetUnits);
            DynamicObject realCard = QueryServiceHelper.queryOne((String)"fa_card_real", (String)"id,assetunit", (QFilter[])new QFilter[]{numberFilter, assetUnitFilter, isbakFilter});
            if (realCard != null) {
                this.getPageCache().put(REALCARDID, realCard.getString("id"));
                this.setScanCreateParam(realCard);
                this.getView().setVisible(Boolean.TRUE, new String[]{LABELAP, LABELAP1, BTN_COPY, BTN_COPY_AND_BATCH_CREATE});
                this.getView().setVisible(Boolean.FALSE, new String[]{BTN_SEARCH});
            } else {
                realCard = QueryServiceHelper.queryOne((String)"fa_card_real", (String)"id,assetunit", (QFilter[])new QFilter[]{barcodeFilter, assetUnitFilter, isbakFilter});
                if (realCard != null) {
                    this.getPageCache().put(REALCARDID, realCard.getString("id"));
                    this.setScanCreateParam(realCard);
                    this.getView().setVisible(Boolean.TRUE, new String[]{LABELAP, LABELAP1, BTN_COPY, BTN_COPY_AND_BATCH_CREATE});
                    this.getView().setVisible(Boolean.FALSE, new String[]{BTN_SEARCH});
                } else {
                    this.getView().setVisible(Boolean.TRUE, new String[]{LABELAP2, LABELAP3});
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        OperationResult operationResult;
        List allErrorOrValidateInfo;
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ((BTN_COPY.equals(operateKey) || BTN_COPY_AND_BATCH_CREATE.equals(operateKey)) && CollectionUtils.isEmpty((Collection)(allErrorOrValidateInfo = (operationResult = args.getOperationResult()).getAllErrorOrValidateInfo()))) {
            HashMap<String, Object> returnData = new HashMap<String, Object>(2);
            if (BTN_COPY.equals(operateKey)) {
                returnData.put(BTN_COPY, true);
            } else {
                returnData.put("batchCopy", true);
            }
            returnData.put("realCardId", this.getPageCache().get(REALCARDID));
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }

    private void setScanCreateParam(DynamicObject realCard) {
        this.getModel().setValue("assetunitid", (Object)realCard.getLong("assetunit"));
    }
}

