/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin;

import java.io.IOException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.RefEntityType;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeQueryOfExportEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.utils.FaPermissionUtils;
import kd.fi.fa.business.utils.FaUtils;
import kd.fi.fa.business.utils.SystemParamHelper;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.common.util.ThrowableHelper;
import kd.fi.fa.common.util.Tuple;
import kd.fi.fa.utils.FaChangeBillUtils;
import kd.fi.fa.utils.FaFormPermissionUtil;
import kd.fi.fa.utils.FaFormUtils;

public class FaChangeBillListPlugin
extends AbstractListPlugin {
    private static final String IS_CLICK_ORG = "isClickOrg";
    private static Log logger = LogFactory.getLog(FaChangeBillListPlugin.class);

    public void registerListener(EventObject evn) {
        super.registerListener(evn);
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new ChangeBillListDataProvider());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String type = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("previewvoucher".equals(type) || "generatevoucher".equals(type)) {
            ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
            HashSet<Long> billIds = new HashSet<Long>(selectedRows.size());
            for (ListSelectedRow selectedRow : selectedRows) {
                long primaryKey = (Long)selectedRow.getPrimaryKeyValue();
                billIds.add(primaryKey);
            }
            StringBuilder billNos = new StringBuilder();
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"fa_change_dept", (String)"fa_change_dept", (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("voucherflag", "=", (Object)"A"), new QFilter("id", "in", billIds)}, (String)"");){
                while (ds.hasNext()) {
                    if (billNos.length() > 0) {
                        billNos.append(',');
                    }
                    billNos.append(ds.next().getString("billno"));
                }
            }
            String logMessage = null;
            if (billNos.length() > 0) {
                logMessage = ResManager.loadKDString((String)"\u5f53\u524d\u53d8\u66f4\u5355{0}\u65e0\u9700\u8bb0\u8d26\u3002", (String)"FaChangeBillListPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]);
                logMessage = MessageFormat.format(logMessage, billNos.toString());
            }
            if (logMessage != null) {
                this.getView().showErrorNotification(logMessage);
                args.cancel = true;
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if (!FaUtils.isF7((IFormView)this.getView())) {
            BillList billList = (BillList)this.getControl("BillListAp");
            HyperLinkClickEvent hyperClick = args.getHyperLinkClickEvent();
            if ("vounchernumber".equals(hyperClick.getFieldName())) {
                Object rowPk = FaUtils.getRowPk((Object)billList.getCurrentSelectedRowInfo().getPrimaryKeyValue());
                args.setCancel(true);
                FaUtils.showTabForm((String)"gl_voucher", (String)ResManager.loadKDString((String)"\u51ed\u8bc1", (String)"FaChangeBillListPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]), (Object)rowPk, (IFormView)this.getView());
            }
        }
    }

    public void filterContainerInit(FilterContainerInitArgs filtercontainerinitargs) {
        super.filterContainerInit(filtercontainerinitargs);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        String orgFilterObjId = (String)paramMap.get("org");
        if (orgFilterObjId != null) {
            this.getPageCache().put("org", orgFilterObjId);
        }
        try {
            String jsonString = FaFormUtils.linkOrgContainerInit(this.getPageCache(), this.getView(), "org");
            this.getPageCache().put("orgs", jsonString);
        }
        catch (IOException e) {
            logger.error(ThrowableHelper.toString((Throwable)e));
        }
        FaFormPermissionUtil.filterContainerInitV2(filtercontainerinitargs, this.getPageCache(), this.getView().getPageId());
        List listFilterColumns = filtercontainerinitargs.getFilterContainerInitEvent().getCommonFilterColumns();
        Object sFilter = paramMap.get("filter");
        QFilter filters = null;
        QFilter[] filters2 = null;
        if (sFilter != null) {
            filters = QFilter.fromSerializedString((String)(sFilter + ""));
            filters2 = filters.recombine();
        }
        for (FilterColumn listFilter : listFilterColumns) {
            CommonFilterColumn commFilter = (CommonFilterColumn)listFilter;
            if (!"changedate".equals(commFilter.getFieldName())) continue;
            if (sFilter != null) {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                List clearDateDefValue = Stream.of(filters2).filter(v -> v.getProperty().equalsIgnoreCase("changedate")).map(v -> df.format((Date)v.getValue())).collect(Collectors.toList());
                commFilter.setDefaultValues(clearDateDefValue);
                continue;
            }
            String finaccountdate = (String)paramMap.get("finaccountdate");
            if (!StringUtils.isNotEmpty((CharSequence)finaccountdate) || !finaccountdate.equals("ismainpage")) continue;
            commFilter.setDefaultValue("");
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        FaFormPermissionUtil.filterContainerSearchClick(args, this.getPageCache());
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent e) {
        super.filterContainerBeforeF7Select(e);
        String field = e.getFieldName();
        if ("org.id".equals(field) || "org.number".equals(field) || "org.name".equals(field)) {
            List orgIds = FaPermissionUtils.getAllEnableBookAndPermissionOrgsV2((String)this.getView().getPageId(), (String)"fa_change_dept");
            e.getQfilters().add(new QFilter("id", "in", (Object)orgIds));
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        Object sFilter = this.getView().getFormShowParameter().getCustomParams().get("filter");
        if (sFilter != null) {
            e.getQFilters().add(QFilter.fromSerializedString((String)(sFilter + "")));
        } else {
            FormShowParameter formShowParameter;
            Map paramMap;
            String defortfilter;
            List qFilters = e.getQFilters();
            String notFirst = this.getPageCache().get("notFirst");
            if (!(notFirst != null && notFirst.equals("1") || (defortfilter = (String)(paramMap = (formShowParameter = this.getView().getFormShowParameter()).getCustomParams()).get("defortFilter")) == null || defortfilter.length() <= 0)) {
                qFilters.add(QFilter.fromSerializedString((String)defortfilter));
                this.getPageCache().put("notFirst", "1");
            }
        }
    }

    public void beforeQueryOfExport(BeforeQueryOfExportEvent e) {
        super.beforeQueryOfExport(e);
        String selectFields = e.getSelectFields();
        selectFields = selectFields + ",fieldentry.fincard1_id,fieldentry.realcard1_id,";
        e.setSelectFields(selectFields);
    }

    public void afterQueryOfExport(AfterQueryOfExportEvent e) {
        DynamicObject[] queryValues = e.getQueryValues();
        List orgIdList = Arrays.stream(queryValues).map(v -> v.getLong(Fa.id((String)"org"))).collect(Collectors.toList());
        Map changeEmptyParam = SystemParamHelper.getChangeEmptyParam(orgIdList);
        ArrayList<DynamicObject> typeFromCardRows = new ArrayList<DynamicObject>(20);
        ArrayList<Long> typeFromCardEntries = new ArrayList<Long>();
        HashSet<Long> realCardIds = new HashSet<Long>();
        HashSet<Long> finCardIds = new HashSet<Long>();
        for (DynamicObject queryValue : queryValues) {
            DynamicObjectCollection fieldentries = queryValue.getDynamicObjectCollection("fieldentry");
            for (Object fieldentry : fieldentries) {
                String field = fieldentry.getString("field");
                Tuple<IDataEntityProperty, Boolean> fieldTuple = FaChangeBillUtils.parseField(field);
                IDataEntityProperty prop = (IDataEntityProperty)fieldTuple.item1;
                if (!(prop instanceof ItemClassProp)) continue;
                ItemClassProp itemClassProp = (ItemClassProp)prop;
                String typePropName = itemClassProp.getTypePropName();
                String baseEntityId = "";
                String key = FaChangeBillListPlugin.genItemClassMapKey((DynamicObject)fieldentry, typePropName, false);
                for (DynamicObject cpFieldEntry : fieldentries) {
                    String cpField = cpFieldEntry.getString("field");
                    Tuple<IDataEntityProperty, Boolean> cpFieldTuple = FaChangeBillUtils.parseField(cpField);
                    IDataEntityProperty cpProp = (IDataEntityProperty)cpFieldTuple.item1;
                    String cpKey = FaChangeBillListPlugin.genItemClassMapKey(cpFieldEntry, cpProp.getName(), false);
                    if (!cpKey.equals(key)) continue;
                    baseEntityId = cpFieldEntry.getString("aftervalue");
                    break;
                }
                if (StringUtils.isEmpty((CharSequence)baseEntityId)) {
                    String[] split = field.split("\\.");
                    if ("fa_card_real".equals(split[0])) {
                        long realCard = fieldentry.getLong("realcard1_id");
                        realCardIds.add(realCard);
                    } else {
                        long finCard = fieldentry.getLong("fincard1_id");
                        finCardIds.add(finCard);
                    }
                    typeFromCardRows.add(queryValue);
                    typeFromCardEntries.add(Long.valueOf(fieldentry.getPkValue().toString()));
                    continue;
                }
                long rawValue = Long.parseLong(fieldentry.getString("aftervalue"));
                boolean changeNo = (Boolean)changeEmptyParam.get(queryValue.getLong(Fa.id((String)"org")));
                if (changeNo && rawValue == 0L) {
                    fieldentry.set("aftervalue", null);
                    continue;
                }
                DynamicObject dobj = BusinessDataServiceHelper.loadSingleFromCache((Object)rawValue, (String)baseEntityId, (String)"id,name");
                if (dobj == null) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u7f16\u7801\u4e3a%1$s\u7684%2$s\u3002", (String)"FaChangeBillListPlugin_2", (String)"fi-fa-formplugin", (Object[])new Object[0]), rawValue, prop.getDisplayName()));
                }
                fieldentry.set("aftervalue", (Object)dobj.get("name").toString());
            }
        }
        Map realCardMap = null;
        if (realCardIds.size() > 0) {
            realCardMap = BusinessDataServiceHelper.loadFromCache((Object[])realCardIds.toArray(new Object[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fa_card_real"));
        }
        Map finCardMap = null;
        if (finCardIds.size() > 0) {
            finCardMap = BusinessDataServiceHelper.loadFromCache((Object[])finCardIds.toArray(new Object[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fa_card_fin"));
        }
        HashMap<String, Map<Long, String>> baseDataNameMap = new HashMap<String, Map<Long, String>>(20);
        for (DynamicObject queryValue : typeFromCardRows) {
            DynamicObjectCollection fieldentries = queryValue.getDynamicObjectCollection("fieldentry");
            for (DynamicObject fieldentry : fieldentries) {
                Object pkValue = fieldentry.getPkValue();
                if (!typeFromCardEntries.contains(pkValue)) continue;
                String field = fieldentry.getString("field");
                Tuple<IDataEntityProperty, Boolean> fieldTuple = FaChangeBillUtils.parseField(field);
                IDataEntityProperty prop = (IDataEntityProperty)fieldTuple.item1;
                if (!(prop instanceof ItemClassProp)) continue;
                ItemClassProp itemClassProp = (ItemClassProp)prop;
                String typePropName = itemClassProp.getTypePropName();
                String billName = itemClassProp.getParent().getExtendName();
                String entityId = null;
                if (realCardMap != null && "fa_card_real".equals(billName)) {
                    Long realcard = fieldentry.getLong("realcard1_id");
                    entityId = ((DynamicObject)realCardMap.get(realcard)).getString(typePropName);
                } else if (finCardMap != null && "fa_card_fin".equals(billName)) {
                    Long fincard = fieldentry.getLong("fincard1_id");
                    entityId = ((DynamicObject)finCardMap.get(fincard)).getString(typePropName);
                }
                if (StringUtils.isEmpty(entityId)) continue;
                long aftDataId = fieldentry.getLong("aftervalue");
                String aftBaseDataName = FaChangeBillListPlugin.getRowBaseDataName(baseDataNameMap, entityId, aftDataId);
                fieldentry.set("aftervalue", (Object)aftBaseDataName);
                if (!fieldentry.containsProperty("beforevalue")) continue;
                long befDataId = fieldentry.getLong("beforevalue");
                String befBaseDataName = FaChangeBillListPlugin.getRowBaseDataName(baseDataNameMap, entityId, befDataId);
                fieldentry.set("beforevalue", (Object)befBaseDataName);
            }
        }
        for (DynamicObject queryValue : queryValues) {
            long orgId = queryValue.getLong(Fa.id((String)"org"));
            DynamicObjectCollection fieldentries = queryValue.getDynamicObjectCollection("fieldentry");
            for (DynamicObject fieldentry : fieldentries) {
                String field = fieldentry.getString("field");
                Tuple<IDataEntityProperty, Boolean> fieldTuple = FaChangeBillUtils.parseField(field);
                IDataEntityProperty prop = (IDataEntityProperty)fieldTuple.item1;
                fieldentry.set("field", (Object)prop.getDisplayName());
                String afterValue = this.parseValue(fieldentry.getString("aftervalue"), prop, (Boolean)changeEmptyParam.get(orgId));
                fieldentry.set("aftervalue", (Object)afterValue);
                if (!fieldentry.containsProperty("beforevalue")) continue;
                String befValue = this.parseValue(fieldentry.getString("beforevalue"), prop, (Boolean)changeEmptyParam.get(orgId));
                fieldentry.set("beforevalue", (Object)befValue);
            }
        }
    }

    private String parseValue(String rawValue, IDataEntityProperty prop, boolean changeNo) {
        if (StringUtils.isEmpty((CharSequence)rawValue)) {
            return rawValue;
        }
        if (prop instanceof ItemClassProp) {
            return rawValue;
        }
        if (prop instanceof ItemClassTypeProp) {
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)rawValue);
            String displayName = type.getDisplayName().getLocaleValue();
            return displayName + "(" + rawValue + ")";
        }
        if (prop instanceof BasedataProp) {
            BasedataProp basedataProp = (BasedataProp)prop;
            DynamicObjectType type = basedataProp.getDynamicComplexPropertyType();
            String entityName = type.getName();
            long id = Long.parseLong(rawValue);
            if (changeNo && id == 0L) {
                return null;
            }
            DynamicObject dobj = BusinessDataServiceHelper.loadSingle((String)entityName, (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
            if (dobj == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u7f16\u7801\u4e3a%1$s\u7684%2$s\u3002", (String)"FaChangeBillListPlugin_2", (String)"fi-fa-formplugin", (Object[])new Object[0]), rawValue, type.getDisplayName()));
            }
            return dobj.get("name").toString();
        }
        return rawValue;
    }

    private static String getRowBaseDataName(Map<String, Map<Long, String>> baseDataNameMap, String entityId, Long dataId) {
        if (StringUtils.isEmpty((CharSequence)entityId) || dataId == null || dataId.equals(0L)) {
            return null;
        }
        String baseDataName = dataId.toString();
        if (baseDataNameMap.containsKey(entityId)) {
            Map<Long, String> nameMap = baseDataNameMap.get(entityId);
            if (nameMap == null) {
                nameMap = new HashMap<Long, String>(20);
                baseDataNameMap.put(entityId, nameMap);
                DynamicObject befObj = BusinessDataServiceHelper.loadSingleFromCache((Object)dataId, (String)entityId);
                if (befObj != null) {
                    baseDataName = befObj.getString("name");
                    nameMap.put(dataId, baseDataName);
                }
            } else if (!nameMap.containsKey(dataId)) {
                DynamicObject befObj = BusinessDataServiceHelper.loadSingleFromCache((Object)dataId, (String)entityId);
                if (befObj != null) {
                    baseDataName = befObj.getString("name");
                    nameMap.put(dataId, baseDataName);
                }
            } else {
                baseDataName = nameMap.get(dataId);
            }
        } else {
            HashMap<Long, String> nameMap = new HashMap<Long, String>(20);
            baseDataNameMap.put(entityId, nameMap);
            DynamicObject befObj = BusinessDataServiceHelper.loadSingleFromCache((Object)dataId, (String)entityId);
            if (befObj != null) {
                baseDataName = befObj.getString("name");
                nameMap.put(dataId, baseDataName);
            }
        }
        return baseDataName;
    }

    private static String genItemClassMapKey(DynamicObject row, String fieldKey, boolean containsId) {
        StringBuilder key = new StringBuilder();
        if (containsId) {
            key.append(row.getLong("id")).append("-");
        }
        key.append(row.getLong("realcard1_id")).append("-");
        key.append(row.getLong("depreuse1_id")).append("-");
        key.append(fieldKey);
        return key.toString();
    }

    private static class ChangeBillListDataProvider
    extends ListDataProvider {
        private ChangeBillListDataProvider() {
        }

        public void setListFields(List<ListField> listFields) {
            ListField f;
            List allEntityNames = listFields.stream().map(ListField::getEntityName).filter(t -> StringUtils.isNotEmpty((CharSequence)t)).distinct().collect(Collectors.toList());
            if (!allEntityNames.contains("fieldentry")) {
                super.setListFields(listFields);
                return;
            }
            ListField e = new ListField("basecurrency1");
            e.setFieldName("fieldentry.basecurrency1");
            listFields.add(e);
            HashSet<String> hasField = new HashSet<String>(listFields.size());
            for (ListField field : listFields) {
                hasField.add(field.getFieldName());
            }
            if (!hasField.contains("fieldentry.field")) {
                f = new ListField("field");
                f.setFieldName("fieldentry.field");
                listFields.add(f);
            }
            if (!hasField.contains("fieldentry.depreuse1")) {
                f = new ListField("depreuse1");
                f.setFieldName("fieldentry.depreuse1");
                listFields.add(f);
            }
            if (!hasField.contains("fieldentry.beforevalue")) {
                f = new ListField("beforevalue");
                f.setFieldName("fieldentry.beforevalue");
                listFields.add(f);
            }
            if (!hasField.contains("fieldentry.aftervalue")) {
                f = new ListField("aftervalue");
                f.setFieldName("fieldentry.aftervalue");
                listFields.add(f);
            }
            if (!hasField.contains("fieldentry.field")) {
                f = new ListField("field");
                f.setFieldName("fieldentry.field");
                listFields.add(f);
            }
            if (!hasField.contains(Fa.dot((String[])new String[]{"fieldentry", "fincard1"}))) {
                f = new ListField("fincard1");
                f.setFieldName(Fa.dot((String[])new String[]{"fieldentry", "fincard1"}));
                listFields.add(f);
            }
            super.setListFields(listFields);
        }

        public DynamicObjectCollection getData(int start, int limit) {
            String VOUNCHERNUMBER = "vounchernumber";
            DynamicObjectCollection rows = super.getData(start, limit);
            Map<String, IDataEntityProperty> fieldPropMap = this.getFieldPropMap(rows);
            Map<String, String> valueNameMap = this.getChangeFieldValueNameMap(rows, fieldPropMap);
            ArrayList<DynamicObject> itemClassRows = new ArrayList<DynamicObject>(10);
            HashMap<String, String> itemClassEntityBefMap = new HashMap<String, String>();
            HashMap<String, String> itemClassEntityAftMap = new HashMap<String, String>();
            HashMap<String, String> itemClassTypeNameMap = new HashMap<String, String>();
            for (DynamicObject row : rows) {
                String fieldName;
                DataEntityPropertyCollection propertys = row.getDataEntityType().getProperties();
                if (!propertys.containsKey((Object)"fieldentry.field") || (fieldName = row.getString("fieldentry.field")) == null) continue;
                boolean isFinChange = fieldName.contains("fa_card_fin");
                this.showDepreuse(row);
                IDataEntityProperty prop = fieldPropMap.get(fieldName);
                if (prop == null) continue;
                if (prop instanceof ItemClassProp) {
                    itemClassRows.add(row);
                    continue;
                }
                if (prop instanceof ItemClassTypeProp) {
                    row.set("fieldentry.field", (Object)prop.getDisplayName());
                    String befEntity = row.getString("fieldentry.beforevalue");
                    if (!(ObjectUtils.isEmpty((Object)befEntity) || "0".equals(befEntity) || "null".equals(befEntity))) {
                        itemClassEntityBefMap.put(FaChangeBillListPlugin.genItemClassMapKey(row, prop.getName(), true), befEntity);
                        if (!itemClassTypeNameMap.containsKey(befEntity)) {
                            DynamicObject entityObj = BusinessDataServiceHelper.loadSingleFromCache((Object)befEntity, (String)"bos_entityobject");
                            itemClassTypeNameMap.put(befEntity, entityObj.getString("name"));
                        }
                        row.set("fieldentry.beforevalue", (Object)((String)itemClassTypeNameMap.get(befEntity) + "(" + befEntity + ")"));
                    } else {
                        row.set("fieldentry.beforevalue", null);
                    }
                    String aftEntity = row.getString("fieldentry.aftervalue");
                    if (!(ObjectUtils.isEmpty((Object)aftEntity) || "0".equals(aftEntity) || "null".equals(aftEntity))) {
                        itemClassEntityAftMap.put(FaChangeBillListPlugin.genItemClassMapKey(row, prop.getName(), true), aftEntity);
                        if (!itemClassTypeNameMap.containsKey(aftEntity)) {
                            DynamicObject entityObj = BusinessDataServiceHelper.loadSingle((Object)aftEntity, (String)"bos_entityobject");
                            itemClassTypeNameMap.put(aftEntity, entityObj.getString("name"));
                        }
                        row.set("fieldentry.aftervalue", (Object)((String)itemClassTypeNameMap.get(aftEntity) + "(" + aftEntity + ")"));
                        continue;
                    }
                    row.set("fieldentry.aftervalue", null);
                    continue;
                }
                row.set("fieldentry.field", (Object)prop.getDisplayName());
                row.set("fieldentry.beforevalue", (Object)this.parseValue(row.getString("fieldentry.beforevalue"), prop, row, valueNameMap, isFinChange));
                row.set("fieldentry.aftervalue", (Object)this.parseValue(row.getString("fieldentry.aftervalue"), prop, row, valueNameMap, isFinChange));
            }
            this.handleItemClassRows(itemClassRows, itemClassEntityBefMap, itemClassEntityAftMap);
            return rows;
        }

        private Map<String, IDataEntityProperty> getFieldPropMap(DynamicObjectCollection rows) {
            HashMap<String, IDataEntityProperty> resultMap = new HashMap<String, IDataEntityProperty>(4);
            for (DynamicObject row : rows) {
                IDataEntityProperty prop;
                String fieldName;
                DataEntityPropertyCollection propertys = row.getDataEntityType().getProperties();
                if (!propertys.containsKey((Object)"fieldentry.field") || (fieldName = row.getString("fieldentry.field")) == null || resultMap.containsKey(fieldName) || (prop = this.getProperty(fieldName)) == null) continue;
                resultMap.put(fieldName, prop);
            }
            return resultMap;
        }

        private Map<String, String> getChangeFieldValueNameMap(DynamicObjectCollection rows, Map<String, IDataEntityProperty> fieldPropMap) {
            HashMap changeFieldIdsMap = new HashMap(8);
            HashMap<String, String> nameFieldMap = new HashMap<String, String>(8);
            HashMap<String, String> resultMap = new HashMap<String, String>(8);
            for (DynamicObject row : rows) {
                String afterValue;
                String beforeValue;
                IDataEntityProperty prop;
                String fieldName;
                DataEntityPropertyCollection propertys = row.getDataEntityType().getProperties();
                if (!propertys.containsKey((Object)"fieldentry.field") || (fieldName = row.getString("fieldentry.field")) == null || null == (prop = fieldPropMap.get(fieldName)) || !(prop instanceof BasedataProp)) continue;
                BasedataProp basedataProp = (BasedataProp)prop;
                DynamicObjectType type = basedataProp.getDynamicComplexPropertyType();
                String entityName = type.getName();
                String displayProp = ((RefEntityType)type).getNameProperty();
                nameFieldMap.putIfAbsent(entityName, displayProp);
                HashSet<Long> idSet = (HashSet<Long>)changeFieldIdsMap.get(entityName);
                if (null == idSet) {
                    idSet = new HashSet<Long>(8);
                    changeFieldIdsMap.put(entityName, idSet);
                }
                if (!(ObjectUtils.isEmpty((Object)(beforeValue = row.getString("fieldentry.beforevalue"))) || "0".equals(beforeValue) || "null".equals(beforeValue))) {
                    idSet.add(Long.valueOf(beforeValue));
                }
                if (ObjectUtils.isEmpty((Object)(afterValue = row.getString("fieldentry.aftervalue"))) || "0".equals(afterValue) || "null".equals(afterValue)) continue;
                idSet.add(Long.valueOf(afterValue));
            }
            for (Map.Entry entry : changeFieldIdsMap.entrySet()) {
                DynamicObject[] dynamicObjects;
                String entityName = (String)entry.getKey();
                Set fieldIdSet = (Set)entry.getValue();
                for (DynamicObject data : dynamicObjects = BusinessDataServiceHelper.load((String)entityName, (String)Fa.comma((String[])new String[]{"id", (String)nameFieldMap.get(entityName)}), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)fieldIdSet)})) {
                    String key = entityName.concat("_").concat(data.getString("id"));
                    String value = data.getString((String)nameFieldMap.get(entityName));
                    resultMap.put(key, value);
                }
            }
            return resultMap;
        }

        private void handleItemClassRows(List<DynamicObject> itemClassRows, Map<String, String> itemClassEntityBefMap, Map<String, String> itemClassEntityAftMap) {
            Long fincard;
            Long realcard;
            if (itemClassRows.size() == 0) {
                return;
            }
            HashMap baseDataNameMap = new HashMap(20);
            ArrayList<DynamicObject> typeFromCardRows = new ArrayList<DynamicObject>(20);
            HashSet<Long> realCardIds = new HashSet<Long>();
            HashSet<Long> finCardIds = new HashSet<Long>();
            for (DynamicObject row : itemClassRows) {
                String fieldName = row.getString("fieldentry.field");
                IDataEntityProperty prop = this.getProperty(fieldName);
                if (prop == null) continue;
                ItemClassProp itemClassProp = (ItemClassProp)prop;
                String typePropName = itemClassProp.getTypePropName();
                String key = FaChangeBillListPlugin.genItemClassMapKey(row, typePropName, true);
                String befEntityId = itemClassEntityBefMap.get(key);
                String aftEntityId = itemClassEntityAftMap.get(key);
                if (StringUtils.isEmpty((CharSequence)befEntityId) && StringUtils.isEmpty((CharSequence)aftEntityId)) {
                    typeFromCardRows.add(row);
                    String[] split = fieldName.split("\\.");
                    if ("fa_card_real".equals(split[0])) {
                        realcard = row.getLong("realcard1_id");
                        realCardIds.add(realcard);
                        continue;
                    }
                    fincard = row.getLong("fincard1_id");
                    finCardIds.add(fincard);
                    continue;
                }
                row.set("fieldentry.field", (Object)prop.getDisplayName());
                Long befDataId = row.getLong("fieldentry.beforevalue");
                String befBaseDataName = FaChangeBillListPlugin.getRowBaseDataName(baseDataNameMap, befEntityId, befDataId);
                row.set("fieldentry.beforevalue", (Object)befBaseDataName);
                long aftDataId = row.getLong("fieldentry.aftervalue");
                String aftBaseDataName = FaChangeBillListPlugin.getRowBaseDataName(baseDataNameMap, aftEntityId, aftDataId);
                row.set("fieldentry.aftervalue", (Object)aftBaseDataName);
            }
            Map realCardMap = null;
            if (realCardIds.size() > 0) {
                realCardMap = BusinessDataServiceHelper.loadFromCache((Object[])realCardIds.toArray(new Object[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fa_card_real"));
            }
            Map finCardMap = null;
            if (finCardIds.size() > 0) {
                finCardMap = BusinessDataServiceHelper.loadFromCache((Object[])finCardIds.toArray(new Object[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fa_card_fin"));
            }
            for (DynamicObject row : typeFromCardRows) {
                String fieldName = row.getString("fieldentry.field");
                IDataEntityProperty prop = this.getProperty(fieldName);
                if (prop == null) continue;
                row.set("fieldentry.field", (Object)prop.getDisplayName());
                ItemClassProp itemClassProp = (ItemClassProp)prop;
                String typePropName = itemClassProp.getTypePropName();
                String[] split = fieldName.split("\\.");
                String entityId = null;
                if (realCardMap != null && "fa_card_real".equals(split[0])) {
                    realcard = row.getLong("realcard1_id");
                    entityId = ((DynamicObject)realCardMap.get(realcard)).getString(typePropName);
                } else if (finCardMap != null) {
                    fincard = row.getLong("fincard1_id");
                    entityId = ((DynamicObject)finCardMap.get(fincard)).getString(typePropName);
                }
                if (StringUtils.isEmpty(entityId)) continue;
                Long befDataId = row.getLong("fieldentry.beforevalue");
                String befBaseDataName = FaChangeBillListPlugin.getRowBaseDataName(baseDataNameMap, entityId, befDataId);
                row.set("fieldentry.beforevalue", (Object)befBaseDataName);
                long aftDataId = row.getLong("fieldentry.aftervalue");
                String aftBaseDataName = FaChangeBillListPlugin.getRowBaseDataName(baseDataNameMap, entityId, aftDataId);
                row.set("fieldentry.aftervalue", (Object)aftBaseDataName);
            }
        }

        void showDepreuse(DynamicObject row) {
            String[] fieldArr;
            String fieldName = row.getString("fieldentry.field");
            if (!fieldName.isEmpty() && !(fieldArr = fieldName.split("\\."))[0].equals("fa_card_fin")) {
                row.set("fieldentry.depreuse1", null);
            }
        }

        private String parseValue(String rawValue, IDataEntityProperty prop, DynamicObject row, Map<String, String> valueNameMap, boolean isFinChange) {
            if (prop instanceof BasedataProp) {
                if (ObjectUtils.isEmpty((Object)rawValue) || "0".equals(rawValue) || "null".equals(rawValue)) {
                    return null;
                }
                BasedataProp basedataProp = (BasedataProp)prop;
                DynamicObjectType type = basedataProp.getDynamicComplexPropertyType();
                String entityName = type.getName();
                String key = entityName.concat("_").concat(rawValue);
                return valueNameMap.get(key);
            }
            if (prop instanceof AmountProp) {
                DynamicObject currency = row.getDynamicObject("fieldentry.basecurrency1");
                if (isFinChange) {
                    String currencyFieldName = ((AmountProp)prop).getControlPropName();
                    DynamicObject finCard = row.getDynamicObject(Fa.dot((String[])new String[]{"fieldentry", "fincard1"}));
                    if (finCard != null) {
                        currency = finCard.getDynamicObject(currencyFieldName);
                    }
                }
                int amtprecision = 2;
                String sign = "";
                if (currency != null) {
                    amtprecision = currency.getInt("amtprecision");
                    sign = currency.getString("sign");
                }
                StringBuilder fmtSb = new StringBuilder(",###,##0");
                for (int i = 0; i < amtprecision; ++i) {
                    if (i == 0) {
                        fmtSb.append('.');
                    }
                    fmtSb.append('0');
                }
                DecimalFormat df = new DecimalFormat(fmtSb.toString());
                return sign + df.format(new BigDecimal(rawValue));
            }
            if (prop instanceof BooleanProp) {
                Boolean value = rawValue.equals("1");
                return value != false ? ResManager.loadKDString((String)"\u662f", (String)"FaChangeBillListPlugin_3", (String)"fi-fa-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"FaChangeBillListPlugin_4", (String)"fi-fa-formplugin", (Object[])new Object[0]);
            }
            if ("preusingamount".equals(prop.getName()) && new BigDecimal(rawValue).compareTo(BigDecimal.ZERO) == 0) {
                return null;
            }
            return rawValue;
        }

        private IDataEntityProperty getProperty(String fieldName) {
            String[] split = fieldName.split("\\.");
            DataEntityPropertyCollection props = null;
            if ("fa_card_real".equalsIgnoreCase(split[0])) {
                MainEntityType realType = EntityMetadataCache.getDataEntityType((String)"fa_card_real");
                props = realType.getProperties();
            } else {
                MainEntityType finType = EntityMetadataCache.getDataEntityType((String)"fa_card_fin");
                props = finType.getProperties();
            }
            for (IDataEntityProperty prop : props) {
                if (!split[1].equalsIgnoreCase(prop.getName())) continue;
                return prop;
            }
            return null;
        }
    }
}

