/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.fa.formplugin.FaBaseTreeListPlugin;

public class FaChangeModePlugin
extends FaBaseTreeListPlugin {
    @Override
    public String getBaseName() {
        return "fa_changemode";
    }

    public void initImportData(InitImportDataEventArgs e) {
        super.initImportData(e);
        List sourceData = e.getSourceDataList();
        HashSet<String> parentNumberSet = new HashSet<String>(4);
        for (Map row : sourceData) {
            Map parent = (Map)row.get("parent");
            if (parent == null) continue;
            String number = (String)parent.get("number");
            parentNumberSet.add(number);
        }
        DynamicObject[] parents = BusinessDataServiceHelper.load((String)"fa_changemode", (String)"number,type", (QFilter[])new QFilter[]{new QFilter("number", "in", parentNumberSet), new QFilter("enable", "=", (Object)"1")});
        Map<String, DynamicObject> parentChangeModeMap = Arrays.stream(parents).collect(Collectors.toMap(m -> m.getString("number"), m -> m));
        for (Map row : sourceData) {
            String parentNumber;
            Map parent = (Map)row.get("parent");
            if (parent == null || parentChangeModeMap.containsKey(parentNumber = (String)parent.get("number"))) continue;
            String number = (String)row.get("number");
            String type = (String)row.get("type");
            MainEntityType dType = EntityMetadataCache.getDataEntityType((String)"fa_changemode");
            DynamicObject addRow = new DynamicObject((DynamicObjectType)dType);
            addRow.set("number", (Object)number);
            addRow.set("type", (Object)type);
            parentChangeModeMap.put(parentNumber, addRow);
        }
        int index = -1;
        for (Map row : sourceData) {
            ++index;
            Map parent = (Map)row.get("parent");
            if (parent == null) continue;
            String parentNumber = (String)parent.get("number");
            DynamicObject parentMode = parentChangeModeMap.get(parentNumber);
            if (parentMode == null) {
                e.addCancelMessage(Integer.valueOf(index), Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u4e0a\u7ea7\u4e0d\u5b58\u5728\u6216\u88ab\u7981\u7528\u3002", (String)"FaChangeModePlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                continue;
            }
            String parentType = parentMode.getString("type");
            String type = (String)row.get("type");
            if (type.equals(parentType)) continue;
            e.addCancelMessage(Integer.valueOf(index), Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u589e\u51cf\u7c7b\u578b\u4e0e\u4e0a\u7ea7\u4e0d\u4e00\u81f4\u3002", (String)"FaChangeModePlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        Map sourceData = e.getSourceData();
        BillModel model = (BillModel)this.getModel();
        String type = model.getDataEntity().getString("type");
        if (type == null) {
            model.setValue("type", sourceData.get("type"));
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.getQFilters().add(new QFilter("id", "!=", (Object)21));
    }
}

