/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.basedataref.BaseDataCheckRefrence;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.TransferContainer;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.validator.changeitem.ChangeItemSelectValidator;

public class FaChangeTypeEditPlugin
extends AbstractBillPlugIn {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        TransferContainer transfer = (TransferContainer)this.getControl("transfercontainerap");
        HashMap<String, ArrayList<Object>> source = new HashMap<String, ArrayList<Object>>();
        HashMap target = new HashMap();
        ArrayList<Object> sourceData = new ArrayList<Object>();
        ArrayList<String> targetData = new ArrayList<String>();
        this.getSourceDate(sourceData);
        DynamicObjectCollection changetypeEntrys = model.getEntryEntity("changetypeentry");
        for (DynamicObject changetypeEntry : changetypeEntrys) {
            targetData.add(String.valueOf(changetypeEntry.getLong("changeitem.id")));
        }
        source.put("data", sourceData);
        target.put("selected", targetData);
        transfer.setTransferListData(source, target);
        if (((Boolean)model.getValue("issystem")).booleanValue()) {
            view.setEnable(Boolean.valueOf(false), new String[]{"buttonsave"});
        }
    }

    private void getSourceDate(List<Object> sourceData) {
        QFilter status = new QFilter("status", "=", (Object)BillStatus.C.toString());
        QFilter qRealaccountdate = new QFilter("number", "not in", (Object)new String[]{"realaccountdate", "usestatus", "depredamount"});
        QFilter qTopic = new QFilter("topic", "in", (Object)new String[]{"fa_card_real", "fa_card_fin"});
        DynamicObjectCollection changeItems = QueryServiceHelper.query((String)"fa_change_item", (String)"id,number,name,topic", (QFilter[])new QFilter[]{status, qRealaccountdate, qTopic});
        for (DynamicObject changeItem : changeItems) {
            HashMap<String, String> item = new HashMap<String, String>();
            item.put("id", changeItem.getString("id"));
            String topic = changeItem.getString("topic");
            String topicName = this.getChangeTopicName(topic);
            String name = changeItem.getString("name");
            if (ChangeItemSelectValidator.isDepreChangeItem((DynamicObject)changeItem)) {
                item.put("text", String.format(ResManager.loadKDString((String)"%s\uff08\u5f71\u54cd\u6298\u65e7\uff09", (String)"FaChangeTypeEditPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]), topicName + "-" + name));
            } else {
                item.put("text", topicName + "-" + name);
            }
            item.put("name", name);
            item.put("topic", topic);
            sourceData.add(item);
        }
    }

    private String getChangeTopicName(String topic) {
        if ("fa_card_real".equalsIgnoreCase(topic)) {
            return ResManager.loadKDString((String)"\u5b9e\u7269\u5361\u7247", (String)"FaChangeTypeEditPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]);
        }
        if ("fa_card_fin".equalsIgnoreCase(topic)) {
            return ResManager.loadKDString((String)"\u8d22\u52a1\u5361\u7247", (String)"FaChangeTypeEditPlugin_2", (String)"fi-fa-formplugin", (Object[])new Object[0]);
        }
        if ("fa_lease_contract".equalsIgnoreCase(topic)) {
            return ResManager.loadKDString((String)"\u79df\u8d41\u5408\u540c", (String)"FaChangeTypeEditPlugin_3", (String)"fi-fa-formplugin", (Object[])new Object[0]);
        }
        return "";
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"buttonsave"});
        this.addClickListeners(new String[]{"transfercontainerap"});
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        Control c = (Control)evt.getSource();
        if (c.getKey().equals("buttonsave")) {
            DynamicObjectCollection changetypeEntrys;
            TransferContainer transfer = (TransferContainer)this.getControl("transfercontainerap");
            List selectDatas = transfer.getSelectedData();
            BaseDataCheckRefrence checker = new BaseDataCheckRefrence();
            boolean referenced = checker.isRefrenced((BasedataEntityType)EntityMetadataCache.getDataEntityType((String)"fa_change_type"), model.getValue("id"));
            if (referenced && !model.getValue("id").toString().equals("0")) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u88ab\u5f15\u7528\u4e0d\u80fd\u4fee\u6539\u3002", (String)"FaChangeTypeEditPlugin_4", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            }
            String effectScope = model.getValue("eft_scope").toString();
            if (effectScope.contains("A") && effectScope.contains("B")) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8d39\u7528\u5316\u8d44\u4ea7\u4e0d\u53ef\u4ee5\u548c\u975e\u8d39\u7528\u5316\u8d44\u4ea7\u6216\u79df\u8d41\u5408\u540c\u540c\u65f6\u52fe\u9009\u3002", (String)"FaChangeTypeEditPlugin_5", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            }
            if (effectScope.contains("C") && effectScope.contains("B")) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8d39\u7528\u5316\u8d44\u4ea7\u4e0d\u53ef\u4ee5\u548c\u975e\u8d39\u7528\u5316\u8d44\u4ea7\u6216\u79df\u8d41\u5408\u540c\u540c\u65f6\u52fe\u9009\u3002", (String)"FaChangeTypeEditPlugin_5", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            }
            ArrayList<Long> numbers = new ArrayList<Long>();
            if (selectDatas != null) {
                for (Object selectData : selectDatas) {
                    Map target = (Map)selectData;
                    numbers.add(Long.valueOf(target.get("id").toString()));
                }
            }
            if (selectDatas != null) {
                model.deleteEntryData("changetypeentry");
            }
            ArrayList<Long> selChangeIds = new ArrayList<Long>();
            if (numbers.size() > 0) {
                QFilter numbersQ = new QFilter("id", "in", numbers);
                DynamicObjectCollection selChangeItems = QueryServiceHelper.query((String)"fa_change_item", (String)"id", (QFilter[])new QFilter[]{numbersQ});
                for (DynamicObject selChangeItem : selChangeItems) {
                    int rowindex = model.createNewEntryRow("changetypeentry");
                    long setChangeId = selChangeItem.getLong("id");
                    model.setValue("changeitem", (Object)setChangeId, rowindex);
                    selChangeIds.add(setChangeId);
                }
            }
            if ((changetypeEntrys = model.getEntryEntity("changetypeentry")) == null || changetypeEntrys.size() < 1) {
                model.setDataChanged(false);
                throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u9009\u62e9\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FaChangeTypeEditPlugin_6", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            }
            int selChangeSize = selChangeIds.size();
            if (selChangeSize > 0) {
                QFilter seChangeQ = new QFilter("changetypeentry.changeitem", "in", selChangeIds);
                QFilter enableQ = new QFilter("enable", "=", (Object)Boolean.TRUE);
                DynamicObjectCollection selChangeItems = QueryServiceHelper.query((String)"fa_change_type", (String)"id,changetypeentry.changeitem", (QFilter[])new QFilter[]{seChangeQ, enableQ});
                Map<Object, List<DynamicObject>> collect = selChangeItems.stream().collect(Collectors.groupingBy(t -> t.getLong("id")));
                collect.forEach((k, v) -> {
                    if (v.size() == selChangeSize) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u53ef\u53d8\u66f4\u9879\u76ee\u7ec4\u5408\u7684\u53d8\u66f4\u7c7b\u578b\u3002", (String)"FaChangeTypeEditPlugin_7", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                    }
                });
            }
            if (effectScope.contains("A") && effectScope.contains("C")) {
                DynamicObjectCollection changeitems = (DynamicObjectCollection)model.getValue("changetypeentry");
                QFilter mQ = new QFilter("leasechgitem", "in", selChangeIds);
                DynamicObjectCollection chgMapCollection = QueryServiceHelper.query((String)"fa_change_map", (String)"id,leasechgitem,cardchgitem", (QFilter[])new QFilter[]{mQ});
                Map<Long, List<DynamicObject>> changeMap = chgMapCollection.stream().collect(Collectors.groupingBy(t -> t.getLong("leasechgitem")));
                for (DynamicObject entry : changeitems) {
                    DynamicObject item = entry.getDynamicObject("changeitem");
                    if (changeMap.containsKey(item.getLong("id"))) continue;
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53ef\u53d8\u66f4\u9879\u76ee%s\u672a\u7ef4\u62a4\u79df\u8d41\u53d8\u66f4\u548c\u8d44\u4ea7\u53d8\u66f4\u7684\u6620\u5c04\u5173\u7cfb\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"FaChangeTypeEditPlugin_8", (String)"fi-fa-formplugin", (Object[])new Object[0]), item.getString("name")));
                }
            }
        }
    }
}

