/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mutex.impl.MutexLockInfo;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.fa.business.SourceFlagEnum;
import kd.fi.fa.business.enums.AssetCatApplyTypeEnum;
import kd.fi.fa.business.utils.FaPermissionUtils;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.formplugin.importhandler.RealCardImportHandler;
import kd.fi.fa.utils.FaBillImportOrgCheckUtil;
import kd.fi.fa.utils.FaF7CostCenterUtils;
import kd.fi.fa.utils.FaF7DeptUtils;
import kd.fi.fa.utils.FaFormPermissionUtil;

public class FaCurCardRealEditPlugin
extends AbstractFormPlugin {
    private static final String EXIST_1 = "1";
    private static final String ORIGINMETHOD = "originmethod";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"device_toolbarap", "barmodify", "barmodifyrecord"});
        boolean mergedCard = (Boolean)this.getModel().getValue("mergedcard");
        String billName = this.getModel().getDataEntityType().getName();
        OrgEdit orgF7 = (OrgEdit)this.getControl("org");
        orgF7.setIsOnlyDisplayOrgLeaves(true);
        BasedataEdit inCostCenter = (BasedataEdit)this.getControl("costcentrer");
        if (!mergedCard) {
            orgF7.addBeforeF7SelectListener(listener -> FaF7DeptUtils.orgDelegateAssetUnit(listener, this.getModel()));
        } else {
            if (billName.equals("fa_asset_initcard")) {
                orgF7.addBeforeF7SelectListener(v -> FaPermissionUtils.getAllBookAndPermissionOrgsV2((String)this.getView().getPageId(), (String)"fa_asset_initcard"));
            }
            if (billName.equals("fa_asset_card")) {
                orgF7.addBeforeF7SelectListener(v -> FaFormPermissionUtil.beforeOrgSelectV2(this.getView().getPageId(), v, "fa_asset_card"));
            }
        }
        OrgEdit assetUnitEdit = (OrgEdit)this.getControl("assetunit");
        assetUnitEdit.setIsOnlyDisplayOrgLeaves(true);
        if (!mergedCard) {
            assetUnitEdit.addBeforeF7SelectListener(evt -> FaFormPermissionUtil.beforeAssetUnitSelect(evt, "fa_card_real"));
        } else {
            assetUnitEdit.addBeforeF7SelectListener(this::assetUnitF7);
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        BasedataEdit deptF7 = (BasedataEdit)this.getControl("headusedept");
        DynamicObject assetUnit = (DynamicObject)this.getModel().getValue("assetunit");
        deptF7.addBeforeF7SelectListener(evt -> FaF7DeptUtils.beforeDeptSelect(evt, org, assetUnit));
        inCostCenter.addBeforeF7SelectListener(evt -> FaF7CostCenterUtils.beforeCostCenterSelect(evt, org));
        BasedataEdit assetCategoryF7 = (BasedataEdit)this.getControl("assetcat");
        assetCategoryF7.addBeforeF7SelectListener(this::assetCatF7);
    }

    private void assetCatF7(BeforeF7SelectEvent event) {
        String sourceFlag = String.valueOf(this.getModel().getValue("sourceflag"));
        if (SourceFlagEnum.DATAASSET.name().equals(sourceFlag)) {
            QFilter qFilter = new QFilter("applytype", "=", (Object)AssetCatApplyTypeEnum.DATA.getValue());
            List filters = ((ListShowParameter)event.getFormShowParameter()).getListFilterParameter().getQFilters();
            filters.add(qFilter);
        }
    }

    public void afterCreateNewData(EventObject arg0) {
        List<Long> assetUnitIdList;
        DynamicObject assetUnit;
        IDataModel model = this.getModel();
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (this.getView() == null || parentView == null) {
            return;
        }
        Object isChangingMainOrg = this.getModel().getContextVariable("isChangingMainOrg");
        if (isChangingMainOrg == null && parentView.toString().indexOf("FormView-fa_mainpage_grid") == 0) {
            List assetUnits = FaPermissionUtils.getAllPermissionAsseUnitsV2((String)this.getView().getPageId(), (String)"fa_card_real");
            Long org = FaPermissionUtils.getDefaultAcctOrg((List)assetUnits);
            this.getModel().setValue("assetunit", (Object)org);
            this.getModel().setValue("org", (Object)org);
        }
        if ((assetUnit = (DynamicObject)model.getValue("assetunit")) == null && (assetUnitIdList = this.getAssetUnitByOrg()) != null && !assetUnitIdList.isEmpty()) {
            long orgId = (Long)this.getModel().getValue(Fa.id((String)"org"));
            if (assetUnitIdList.contains(orgId)) {
                model.setValue("assetunit", (Object)orgId);
            } else {
                model.setValue("assetunit", (Object)assetUnitIdList.get(0));
            }
        }
        if ("newjustrealcard".equals(parentView.getPageCache().get("newjustrealcard"))) {
            this.getModel().setValue("justrealcard", (Object)true);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"justrealcard"});
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        new RealCardImportHandler().handleImport((BillModel)this.getModel());
    }

    public void afterBindData(EventObject e) {
        String copySourceFlag;
        super.afterBindData(e);
        IDataModel model = this.getModel();
        String showsuccess = (String)this.getView().getFormShowParameter().getCustomParam("showsuccess");
        if (null != showsuccess) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"FaCurCardRealEditPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        if (StringUtils.isNotEmpty((String)(copySourceFlag = (String)this.getView().getFormShowParameter().getCustomParam("sourceFlag")))) {
            this.getModel().setValue("sourceflag", (Object)copySourceFlag);
            if (SourceFlagEnum.SCAN.name().equals(copySourceFlag)) {
                this.getModel().setValue("headuseperson", null);
            }
        }
        if (this.getModel().getValue("org") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"FaCurCardRealEditPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            return;
        }
        Object sourceFlag = model.getValue("sourceflag");
        if (SourceFlagEnum.INITLEASECONTRACT.name().equals(sourceFlag) || SourceFlagEnum.LEASECONTRACT.name().equals(sourceFlag)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"assetcat", "assetname", "assetamount", "unit", "supplier", "storeplace"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"assetcat", "assetname", "assetamount", "unit", "supplier", "storeplace"});
        }
    }

    public void initImportData(InitImportDataEventArgs e) {
        List dataList = e.getSourceDataList();
        if (dataList != null && dataList.size() > 0) {
            dataList.forEach(dataObject -> {
                QFilter filter;
                DynamicObject assetCategory;
                JSONObject data = new JSONObject(dataObject);
                Map assetCategoryJsonObject = (Map)dataObject.get("assetcat");
                String assetCategoryId = (String)assetCategoryJsonObject.get(assetCategoryJsonObject.get("importprop"));
                if ((data.getString("unit") == null || StringUtils.isEmpty((String)data.getString("unit"))) && assetCategoryId != null && (assetCategory = QueryServiceHelper.queryOne((String)"fa_assetcategory", (String)"unit", (QFilter[])new QFilter[]{filter = new QFilter("number", "=", (Object)assetCategoryId)})) != null) {
                    String unitName;
                    QFilter idFilter = new QFilter("id", "=", (Object)assetCategory.getLong("unit"));
                    DynamicObject unitDynamicObject = QueryServiceHelper.queryOne((String)"bd_measureunits", (String)"number,id,name", (QFilter[])new QFilter[]{idFilter});
                    HashMap unitMap = (HashMap)data.get((Object)"unit");
                    String unitValue = unitDynamicObject == null ? null : unitDynamicObject.getString("number");
                    String string = unitName = unitDynamicObject == null ? null : unitDynamicObject.getString("name");
                    if (unitMap == null) {
                        unitMap = new JSONObject();
                        unitMap.put("importprop", "number");
                        unitMap.put("number", unitValue);
                        unitMap.put("name", unitName);
                        data.put("unit", (Object)unitMap);
                    } else {
                        unitMap.put("number", unitValue);
                        unitMap.put("name", unitName);
                    }
                }
            });
        }
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"justrealcard"});
        FaBillImportOrgCheckUtil.checkOrgPermission(this.getView().getPageId(), e, "fa_card_real", "assetunit", "09");
        FaBillImportOrgCheckUtil.checkOrgPermission(this.getView().getPageId(), e, "fa_card_real", "org", "10");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataModel thisModel = this.getModel();
        DynamicObject dynamicObject = thisModel.getDataEntity();
        String propName = e.getProperty().getName();
        if ("assetcat".equalsIgnoreCase(propName)) {
            DynamicObject assetCategory = dynamicObject.getDynamicObject("assetcat");
            String parentFormId = this.getView().getFormShowParameter().getParentFormId();
            if (assetCategory != null && "fa_mainpage_grid".equals(parentFormId)) {
                thisModel.setValue("unit", assetCategory.getDynamicObject("unit") == null ? null : assetCategory.getDynamicObject("unit").getPkValue());
            }
        } else if ("isfacility".equalsIgnoreCase(propName)) {
            if (thisModel.getValue("numberruleexist").toString().equals(EXIST_1)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"facilitynumber"});
            }
            if (thisModel.getValue("barcoderuleexist").toString().equals(EXIST_1)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"facilitybarcode"});
            }
        }
        if ("headuseperson".equals(propName) && !ObjectUtils.isEmpty((Object)this.getModel().getValue("headuseperson")) && ObjectUtils.isEmpty((Object)this.getModel().getValue("headusedept"))) {
            DynamicObject usePerson = (DynamicObject)this.getModel().getValue("headuseperson");
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            Long assetUnitId = ((DynamicObject)this.getModel().getValue("assetunit")).getLong("id");
            FaF7DeptUtils.getUseDeptByUsePerson(this.getModel(), usePerson, org, "headusedept", assetUnitId);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("barmodifyrecord".equals(itemKey)) {
            boolean havePerm = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)this.getView().getFormShowParameter().getAppId(), (String)this.getView().getEntityId(), (String)"3N2S/ET0A=/T");
            if (!havePerm) {
                return;
            }
            ListShowParameter param = new ListShowParameter();
            param.setBillFormId("fa_additiondevrecord");
            param.setShowFilter(false);
            param.setLookUp(true);
            param.setShowTitle(false);
            param.setShowQuickFilter(false);
            param.setMultiSelect(false);
            param.getOpenStyle().setShowType(ShowType.Modal);
            StyleCss css = new StyleCss();
            css.setWidth("1024px");
            css.setHeight("580px");
            param.getOpenStyle().setInlineStyleCss(css);
            Object masterid = this.getModel().getValue("masterid");
            param.getListFilterParameter().getQFilters().add(new QFilter("realcard", "=", masterid));
            this.getView().showForm((FormShowParameter)param);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (!"modifydev".equals(operateKey)) return;
        OperationResult opResult = args.getOperationResult();
        if (opResult.isSuccess()) {
            StringBuilder msg = new StringBuilder(16);
            Object masterid = this.getModel().getValue("masterid");
            String number = (String)this.getModel().getValue("number");
            MutexLockInfo lock = new MutexLockInfo("mdf" + masterid.toString(), number, "default_netctrl", "fa_additiondevrecord", "modifydev", true, "modifydev");
            boolean require = MutexHelper.require((MutexLockInfo)lock, (StringBuilder)msg);
            if (!require) throw new KDBizException(msg.toString());
            DynamicObjectCollection advs = this.getModel().getDataEntity(true).getDynamicObjectCollection("facility_entry");
            FormShowParameter param = new FormShowParameter();
            param.setFormId("fa_additiondevrecord");
            param.getOpenStyle().setShowType(ShowType.Modal);
            param.setStatus(OperationStatus.ADDNEW);
            param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "modifydev"));
            param.setCustomParam("entry", (Object)advs);
            param.setCustomParam("realcard", this.getModel().getValue("masterid"));
            String mainOrgKey = this.getModel().getDataEntityType().getMainOrg();
            param.setCustomParam("org", this.getModel().getValue(mainOrgKey + "_id"));
            this.getView().showForm(param);
            return;
        } else {
            List errorMsgs = opResult.getAllErrorOrValidateInfo().stream().map(IOperateInfo::getMessage).collect(Collectors.toList());
            throw new KDBizException(String.join((CharSequence)";", errorMsgs));
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Object returnData;
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if ("modifydev".equals(actionId) && "success".equals(returnData = evt.getReturnData())) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void assetUnitF7(BeforeF7SelectEvent event) {
        List<Long> toOrgIdList = this.getAssetUnitByOrg();
        ListShowParameter params = (ListShowParameter)event.getFormShowParameter();
        params.getListFilterParameter().getQFilters().add(new QFilter("id", "in", toOrgIdList));
    }

    private List<Long> getAssetUnitByOrg() {
        long orgId = (Long)this.getModel().getValue(Fa.id((String)"org"));
        return OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"09", (Long)orgId, (boolean)true);
    }
}

