/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.validate.BillStatus;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.fi.fa.business.dao.factory.FaAssetBookDaoFactory;
import kd.fi.fa.business.utils.FaAssetBookDataUpgradeLogUtils;
import kd.fi.fa.common.util.Tuple;

public class FaDepreEditCheckPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(FaDepreEditCheckPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"flexpanelapneedadp"});
        this.addClickListeners(new String[]{"btneedaddmerged"});
        this.addClickListeners(new String[]{"flexpanelapneedcleap"});
        this.addClickListeners(new String[]{"flexpanelapneedchangedepp"});
        this.addClickListeners(new String[]{"flexpanelapneedsplip"});
        this.addClickListeners(new String[]{"flexpanelapneeddevap"});
        this.addClickListeners(new String[]{"flexpanelapneedadjusmenp"});
        this.addClickListeners(new String[]{"flexpanelapneedworkloap"});
        this.addClickListeners(new String[]{"flexpanelapneedvouchep"});
        this.addClickListeners(new String[]{"buttonsubmit"});
        this.addClickListeners(new String[]{"flexpanelapneedmergep"});
        this.addClickListeners(new String[]{"flexpanelapneedauditcardp"});
        this.addClickListeners(new String[]{"flexpanelapneedrestartp"});
    }

    public void afterCreateNewData(EventObject e) {
        Map map = this.getView().getFormShowParameter().getCustomParams();
        Object asssetbookId = map.get("asssetbookId");
        Object curperiodId = map.get("curperiodId");
        Object ordId = map.get("ordId");
        Object depreuseId = map.get("depreuseId");
        Object cacheDepreCheck = map.get("cacheDepreCheck");
        if (asssetbookId == null || curperiodId == null || cacheDepreCheck == null) {
            return;
        }
        Map param = (Map)SerializationUtils.fromJsonString((String)String.valueOf(cacheDepreCheck), Map.class);
        List unAuditCards = (List)param.get("unAuditCards");
        List unAuditMergedCards = (List)param.get("unAuditMergedCards");
        List clearObjects = (List)param.get("clearObjects");
        List useDeptChangeObjects = (List)param.get("useDeptChangeObjects");
        List devalsObjects = (List)param.get("devalsObjects");
        List splitObjects = (List)param.get("splitObjects");
        List workLoadObjects = (List)param.get("workLoadObjects");
        List mergeObjects = (List)param.get("mergeObjects");
        List unAuditRealCards = (List)param.get("unAuditRealCards");
        List unAuditRestartBills = param.get("unAuditRestartBills") == null ? new ArrayList() : (List)param.get("unAuditRestartBills");
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelapneedadd"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelapneedasset"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelapneedclear"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelapneedchangedept"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelapneeddeval"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelapneedadjusment"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelapneedworkload"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelapneedvoucher"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelapneedsplit"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelapneedmerge"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelapneedauditcard"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelapneedrestart"});
        HashMap flexDeals = new HashMap();
        if (unAuditCards.size() > 0) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelapneedadd"});
            flexDeals.put("flexpanelapneedadp", unAuditCards);
        }
        if (CollectionUtils.isNotEmpty((Collection)unAuditMergedCards)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelapneedasset"});
            flexDeals.put("btneedaddmerged", unAuditMergedCards);
        }
        if (clearObjects.size() > 0) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelapneedclear"});
            flexDeals.put("flexpanelapneedcleap", clearObjects);
        }
        if (useDeptChangeObjects.size() > 0) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelapneedchangedept"});
            flexDeals.put("flexpanelapneedchangedepp", useDeptChangeObjects);
        }
        if (devalsObjects.size() > 0) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelapneeddeval"});
            flexDeals.put("flexpanelapneeddevap", devalsObjects);
        }
        if (splitObjects.size() > 0) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelapneedsplit"});
            flexDeals.put("flexpanelapneedsplip", splitObjects);
        }
        if (workLoadObjects.size() > 0) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelapneedworkload"});
            flexDeals.put("flexpanelapneedworkloap", workLoadObjects);
        }
        if (mergeObjects.size() > 0) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelapneedmerge"});
            flexDeals.put("flexpanelapneedmergep", mergeObjects);
        }
        if (!unAuditRealCards.isEmpty()) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelapneedauditcard"});
            flexDeals.put("flexpanelapneedauditcardp", unAuditRealCards);
        }
        if (!unAuditRestartBills.isEmpty()) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelapneedrestart"});
            flexDeals.put("flexpanelapneedrestartp", unAuditRestartBills);
        }
        this.getPageCache().put("flexDeals", SerializationUtils.toJsonString(flexDeals));
        this.getPageCache().put("asssetbookId", String.valueOf(asssetbookId));
        this.getPageCache().put("curperiodId", String.valueOf(curperiodId));
        this.getPageCache().put("ordId", String.valueOf(ordId));
        this.getPageCache().put("depreuseId", String.valueOf(depreuseId));
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String fieldName = control.getKey();
        Map flexDeals = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("flexDeals"), Map.class);
        Long asssetbookId = Long.parseLong(this.getPageCache().get("asssetbookId"));
        Long curperiodId = Long.parseLong(this.getPageCache().get("curperiodId"));
        Long ordId = Long.parseLong(this.getPageCache().get("ordId"));
        Long depreuseId = Long.parseLong(this.getPageCache().get("depreuseId"));
        DynamicObject bookObj = FaAssetBookDaoFactory.getInstance().queryOne((Object)asssetbookId);
        DynamicObject currentPeriod = bookObj.getDynamicObject("curperiod");
        Date beginDate = currentPeriod.getDate("begindate");
        Date endDate = currentPeriod.getDate("enddate");
        Tuple<String, QFilter> tuple = this.jumpToPage(fieldName, curperiodId, ordId, depreuseId, beginDate, endDate);
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)tuple.item1))) {
            this.jumpAndCallback(flexDeals, fieldName, (String)tuple.item1, (QFilter)tuple.item2);
        }
    }

    public Tuple<String, QFilter> jumpToPage(String fieldName, Long curperiodId, Long ordId, Long depreuseId, Date beginDate, Date endDate) {
        QFilter filter = new QFilter("org", "=", (Object)ordId);
        filter = filter.and(new QFilter("billstatus", "!=", (Object)"C"));
        String toPage = null;
        if (fieldName.equals("flexpanelapneedadp")) {
            filter.and(new QFilter("finaccountdate", ">=", (Object)beginDate));
            filter.and(new QFilter("finaccountdate", "<=", (Object)endDate));
            filter.and(new QFilter("depreuse", "=", (Object)depreuseId));
            filter.and(new QFilter("realcard.mergedcard", "=", (Object)false));
            boolean enableCurPeriodSplit = FaAssetBookDataUpgradeLogUtils.enableCurPeriodSplit((Long)ordId);
            if (enableCurPeriodSplit) {
                filter.and(new QFilter("originaldata", "=", (Object)true));
            }
            toPage = "fa_card_fin";
        } else {
            if (fieldName.equals("btneedaddmerged")) {
                QFilter mergedFilter = new QFilter("org", "=", (Object)ordId);
                mergedFilter.and(new QFilter("isbak", "=", (Object)false));
                mergedFilter.and(new QFilter("mergedcard", "=", (Object)true));
                mergedFilter.and(new QFilter("finentry.fincard.finaccountdate", ">=", (Object)beginDate));
                mergedFilter.and(new QFilter("finentry.fincard.finaccountdate", "<=", (Object)endDate));
                mergedFilter.and(new QFilter("finentry.fincard.depreuse", "=", (Object)depreuseId));
                mergedFilter.and(new QFilter("finentry.fincard.billstatus", "!=", (Object)"C"));
                toPage = "fa_asset_card";
                return new Tuple((Object)toPage, (Object)mergedFilter);
            }
            if (fieldName.equals("flexpanelapneedcleap")) {
                filter.and(new QFilter("cleardate", ">=", (Object)beginDate));
                filter.and(new QFilter("cleardate", "<=", (Object)endDate));
                toPage = "fa_clearbill";
            } else if (fieldName.equals("flexpanelapneedchangedepp")) {
                filter.and(new QFilter("changedate", ">=", (Object)beginDate));
                filter.and(new QFilter("changedate", "<=", (Object)endDate));
                toPage = "fa_change_dept";
            } else if (fieldName.equals("flexpanelapneedsplip")) {
                filter.and(new QFilter("splitdate", ">=", (Object)beginDate));
                filter.and(new QFilter("splitdate", "<=", (Object)endDate));
                toPage = "fa_assetsplitbill";
            } else if (fieldName.equals("flexpanelapneeddevap")) {
                toPage = "fa_asset_devalue";
            } else if (fieldName.equals("flexpanelapneedadjusmenp")) {
                QFilter filterJust = new QFilter("org", "=", (Object)ordId);
                filterJust.and(new QFilter("depreuse", "=", (Object)depreuseId));
                filterJust.and(new QFilter("period", "=", (Object)curperiodId));
                filter = filterJust;
                toPage = "fa_depreadjustbill";
            } else if (fieldName.equals("flexpanelapneedworkloap")) {
                QFilter filterJust = new QFilter("org", "=", (Object)ordId);
                filterJust.and(new QFilter("depreuse", "=", (Object)depreuseId));
                filterJust.and(new QFilter("period", "=", (Object)curperiodId));
                filterJust.and(new QFilter("billstatus", "=", (Object)BillStatus.A));
                filter = filterJust;
                toPage = "fa_workload";
            } else if (fieldName.equals("flexpanelapneedvouchep")) {
                filter.and(new QFilter("depreuse", "=", (Object)depreuseId));
                filter.and(new QFilter("period", "=", (Object)curperiodId));
                toPage = "fa_depre_sum";
            } else if (fieldName.equals("buttonsubmit")) {
                this.getView().returnDataToParent((Object)"depreAgain");
                this.getView().close();
            } else if (fieldName.equals("flexpanelapneedmergep")) {
                filter.and(new QFilter("mergedate", ">=", (Object)beginDate));
                filter.and(new QFilter("mergedate", "<=", (Object)endDate));
                toPage = "fa_mergebill";
            } else if (fieldName.equals("flexpanelapneedauditcardp")) {
                toPage = "fa_card_real";
            } else if (fieldName.equals("flexpanelapneedrestartp")) {
                filter.and("restartdate", ">=", (Object)beginDate);
                filter.and("restartdate", "<=", (Object)endDate);
                toPage = "fa_restartrealbill";
            }
        }
        return new Tuple((Object)toPage, (Object)filter);
    }

    private void jumpAndCallback(Map<String, List<Object>> flexDeals, String flex, String pageId, QFilter filter) {
        List<Object> ids = flexDeals.get(flex);
        if (ids == null) {
            if (flex.equals("flexpanelapneedvouchep")) {
                HashMap<String, String> resultMap = new HashMap<String, String>();
                resultMap.put("filter", filter.toSerializedString());
                resultMap.put("pageId", pageId);
                this.getView().returnDataToParent(resultMap);
            }
        } else {
            HashMap<String, String> resultMap = new HashMap<String, String>();
            resultMap.put("filter", filter.and(new QFilter("id", "in", ids)).toSerializedString());
            resultMap.put("pageId", pageId);
            this.getView().returnDataToParent(resultMap);
        }
        this.getView().close();
    }
}

