/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin;

import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.depreciation.DepreBook;
import kd.fi.fa.business.utils.FaCommonUtils;
import kd.fi.fa.common.util.Fa;
import net.sf.json.JSONObject;

public class FaDepreHelpFormPlugin
extends AbstractFormPlugin {
    public static final String TAB = "        ";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        BasedataEdit periodF7 = (BasedataEdit)this.getControl("period");
        periodF7.addBeforeF7SelectListener(event -> {
            IDataModel model = this.getModel();
            DynamicObject book = (DynamicObject)model.getValue("assetbook");
            QFilter filter = new QFilter("periodtype", "=", book.get("periodtype_id"));
            filter = filter.and("id", ">=", book.get("startperiod_id"));
            ListShowParameter listShowp = (ListShowParameter)event.getFormShowParameter();
            ListFilterParameter listFilterParameter = listShowp.getListFilterParameter();
            listFilterParameter.getQFilters().add(filter);
        });
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propname = e.getProperty().getName();
        if ("period".equals(propname)) {
            this.updateDeprelogCache();
        }
    }

    private void updateDeprelogCache() {
        IDataModel model = this.getModel();
        DynamicObject book = (DynamicObject)model.getValue("assetbook");
        book = BusinessDataServiceHelper.loadSingle((Object)book.getPkValue(), (String)"fa_assetbook");
        DynamicObject period = (DynamicObject)model.getValue("period");
        Object curPeriodId = period.get("id");
        period = BusinessDataServiceHelper.loadSingleFromCache((Object)curPeriodId, (String)"bd_period");
        book.set("curperiod", (Object)period);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.containsKey("data")) {
            Map data = (Map)customParams.get("data");
            HashSet masterIdSet = new HashSet((List)data.get("masterids"));
            DepreBook depreBook = new DepreBook(book);
            depreBook.setAnalyzeMode();
            QFilter periodFilter = new QFilter("bizperiod.id", "<=", curPeriodId).and("endperiod.id", ">", curPeriodId);
            boolean predictAccumDepre = false;
            if (model.getValue("endperiod") != null) {
                DynamicObject depreEndPeriod = (DynamicObject)model.getValue("endperiod");
                Date predictEndDate = depreEndPeriod.getDate("enddate");
                depreBook.setDepreEndDate(predictEndDate);
                predictAccumDepre = true;
                String exp = "%s > ? and %s <= ? and %s = %s";
                exp = String.format(exp, "bizperiod", "realcard.realaccountdate", "bizperiod", "period");
                periodFilter = periodFilter.or(QFilter.of((String)exp, (Object[])new Object[]{curPeriodId, predictEndDate}));
            }
            DynamicObjectCollection fincards = QueryServiceHelper.query((String)"fa_card_fin", (String)"id", (QFilter[])new QFilter[]{new QFilter("assetbook.id", "=", book.get("id")), new QFilter("realcard.masterid", "in", masterIdSet), periodFilter});
            Set finCardIdSet = fincards.stream().map(v -> v.getLong("id")).collect(Collectors.toSet());
            if (predictAccumDepre) {
                depreBook.predictAccumDepre(finCardIdSet);
            } else {
                depreBook.depreFinCards(finCardIdSet, false, false, false);
            }
            this.getPageCache().put("deprelog", depreBook.getLogger().toJson());
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("analyze".equalsIgnoreCase(itemKey)) {
            this.updateDeprelogCache();
            JSONObject log = this.getLog();
            this.showData("", log);
        } else if ("download".equalsIgnoreCase(itemKey)) {
            FaCommonUtils.downloadLog((IFormView)this.getView(), (String)"deprehelp.txt", (String)this.getPageCache().get("deprelog"));
        }
    }

    private JSONObject getLog() {
        String json = this.getPageCache().get("deprelog");
        JSONObject jsonObject = JSONObject.fromObject((Object)json);
        return jsonObject;
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("lbl_download".equalsIgnoreCase(key)) {
            String rawData = (String)this.getView().getFormShowParameter().getCustomParam("data");
            FaCommonUtils.downloadLog((IFormView)this.getView(), (String)"deprehelp.txt", (String)rawData);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.containsKey("data")) {
            Map data = (Map)customParams.get("data");
            long assetBookId = (Long)data.get("assetBookId");
            DynamicObject book = BusinessDataServiceHelper.loadSingleFromCache((Object)assetBookId, (String)"fa_assetbook");
            IDataModel model = this.getModel();
            model.setValue("assetbook", (Object)book);
            DynamicObject curperiod = book.getDynamicObject("curperiod");
            model.setValue("period", (Object)curperiod);
            if (data.containsKey("depreEndPeriodId")) {
                Object depreEndPeriodId = data.get("depreEndPeriodId");
                model.setValue("endperiod", depreEndPeriodId);
            }
            this.updateDeprelogCache();
            JSONObject log = this.getLog();
            this.showData("", log);
        } else if (customParams.containsKey("deprelog")) {
            Map logMap = (Map)customParams.get("deprelog");
            JSONObject jsonObj = new JSONObject();
            logMap.forEach((k, v) -> jsonObj.put(k, (Object)JSONObject.fromObject((Object)v)));
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"period"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap1", "analyze"});
            this.getPageCache().put("deprelog", jsonObj.toString());
            this.showData("", jsonObj);
        }
    }

    private void showData(String indent, Object obj) {
        if (obj instanceof JSONObject) {
            TreeView tree = (TreeView)this.getView().getControl("treeviewap");
            tree.deleteAllNodes();
            JSONObject data = (JSONObject)obj;
            Set entrySet = data.entrySet();
            int i = 0;
            boolean isOpened = entrySet.size() <= 1;
            for (Map.Entry mapEntry : entrySet) {
                String key = (String)mapEntry.getKey();
                TreeNode node = new TreeNode();
                node.setParentid("");
                node.setId(i++ + "");
                node.setText(key);
                node.setIsOpened(isOpened);
                Object value = mapEntry.getValue();
                this.buildTree(node, value);
                tree.addNode(node);
            }
        }
    }

    private void buildTree(TreeNode parent, Object obj) {
        String parentId = parent.getId();
        String prefix = parentId + "-";
        int i = 0;
        if (obj instanceof JSONObject) {
            JSONObject data = (JSONObject)obj;
            Set entrySet = data.entrySet();
            for (Map.Entry mapEntry : entrySet) {
                TreeNode node = new TreeNode();
                parent.addChild(node);
                String key = (String)mapEntry.getKey();
                Object value = mapEntry.getValue();
                if (value instanceof List) {
                    node.setParentid(parentId);
                    node.setId(prefix + i++);
                    node.setText(key);
                    List lst = (List)value;
                    for (Object subObj : lst) {
                        this.buildTree(node, subObj);
                    }
                    continue;
                }
                if (value instanceof JSONObject) {
                    node.setParentid(parentId);
                    node.setId(prefix + i++);
                    node.setText(key);
                    this.buildTree(node, value);
                    continue;
                }
                node.setParentid(parentId);
                node.setId(prefix + i++);
                String txt_value = value.toString();
                if (value instanceof Date) {
                    txt_value = Fa.getTF().format((Date)value);
                }
                txt_value = key + ": " + txt_value;
                node.setText(txt_value);
            }
        } else {
            TreeNode node = new TreeNode();
            parent.addChild(node);
            node.setParentid(parentId);
            node.setId(prefix + i++);
            String txt_value = obj.toString();
            if (obj instanceof Date) {
                txt_value = Fa.getTF().format((Date)obj);
            }
            node.setText(txt_value);
        }
    }
}

