/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin;

import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.fa.business.constants.FaClearSourceEnum;
import kd.fi.fa.business.constants.FaDisposal;
import kd.fi.fa.business.enums.ClearBizStatus;
import kd.fi.fa.business.utils.FaBizUtils;
import kd.fi.fa.business.utils.FaPermissionUtils;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.utils.FaUtils;

public class FaDisposalPlugin
extends AbstractFormPlugin {
    private static final String KEY_ADDROW = "addrow";
    private static final String CALLBACK_CLEAR = "callbackclear";
    private static final String KEY_MAIN_DISPOSAL_TOOLBARAP = "main_disposal_toolbarap";
    private static Log log = LogFactory.getLog(FaDisposal.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{KEY_MAIN_DISPOSAL_TOOLBARAP});
        OrgEdit orgF7 = (OrgEdit)this.getControl("org");
        orgF7.addBeforeF7SelectListener(this::beforeOrgSelect);
    }

    private void beforeOrgSelect(BeforeF7SelectEvent evt) {
        List orgs = FaPermissionUtils.getAllEnableBookAndPermissionOrgsV2((String)this.getView().getPageId(), (String)"fa_disposal", (String)"47156aff000000ac");
        QFilter qFilter = new QFilter("id", "in", (Object)orgs);
        List filters = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().getQFilters();
        filters.add(qFilter);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (KEY_ADDROW.equals(evt.getItemKey())) {
            this.showClear();
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setCurrency();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setVocherBtn();
    }

    private void setVocherBtn() {
        String appId;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (formShowParameter != null && "dhc".equals(appId = formShowParameter.getAppId())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"generatevoucher"});
        }
    }

    private void showClear() {
        ListShowParameter para = ShowFormHelper.createShowListForm((String)"fa_cleardetail_base", (boolean)true);
        para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_CLEAR));
        QFilter filter = this.getSelectFilter();
        para.getListFilterParameter().getQFilters().add(filter);
        para.setHasRight(true);
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setFormId("fa_cleardetail_listf7");
        this.getView().showForm((FormShowParameter)para);
    }

    private QFilter getSelectFilter() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        long orgId = org.getLong("id");
        DynamicObject mainBook = FaBizUtils.getAsstBookByOrg((Long)orgId, (String)Fa.comma((String[])new String[]{"depreuse", "periodtype"}));
        if (mainBook == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u6ca1\u6709\u4e3b\u8d26\u7c3f", (String)"FaDisposalPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        long depreUseId = mainBook.getLong("depreuse");
        Date bizDate = (Date)this.getModel().getValue("bizdate");
        DynamicObject periodDynamic = FaUtils.getPeriodByDate(bizDate, mainBook.getLong("periodtype"));
        Date endDate = periodDynamic.getDate("enddate");
        DynamicObjectCollection detailEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("detail");
        Set selectClearDetail = detailEntry.stream().filter(v -> v.get("clearbill") != null).map(v -> v.getDynamicObject("clearbill").getLong("id")).collect(Collectors.toSet());
        QFilter[] filters = new QFilter[]{new QFilter("clearbill.org", "=", (Object)orgId), new QFilter("clearbill.billstatus", "=", (Object)BillStatus.C), new QFilter("clearbill.clearsource", "not in", this.getUnDisposalClearSrc()), new QFilter("bizdate", "<=", (Object)endDate), new QFilter("depreuse", "=", (Object)depreUseId), new QFilter("entrysid", "not in", selectClearDetail), new QFilter("bizstatus", "=", (Object)ClearBizStatus.READY.name())};
        DataSet clearEntryDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"fa_cleardetail_base", (String)"entrysid", (QFilter[])filters, null);
        HashSet<Long> clearEntryPkSet = new HashSet<Long>(16);
        for (Row row : clearEntryDataSet) {
            clearEntryPkSet.add(row.getLong("entrysid"));
        }
        log.info("rangeList:" + selectClearDetail);
        return new QFilter("entrysid", "in", clearEntryPkSet);
    }

    private Set<String> getUnDisposalClearSrc() {
        HashSet<String> unDisposalClearSrc = new HashSet<String>(8);
        unDisposalClearSrc.add(FaClearSourceEnum.MERGE.name());
        unDisposalClearSrc.add(FaClearSourceEnum.SPLIT.name());
        return unDisposalClearSrc;
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        ListSelectedRowCollection returnDataList;
        super.closedCallBack(evt);
        Object returnData = evt.getReturnData();
        if (returnData != null && CALLBACK_CLEAR.equals(evt.getActionId()) && (returnDataList = (ListSelectedRowCollection)returnData) != null && returnDataList.size() > 0) {
            Set<Object> clearPKSet = this.getReturnClearPKSet(returnDataList);
            DynamicObjectCollection clearinfo = this.getClearInfo(clearPKSet);
            this.checkClearBill4MergeSource(clearinfo);
            this.setValues(clearinfo);
        }
    }

    private void checkClearBill4MergeSource(DynamicObjectCollection clearDetailBases) {
        if (CollectionUtils.isNotEmpty((Collection)clearDetailBases)) {
            HashSet invalidClearBills = new HashSet(clearDetailBases.size());
            clearDetailBases.stream().forEach(t -> {
                if (FaClearSourceEnum.MERGE.name().equals(t.getString("clearbill.clearsource"))) {
                    invalidClearBills.add(t.getString(Fa.dot((String[])new String[]{"clearbill", "billno"})));
                }
            });
            if (CollectionUtils.isNotEmpty(invalidClearBills)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6e05\u7406\u5355[%s]\u7531\u5408\u5e76\u5355\u4ea7\u751f\uff0c\u4e0d\u5141\u8bb8\u505a\u8d44\u4ea7\u5904\u7f6e\u3002", (String)"FaDisposalPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]), invalidClearBills.stream().collect(Collectors.joining(", "))));
            }
        }
    }

    private Set<Object> getReturnClearPKSet(ListSelectedRowCollection selectlist) {
        HashSet<Object> clearIds = new HashSet<Object>();
        for (ListSelectedRow row : selectlist) {
            clearIds.add(row.getPrimaryKeyValue());
        }
        return clearIds;
    }

    private DynamicObjectCollection getClearInfo(Set<Object> clearPKSet) {
        String selectfields = "id,realcard,clearbill.clearsource,clearbill.billno";
        DynamicObjectCollection clearInfo = QueryServiceHelper.query((String)"fa_cleardetail_base", (String)selectfields, (QFilter[])new QFilter[]{new QFilter("id", "in", clearPKSet)});
        return clearInfo;
    }

    private void setValues(DynamicObjectCollection clearinfo) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[]{"clearbill"});
        int index = 0;
        for (DynamicObject dynamicObject : clearinfo) {
            setter.set("clearbill", (Object)dynamicObject.getLong("id"), index);
            setter.set("realcard", (Object)dynamicObject.getLong("realcard"), index);
            ++index;
        }
        model.batchCreateNewEntryRow("detail", setter);
        model.endInit();
        this.getView().updateView("detail");
    }

    private void setCurrency() {
        Object org = this.getModel().getValue("org");
        if (org != null) {
            QFilter orgFilter = new QFilter("baseacctorg", "=", ((DynamicObject)org).getPkValue());
            DynamicObject basecurrrency = QueryServiceHelper.queryOne((String)"bd_accountingsys_base", (String)"basecurrrency", (QFilter[])new QFilter[]{orgFilter});
            if (basecurrrency == null) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u6838\u7b97\u7ec4\u7ec7\u672c\u4f4d\u5e01\u5931\u8d25\uff0c\u8bf7\u524d\u5f80\u201c\u6838\u7b97\u7ec4\u7ec7\u672c\u4f4d\u5e01\u8bbe\u7f6e\u201d\u754c\u9762\u8fdb\u884c\u914d\u7f6e\u3002", (String)"FaDisposalPlugin_2", (String)"fi-fa-formplugin", (Object[])new Object[0]), new Object[0]));
                return;
            }
            Long basecurrrencyId = basecurrrency.getLong("basecurrrency");
            if (basecurrrencyId != 0L) {
                this.getModel().setValue("basecurrency", (Object)basecurrrencyId);
            }
        }
    }
}

