/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.SourceFlagEnum;
import kd.fi.fa.business.utils.PeriodUtil;
import kd.fi.fa.formplugin.FaCurCardFinEditPlugin;
import kd.fi.fa.formplugin.importhandler.InitFinCardImportHandler;

public class FaInitFinCardEditPlugin
extends FaCurCardFinEditPlugin {
    private static final String OP_TRACKUPREAL = "trackupreal";

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (OP_TRACKUPREAL.equals(afterDoOperationEventArgs.getOperateKey())) {
            this.showInitRealCardList();
        }
    }

    @Override
    public void initImportData(InitImportDataEventArgs e) {
        List sourceDataList = e.getSourceDataList();
        for (Map map : sourceDataList) {
            Object workLoadUnit = map.get("workloadunit");
            if (!Objects.isNull(workLoadUnit)) continue;
            map.put("workloadunit", null);
        }
    }

    @Override
    public void afterImportData(ImportDataEventArgs e) {
        new InitFinCardImportHandler().handleImport((BillModel)this.getModel(), e);
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        QFilter filterAsseboook = new QFilter("id", "=", model.getValue("assetbook_id"));
        QFilter filterEnable = new QFilter("status", "=", (Object)"C");
        boolean isExistUnEnablebook = QueryServiceHelper.exists((String)"fa_assetbook", (QFilter[])new QFilter[]{filterAsseboook, filterEnable});
        if (isExistUnEnablebook) {
            view.setVisible(Boolean.valueOf(false), new String[]{"bar_save"});
            view.setVisible(Boolean.valueOf(false), new String[]{"bar_print"});
            view.setEnable(Boolean.valueOf(false), new String[]{"contentpanel"});
            return;
        }
        DynamicObject bill = model.getDataEntity();
        DynamicObject assetBook = bill.getDynamicObject("assetbook");
        if (assetBook != null) {
            Long periodId;
            int periodNumber;
            DynamicObject period;
            if (!assetBook.containsProperty("startperiod")) {
                assetBook = BusinessDataServiceHelper.loadSingleFromCache((String)"fa_assetbook", (QFilter[])new QFilter("id", "=", (Object)assetBook.getLong("id")).toArray());
            }
            if ((period = assetBook.getDynamicObject("startperiod")) != null && (periodNumber = PeriodUtil.getPeriodNumberById((long)(periodId = (Long)period.getPkValue()))) == 1) {
                view.setEnable(Boolean.FALSE, new String[]{"addupyeardepre"});
            }
        }
        model.setValue("bizperiod_id", (Object)0L);
        model.setValue("period_id", (Object)0L);
        model.setDataChanged(false);
        DynamicObject realCard = super.getRealCard();
        if (realCard != null) {
            String sourceFlag = realCard.getString("sourceflag");
            if (SourceFlagEnum.INITLEASECONTRACT.name().equals(sourceFlag)) {
                this.getModel().setValue("showcurrency", (Object)false);
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"showcurrency"});
            }
        }
    }

    private void showInitRealCardList() {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setFormId("bos_list");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        DynamicObject initFinCard = this.getModel().getDataEntity();
        ArrayList<Long> realCardIdList = new ArrayList<Long>(1);
        ArrayList<String> assetunitList = new ArrayList<String>(1);
        Long realCardId = initFinCard.getDynamicObject("realcard").getLong("id");
        realCardIdList.add(realCardId);
        String assetunit = initFinCard.getDynamicObject("realcard.assetunit").getString("id");
        assetunitList.add(assetunit);
        parameter.getCustomParams().put("realCard", realCardIdList);
        parameter.getCustomParams().put("assetunit", assetunitList);
        parameter.getCustomParams().put("trackDownInitFin", true);
        parameter.setBillFormId("fa_initcard_real");
        parameter.setHasRight(true);
        this.getView().showForm((FormShowParameter)parameter);
    }
}

