/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.fa.business.model.ReconciliationParam;
import kd.fi.fa.business.utils.FaCardBotpUtil;
import kd.fi.fa.business.utils.FaOperateLogUtil;
import kd.fi.fa.business.utils.FaPermissionUtils;
import kd.fi.fa.business.utils.FaUtils;
import kd.fi.fa.common.batch.BatchResult;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.common.util.ThrowableHelper;

public class FaInitFinListPlugin
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(FaInitFinListPlugin.class);
    private static final String IS_CLICK_ORG = "isClickOrg";
    private static final String PAGECACHE_ORG_ID = "pagecache.orgId";
    private static final String PAGECACHE_DEPREUSE_ID = "pagecache.depreuseId";
    private static final String CALL_BACK_RECONCILIATION = "call_back_reconciliation";
    private static final String CACHE_RECONCILIATION_RES = "cache_reconciliation_res";
    private static final String DEPRE_USE_ID_SEPARATOR = ",";
    private static final String OP_TRACKUPREAL = "trackupreal";
    private static final String ANTICLOSEINIT = "anticloseinit";
    private static final String CLOSEINIT = "closeinit";
    private static final String SWITCH = "switch";
    private static final String[] HIDE_BTN = new String[]{"btn_delsysbotp"};

    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        qFilters.removeIf(Objects::isNull);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        qFilters.add(new QFilter("bizperiod", "=", (Object)0L));
        QFilter mainOrgQFilter = e.getMainOrgQFilter();
        if (mainOrgQFilter != null) {
            List orgIds = (List)mainOrgQFilter.getValue();
            Object depreuseId = null;
            for (QFilter filter : qFilters) {
                if (!"depreuse.id".equals(filter.getProperty())) continue;
                depreuseId = filter.getValue();
                break;
            }
            IPageCache pageCache = this.getPageCache();
            pageCache.put(PAGECACHE_ORG_ID, orgIds.get(0).toString());
            if (null != depreuseId) {
                if (depreuseId instanceof Long) {
                    pageCache.put(PAGECACHE_DEPREUSE_ID, depreuseId.toString());
                } else if (depreuseId instanceof List) {
                    String depreUserIdStr = Fa.join((Collection)((List)depreuseId), (String)DEPRE_USE_ID_SEPARATOR);
                    pageCache.put(PAGECACHE_DEPREUSE_ID, depreUserIdStr);
                }
            } else {
                pageCache.put(PAGECACHE_DEPREUSE_ID, null);
            }
        }
        if (null != paramMap.get("realCard")) {
            qFilters.add(new QFilter("realcard.id", "in", paramMap.get("realCard")));
        }
        this.setBarStarus();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "trackupreal": {
                this.showInitRealCardList();
                break;
            }
            case "anticloseinit": {
                this.antiCloseInitMethod();
                break;
            }
            case "closeinit": {
                this.closeInitMethod();
                break;
            }
            case "switch": {
                this.switchDynamicMethod();
                break;
            }
        }
    }

    private void switchDynamicMethod() {
        DynamicObjectCollection assetBooks;
        DynamicObject assetBook;
        IPageCache pageCache = this.getPageCache();
        String depreUseIdStr = pageCache.get(PAGECACHE_DEPREUSE_ID);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("org.id", "=", (Object)Long.parseLong(pageCache.get(PAGECACHE_ORG_ID))));
        if (depreUseIdStr != null) {
            String[] splitDepreUseId = depreUseIdStr.split(DEPRE_USE_ID_SEPARATOR);
            Set depreUseIdSet = Arrays.stream(splitDepreUseId).map(v -> Long.parseLong(v)).collect(Collectors.toSet());
            filters.add(new QFilter("depreuse.id", "in", depreUseIdSet));
        }
        DynamicObject dynamicObject = assetBook = (assetBooks = QueryServiceHelper.query((String)"fa_assetbook", (String)"id,startperiod,curperiod,ismainbook", (QFilter[])filters.toArray(new QFilter[0]))).size() == 0 ? null : (DynamicObject)assetBooks.get(0);
        if (assetBooks != null) {
            for (DynamicObject book : assetBooks) {
                if (!book.getBoolean("ismainbook")) continue;
                assetBook = book;
                break;
            }
        }
        if (assetBook == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u6838\u7b97\u7ec4\u7ec7\u548c\u6298\u65e7\u7528\u9014\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u8d26\u7c3f\u3002", (String)"FaInitFinListPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        if (assetBook.getLong("startperiod") != assetBook.getLong("curperiod")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5bf9\u5e94\u8d26\u7c3f\u5df2\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"FaInitFinListPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        FormShowParameter param = new FormShowParameter();
        param.setFormId("fa_dyndepre");
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setCustomParam("bookid", assetBook.get("id"));
        this.getView().showForm(param);
    }

    private void closeInitMethod() {
        DynamicObject[] assetBooks = this.getAssetBookDy();
        HashSet<Long> orgIdSet = new HashSet<Long>(4);
        for (DynamicObject assetBook : assetBooks) {
            Object assetBookPk = assetBook.get("id");
            boolean res = this.reconciliation(assetBookPk, true);
            if (!res) {
                return;
            }
            orgIdSet.add(assetBook.getLong(Fa.id((String)"org")));
        }
        this.checkFinRealCardMasterId(orgIdSet);
        this.closeInit(assetBooks);
        this.setBarStarus();
    }

    private void checkFinRealCardMasterId(Set<Long> orgIds) {
        boolean exist = QueryServiceHelper.exists((String)"fa_card_fin", (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds), new QFilter("realcardmasterid", "=", (Object)0)});
        if (exist) {
            String msg = ResManager.loadKDString((String)"\u8d22\u52a1\u5361\u7247\u7684[\u5361\u7247\u4e3b\u6570\u636eID]\u5b57\u6bb5\u672a\u6210\u529f\u5347\u7ea7\uff0c\u8bf7\u5148\u5347\u7ea7\u3002", (String)"FaInitFinListPlugin_2", (String)"fi-fa-formplugin", (Object[])new Object[0]);
            throw new KDBizException(msg);
        }
    }

    private void antiCloseInitMethod() {
        DynamicObject[] assetBooks = this.getAssetBookDy();
        this.antiCloseInit(assetBooks);
        this.setBarStarus();
        this.getView().updateView("billlistap");
    }

    public void filterContainerInit(FilterContainerInitArgs filtercontainerinitargs) {
        super.filterContainerInit(filtercontainerinitargs);
        List listFilterColumns = filtercontainerinitargs.getFilterContainerInitEvent().getCommonFilterColumns();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        if (null != paramMap.get("trackDownInitFin")) {
            for (FilterColumn listFilter : listFilterColumns) {
                Object comboItems;
                CommonFilterColumn commFilter = (CommonFilterColumn)listFilter;
                String field = commFilter.getFieldName();
                if ("org.name".equals(field)) {
                    List orgIdList = (List)paramMap.get("orgId");
                    if (orgIdList != null && orgIdList.size() > 0) {
                        commFilter.setDefaultValues(orgIdList);
                    } else {
                        String orgFilterObjId;
                        String billFormID = ((FilterContainer)filtercontainerinitargs.getFilterContainerInitEvent().getSource()).getEntityId();
                        comboItems = FaPermissionUtils.getAllBookAndPermissionOrgsCombosV2((String)this.getView().getPageId(), (String)billFormID);
                        commFilter.setComboItems((List)comboItems);
                        if (null != comboItems && comboItems.size() > 0) {
                            String defaultOrgid = FaUtils.getDefaultOrgId((List)comboItems);
                            this.getPageCache().put("org", defaultOrgid);
                            if (StringUtils.isEmpty((CharSequence)this.getPageCache().get(IS_CLICK_ORG))) {
                                commFilter.setDefaultValue(defaultOrgid);
                                commFilter.setDefValue(defaultOrgid);
                            }
                        }
                        if ((orgFilterObjId = (String)paramMap.get("org")) != null) {
                            commFilter.setDefaultValue(orgFilterObjId);
                        }
                    }
                } else if ("depreuse.name".equals(field)) {
                    ArrayList<String> depreusesList = new ArrayList<String>(16);
                    List depreuses = commFilter.getComboItems();
                    comboItems = depreuses.iterator();
                    while (comboItems.hasNext()) {
                        ComboItem comboItem = (ComboItem)comboItems.next();
                        depreusesList.add(comboItem.getValue());
                    }
                    commFilter.setDefaultValues(depreusesList);
                }
                List listFastFilterColumns = filtercontainerinitargs.getFilterContainerInitEvent().getFastFilterColumns();
                for (FilterColumn listFastFilter : listFastFilterColumns) {
                    String fastField;
                    switch (fastField = listFastFilter.getFieldName()) {
                        case "number": {
                            List contractNumber = (List)paramMap.get("finNumber");
                            if (contractNumber == null || contractNumber.size() <= 0) break;
                            listFastFilter.setDefaultValues(contractNumber);
                            break;
                        }
                    }
                }
            }
        } else {
            for (FilterColumn listFilter : listFilterColumns) {
                CommonFilterColumn commFilter = (CommonFilterColumn)listFilter;
                String field = commFilter.getFieldName();
                if ("org.id".equals(field) || "org.name".equals(field) || "org.number".equals(field)) {
                    String orgFilterObjId;
                    Object initGuideOrgId = this.getView().getFormShowParameter().getCustomParam("initGuide.orgId");
                    if (initGuideOrgId != null) {
                        DynamicObject org = QueryServiceHelper.queryOne((String)"bos_org", (String)"name", (QFilter[])new QFilter("id", "=", initGuideOrgId).toArray());
                        ComboItem c = new ComboItem();
                        c.setValue(initGuideOrgId.toString());
                        c.setCaption(new LocaleString(org.getString("name")));
                        commFilter.setComboItems(Collections.singletonList(c));
                        commFilter.setDefaultValue(initGuideOrgId.toString());
                        commFilter.setDefValue(initGuideOrgId.toString());
                        commFilter.setMustInput(true);
                        continue;
                    }
                    String billFormID = ((FilterContainer)filtercontainerinitargs.getFilterContainerInitEvent().getSource()).getEntityId();
                    List comboItems = FaPermissionUtils.getAllBookAndPermissionOrgsCombosV2((String)this.getView().getPageId(), (String)billFormID);
                    commFilter.setComboItems(comboItems);
                    if (null != comboItems && comboItems.size() > 0) {
                        String defaultOrgid = FaUtils.getDefaultOrgId((List)comboItems);
                        this.getPageCache().put("org", defaultOrgid);
                        if (StringUtils.isEmpty((CharSequence)this.getPageCache().get(IS_CLICK_ORG))) {
                            commFilter.setDefaultValue(defaultOrgid);
                            commFilter.setDefValue(defaultOrgid);
                        }
                    }
                    if ((orgFilterObjId = (String)paramMap.get("org")) == null) continue;
                    commFilter.setDefaultValue(orgFilterObjId);
                    continue;
                }
                if (!"depreuse.name".equals(field)) continue;
                List depreuses = commFilter.getComboItems();
                commFilter.setDefaultValue(((ComboItem)depreuses.get(0)).getValue());
            }
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        SearchClickEvent searchClickEvent = args.getSearchClickEvent();
        Map map = searchClickEvent.getFilterValues();
        List customlist = (List)map.get("customfilter");
        List schemelist = (List)map.get("schemefilter");
        List fastlist = (List)map.get("fastfilter");
        if (customlist != null) {
            if (customlist.size() == 0) {
                return;
            }
            for (int i = 0; i < customlist.size(); ++i) {
                Map map1 = (Map)customlist.get(i);
                List listValue = (List)map1.get("Value");
                List listFieldName = (List)map1.get("FieldName");
                for (int j = 0; j < listFieldName.size(); ++j) {
                    if (!listFieldName.get(j).equals("org.id")) continue;
                    String key = (String)listValue.get(j);
                    this.getPageCache().put("org", key);
                    this.getPageCache().put(IS_CLICK_ORG, "yes");
                }
            }
        } else if (schemelist != null ? schemelist.size() == 0 : fastlist != null && fastlist.size() == 0) {
            return;
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent e) {
        super.filterContainerBeforeF7Select(e);
        String field = e.getFieldName();
        ListShowParameter parameter = (ListShowParameter)this.getView().getFormShowParameter();
        String formId = parameter.getBillFormId();
        if ("org.id".equals(field) || "org.number".equals(field) || "org.name".equals(field)) {
            List orgIds = FaPermissionUtils.getAllBookAndPermissionOrgsV2((String)this.getView().getPageId(), (String)formId);
            e.getQfilters().add(new QFilter("id", "in", (Object)orgIds));
        }
    }

    public void itemClick(ItemClickEvent evt) {
        if ("reconciliation".equals(evt.getItemKey())) {
            Object assetBookPk = this.getAssetBookPk();
            this.reconciliation(assetBookPk, false);
        } else if ("btn_delsysbotp".equals(evt.getItemKey())) {
            this.deleteBotp4InitFinCard();
        }
    }

    private void deleteBotp4InitFinCard() {
        ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
        Object[] finCardIds = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).toArray();
        FaCardBotpUtil.deleteBotp4InitFinCard((Object[])finCardIds);
    }

    private void showInitRealCardList() {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setFormId("bos_list");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
        List finCardIds = selectedRows.stream().map(v -> (Long)v.getPrimaryKeyValue()).collect(Collectors.toList());
        QFilter filter = new QFilter("id", "in", finCardIds);
        DynamicObjectCollection initFinCards = QueryServiceHelper.query((String)"fa_initcard_fin", (String)"id,org,number,realcard,realcard.assetunit assetunit", (QFilter[])filter.toArray());
        List realCardIdList = initFinCards.stream().map(v -> v.getLong("realcard")).collect(Collectors.toList());
        Set assetUnitList = initFinCards.stream().map(v -> v.getString("assetunit")).collect(Collectors.toSet());
        parameter.getCustomParams().put("realCard", realCardIdList);
        parameter.getCustomParams().put("assetunit", assetUnitList);
        parameter.getCustomParams().put("trackDownInitFin", true);
        parameter.setBillFormId("fa_initcard_real");
        parameter.setHasRight(true);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void setBarStarus() {
        List<QFilter> qfList = this.getFilter();
        DynamicObjectCollection assetbooks = QueryServiceHelper.query((String)"fa_assetbook", (String)"status", (QFilter[])qfList.toArray(new QFilter[0]));
        this.getView().setEnable(Boolean.FALSE, new String[]{CLOSEINIT});
        for (DynamicObject assetbook : assetbooks) {
            if ("C".equals(assetbook.get("status"))) continue;
            this.getView().setEnable(Boolean.TRUE, new String[]{CLOSEINIT});
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        MessageBoxResult evtResult = evt.getResult();
        if (MessageBoxResult.Yes == evtResult && CALL_BACK_RECONCILIATION.equals(callBackId)) {
            this.showReconciliationTab();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setShortCuts();
    }

    public void customEvent(CustomEventArgs e) {
        String key;
        super.customEvent(e);
        if (e.getEventName().equalsIgnoreCase("shortCuts") && "[16,77]".equals(key = e.getEventArgs())) {
            this.getView().setVisible(Boolean.valueOf(true), HIDE_BTN);
        }
    }

    private void setShortCuts() {
        this.getView().setVisible(Boolean.FALSE, HIDE_BTN);
        JSONArray arrayItem = new JSONArray();
        JSONObject item = new JSONObject();
        item.put("type", (Object)"keyUp");
        item.put("shortCuts", (Object)"shift+m");
        arrayItem.add((Object)item);
        IFormView formView = this.getView();
        IClientViewProxy clientViewProxy = (IClientViewProxy)formView.getService(IClientViewProxy.class);
        JSONArray action = new JSONArray();
        action.add((Object)arrayItem);
        clientViewProxy.addAction("setShortCuts", (Object)action);
    }

    private Object getAssetBookPk() {
        List<QFilter> qfList = this.getFilter();
        DynamicObject assetBook = QueryServiceHelper.queryOne((String)"fa_assetbook", (String)"id", (QFilter[])qfList.toArray(new QFilter[0]));
        if (assetBook == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u6838\u7b97\u7ec4\u7ec7\u548c\u6298\u65e7\u7528\u9014\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u8d26\u7c3f\u3002", (String)"FaInitFinListPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        return assetBook.get("id");
    }

    private List<QFilter> getFilter() {
        IPageCache pageCache = this.getPageCache();
        String depreUseIdStr = pageCache.get(PAGECACHE_DEPREUSE_ID);
        ArrayList<QFilter> qfList = new ArrayList<QFilter>(1);
        String orgIdStr = pageCache.get(PAGECACHE_ORG_ID);
        if (orgIdStr != null) {
            QFilter qfOrg = new QFilter("org.id", "=", (Object)Long.parseLong(orgIdStr));
            qfList.add(qfOrg);
        }
        if (depreUseIdStr != null) {
            String[] splitDepreUseId = depreUseIdStr.split(DEPRE_USE_ID_SEPARATOR);
            Set depreUseIdSet = Arrays.stream(splitDepreUseId).map(v -> Long.parseLong(v)).collect(Collectors.toSet());
            QFilter qfDepreuse = new QFilter("depreuse.id", "in", depreUseIdSet);
            qfList.add(qfDepreuse);
        }
        return qfList;
    }

    private void handleBatchResult(BatchResult<DynamicObject, Void> result, String actionName) {
        if (result.hasFailure()) {
            FaOperateLogUtil.addLog((String)"fa_initcard_fin", (Long)Long.parseLong(this.getPageCache().get(PAGECACHE_ORG_ID)), (String)actionName, (String)(result.getMessage(actionName) + "; " + result.getDetailMessage(v -> v.getString("name"))));
            this.getView().showMessage(result.getMessage(actionName), result.getDetailMessage(v -> v.getString("name")), MessageTypes.Default);
        } else {
            FaOperateLogUtil.addLog((String)"fa_initcard_fin", (Long)Long.parseLong(this.getPageCache().get(PAGECACHE_ORG_ID)), (String)actionName, (String)actionName);
            this.getView().showSuccessNotification(result.getMessage(actionName));
        }
        if (result.hasSuccess()) {
            ((IListView)this.getView()).refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reconciliation(Object assetBookId, boolean showTipsWindow) {
        DynamicObject assetBook = QueryServiceHelper.queryOne((String)"fa_assetbook", (String)"id,org.id org,startperiod.id startperiod,name", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)new Object[]{assetBookId})});
        ReconciliationParam param = new ReconciliationParam();
        param.setInit(true);
        param.setAppNumber("fa");
        param.setOrgId(Long.valueOf(assetBook.getLong("org")));
        param.setBizBookId(Long.valueOf(assetBook.getLong("id")));
        param.setPeriodId(Long.valueOf(assetBook.getLong("startperiod")));
        String paramJson = JSONObject.toJSONString((Object)param);
        String result = "";
        try {
            result = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"frm", (String)"ReconciliationService", (String)"execute", (Object[])new Object[]{paramJson});
            this.getPageCache().put(CACHE_RECONCILIATION_RES, result);
        }
        catch (Exception e) {
            logger.info("\u56fa\u5b9a\u8d44\u4ea7\u521d\u59cb\u5316\u5bf9\u8d26\u68c0\u67e5\u5f02\u5e38", (Object)e);
            if (e instanceof KDBizException) {
                KDBizException kdex = (KDBizException)((Object)e);
                if ("2".equals(kdex.getErrorCode().getCode())) {
                    result = kdex.getArgs()[0].toString();
                    this.getPageCache().put(CACHE_RECONCILIATION_RES, result);
                    if (showTipsWindow) {
                        this.getView().showConfirm(ResManager.loadKDString((String)"\u5bf9\u8d26\u68c0\u67e5", (String)"FaInitFinListPlugin_3", (String)"fi-fa-formplugin", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"%s\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u9700\u8981\u8054\u67e5\u5bf9\u8d26\u6c47\u603b\u8868\u3002", (String)"FaInitFinListPlugin_4", (String)"fi-fa-formplugin", (Object[])new Object[0]), kdex.getMessage()), MessageBoxOptions.OKCancel, ConfirmTypes.Fail, new ConfirmCallBackListener(CALL_BACK_RECONCILIATION));
                    } else {
                        this.showReconciliationTab();
                    }
                } else if ("7".equals(kdex.getErrorCode().getCode())) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u5bf9\u8d26\u68c0\u67e5", (String)"FaInitFinListPlugin_3", (String)"fi-fa-formplugin", (Object[])new Object[0]), assetBook.getString("name") + ":" + kdex.getArgs()[0].toString(), MessageTypes.Default);
                } else {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u5bf9\u8d26\u68c0\u67e5", (String)"FaInitFinListPlugin_3", (String)"fi-fa-formplugin", (Object[])new Object[0]), assetBook.getString("name") + ":" + kdex.getErrorCode().getMessage(), MessageTypes.Default);
                }
            } else {
                this.getView().showMessage(ResManager.loadKDString((String)"\u5bf9\u8d26\u68c0\u67e5", (String)"FaInitFinListPlugin_3", (String)"fi-fa-formplugin", (Object[])new Object[0]), ThrowableHelper.toString((Throwable)e), MessageTypes.Default);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            logger.info("\u56fa\u5b9a\u8d44\u4ea7\u521d\u59cb\u5316\u5bf9\u8d26\u68c0\u67e5\u7ed3\u679c\uff1a" + result);
        }
        if (!showTipsWindow) {
            if (result != null) {
                this.showReconciliationTab();
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u9700\u5bf9\u8d26\u3002", (String)"FaInitFinListPlugin_5", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            }
        }
        return true;
    }

    private void showReconciliationTab() {
        String reconciliationRes = this.getPageCache().get(CACHE_RECONCILIATION_RES);
        if (StringUtils.isNotBlank((CharSequence)reconciliationRes)) {
            FormShowParameter showParam = new FormShowParameter();
            showParam.setFormId("ai_reconciliation_rst_fst");
            showParam.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParam.setCustomParam("model", (Object)reconciliationRes);
            this.getView().showForm(showParam);
        }
    }

    private DynamicObject[] getAssetBookDy() {
        List<QFilter> qfList = this.getFilter();
        DynamicObject[] assetBooks = BusinessDataServiceHelper.load((String)"fa_assetbook", (String)"id,org,status,depreuse,startperiod,curperiod", (QFilter[])qfList.toArray(new QFilter[0]));
        if (assetBooks.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u6838\u7b97\u7ec4\u7ec7\u548c\u6298\u65e7\u7528\u9014\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u8d26\u7c3f\u3002", (String)"FaInitFinListPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        return assetBooks;
    }

    private void closeInit(DynamicObject[] assetbook) {
        OperationResult closeinitResult = OperationServiceHelper.executeOperate((String)"facloseinit", (String)"fa_assetbook", (DynamicObject[])assetbook);
        if (!closeinitResult.isSuccess()) {
            List allError = closeinitResult.getAllErrorOrValidateInfo();
            closeinitResult.getAllErrorInfo();
            StringBuilder errorInfo = new StringBuilder();
            if (!CollectionUtils.isEmpty((Collection)allError)) {
                for (IOperateInfo in : allError) {
                    errorInfo.append(in.getMessage());
                }
            }
            throw new KDBizException(new LocaleString(String.format(ResManager.loadKDString((String)"\u7ed3\u675f\u521d\u59cb\u5316\u5931\u8d25\uff1a%s", (String)"FaInitFinListPlugin_6", (String)"fi-fa-formplugin", (Object[])new Object[0]), errorInfo.toString())).toString());
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u521d\u59cb\u5316\u6210\u529f\u3002", (String)"FaInitFinListPlugin_7", (String)"fi-fa-formplugin", (Object[])new Object[0]));
    }

    private void antiCloseInit(DynamicObject[] assetbook) {
        OperationResult closeinitResult = OperationServiceHelper.executeOperate((String)"faanticloseinit", (String)"fa_assetbook", (DynamicObject[])assetbook, null);
        if (!closeinitResult.isSuccess()) {
            List allError = closeinitResult.getAllErrorOrValidateInfo();
            closeinitResult.getAllErrorInfo();
            StringBuilder errorInfo = new StringBuilder();
            if (!CollectionUtils.isEmpty((Collection)allError)) {
                for (IOperateInfo in : allError) {
                    errorInfo.append(in.getMessage());
                }
            }
            throw new KDBizException(new LocaleString(String.format(ResManager.loadKDString((String)"\u53cd\u521d\u59cb\u5316\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a%s", (String)"FaInitFinListPlugin_8", (String)"fi-fa-formplugin", (Object[])new Object[0]), errorInfo.toString())).toString());
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53cd\u521d\u59cb\u5316\u6210\u529f\u3002", (String)"FaInitFinListPlugin_9", (String)"fi-fa-formplugin", (Object[])new Object[0]));
    }
}

