/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.SourceFlagEnum;
import kd.fi.fa.formplugin.FaCurCardRealEditPlugin;
import kd.fi.fa.formplugin.importhandler.InitRealCardImportHandler;
import kd.fi.fa.utils.FaF7DeptUtils;

public class FaInitRealCardEditPlugin
extends FaCurCardRealEditPlugin {
    private static final String OP_GENERATE_FIN_CARD = "generatefincard";
    private static final String OP_DELETE_FIN_CARD = "deletefincard";
    private static final String BTN_SAVE = "bar_save";
    private static final String OP_TRACKDOWN_FIN_CARD = "trackdowninitfin";

    @Override
    public void afterImportData(ImportDataEventArgs e) {
        new InitRealCardImportHandler().handleImport((BillModel)this.getModel());
    }

    @Override
    public void afterBindData(EventObject e) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        if (!model.getDataEntity().getDataEntityState().getFromDatabase()) {
            view.setVisible(Boolean.valueOf(false), new String[]{"bar_del", OP_GENERATE_FIN_CARD});
        }
        if (this.getModel().getValue("org") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"FaInitRealCardEditPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            return;
        }
        if (this.checkAssetBookSetVisibleAndEnable(true)) {
            return;
        }
    }

    private boolean checkAssetBookSetVisibleAndEnable(boolean needShowTip) {
        QFilter filterEnable;
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        QFilter filterOrg = new QFilter("org.id", "=", model.getValue("org_id"));
        boolean isExistUnEnablebook = QueryServiceHelper.exists((String)"fa_assetbook", (QFilter[])new QFilter[]{filterOrg, filterEnable = new QFilter("status", "=", (Object)"C")});
        if (isExistUnEnablebook) {
            view.setVisible(Boolean.valueOf(false), new String[]{BTN_SAVE});
            view.setVisible(Boolean.valueOf(false), new String[]{OP_GENERATE_FIN_CARD});
            view.setVisible(Boolean.valueOf(false), new String[]{OP_DELETE_FIN_CARD});
            view.setVisible(Boolean.valueOf(false), new String[]{"bar_del"});
            if (needShowTip) {
                view.showTipNotification(ResManager.loadKDString((String)"\u5bf9\u5e94\u8d26\u7c3f\u5df2\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u4e0d\u80fd\u64cd\u4f5c\u3002", (String)"FaInitRealCardEditPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            }
            return true;
        }
        Object sourceFlag = model.getValue("sourceflag");
        if (SourceFlagEnum.INITLEASECONTRACT.name().equals(sourceFlag) || SourceFlagEnum.LEASECONTRACT.name().equals(sourceFlag)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"assetcat", "assetname", "assetamount", "unit", "supplier", "storeplace"});
        }
        return false;
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        IDataModel model = this.getModel();
        OperationResult op = e.getOperationResult();
        if (op == null) {
            return;
        }
        boolean isSuccess = op.isSuccess();
        String opName = e.getOperateKey();
        if (isSuccess && OP_GENERATE_FIN_CARD.equals(opName)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_SAVE});
        } else if (isSuccess && OP_DELETE_FIN_CARD.equals(opName)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_SAVE});
        } else if (OP_TRACKDOWN_FIN_CARD.equals(opName)) {
            this.showInitFinCardList();
        }
        if (model.getDataEntity().getDataEntityState().getFromDatabase()) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_del", OP_GENERATE_FIN_CARD});
        }
        this.checkAssetBookSetVisibleAndEnable(false);
    }

    private void showInitFinCardList() {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setFormId("bos_list");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        DynamicObject initRealCard = this.getModel().getDataEntity();
        ArrayList<String> finNumberList = new ArrayList<String>(1);
        String finNumber = initRealCard.getString("number");
        finNumberList.add(finNumber);
        parameter.getCustomParams().put("finNumber", finNumberList);
        ArrayList<String> orgIdList = new ArrayList<String>(1);
        long orgId = initRealCard.getLong("org_id");
        orgIdList.add(Long.toString(orgId));
        parameter.getCustomParams().put("orgId", orgIdList);
        ArrayList<Long> realCardIdList = new ArrayList<Long>(1);
        Long realCardId = initRealCard.getLong("id");
        realCardIdList.add(realCardId);
        parameter.getCustomParams().put("realCard", realCardIdList);
        QFilter qrealcard = new QFilter("realcard", "in", realCardIdList);
        DynamicObjectCollection fins = QueryServiceHelper.query((String)"fa_initcard_fin", (String)"id", (QFilter[])qrealcard.toArray());
        if (fins.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0b\u6e38\u65e0\u5173\u8054\u8d22\u52a1\u5361\u7247\u3002", (String)"FaInitRealCardEditPlugin_2", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        parameter.getCustomParams().put("trackDownInitFin", true);
        parameter.setBillFormId("fa_initcard_fin");
        this.getView().showForm((FormShowParameter)parameter);
    }

    @Override
    public void initImportData(InitImportDataEventArgs e) {
        super.initImportData(e);
        List sourceData = e.getSourceDataList();
        ArrayList<String> numbers = new ArrayList<String>(sourceData.size());
        for (Map sourceDatum : sourceData) {
            Object number = sourceDatum.get("number");
            if (number == null) continue;
            numbers.add(number.toString());
        }
        QFilter numberQFilter = new QFilter("number", "in", numbers);
        QFilter bizperiodQFilter = new QFilter("bizperiod", "=", (Object)0);
        DynamicObjectCollection fins = QueryServiceHelper.query((String)"fa_initcard_fin", (String)"id,number", (QFilter[])new QFilter[]{numberQFilter, bizperiodQFilter});
        HashSet<String> existNumbers = new HashSet<String>(fins.size());
        for (DynamicObject fin : fins) {
            existNumbers.add(fin.getString("number"));
        }
        for (Map sourceDatum : sourceData) {
            Object number = sourceDatum.get("number");
            if (number == null || !existNumbers.contains(number)) continue;
            sourceDatum.put("__exist__", 1);
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
        Map sourceData = e.getSourceData();
        Object exist = sourceData.get("__exist__");
        if (exist != null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5b9e\u7269\u5361\u7247\u5df2\u751f\u6210\u8d22\u52a1\u5361\u7247\uff0c\u4e0d\u80fd\u66f4\u65b0\u6570\u636e\u3002", (String)"FaInitRealCardEditPlugin_3", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        BasedataEdit deptF7 = (BasedataEdit)this.getControl("headusedept");
        DynamicObject assetUnit = (DynamicObject)this.getModel().getValue("assetunit");
        deptF7.addBeforeF7SelectListener(evt -> FaF7DeptUtils.beforeDeptSelect(evt, org, assetUnit));
    }
}

