/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.fa.common.util.ThrowableHelper;
import kd.fi.fa.formplugin.FaFilterList;
import kd.fi.fa.utils.FaFormPermissionUtil;
import kd.fi.fa.utils.FaFormUtils;

public class FaInitRealListPlugin
extends FaFilterList {
    private static final String IS_CLICK_ORG = "isClickOrg";
    private static final String OP_TRACKDOWN_FIN_CARD = "trackdowninitfin";
    private static Log logger = LogFactory.getLog(FaInitRealListPlugin.class);

    @Override
    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        qFilters.add(new QFilter("initialcard", "=", (Object)"1"));
        qFilters.add(new QFilter("originaldata", "=", (Object)Boolean.TRUE));
        if (null == paramMap.get("trackdowninitrealcard")) {
            this.disposeClosePeriod(e);
            this.appendFilter(e);
            if (null != paramMap.get("realCard")) {
                qFilters.add(new QFilter("id", "in", paramMap.get("realCard")));
            }
        }
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs filtercontainerinitargs) {
        Object orgId = this.getView().getFormShowParameter().getCustomParam("initGuide.orgId");
        if (orgId != null) {
            DynamicObject org = QueryServiceHelper.queryOne((String)"bos_org", (String)"fisasset", (QFilter[])new QFilter("id", "=", orgId).toArray());
            boolean isAsset = org.getBoolean("fisasset");
            long assetOrgId = 0L;
            assetOrgId = !isAsset ? OrgUnitServiceHelper.getToOrg((String)"10", (String)"09", (Long)Long.valueOf(orgId.toString()), (boolean)true) : Long.parseLong(orgId.toString());
            if (assetOrgId > 0L) {
                String ASSETUNITNAME = "assetunit.name";
                String ASSETUNIT_ID = "assetunit.id";
                List listFilterColumns = filtercontainerinitargs.getFilterContainerInitEvent().getCommonFilterColumns();
                for (FilterColumn listFilter : listFilterColumns) {
                    CommonFilterColumn commFilter = (CommonFilterColumn)listFilter;
                    String fieldName = commFilter.getFieldName();
                    if (!ASSETUNITNAME.equals(fieldName) && !ASSETUNIT_ID.equals(fieldName)) continue;
                    ComboItem c = new ComboItem();
                    c.setValue(assetOrgId + "");
                    org = QueryServiceHelper.queryOne((String)"bos_org", (String)"name", (QFilter[])new QFilter("id", "=", orgId).toArray());
                    c.setCaption(new LocaleString(org.getString("name")));
                    ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
                    comboItems.add(c);
                    commFilter.setComboItems(comboItems);
                    commFilter.setDefaultValue(assetOrgId + "");
                    commFilter.setDefValue(assetOrgId + "");
                    return;
                }
            }
        }
        try {
            String jsonString = FaFormUtils.linkOrgContainerInit(this.getPageCache(), this.getView(), "assetunit");
            this.getPageCache().put("assetunits", jsonString);
        }
        catch (IOException e) {
            logger.error(ThrowableHelper.toString((Throwable)e));
        }
        FaFormPermissionUtil.filterContainerInitV2(filtercontainerinitargs, this.getPageCache(), this.getView().getPageId());
        if (null != this.getView().getFormShowParameter().getCustomParam("trackDownInitFin") || null != this.getView().getFormShowParameter().getCustomParam("trackdowninitrealcard")) {
            List listFilterColumns = filtercontainerinitargs.getFilterContainerInitEvent().getCommonFilterColumns();
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Map paramMap = formShowParameter.getCustomParams();
            for (FilterColumn listFilter : listFilterColumns) {
                List orgIdList;
                CommonFilterColumn commFilter = (CommonFilterColumn)listFilter;
                String field = commFilter.getFieldName();
                if (!"assetunit.name".equals(field) && !"assetunit.id".equals(field) || (orgIdList = (List)paramMap.get("assetunit")) == null || orgIdList.isEmpty()) continue;
                commFilter.setDefaultValues(orgIdList.stream().map(Object::toString).toArray());
            }
        }
    }

    @Override
    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        SearchClickEvent searchClickEvent = args.getSearchClickEvent();
        Map map = searchClickEvent.getFilterValues();
        List customlist = (List)map.get("customfilter");
        List schemelist = (List)map.get("schemefilter");
        List fastlist = (List)map.get("fastfilter");
        if (customlist != null) {
            if (customlist.size() == 0) {
                return;
            }
            for (int i = 0; i < customlist.size(); ++i) {
                Map map1 = (Map)customlist.get(i);
                List listValue = (List)map1.get("Value");
                List listFieldName = (List)map1.get("FieldName");
                for (int j = 0; j < listFieldName.size(); ++j) {
                    if (!listFieldName.get(j).equals("org.id")) continue;
                    String key = (String)listValue.get(j);
                    this.getPageCache().put("org", key);
                    this.getPageCache().put(IS_CLICK_ORG, "yes");
                }
            }
        } else if (schemelist != null ? schemelist.size() == 0 : fastlist != null && fastlist.size() == 0) {
            return;
        }
    }

    @Override
    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent e) {
        FaFormPermissionUtil.initFilterContainerBeforeF7SelectV2(this.getView().getPageId(), e, "fa_initcard_real");
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "trackdowninitfin": {
                this.showFincardList();
                break;
            }
        }
    }

    private void showFincardList() {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setFormId("bos_list");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        HashSet<String> orgIdList = new HashSet<String>(1);
        ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
        ArrayList<String> finNumberList = new ArrayList<String>(1);
        ArrayList<Long> realCardIdList = new ArrayList<Long>(1);
        for (ListSelectedRow selectedRow : selectedRows) {
            long realCardId = (Long)selectedRow.getPrimaryKeyValue();
            ArrayList<QFilter> filterList = new ArrayList<QFilter>(1);
            filterList.add(new QFilter("id", "in", (Object)realCardId));
            DynamicObject InitRealCard = QueryServiceHelper.queryOne((String)"fa_initcard_real", (String)"id,org,number", (QFilter[])filterList.toArray(new QFilter[0]));
            String orgId = InitRealCard.getString("org");
            orgIdList.add(orgId);
            String finNumber = InitRealCard.getString("number");
            finNumberList.add(finNumber);
            realCardIdList.add(realCardId);
        }
        parameter.getCustomParams().put("finNumber", finNumberList);
        parameter.getCustomParams().put("realCard", realCardIdList);
        parameter.getCustomParams().put("orgId", orgIdList);
        parameter.getCustomParams().put("trackDownInitFin", true);
        QFilter qrealcard = new QFilter("realcard", "in", realCardIdList);
        DynamicObjectCollection fins = QueryServiceHelper.query((String)"fa_initcard_fin", (String)"id", (QFilter[])qrealcard.toArray());
        if (fins.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0b\u6e38\u65e0\u5173\u8054\u8d22\u52a1\u5361\u7247\u3002", (String)"FaInitRealListPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        parameter.setBillFormId("fa_initcard_fin");
        this.getView().showForm((FormShowParameter)parameter);
    }
}

