/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.data.ParameterHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.entity.param.BillParam;
import kd.bos.entity.param.OverallParam;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.utils.FaPermissionUtils;
import kd.fi.fa.common.util.ContextUtil;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.utils.FaFormPermissionUtil;

public class FaInventoryRecordList
extends AbstractListPlugin {
    private static final Log log = LogFactory.getLog(FaInventoryRecordList.class);
    private final Long userId = ContextUtil.getUserId();
    private static final String ASSETUNIT = "realcard.assetunit.name";
    private static final String ASSETUNIT_ID = "realcard.assetunit.id";
    private static final String INVENT_SCHEME = "inventschemeentry.name";
    private static final String BAR_AUDIT = "audit";
    private static final String BAR_ITEM = "baritemap";
    private static final String BAR_EXPORT_LIST = "bar_exportlist";
    public static final String PARAM_INVENTORY_TASK_ID = "inventorytaskid";
    public static final String PARAM_INVENT_ASSET_UNIT_ID = "inventassetunitid";
    public static final String PARAM_INVENT_SCHEMA_ID = "inventschemaid";
    public static final String PARAM_SHOW_AUDIT_BAR = "showAuditBar";

    public void closedCallBack(ClosedCallBackEvent e) {
        if ("scan".equals(e.getActionId())) {
            String refreshOp = (String)e.getReturnData();
            this.getView().invokeOperation("refresh");
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        BillParam billParam = ParameterHelper.getBillParam((String)"fa_inventory_record");
        OverallParam overallParam = billParam.getOverallParam();
        overallParam.setViewBill(true);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObject[] selectDynamicObject;
        super.beforeDoOperation(args);
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        QFilter qfIds = new QFilter("id", "in", (Object)this.getSelectedRows().getPrimaryKeyValues());
        for (DynamicObject selectDO : selectDynamicObject = BusinessDataServiceHelper.load((String)"fa_inventory_record", (String)"inventschemeentry", (QFilter[])new QFilter[]{qfIds})) {
            if (!"C".equals(selectDO.getString("inventschemeentry.billstate"))) continue;
            if (BAR_AUDIT.equals(key)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u76d8\u70b9\u65b9\u6848\u5df2\u5173\u95ed\uff0c\u4e0d\u80fd\u8fdb\u884c\u5ba1\u6838\u3002", (String)"FaInventoryRecordList_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
            if ("unaudit".equals(key)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u76d8\u70b9\u65b9\u6848\u5df2\u5173\u95ed\uff0c\u4e0d\u80fd\u8fdb\u884c\u53cd\u5ba1\u6838\u3002", (String)"FaInventoryRecordList_1", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
            if (!"importdata".equals(key)) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u76d8\u70b9\u65b9\u6848\u5df2\u5173\u95ed\uff0c\u4e0d\u80fd\u8fdb\u884c\u5f15\u5165\u3002", (String)"FaInventoryRecordList_2", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            break;
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "scan": {
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId("fa_inventory_scan_pc");
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "scan");
                formShowParameter.setCloseCallBack(closeCallBack);
                this.getView().showForm(formShowParameter);
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        Object inventorytaskid = this.getView().getFormShowParameter().getCustomParams().get(PARAM_INVENTORY_TASK_ID);
        log.info("\u6b63\u5728\u64cd\u4f5c\u7684\u76d8\u70b9\u4efb\u52a1id\uff1a" + inventorytaskid);
        IAppCache cacheDepreCheck = AppCache.get((String)"fa");
        cacheDepreCheck.put("faInventoryRecordInventorytaskid" + this.userId, inventorytaskid);
        if (inventorytaskid != null) {
            e.getQFilters().add(new QFilter("inventorytask_id", "=", inventorytaskid));
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        this.InventoryfilterContainerInit(args, this.getPageCache());
        this.handleLinkQuery(args);
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent e) {
        super.filterContainerBeforeF7Select(e);
        String field = e.getFieldName();
        if (ASSETUNIT.equals(field)) {
            List orgIds = FaPermissionUtils.getViewPermissionLeafAssetUnitV2((String)this.getView().getPageId(), (String)"fa_inventory_record");
            e.getQfilters().add(new QFilter("id", "in", (Object)orgIds));
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setBarItemVisible();
    }

    private void InventoryfilterContainerInit(FilterContainerInitArgs args, IPageCache pageCache) {
        List listFilterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        String defaultAssetUnitId = "0";
        for (FilterColumn listFilter : listFilterColumns) {
            ArrayList<Object> assetUnitIds;
            CommonFilterColumn commFilter = (CommonFilterColumn)listFilter;
            String fieldName = commFilter.getFieldName();
            FilterContainer source = (FilterContainer)args.getFilterContainerInitEvent().getSource();
            String billFormID = source.getEntityId();
            if (ASSETUNIT.equals(fieldName) || ASSETUNIT_ID.equals(fieldName)) {
                List comboItems = FaPermissionUtils.getAllPermissionAssetUnitCombosV2((String)this.getView().getPageId(), (String)billFormID);
                commFilter.setComboItems(comboItems);
                String pageAssetUnitId = pageCache.get("assetunit");
                defaultAssetUnitId = StringUtils.isNotBlank((CharSequence)pageAssetUnitId) ? pageAssetUnitId : FaFormPermissionUtil.getDefaultId(comboItems);
                pageCache.put("assetunit", defaultAssetUnitId);
                commFilter.setDefaultValue(defaultAssetUnitId);
                commFilter.setDefValue(defaultAssetUnitId);
                commFilter.setMustInput(true);
                continue;
            }
            if (!INVENT_SCHEME.equals(fieldName)) continue;
            ControlFilters controlFilters = this.getControlFilters();
            if (controlFilters != null) {
                assetUnitIds = controlFilters.getFilter(ASSETUNIT_ID);
            } else {
                assetUnitIds = new ArrayList<Object>(10);
                assetUnitIds.add(defaultAssetUnitId);
            }
            List<ComboItem> schemaComboItems = this.getInventSchemaComboItem(assetUnitIds);
            commFilter.setComboItems(schemaComboItems);
        }
    }

    private List<ComboItem> getInventSchemaComboItem(List<Object> assetUnitIds) {
        ArrayList<Long> assetUnits = new ArrayList<Long>(16);
        for (Object id : assetUnitIds) {
            if (id == null) continue;
            assetUnits.add(Long.parseLong(id.toString()));
        }
        if (assetUnits.size() == 0) {
            assetUnits.add(0L);
        }
        QFilter schemaFilter = new QFilter(Fa.dot((String[])new String[]{"entryentity", "assetunit"}), "in", assetUnits);
        String selectFields = Fa.comma((String[])new String[]{"id", "name"});
        DynamicObjectCollection schemaList = QueryServiceHelper.query((String)"fa_inventscheme_new", (String)selectFields, (QFilter[])new QFilter[]{schemaFilter});
        ArrayList<ComboItem> schemaItems = new ArrayList<ComboItem>(10);
        HashSet<Long> ids = new HashSet<Long>();
        for (DynamicObject schema : schemaList) {
            long id = schema.getLong("id");
            if (ids.contains(id)) continue;
            ids.add(id);
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(schema.getString("name")));
            item.setValue(String.valueOf(id));
            schemaItems.add(item);
        }
        return schemaItems;
    }

    private void handleLinkQuery(FilterContainerInitArgs args) {
        DynamicObject assetUnit;
        Map params = this.getView().getFormShowParameter().getCustomParams();
        String assetUnitId = (String)params.get(PARAM_INVENT_ASSET_UNIT_ID);
        String inventSchemaId = (String)params.get(PARAM_INVENT_SCHEMA_ID);
        String assetUnitName = "";
        if (StringUtils.isNotBlank((CharSequence)assetUnitId) && (assetUnit = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(assetUnitId), (String)"bos_org", (String)"name")) != null) {
            assetUnitName = assetUnit.getString("name");
        }
        List listFilterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn listFilter : listFilterColumns) {
            CommonFilterColumn commFilter = (CommonFilterColumn)listFilter;
            String fieldName = commFilter.getFieldName();
            if (ASSETUNIT.equals(fieldName) && StringUtils.isNotBlank((CharSequence)assetUnitId)) {
                ArrayList<ComboItem> items = new ArrayList<ComboItem>(4);
                ComboItem item = new ComboItem();
                item.setValue(assetUnitId);
                item.setCaption(new LocaleString(assetUnitName));
                items.add(item);
                commFilter.setComboItems(items);
                commFilter.setDefaultValue(assetUnitId);
                commFilter.setDefValue(assetUnitId);
                continue;
            }
            if (!INVENT_SCHEME.equals(fieldName) || !StringUtils.isNotBlank((CharSequence)inventSchemaId)) continue;
            if (StringUtils.isNotBlank((CharSequence)assetUnitId)) {
                List<ComboItem> schemaComboItems = this.getInventSchemaComboItem(Collections.singletonList(assetUnitId));
                commFilter.setComboItems(schemaComboItems);
            }
            commFilter.setDefaultValue(inventSchemaId);
            commFilter.setDefValue(inventSchemaId);
        }
    }

    private void setBarItemVisible() {
        Boolean showAudit = (Boolean)this.getView().getFormShowParameter().getCustomParam(PARAM_SHOW_AUDIT_BAR);
        showAudit = showAudit == null ? Boolean.FALSE : showAudit;
        this.getView().setVisible(showAudit, new String[]{BAR_AUDIT, BAR_ITEM});
        this.getView().setVisible(Boolean.valueOf(showAudit == false), new String[]{BAR_EXPORT_LIST});
    }
}

