/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.fa.business.enums.BusyTypeDetailEnum;
import kd.fi.fa.business.utils.FaAssetBookDataUpgradeLogUtils;
import kd.fi.fa.business.utils.FaBizUtils;
import kd.fi.fa.business.utils.FaPermissionUtils;
import kd.fi.fa.business.utils.FaUtils;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.utils.FaFormCurPeriodBizUtils;
import kd.fi.fa.utils.FaQFilter;

public class FaMergeBillEditPlugin
extends AbstractBillPlugIn {
    private static final String OUT_ADD_ROW = "out_add_row";
    private static final String CALL_BACK_REAL_CARD_FORM_OUT = "callBackRealCardFormOut";
    private static final String OUT_TOOL_BAR_AP = "out_toolbarap";
    private static final String CALL_BACK_REAL_CARD_FORM_IN = "callBackRealCardFormIn";
    private static final String IN_CARD_F7_FLAG_CACHE = "inCardF7FlagCache";
    private static final int BATCH_SELECT_NUM = 1999;
    private static final String[] FIELD_ARR = new String[]{"id", "realcard", "currency", "number", "originalval", "accumdepre", "decval", "netamount", "preresidualval", "preusingamount", "assetbook", "depreuse", "isneeddepre", "period", "bizperiod", "endperiod", "monthdepre", "networth", "addupyeardepre", "depremethod", "assetcat", "isdynamic", "monthorigvalchg", "monthdeprechg", "yearorigvalchg"};
    private static final String OUT_ENTRY_DELETE_REAL_CARD_IDS_KEY = "outEntryDeleteRealCardIdsKey";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initValue();
    }

    private void initValue() {
        this.getModel().setValue("type", (Object)"1");
    }

    private void setMergeDate() {
        FaBizUtils.setDate((IFormView)this.getView(), (String)"mergedate", (DateEdit)((DateEdit)this.getControl("mergedate")), (boolean)false, (boolean)this.getView().getFormShowParameter().getStatus().equals((Object)OperationStatus.ADDNEW));
    }

    public void afterBindData(EventObject e) {
        String msg;
        super.afterBindData(e);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"type"});
        DynamicObject mergeBill = this.getModel().getDataEntity();
        DynamicObject org = mergeBill.getDynamicObject("org");
        long orgId = org.getLong("id");
        boolean isNew = this.getView().getFormShowParameter().getStatus().equals((Object)OperationStatus.ADDNEW);
        if (isNew) {
            this.setAssetBook(orgId);
            this.setMergeDate();
        }
        if ((msg = FaBizUtils.checkOrgBookCurPeriodEqual((Long)orgId)) != null) {
            this.getView().showErrorNotification(msg);
        }
    }

    private void setAssetBook(Long orgId) {
        DynamicObject mergeBill = this.getModel().getDataEntity(true);
        if (orgId == null) {
            orgId = mergeBill.getLong(Fa.id((String)"org"));
        }
        List bookList = FaBizUtils.loadAssetBookByOrgOrder((Long)orgId);
        DynamicObjectCollection inEntryEntity = mergeBill.getDynamicObjectCollection("inentryentity");
        inEntryEntity.clear();
        DynamicObject curPeriod = null;
        for (DynamicObject book : bookList) {
            DynamicObject inEntry = inEntryEntity.addNew();
            inEntry.set("indepreuse", (Object)book.getDynamicObject("depreuse"));
            if (curPeriod != null) continue;
            curPeriod = book.getDynamicObject("curperiod");
        }
        this.getModel().setValue("mergeperiod", curPeriod);
        this.getView().updateView("inentryentity");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain", OUT_TOOL_BAR_AP});
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener(this::before7OrgSelect);
        BasedataEdit realCardEdit = (BasedataEdit)this.getView().getControl("realcard");
        realCardEdit.addBeforeF7SelectListener(this::beforeF7RealCardSelect);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        switch (name) {
            case "org": {
                if (changeData != null && changeData.getNewValue() != null) break;
                model.deleteEntryData("inentryentity");
                model.deleteEntryData("outentryentity");
                break;
            }
            case "realcard": {
                this.inCardPropertyChanged(model, changeData);
                break;
            }
        }
    }

    private void inCardPropertyChanged(IDataModel model, ChangeData changeData) {
        if (changeData == null || changeData.getNewValue() == null) {
            this.setInEntryRealDataNull();
            return;
        }
        DynamicObject realDy = (DynamicObject)changeData.getNewValue();
        String f7Flag = this.getView().getPageCache().get(IN_CARD_F7_FLAG_CACHE);
        if (f7Flag == null && realDy != null) {
            String sourceFlag;
            List<String> leaseFlag = Arrays.asList("LEASECONTRACT", "INITLEASECONTRACT");
            if (leaseFlag.contains(sourceFlag = realDy.getString("sourceflag"))) {
                FaUtils.showErrorIsLeaseContractCardMsg((int)1, null, (DynamicObject)realDy, (IFormView)this.getView());
                this.getModel().setValue("realcard", null);
                return;
            }
            HashSet<Long> cardIds = new HashSet<Long>(2);
            cardIds.add(realDy.getLong("id"));
            String msg = FaUtils.checkRealCardBizStatus(cardIds);
            if (!msg.isEmpty()) {
                this.getView().showErrorNotification(msg);
                return;
            }
            Set<Long> existCards = this.checkCard(cardIds);
            if (!existCards.containsAll(cardIds)) {
                FaUtils.showErrorRealCardMsg((int)1, null, (DynamicObject)realDy, (IFormView)this.getView());
                model.setValue("realcard", null);
                this.setInRealCardEntry(null);
                return;
            }
            String dataAssetCardNumber = FaUtils.checkDataAssetRealCard(cardIds);
            if (!dataAssetCardNumber.isEmpty()) {
                String part2 = ResManager.loadKDString((String)"\u5efa\u5361\u65b9\u5f0f\u4e3a\u3010\u6570\u636e\u5361\u7247\u3011\uff0c\u4e0d\u652f\u6301\u505a\u5408\u5e76\u4e1a\u52a1\u3002", (String)"FaMergeBillEditPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]);
                FaUtils.showErrorSourceFlagRealCardMsg((int)dataAssetCardNumber.split(",").length, (String)dataAssetCardNumber, (String)part2, (IFormView)this.getView());
                model.setValue("realcard", null);
                this.setInRealCardEntry(null);
                return;
            }
        }
        this.setInRealCardEntry(realDy);
        this.getView().getPageCache().remove(IN_CARD_F7_FLAG_CACHE);
    }

    private void setInEntryRealDataNull() {
        IDataModel model = this.getModel();
        int count = model.getEntryRowCount("inentryentity");
        for (int i = 0; i < count; ++i) {
            model.setValue("inrealcard", null, i);
            model.setValue("inrealunit", null, i);
            model.setValue("inrealamount", null, i);
            model.setValue("inrealcardmasterid", null, i);
        }
        this.getView().updateView("inentryentity");
    }

    private Set<Long> checkCard(Set<Long> cardIds) {
        Date date = (Date)this.getModel().getValue("mergedate");
        long orgId = (Long)this.getModel().getValue(Fa.id((String)"org"));
        boolean enableCurPeriodBiz = FaAssetBookDataUpgradeLogUtils.enableCurPeriodSplit((Long)orgId);
        return FaUtils.getCurRealCard((Date)date, (Long)orgId, (Boolean)(!enableCurPeriodBiz ? 1 : 0), cardIds, (BusyTypeDetailEnum)BusyTypeDetailEnum.REAL_FIN_CHG, null);
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        String entryName = e.getEntryProp().getName();
        if (entryName.equals("outentryentity")) {
            this.setBefDeleteCardPKsCache(e.getRowIndexs());
        }
    }

    private void setBefDeleteCardPKsCache(int[] rows) {
        if (rows == null || rows.length == 0) {
            return;
        }
        HashSet<Object> realCardIds = new HashSet<Object>();
        IDataModel model = this.getModel();
        for (int i : rows) {
            DynamicObject realCard = (DynamicObject)model.getValue("outrealcard", i);
            if (realCard == null) continue;
            realCardIds.add(realCard.getPkValue());
        }
        String ids = SerializationUtils.toJsonString(realCardIds);
        this.getPageCache().put(OUT_ENTRY_DELETE_REAL_CARD_IDS_KEY, ids);
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        String entryName = e.getEntryProp().getName();
        if (entryName.equals("outentryentity")) {
            this.afterDeleteRelateCardRow();
        }
        this.updateInEntryInFinData();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FaFormCurPeriodBizUtils.showGuideConfirm4EditView(args, this.getView(), "fa_mergebill", (IFormPlugin)this);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        FaFormCurPeriodBizUtils.guideConfirmCallBack(messageBoxClosedEvent, this.getView());
    }

    private void afterDeleteRelateCardRow() {
        if (this.getPageCache().get(OUT_ENTRY_DELETE_REAL_CARD_IDS_KEY) == null) {
            return;
        }
        Set realCardIds = (Set)SerializationUtils.fromJsonString((String)this.getPageCache().get(OUT_ENTRY_DELETE_REAL_CARD_IDS_KEY), Set.class);
        Set<String> ids = realCardIds.stream().map(Object::toString).collect(Collectors.toSet());
        this.removeOldRows(ids);
    }

    public void removeOldRows(Set<String> values) {
        if (values == null || values.isEmpty()) {
            return;
        }
        IDataModel model = this.getModel();
        DynamicObject mergeBill = model.getDataEntity(true);
        DynamicObjectCollection inEntry = mergeBill.getDynamicObjectCollection("inentryentity");
        for (DynamicObject in : inEntry) {
            DynamicObjectCollection outEntry = in.getDynamicObjectCollection("outentryentity");
            Iterator iterator = outEntry.iterator();
            while (iterator.hasNext()) {
                DynamicObject out = (DynamicObject)iterator.next();
                String id = out.getString("OUTREALCARDMASTERID");
                if (!values.contains(id)) continue;
                iterator.remove();
            }
        }
    }

    private void setInRealCardEntry(DynamicObject realDy) {
        IDataModel model = this.getModel();
        if (realDy == null) {
            this.setInEntryRealDataNull();
            return;
        }
        HashSet<Object> realCardPKSet = new HashSet<Object>();
        realCardPKSet.add(realDy.getPkValue());
        List finCardLst = FaUtils.queryFinCards(realCardPKSet);
        LinkedHashMap<Long, DynamicObject> finCardMap = new LinkedHashMap<Long, DynamicObject>(finCardLst.size());
        for (DynamicObject finCard : finCardLst) {
            Long depreUseId = finCard.getLong(Fa.id((String)"depreuse"));
            finCardMap.put(depreUseId, finCard);
        }
        DynamicObject mergeBill = this.getModel().getDataEntity(true);
        DynamicObjectCollection inEntryEntity = mergeBill.getDynamicObjectCollection("inentryentity");
        model.beginInit();
        for (int i = 0; i < inEntryEntity.size(); ++i) {
            DynamicObject inEntry = (DynamicObject)inEntryEntity.get(i);
            long depreUseId = inEntry.getLong(Fa.id((String)"indepreuse"));
            model.setValue("inrealcard", (Object)realDy, i);
            model.setValue("inrealcardbak", (Object)realDy, i);
            model.setValue("inrealunit", (Object)realDy.getDynamicObject("unit"), i);
            model.setValue("inrealamount", (Object)0, i);
            DynamicObject finCard = (DynamicObject)finCardMap.get(depreUseId);
            if (finCard == null) continue;
            model.setValue("infincard", (Object)finCard, i);
            model.setValue("inbasecurrency", (Object)finCard.getDynamicObject(Fa.dot((String[])new String[]{"assetbook", "basecurrency"})), i);
            model.setValue("indepredamount", (Object)0, i);
            model.setValue("inrealcardmasterid", (Object)realDy.getLong("masterid"), i);
        }
        model.endInit();
        this.updateInEntryInFinData();
    }

    private void before7OrgSelect(BeforeF7SelectEvent evt) {
        List orgIds = FaPermissionUtils.getAllEnableBookAndPermissionOrgsV2((String)this.getView().getPageId(), (String)"fa_mergebill");
        List filters = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().getQFilters();
        filters.add(new QFilter("id", "in", (Object)orgIds));
    }

    private void beforeF7RealCardSelect(BeforeF7SelectEvent evt) {
        evt.getFormShowParameter().setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALL_BACK_REAL_CARD_FORM_IN));
        DynamicObject mergeBill = this.getModel().getDataEntity();
        Long orgId = mergeBill.getLong(Fa.id((String)"org"));
        DynamicObject mainBook = FaUtils.getMainBookByOrg((Long)orgId);
        if (mainBook == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u4e3b\u8d26\u7c3f", (String)"FaMergeBillEditPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        FaQFilter.realCardQFilter(this.getModel(), evt);
        ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
        List filters = param.getListFilterParameter().getQFilters();
        filters.add(this.getSelectCardFilter());
    }

    private QFilter getSelectCardFilter() {
        IDataModel model = this.getModel();
        DynamicObject mergeBill = model.getDataEntity();
        HashSet<Object> realCardIds = new HashSet<Object>();
        DynamicObject realCard = mergeBill.getDynamicObject("realcard");
        if (realCard != null) {
            realCardIds.add(realCard.getPkValue());
        }
        realCardIds.addAll(this.getOutEntryReadCardIds());
        return new QFilter("id", "not in", realCardIds);
    }

    public void itemClick(ItemClickEvent evt) {
        if (OUT_ADD_ROW.equals(evt.getItemKey())) {
            this.showRealCard();
        }
    }

    private void showRealCard() {
        ListShowParameter para = ShowFormHelper.createShowListForm((String)"fa_card_real_base", (boolean)true);
        para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALL_BACK_REAL_CARD_FORM_OUT));
        List<QFilter> filterList = this.getSelectFilter();
        if (!filterList.isEmpty()) {
            para.setListFilterParameter(new ListFilterParameter(filterList, null));
        }
        para.setHasRight(true);
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setFormId("fa_realcard_listf7");
        this.getView().showForm((FormShowParameter)para);
    }

    private List<QFilter> getSelectFilter() {
        IDataModel model = this.getModel();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        HashSet<Object> realCardIds = new HashSet<Object>();
        DynamicObject mergeBill = model.getDataEntity(true);
        DynamicObject realCard = mergeBill.getDynamicObject("realcard");
        if (realCard != null) {
            realCardIds.add(realCard.getPkValue());
        }
        Set<Object> outRealCardIds = this.getOutEntryReadCardIds();
        realCardIds.addAll(outRealCardIds);
        if (!realCardIds.isEmpty()) {
            qFilters.add(new QFilter("id", "not in", realCardIds));
        }
        long orgId = mergeBill.getLong(Fa.id((String)"org"));
        qFilters.add(new QFilter("org", "=", (Object)orgId));
        FaQFilter.realCardF7CommonFilter(qFilters, orgId, "fa_mergebill");
        return qFilters;
    }

    private Set<Object> getOutEntryReadCardIds() {
        HashSet<Object> realCardIds = new HashSet<Object>();
        DynamicObject mergeBill = this.getModel().getDataEntity(true);
        DynamicObjectCollection inEntity = mergeBill.getDynamicObjectCollection("inentryentity");
        if (!inEntity.isEmpty()) {
            DynamicObject mainBookEntry = (DynamicObject)inEntity.get(0);
            DynamicObjectCollection outEntity = mainBookEntry.getDynamicObjectCollection("outentryentity");
            for (DynamicObject outEntry : outEntity) {
                DynamicObject outRealCard = outEntry.getDynamicObject("outrealcard");
                if (outRealCard == null) continue;
                realCardIds.add(outRealCard.getPkValue());
            }
        }
        return realCardIds;
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        ListSelectedRowCollection returnDataList;
        super.closedCallBack(evt);
        Object returnData = evt.getReturnData();
        if (returnData instanceof ListSelectedRowCollection && !(returnDataList = (ListSelectedRowCollection)returnData).isEmpty()) {
            if (StringUtils.equalsIgnoreCase((CharSequence)evt.getActionId(), (CharSequence)CALL_BACK_REAL_CARD_FORM_OUT)) {
                List<Long> realCardIds = this.getReturnCardIds(returnDataList);
                this.insertSelectRow(realCardIds);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)evt.getActionId(), (CharSequence)CALL_BACK_REAL_CARD_FORM_IN)) {
                this.getView().getPageCache().put(IN_CARD_F7_FLAG_CACHE, "1");
                this.getModel().setValue("realcard", (Object)this.getReturnCardIds(returnDataList).get(0));
            }
        }
    }

    private List<Long> getReturnCardIds(ListSelectedRowCollection selectList) {
        ArrayList<Long> realCardIds = new ArrayList<Long>();
        for (ListSelectedRow row : selectList) {
            realCardIds.add((Long)row.getPrimaryKeyValue());
        }
        return realCardIds;
    }

    private void insertSelectRow(List<Long> realCardIds) {
        if (!realCardIds.isEmpty()) {
            Map<Long, DynamicObject> realCardsMap = this.queryRealCardMap(realCardIds, "fa_card_real");
            ArrayList<DynamicObject> finCards = new ArrayList<DynamicObject>(realCardIds.size());
            long orgId = this.getModel().getDataEntity().getLong(Fa.id((String)"org"));
            List allAssetBooks = FaBizUtils.loadAssetBookByOrgOrder((Long)orgId);
            HashMap<Long, Long> depreUser2CurPeriodMap = new HashMap<Long, Long>(allAssetBooks.size());
            for (DynamicObject assetBook : allAssetBooks) {
                depreUser2CurPeriodMap.putIfAbsent(assetBook.getLong(Fa.id((String)"depreuse")), assetBook.getLong(Fa.id((String)"curperiod")));
            }
            Map<Long, Map<Long, DynamicObject>> finCardsMap = this.getFinCardByReal(realCardIds, finCards, allAssetBooks);
            Map<Long, DynamicObject> realBaseCardsMap = this.queryRealCardMap(realCardIds, "fa_card_real_base");
            Map<Long, Map<Long, DynamicObject>> finBaseCardsMap = this.queryFinBaseCardMap(finCards);
            IDataModel model = this.getModel();
            DynamicObject mergeBill = model.getDataEntity(true);
            DynamicObjectCollection inEntryEntity = mergeBill.getDynamicObjectCollection("inentryentity");
            for (int i = 0; i < inEntryEntity.size(); ++i) {
                this.insertOutEntryData(realCardIds, realCardsMap, depreUser2CurPeriodMap, finCardsMap, realBaseCardsMap, finBaseCardsMap, model, inEntryEntity, i);
            }
            this.updateInEntryInFinData();
        }
    }

    private void insertOutEntryData(List<Long> realCardIds, Map<Long, DynamicObject> realCardsMap, Map<Long, Long> depreUser2CurPeriodMap, Map<Long, Map<Long, DynamicObject>> finCardsMap, Map<Long, DynamicObject> realBaseCardsMap, Map<Long, Map<Long, DynamicObject>> finBaseCardsMap, IDataModel model, DynamicObjectCollection inEntryEntity, int i) {
        model.setEntryCurrentRowIndex("inentryentity", i);
        model.beginInit();
        DynamicObject inEntry = (DynamicObject)inEntryEntity.get(i);
        DynamicObject depreUse = inEntry.getDynamicObject("indepreuse");
        Long depreUseId = depreUse.getLong("id");
        long curPeriodId = depreUser2CurPeriodMap.get(depreUseId);
        DynamicObjectCollection outEntryEntity = inEntry.getDynamicObjectCollection("outentryentity");
        this.removeNullEntry(outEntryEntity);
        int outStartIndex = outEntryEntity.size();
        model.batchCreateNewEntryRow("outentryentity", realCardIds.size());
        DynamicObjectCollection newEntryEntity = model.getEntryEntity("outentryentity");
        Map<Long, DynamicObject> real2FinCardMap = finCardsMap.get(depreUseId);
        Map<Long, DynamicObject> real2FinBaseCardMap = finBaseCardsMap.get(depreUseId);
        if (real2FinCardMap == null || real2FinBaseCardMap == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8f6c\u5165\u5361\u7247\u6298\u65e7\u7528\u9014\u4e0e\u8f6c\u51fa\u5361\u7247\u6298\u65e7\u7528\u9014\u4e0d\u4e00\u81f4\uff0c\u6682\u4e0d\u652f\u6301\u5408\u5e76\u3002", (String)"FaMergeBillEditPlugin_2", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        for (Long realCardId : realCardIds) {
            DynamicObject realCard = realCardsMap.get(realCardId);
            DynamicObject realBaseCard = realBaseCardsMap.get(realCardId);
            DynamicObject finCard = real2FinCardMap.get(realCardId);
            DynamicObject finBaseCard = real2FinBaseCardMap.get(realCardId);
            DynamicObject outEntry = (DynamicObject)newEntryEntity.get(outStartIndex++);
            outEntry.set("outdepreuse", (Object)depreUse);
            outEntry.set("outrealcard", (Object)realBaseCard);
            outEntry.set("OUTREALCARDMASTERID", (Object)realCard.getLong("masterid"));
            if (finCard == null || finBaseCard == null) continue;
            outEntry.set("outbasecurrency", (Object)finBaseCard.getDynamicObject("basecurrency"));
            outEntry.set("outfincard", (Object)finBaseCard);
            BigDecimal originalVal = finCard.getBigDecimal("originalval");
            outEntry.set("outoriginalval", (Object)originalVal);
            BigDecimal accumDepre = finCard.getBigDecimal("accumdepre");
            long bizPeriodId = finCard.getLong(Fa.id((String)"bizperiod"));
            if (curPeriodId == bizPeriodId) {
                BigDecimal monthDepre = finCard.getBigDecimal("monthdepre");
                accumDepre = accumDepre.subtract(monthDepre);
            }
            outEntry.set("outaccumdepre", (Object)accumDepre);
            BigDecimal decVal = finCard.getBigDecimal("decval");
            outEntry.set("outdecval", (Object)decVal);
            BigDecimal preResidualVal = finCard.getBigDecimal("preresidualval");
            outEntry.set("outpreresidualval", (Object)preResidualVal);
        }
        model.endInit();
    }

    private void updateInEntryInFinData() {
        IDataModel model = this.getModel();
        DynamicObject mergeBill = model.getDataEntity(true);
        DynamicObjectCollection inEntry = mergeBill.getDynamicObjectCollection("inentryentity");
        if (inEntry.isEmpty()) {
            return;
        }
        for (DynamicObject in : inEntry) {
            DynamicObjectCollection outEntry = in.getDynamicObjectCollection("outentryentity");
            BigDecimal originalVal = BigDecimal.ZERO;
            BigDecimal accumDepre = BigDecimal.ZERO;
            BigDecimal decVal = BigDecimal.ZERO;
            BigDecimal preResidualVal = BigDecimal.ZERO;
            for (DynamicObject out : outEntry) {
                originalVal = originalVal.add(out.getBigDecimal("outoriginalval"));
                accumDepre = accumDepre.add(out.getBigDecimal("outaccumdepre"));
                decVal = decVal.add(out.getBigDecimal("outdecval"));
                preResidualVal = preResidualVal.add(out.getBigDecimal("outpreresidualval"));
            }
            in.set("inoriginalval", (Object)originalVal);
            in.set("inaccumdepre", (Object)accumDepre);
            in.set("indecval", (Object)decVal);
            in.set("inpreresidualval", (Object)preResidualVal);
        }
        this.getView().updateView("inentryentity");
    }

    private void removeNullEntry(DynamicObjectCollection outEntryEntity) {
        if (outEntryEntity == null || outEntryEntity.isEmpty()) {
            return;
        }
        Iterator iterator = outEntryEntity.iterator();
        while (iterator.hasNext()) {
            DynamicObject outEntry = (DynamicObject)iterator.next();
            DynamicObject outRealCard = outEntry.getDynamicObject("outrealcard");
            if (outRealCard != null) continue;
            iterator.remove();
        }
    }

    private Map<Long, DynamicObject> queryRealCardMap(List<Long> realCardPKSet, String entryName) {
        HashSet<Long> realCardPKTemp = new HashSet<Long>(FaUtils.getInitialCapacity43((int)realCardPKSet.size()));
        int i = 0;
        HashMap<Long, DynamicObject> realCardMap = new HashMap<Long, DynamicObject>(realCardPKSet.size());
        for (Long realCardPK : realCardPKSet) {
            if (i == 1999) {
                this.loadCard(entryName, realCardPKTemp, realCardMap);
                i = 0;
            } else {
                ++i;
            }
            realCardPKTemp.add(realCardPK);
        }
        if (!realCardPKTemp.isEmpty()) {
            this.loadCard(entryName, realCardPKTemp, realCardMap);
        }
        return realCardMap;
    }

    private void loadCard(String entryName, Set<Long> realCardPKTemp, Map<Long, DynamicObject> realCardMap) {
        DynamicObject[] realCards;
        for (DynamicObject realCard : realCards = BusinessDataServiceHelper.load((Object[])realCardPKTemp.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entryName))) {
            Long realCardId = realCard.getLong("id");
            realCardMap.put(realCardId, realCard);
        }
        realCardPKTemp.clear();
    }

    private Map<Long, Map<Long, DynamicObject>> queryFinBaseCardMap(List<DynamicObject> finCardList) {
        HashSet<Long> finCardIdTemp = new HashSet<Long>(FaUtils.getInitialCapacity43((int)finCardList.size()));
        int i = 0;
        HashMap<Long, Map<Long, DynamicObject>> depreUse2Real2FinCard = new HashMap<Long, Map<Long, DynamicObject>>(4);
        for (DynamicObject finCard : finCardList) {
            if (i == 1999) {
                this.loadFin(finCardList, finCardIdTemp, depreUse2Real2FinCard);
                i = 0;
            } else {
                ++i;
            }
            finCardIdTemp.add(finCard.getLong("id"));
        }
        if (!finCardIdTemp.isEmpty()) {
            this.loadFin(finCardList, finCardIdTemp, depreUse2Real2FinCard);
        }
        return depreUse2Real2FinCard;
    }

    private void loadFin(List<DynamicObject> finCardList, Set<Long> finCardIdTemp, Map<Long, Map<Long, DynamicObject>> depreUse2Real2FinCard) {
        DynamicObject[] refFinBaseCards;
        for (DynamicObject finBaseCard : refFinBaseCards = BusinessDataServiceHelper.load((Object[])finCardIdTemp.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fa_card_fin_base"))) {
            Long realCardId = finBaseCard.getLong(Fa.id((String)"realcard"));
            Long depreUseId = finBaseCard.getLong(Fa.id((String)"depreuse"));
            Map<Long, DynamicObject> real2FinCardMap = depreUse2Real2FinCard.get(depreUseId);
            if (real2FinCardMap == null) {
                real2FinCardMap = new HashMap<Long, DynamicObject>(finCardList.size());
            }
            real2FinCardMap.putIfAbsent(realCardId, finBaseCard);
            depreUse2Real2FinCard.put(depreUseId, real2FinCardMap);
        }
        finCardIdTemp.clear();
    }

    private Map<Long, Map<Long, DynamicObject>> getFinCardByReal(List<Long> realCardIds, List<DynamicObject> finCardList, List<DynamicObject> allAssetBooks) {
        finCardList.addAll(this.queryFinCardList(realCardIds, allAssetBooks));
        HashMap<Long, Map<Long, DynamicObject>> depreUse2Real2FinCard = new HashMap<Long, Map<Long, DynamicObject>>(4);
        for (DynamicObject finCard : finCardList) {
            Long realCardId = finCard.getLong(Fa.id((String)"realcard"));
            Long depreUseId = finCard.getLong(Fa.id((String)"depreuse"));
            HashMap<Long, DynamicObject> real2FinCardMap = (HashMap<Long, DynamicObject>)depreUse2Real2FinCard.get(depreUseId);
            if (real2FinCardMap == null) {
                real2FinCardMap = new HashMap<Long, DynamicObject>(realCardIds.size());
            }
            real2FinCardMap.putIfAbsent(realCardId, finCard);
            depreUse2Real2FinCard.put(depreUseId, real2FinCardMap);
        }
        return depreUse2Real2FinCard;
    }

    private List<DynamicObject> queryFinCardList(List<Long> realCardIds, List<DynamicObject> allAssetBooks) {
        HashSet<String> fieldSet = new HashSet<String>(Arrays.asList(FIELD_ARR));
        HashMap<Long, DynamicObject> bookMap = new HashMap<Long, DynamicObject>(2);
        for (DynamicObject assetBook : allAssetBooks) {
            bookMap.put(assetBook.getLong("id"), assetBook);
        }
        String selector = String.join((CharSequence)",", fieldSet);
        ArrayList<DynamicObject> reFinCards = new ArrayList<DynamicObject>(realCardIds.size());
        HashSet<Long> realCardIdTemp = new HashSet<Long>(FaUtils.getInitialCapacity43((int)reFinCards.size()));
        int i = 0;
        for (Long realCardPK : realCardIds) {
            if (i == 1999) {
                this.loadCurPeriodFins(bookMap, selector, reFinCards, realCardIdTemp);
                i = 0;
            } else {
                ++i;
            }
            realCardIdTemp.add(realCardPK);
        }
        if (!realCardIdTemp.isEmpty()) {
            this.loadCurPeriodFins(bookMap, selector, reFinCards, realCardIdTemp);
        }
        return reFinCards;
    }

    private void loadCurPeriodFins(Map<Long, DynamicObject> bookMap, String selector, List<DynamicObject> reFinCards, Set<Long> realCardIdTemp) {
        DynamicObject[] finCards;
        QFilter[] filters = new QFilter[]{new QFilter("realcard", "in", realCardIdTemp)};
        for (DynamicObject finCard : finCards = BusinessDataServiceHelper.load((String)"fa_card_fin", (String)selector, (QFilter[])filters, null)) {
            DynamicObject assetBook = bookMap.get(finCard.getLong(Fa.id((String)"assetbook")));
            boolean isRight = FaUtils.filterFinCards((long)assetBook.getLong(Fa.id((String)"curperiod")), (DynamicObject)finCard);
            if (!isRight) continue;
            reFinCards.add(finCard);
        }
        realCardIdTemp.clear();
    }
}

