/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin;

import java.util.Date;
import java.util.EventObject;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.validate.BillStatus;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.enums.lease.TransitionPlan;
import kd.fi.fa.business.utils.FaBillParamUtils;

public class FaParamEditPlugin
extends AbstractFormPlugin {
    private static final String PARENT_VIEW_ORG = "orgfield";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setIsDeductVatDiscountEnable();
        this.setFirstExecDayEnable();
        this.setDailyDiscountRateEnable();
        boolean newCustomerChaneEmpty = FaBillParamUtils.getBooleanValue(null, null, null, (String)"newCustomerChaneEmpty");
        if (newCustomerChaneEmpty) {
            this.getModel().setValue("change_nothing", (Object)newCustomerChaneEmpty);
        }
    }

    private void setIsDeductVatDiscountEnable() {
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        DynamicObject org = (DynamicObject)parentView.getModel().getValue(PARENT_VIEW_ORG);
        if (org == null) {
            return;
        }
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", org.getPkValue()), new QFilter("status", "!=", (Object)BillStatus.A)};
        boolean exists = QueryServiceHelper.exists((String)"fa_lease_contract", (QFilter[])filters);
        this.getView().setEnable(Boolean.valueOf(!exists), new String[]{"is_deduct_vat_discount"});
    }

    private void setFirstExecDayEnable() {
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        DynamicObject org = (DynamicObject)parentView.getModel().getValue(PARENT_VIEW_ORG);
        if (org == null) {
            return;
        }
        Set transitionPlanSet = Stream.of(TransitionPlan.values()).map(Enum::name).collect(Collectors.toSet());
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", org.getPkValue()), new QFilter("transitionplan", "in", transitionPlanSet)};
        boolean exists = QueryServiceHelper.exists((String)"fa_lease_contract", (QFilter[])filters);
        this.getView().setEnable(Boolean.valueOf(!exists), new String[]{"firstexecday"});
    }

    private void setDailyDiscountRateEnable() {
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        DynamicObject org = (DynamicObject)parentView.getModel().getValue(PARENT_VIEW_ORG);
        if (org == null) {
            return;
        }
        QFilter filter = new QFilter("org", "=", org.getPkValue());
        boolean exists = QueryServiceHelper.exists((String)"fa_lease_contract", (QFilter[])filter.toArray());
        this.getView().setEnable(Boolean.valueOf(!exists), new String[]{"dailydiscountrateformula"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Date sysSwitchDayNew;
        IFormView parentView;
        DynamicObject org;
        Date sysSwitchDay;
        String name = e.getProperty().getName();
        if ("systemswitchday".equals(name) && (sysSwitchDay = this.getSysSwitchDay4InitLease(org = (DynamicObject)(parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId())).getModel().getValue(PARENT_VIEW_ORG))) != null && sysSwitchDay.compareTo(sysSwitchDayNew = (Date)e.getChangeSet()[0].getNewValue()) != 0) {
            this.getModel().setValue("systemswitchday", (Object)sysSwitchDay);
            this.getView().setEnable(Boolean.FALSE, new String[]{"systemswitchday"});
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u5df2\u5b58\u5728\u521d\u59cb\u5316\u79df\u8d41\u5408\u540c\uff0c\u7cfb\u7edf\u5207\u6362\u65e5\u4e0d\u80fd\u4fee\u6539\u3002", (String)"FaParamEditPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
    }

    private Date getSysSwitchDay4InitLease(DynamicObject org) {
        QFilter[] leaseFilters = new QFilter[]{new QFilter("org", "=", org.getPkValue()), new QFilter("sourcetype", "=", (Object)"B")};
        DynamicObject leaseContractInit = QueryServiceHelper.queryOne((String)"fa_lease_contract", (String)"sysswitchdate", (QFilter[])leaseFilters);
        if (leaseContractInit != null) {
            return leaseContractInit.getDate("sysswitchdate");
        }
        return null;
    }
}

