/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin;

import java.io.IOException;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.validate.BillStatus;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.ListColumnCompareTypesSetEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListColumnCompareType;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.fi.fa.business.SourceFlagEnum;
import kd.fi.fa.business.dao.impl.FaDaoOrmImpl;
import kd.fi.fa.business.utils.FaBillParamUtils;
import kd.fi.fa.common.util.ThrowableHelper;
import kd.fi.fa.utils.FaFormPermissionUtil;
import kd.fi.fa.utils.FaFormUtils;

public class FaRecardFilterList
extends AbstractListPlugin {
    private static Log logger = LogFactory.getLog(FaRecardFilterList.class);
    private static final String NEWADD = "new";
    private static final String NEWJUSTREALCARD = "newjustrealcard";
    private static final String BATCH_NEW = "batch_new";
    private static final String BATCH_COPY = "batch_copy";
    private static final String SUCCESSIDS = "successIds";
    private static final String LINKQUERY = "linkQuery";
    private static Map<String, QFilter> filterMap = new HashMap<String, QFilter>();

    private void showBatchNewForm() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("fa_card_real_batch_ent");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), BATCH_NEW));
        this.getView().showForm(parameter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        IPageCache pageCache;
        super.beforeDoOperation(args);
        if (NEWJUSTREALCARD.equals(((AbstractOperate)args.getSource()).getOperateKey())) {
            pageCache = this.getPageCache();
            pageCache.put(NEWJUSTREALCARD, NEWJUSTREALCARD);
            pageCache.remove("construction");
        }
        if (NEWADD.equals(((AbstractOperate)args.getSource()).getOperateKey())) {
            pageCache = this.getPageCache();
            pageCache.remove(NEWJUSTREALCARD);
            pageCache.remove("construction");
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String key = afterDoOperationEventArgs.getOperateKey();
        if (BATCH_NEW.equals(key)) {
            this.showBatchNewForm();
        }
    }

    public void setFilter(SetFilterEvent e) {
        FormShowParameter formShowParameter;
        Map paramMap;
        String billFormId = ((BillList)e.getSource()).getEntityId();
        if ("fa_asset_card".equals(billFormId) || "fa_asset_initcard".equals(billFormId)) {
            billFormId = "fa_card_real";
        }
        if (null == (paramMap = (formShowParameter = this.getView().getFormShowParameter()).getCustomParams()).get("trackdowninitrealcard")) {
            QFilter defaultFilter = this.getDefaultFilter(billFormId);
            if (defaultFilter != null) {
                List qFilters = e.getQFilters();
                qFilters.add(defaultFilter);
            }
            this.disposeClosePeriod(e);
            String orderBy = "realaccountdate DESC";
            e.setOrderBy(orderBy);
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        String limitFilterKeys = FaBillParamUtils.getStringValue(null, null, (String)"fa_card_real", (String)"list.limit.filter", (boolean)false);
        e.getFormShowParameter().getCustomParams().put("list.limit.filter", limitFilterKeys);
    }

    public void listColumnCompareTypesSet(ListColumnCompareTypesSetEvent args) {
        String limitFilterKeys;
        super.listColumnCompareTypesSet(args);
        String colKey = args.getListFieldKey();
        if ("bizstatus".equals(colKey)) {
            List comboItems = args.getComboItems();
            comboItems.removeIf(next -> !next.isItemVisible());
        }
        if (StringUtils.isEmpty((CharSequence)(limitFilterKeys = (String)this.getView().getFormShowParameter().getCustomParam("list.limit.filter")))) {
            return;
        }
        String[] split = limitFilterKeys.split(",");
        Set fieldSet = Arrays.stream(split).collect(Collectors.toSet());
        if (fieldSet.contains(colKey)) {
            Iterator filterItemIt = args.getListColumnCompareTypes().iterator();
            while (filterItemIt.hasNext()) {
                ListColumnCompareType filterItem = (ListColumnCompareType)filterItemIt.next();
                String id = filterItem.getId();
                if ("67".equals(id) || "60".equals(id)) continue;
                filterItemIt.remove();
            }
        }
    }

    private void disposeClosePeriod(SetFilterEvent e) {
        String filterStr;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.get("filter") != null && StringUtils.isNotBlank((CharSequence)(filterStr = (String)customParams.get("filter")))) {
            QFilter filter = QFilter.fromSerializedString((String)filterStr);
            e.getQFilters().clear();
            e.getQFilters().add(filter);
        }
    }

    private QFilter getDefaultFilter(String billFormId) {
        FormShowParameter parentViewParams;
        String sourcePage;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (null != customParams.get("bos_call_source_type") && "botp_track".equals(customParams.get("bos_call_source_type"))) {
            return null;
        }
        String parentFormId = this.getView().getFormShowParameter().getParentFormId();
        if ("gl_vchralt_form".equals(parentFormId)) {
            return null;
        }
        IFormView viewNoPlugin = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (viewNoPlugin != null && "bpm_billrelation_graph".equals(sourcePage = (parentViewParams = viewNoPlugin.getFormShowParameter()).getFormId())) {
            return null;
        }
        return filterMap.get(billFormId);
    }

    private static QFilter and(QFilter a, QFilter b) {
        return a.and(b);
    }

    public void filterContainerInit(FilterContainerInitArgs filtercontainerinitargs) {
        super.filterContainerInit(filtercontainerinitargs);
        try {
            String jsonString = FaFormUtils.linkOrgContainerInit(this.getPageCache(), this.getView(), "assetunit");
            this.getPageCache().put("assetunits", jsonString);
        }
        catch (IOException e) {
            logger.error(ThrowableHelper.toString((Throwable)e));
        }
        FaFormPermissionUtil.filterContainerInitV2(filtercontainerinitargs, this.getPageCache(), this.getView().getPageId());
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        FaFormPermissionUtil.filterContainerSearchClick(args, this.getPageCache());
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent e) {
        super.filterContainerBeforeF7Select(e);
        FaFormPermissionUtil.filterContainerBeforeF7SelectV2(e, this.getView().getPageId(), "fa_card_real");
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if (BATCH_NEW.equals(actionId)) {
            Map returnData = (Map)evt.getReturnData();
            if (returnData == null) {
                return;
            }
            Object realCard = returnData.get("realCardId");
            if (realCard == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u590d\u5236\u7684\u5b9e\u7269\u5361\u7247\u4fe1\u606f\u4e22\u5931\u3002", (String)"FaRecardFilterList_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                return;
            }
            Long realCardId = Long.valueOf(realCard.toString());
            Object copy = returnData.get("copy");
            Object batchCopy = returnData.get("batchCopy");
            if (copy != null && Boolean.parseBoolean(copy.toString())) {
                this.showCopyRealCardForm(realCardId);
            } else if (batchCopy != null && Boolean.parseBoolean(batchCopy.toString())) {
                this.showBatchNewForm(realCardId);
            }
        } else if (BATCH_COPY.equals(actionId)) {
            Map returnData = (Map)evt.getReturnData();
            if (returnData == null) {
                return;
            }
            Object successIds = returnData.get(SUCCESSIDS);
            if (successIds != null) {
                this.getPageCache().put(SUCCESSIDS, SerializationUtils.serializeToBase64((Object)((List)successIds)));
                this.getView().showConfirm(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\uff0c\u662f\u5426\u8054\u67e5\u65b0\u589e\u7684\u5b9e\u7269\u5361\u7247?", (String)"FaRecardFilterList_1", (String)"fi-fa-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(LINKQUERY, (IFormPlugin)this));
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String result;
        super.confirmCallBack(evt);
        String key = evt.getCallBackId();
        if (LINKQUERY.equals(key) && "Yes".equals(result = evt.getResultValue())) {
            String successIdsStr = this.getPageCache().get(SUCCESSIDS);
            this.getPageCache().remove(SUCCESSIDS);
            if (successIdsStr != null) {
                List successIds = (List)SerializationUtils.deSerializeFromBase64((String)successIdsStr);
                this.showNewRealCardList(successIds);
            }
        }
    }

    private void showCopyRealCardForm(Long realCardId) {
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId("fa_card_real");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setBillStatus(BillOperationStatus.ADDNEW);
        parameter.getOpenStyle().setTargetKey("realcard");
        parameter.setCustomParam("CopyEmptyRow -> false", (Object)false);
        parameter.setCustomParam("skipCheckFieldRule", (Object)true);
        parameter.setCustomParam("isCopyRelateEntity", (Object)false);
        parameter.setCustomParam("iscopy", (Object)true);
        parameter.setCustomParam("sourceFlag", (Object)SourceFlagEnum.SCAN.name());
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setPkId((Object)realCardId);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void showBatchNewForm(Long realCardId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("fa_realcard_batch");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), BATCH_COPY));
        parameter.setCustomParam("realcardId", (Object)realCardId);
        this.getView().showForm(parameter);
    }

    private void showNewRealCardList(List<Long> successIds) {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setFormId("bos_list");
        for (Long successId : successIds) {
            parameter.addLinkQueryPkId((Object)successId);
        }
        parameter.setBillFormId("fa_card_real");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setCustomParam("batchSuccess", (Object)"true");
        this.getView().showForm((FormShowParameter)parameter);
    }

    static {
        filterMap.put("fa_purchasebill", null);
        filterMap.put("fa_card_real", FaRecardFilterList.and(new QFilter("isbak", "=", (Object)"0"), new QFilter("bizstatus", "!=", (Object)"DELETE")));
        filterMap.put("fa_card_real_base", new QFilter("isbak", "=", (Object)"0"));
        filterMap.put("fa_initcard_real", FaRecardFilterList.and(new QFilter("id", "=", (Object)"masterid", true), new QFilter("initialcard", "=", (Object)"1")));
        filterMap.put("fa_initcard_fin", new QFilter("bizperiod", "=", (Object)0L));
        filterMap.put("fa_clearapplybill", null);
        filterMap.put("fa_clearbill", null);
        filterMap.put("fa_assetcategory", null);
        filterMap.put("fa_usestatus", null);
        filterMap.put("fa_storeplace", null);
        filterMap.put("fa_assetbook", null);
        filterMap.put("fa_depre", new QFilter("status", "=", (Object)BillStatus.C.toString()));
        filterMap.put("fa_periodclose", new QFilter("status", "=", (Object)BillStatus.C.toString()));
        filterMap.put("fa_test_geninsertsql", null);
        filterMap.put("fa_depre_sum", null);
        filterMap.put("fa_dispatch", null);
        filterMap.put("fa_dispatch_in", FaRecardFilterList.and(new QFilter("billstatus", "!=", (Object)BillStatus.A.toString()), new QFilter("billstatus", "!=", (Object)BillStatus.B.toString())));
        filterMap.put("fa_depremethod", null);
        filterMap.put("fa_depre_workload", new QFilter(FaDaoOrmImpl.dot((String[])new String[]{"fincard", "depremethod", "type"}), "=", (Object)"5"));
        filterMap.put("fa_rpt_card", null);
        filterMap.put("fa_changemode", null);
    }
}

