/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.common.util.DateUtil;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.formplugin.AbstractWorkLoadPlugin;

public class FaWorkLoadEditPlugin
extends AbstractWorkLoadPlugin {
    @Override
    protected QFilter getRealCardFilter() {
        Set<Long> realCardIds = super.getUsedRealCardId();
        return new QFilter("id", "in", realCardIds);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        boolean fromDb = dataEntity.getDataEntityState().getFromDatabase();
        if (!fromDb) {
            this.setCurPeriodAndDate();
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        Map sourceDataMap = e.getSourceData();
        JSONObject sourceData = new JSONObject(sourceDataMap);
        JSONObject orgJson = sourceData.getJSONObject("org");
        String orgNumber = orgJson.getString("number");
        QFilter orgFilter = new QFilter("number", "=", (Object)orgNumber);
        DynamicObject org = QueryServiceHelper.queryOne((String)"bos_org", (String)"id", (QFilter[])orgFilter.toArray());
        if (org == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6839\u636e\u6838\u7b97\u7ec4\u7ec7\u7f16\u7801\u672a\u627e\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u6b63\u786e\u3002", (String)"FaWorkLoadEditPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        long orgId = org.getLong("id");
        JSONObject depreUseJson = sourceData.getJSONObject("depreuse");
        String depreUseNumber = depreUseJson.getString("number");
        QFilter depreUseFilter = new QFilter("number", "=", (Object)depreUseNumber);
        DynamicObject depreUse = QueryServiceHelper.queryOne((String)"fa_depreuse", (String)"id", (QFilter[])depreUseFilter.toArray());
        if (depreUse == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6839\u636e\u6298\u65e7\u7528\u9014\u7f16\u7801\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6298\u65e7\u7528\u9014\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u6b63\u786e\u3002", (String)"FaWorkLoadEditPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        long depreUseId = depreUse.getLong("id");
        QFilter[] boolFilters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("depreuse", "=", (Object)depreUseId)};
        DynamicObject assetBook = QueryServiceHelper.queryOne((String)"fa_assetbook", (String)"periodtype", (QFilter[])boolFilters);
        if (assetBook == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6839\u636e\u6838\u7b97\u7ec4\u7ec7\u3001\u6298\u65e7\u7528\u9014\u672a\u627e\u5230\u5bf9\u5e94\u7684\u8d44\u4ea7\u8d26\u7c3f\u3002", (String)"FaWorkLoadEditPlugin_2", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        long periodTypeId = assetBook.getLong("periodtype");
        JSONObject period = sourceData.getJSONObject("period");
        String periodNumber = period.getString("number");
        QFilter[] periodFilter = new QFilter[]{new QFilter("periodtype", "=", (Object)periodTypeId), new QFilter("number", "=", (Object)periodNumber)};
        DynamicObject periodDyn = QueryServiceHelper.queryOne((String)"bd_period", (String)"id", (QFilter[])periodFilter);
        if (periodDyn == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u671f\u95f4\u6570\u636e\u3002", (String)"FaWorkLoadEditPlugin_3", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        long periodId = periodDyn.getLong("id");
        period.put("importprop", (Object)"id");
        period.put("id", (Object)periodId);
        JSONObject realCard = sourceData.getJSONObject("realcard");
        String realCardNumber = realCard.getString("number");
        QFilter[] realCardFilter = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("number", "=", (Object)realCardNumber), new QFilter("isbak", "=", (Object)"0"), new QFilter("bizstatus", "!=", (Object)BizStatusEnum.DELETE.name())};
        DynamicObject realCardDyn = QueryServiceHelper.queryOne((String)"fa_card_real", (String)"id, bizstatus", (QFilter[])realCardFilter);
        if (realCardDyn == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6839\u636e\u8d44\u4ea7\u7f16\u7801\u672a\u627e\u5230\u5bf9\u5e94\u7684\u5b9e\u7269\u5361\u7247\uff0c\u6216\u8005\u5361\u7247\u5df2\u88ab\u6e05\u7406\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u6b63\u786e\u3002", (String)"FaWorkLoadEditPlugin_4", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        String bizStatus = realCardDyn.getString("bizstatus");
        if (!BizStatusEnum.READY.name().equals(bizStatus)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5b9e\u7269\u5361\u7247\u4e1a\u52a1\u72b6\u6001\u4e0d\u662f\u201c\u5c31\u7eea\u201d\uff0c\u4e0d\u80fd\u7ef4\u62a4\u5de5\u4f5c\u91cf\u3002", (String)"FaWorkLoadEditPlugin_5", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        long realCardId = realCardDyn.getLong("id");
        QFilter[] finCardFilter = new QFilter[]{new QFilter("realcardmasterid", "=", (Object)realCardId), new QFilter("depreuse", "=", (Object)depreUseId), new QFilter("endperiod", "=", (Object)99999999999L)};
        String selectFields = Fa.comma((String[])new String[]{"depremethod.type", Fa.dot((String[])new String[]{"workloadunit", "number"})});
        DynamicObject finCard = QueryServiceHelper.queryOne((String)"fa_card_fin", (String)selectFields, (QFilter[])finCardFilter);
        if (finCard == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u8d22\u52a1\u5361\u7247\u3002", (String)"FaWorkLoadEditPlugin_6", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        String depreMethodType = finCard.getString("depremethod.type");
        if (!"5".equals(depreMethodType)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5361\u7247\u4e0d\u662f\u6309\u5de5\u4f5c\u91cf\u6cd5\u6298\u65e7\uff0c\u4e0d\u80fd\u7ef4\u62a4\u5de5\u4f5c\u91cf\u3002", (String)"FaWorkLoadEditPlugin_7", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        String workLoadUnitNumber = finCard.getString(Fa.dot((String[])new String[]{"workloadunit", "number"}));
        JSONObject workLoadUnitJsonObj = new JSONObject();
        workLoadUnitJsonObj.put("number", (Object)workLoadUnitNumber);
        sourceDataMap.put("workloadunitid", workLoadUnitJsonObj);
        realCard.put("importprop", (Object)"id");
        realCard.put("id", (Object)realCardId);
    }

    public void afterImportData(ImportDataEventArgs e) {
        DynamicObject period = (DynamicObject)this.getModel().getValue("period");
        Date endDate = period.getDate("enddate");
        endDate = DateUtil.stripTime((Date)endDate);
        this.getModel().setValue("date", (Object)endDate);
    }
}

