/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin;

import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.filter.ControlFilter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.fi.fa.business.utils.FaFinCardUtil;
import kd.fi.fa.utils.FaFormPermissionUtil;

public class FaWorkLoadListPlugin
extends AbstractListPlugin {
    private static final String KEY_BATCH_NEW = "batchnew";
    private static final String KEY_REFRESH = "refresh";
    private static final String ENTITY_WORK_LOAD_BATCH = "fa_workload_batch";
    private static final String CALL_BACK_BATCH_NEW = "call_back_batch_new";
    public static final String ORG_ID = "orgId";
    public static final String DEPRE_USE_ID = "depreUseId";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setWorkLoadUnitButtonVisible();
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        FaFormPermissionUtil.filterContainerInitV2(args, this.getPageCache(), this.getView().getPageId());
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        FaFormPermissionUtil.filterContainerSearchClick(args, this.getPageCache());
    }

    private void setWorkLoadUnitButtonVisible() {
        List orgIdList = null;
        ControlFilter orgControlFilter = (ControlFilter)this.getControlFilters().getFilters().get("org.id");
        if (Objects.nonNull(orgControlFilter) && orgControlFilter.getValue() != null) {
            orgIdList = orgControlFilter.getValue().stream().map(orgId -> Long.parseLong(orgId.toString())).collect(Collectors.toList());
        }
        String depreUseIdStr = this.getFilterValue("depreuse.id");
        Long depreUseId = null;
        if (StringUtils.isNotBlank((CharSequence)depreUseIdStr)) {
            depreUseId = Long.parseLong(depreUseIdStr);
        }
        boolean haveWorkLoadNoUnitCard = FaFinCardUtil.isHaveWorkLoadNoUnitCard(orgIdList, depreUseId);
        this.getView().setVisible(Boolean.valueOf(haveWorkLoadNoUnitCard), new String[]{"setworkloadunit"});
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent e) {
        super.filterContainerBeforeF7Select(e);
        FaFormPermissionUtil.filterContainerBeforeF7SelectV2(e, this.getView().getPageId(), "fa_workload");
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (KEY_BATCH_NEW.equals(operateKey)) {
            this.showBatchNewForm();
        } else if ("setworkloadunit".equals(operateKey)) {
            this.showSetWorkLoadForm();
        }
    }

    private void showSetWorkLoadForm() {
        BaseShowParameter param = new BaseShowParameter();
        Long depreSystemId = (Long)this.getModel().getDataEntity().getPkValue();
        param.setFormId("fa_upworkloadunit");
        param.setCaption(ResManager.loadKDString((String)"\u7ef4\u62a4\u5de5\u4f5c\u91cf\u5355\u4f4d", (String)"FaWorkLoadListPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setCustomParam("depreSystemId", (Object)depreSystemId);
        List filter = this.getControlFilters().getFilter("org.id");
        if (filter == null || filter.isEmpty()) {
            return;
        }
        param.setCustomParam(ORG_ID, (Object)SerializationUtils.toJsonString((Object)filter));
        String depreUseId = this.getFilterValue("depreuse.id");
        if (StringUtils.isNotBlank((CharSequence)depreUseId)) {
            param.setCustomParam(DEPRE_USE_ID, (Object)depreUseId);
        }
        this.getView().showForm((FormShowParameter)param);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if (CALL_BACK_BATCH_NEW.equals(actionId) && evt.getReturnData() != null) {
            this.getView().invokeOperation(KEY_REFRESH);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"FaWorkLoadListPlugin_2", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
    }

    private void showBatchNewForm() {
        String depreUseId;
        BaseShowParameter param = new BaseShowParameter();
        param.setFormId(ENTITY_WORK_LOAD_BATCH);
        param.setCaption(ResManager.loadKDString((String)"\u5de5\u4f5c\u91cf\u7ef4\u62a4", (String)"FaWorkLoadListPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        String orgIdStr = this.getFilterValue("org.id");
        if (StringUtils.isNotBlank((CharSequence)orgIdStr)) {
            param.setCustomParam(ORG_ID, (Object)orgIdStr);
        }
        if (StringUtils.isNotBlank((CharSequence)(depreUseId = this.getFilterValue("depreuse.id")))) {
            param.setCustomParam(DEPRE_USE_ID, (Object)depreUseId);
        }
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALL_BACK_BATCH_NEW));
        this.getView().showForm((FormShowParameter)param);
    }

    private String getFilterValue(String filterField) {
        if (this.getControlFilters() == null) {
            return null;
        }
        List filter = this.getControlFilters().getFilter(filterField);
        if (filter == null || filter.isEmpty()) {
            return null;
        }
        return filter.get(0).toString();
    }
}

