/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.fa.business.FaUpgradeMasterIdBillTypeEnum;
import kd.fi.fa.business.depretask.DepreSplitSum;
import kd.fi.fa.business.enums.depre.FaOperationOpTypeEnum;
import kd.fi.fa.business.enums.depre.FaOperationStatusEnum;
import kd.fi.fa.business.enums.lease.InterestAmortizeSchema;
import kd.fi.fa.business.enums.lease.InterestDetailSourceType;
import kd.fi.fa.business.enums.lease.LeaseContractSourceType;
import kd.fi.fa.business.enums.lease.PayFrequency;
import kd.fi.fa.business.lease.utils.LeaseUtil;
import kd.fi.fa.business.pclock.PcLockUtils;
import kd.fi.fa.business.pclock.po.PcForceUnLockParameter;
import kd.fi.fa.business.periodclose.FutureBizCheckerUtils;
import kd.fi.fa.business.po.FaOperationLogInsertPo;
import kd.fi.fa.business.service.AssetCardFinEntryUpgradeServiceImpl;
import kd.fi.fa.business.service.FaBillUpdateCardMasterIdUpgradeServiceImpl;
import kd.fi.fa.business.service.RealCardOriginalDataUpgradeServiceImpl;
import kd.fi.fa.business.utils.FaBizUtils;
import kd.fi.fa.business.utils.FaBusyChgRecordUtil;
import kd.fi.fa.business.utils.FaCardVersion2Utils;
import kd.fi.fa.business.utils.FaClearDetailBaseUtil;
import kd.fi.fa.business.utils.FaGenBigDataUtils;
import kd.fi.fa.business.utils.FaHisFinIsneeddepreUpgradeUtil;
import kd.fi.fa.business.utils.FaInitAssetFinEntryDataUpService;
import kd.fi.fa.business.utils.FaMonthAccumDepreChgUpgradeUtils;
import kd.fi.fa.business.utils.FaOperationLogUtils;
import kd.fi.fa.business.utils.FaSplitUpgradeUtils;
import kd.fi.fa.business.utils.FunctionMutexHelper;
import kd.fi.fa.business.utils.SystemParamHelper;
import kd.fi.fa.common.util.DateUtil;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.common.util.ThrowableHelper;

public class FetchDepreDataPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(FetchDepreDataPlugin.class);
    private static final String TOOLBAR = "toolbarap";
    private static final String ALGO = "kd.fi.fa.formplugin.FetchDepreDataPlugin";
    private static final String BAR_CONFIRM = "confirm";
    private static final String FUNC_UNLOCK = "unlock";
    private static final String FUNC_RESPLIT = "resplit";
    private static final String FUNC_CLEAN_CACHE = "cleancache";
    private static final String FUNC_GENERATE = "generate";
    private static final String UNLOCK_CARD_STATUS_LOCK = "unlockCardStatusLock";
    private static final String UNLOCK_CLEAR_APPLY_BILL_LOCK = "unlockClearApplyBillLock";
    private static final String UNLOCK_PCLOCK = "unlockPcLock";
    private static final String FIND_ERR_CONTRACT = "findErrContract";
    private static final String UPGRADE_ASSET_CARD_FIN_ENTRY = "upgradeAssetCardFinEntry";
    private static final String UNLOCK_FIN_ENTRY_UPGRADE_LOCK = "unlockFinEntryUpgradeLock";
    private static final String UPDATE_FIN_ISNEEDDEPRE = "updateFinIsneeddepre";
    private static final String UPDATE_BILL_REALCARDMASTERID = "updateBillRealCardMasterId";
    private static final String UPGRADE_REAL_CARD_ORI_DATA = "upgradeRealCardOriData";
    private static final String UNLOCK_ORI_DATA_UPGRADE_LOCK = "unlockOriDataUpgradeLock";
    private static final String UPGRADE_START_BUSY_RECORD_PERIOD = "upgradeStartBusyRecordPeriod";
    private static final String FaSplitErrorRealMasterIDUpgrade = "FaSplitErrorRealMasterIDUpgrade";
    private static final String FaAssetFinEntryOriginalFinIDUpgrade = "FaAssetFinEntryOriginalFinIDUpgrade";
    private static final String FaMonthAccumDepreChg2ClearUpgradeService = "FaMonthAccumDepreChg2ClearUpgradeService";
    private static final String FaMonthAccumDepreChg2SplitUpgradeService = "FaMonthAccumDepreChg2SplitUpgradeService";
    private static final String FaClearDetailBaseBizstatusUpgradeService = "FaClearDetailBaseBizstatusUpgradeService";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{TOOLBAR});
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (BAR_CONFIRM.equals(itemKey)) {
            this.exec();
        }
    }

    private void exec() {
        IDataModel model = this.getModel();
        String function = (String)model.getValue("function");
        if (StringUtils.isEmpty((CharSequence)function)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u529f\u80fd\u3002", (String)"FetchDepreDataPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            return;
        }
        switch (function) {
            case "unlock": {
                this.unlock();
                break;
            }
            case "resplit": {
                this.reSplit();
                break;
            }
            case "cleancache": {
                this.cleanCache();
                break;
            }
            case "generate": {
                this.generate();
                break;
            }
            case "unlockCardStatusLock": {
                this.unlockcardstatuslock();
                break;
            }
            case "unlockClearApplyBillLock": {
                this.unlockclearapplybilllock();
                break;
            }
            case "unlockPcLock": {
                this.unlockPcLock();
                break;
            }
            case "upgradeAssetCardFinEntry": {
                this.upgradeAssetCardFinEntry();
                break;
            }
            case "unlockFinEntryUpgradeLock": {
                this.unlockFinEntryUpgradeLock();
                break;
            }
            case "updateFinIsneeddepre": {
                this.updateFinIsneeddepre();
                break;
            }
            case "upgradeRealCardOriData": {
                this.upgradeRealCardOriData();
                break;
            }
            case "unlockOriDataUpgradeLock": {
                this.unlockOriDataUpgradeLock();
                break;
            }
            case "updateBillRealCardMasterId": {
                this.updateBillRealCardMasterId();
                break;
            }
            case "upgradeStartBusyRecordPeriod": {
                this.upgradeStartBusyRecordPeriod();
                break;
            }
            case "findErrContract": {
                this.findErrContract();
                break;
            }
            case "TESTFaCardVersion2Upgrade": {
                FaCardVersion2Utils.upgradeFaCardVersion2();
                break;
            }
            case "FaSplitErrorRealMasterIDUpgrade": {
                FaSplitUpgradeUtils.upgradeErrorRealMasterId();
                break;
            }
            case "FaAssetFinEntryOriginalFinIDUpgrade": {
                FaInitAssetFinEntryDataUpService upService = new FaInitAssetFinEntryDataUpService();
                String msg = upService.executeUpgradeService();
                if (msg == null) break;
                this.getView().showTipNotification(msg);
                break;
            }
            case "FaMonthAccumDepreChg2ClearUpgradeService": {
                this.upgradeClearBillAccumDepre2Fin();
                break;
            }
            case "FaMonthAccumDepreChg2SplitUpgradeService": {
                FaMonthAccumDepreChgUpgradeUtils.upgradeAccumDepre2SplitBill();
                break;
            }
            case "FaClearDetailBaseBizstatusUpgradeService": {
                FaClearDetailBaseUtil.upgradeBizstatus();
                break;
            }
            case "FaBusyChgRecordUpgradeService1": {
                FutureBizCheckerUtils.upgradeBusyChgRecords();
                break;
            }
            default: {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ee3\u7801\u672a\u914d\u7f6e\u8be5\u64cd\u4f5c\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"FetchDepreDataPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f", (String)"FetchDepreDataPlugin_2", (String)"fi-fa-formplugin", (Object[])new Object[0]));
    }

    private void reSplit() {
        String periodIdStr = (String)this.getModel().getValue("param");
        long periodId = Long.parseLong(periodIdStr);
        DynamicObject assetBook = (DynamicObject)this.getModel().getValue("assetbookf7");
        try {
            new DepreSplitSum().repairDepreSplit(Long.valueOf(assetBook.getLong("org_id")), Long.valueOf(assetBook.getLong("depreuse_id")), Long.valueOf(periodId));
        }
        catch (Exception e) {
            String params = "FetchDepreDataPlugin.reSplit -> " + String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7: %1$s, \u6298\u65e7\u7528\u9014\uff1a%2$s, \u671f\u95f4\uff1a%3$s", (String)"FetchDepreDataPlugin_3", (String)"fi-fa-formplugin", (Object[])new Object[0]), assetBook.getLong("org_id"), assetBook.getLong("depreuse_id"), periodId);
            FaOperationLogInsertPo insertPo = new FaOperationLogInsertPo(Long.valueOf(assetBook.getLong("org_id")), Long.valueOf(assetBook.getLong("depreuse_id")), Long.valueOf(assetBook.getLong("id")), Long.valueOf(periodId), Integer.valueOf(0), "fa_fetchdepredata", params, FaOperationOpTypeEnum.RESPLIT);
            FaOperationLogUtils.insertOperationLog((FaOperationLogInsertPo)insertPo, (FaOperationStatusEnum)FaOperationStatusEnum.FAILED, (String)ThrowableHelper.toString((Throwable)e));
            throw e;
        }
    }

    private void generate() {
        String param = (String)this.getModel().getValue("param");
        String[] params = param.split(";");
        String org = params[0].split(":")[1];
        Object[] ids = params[1].split(":")[1].split(",");
        int count = Integer.parseInt(params[2].split(":")[1]);
        DynamicObjectCollection cates = QueryServiceHelper.query((String)"fa_assetcategory", (String)"id", (QFilter[])new QFilter[]{BaseDataServiceHelper.getBaseDataFilter((String)"fa_assetcategory", (Long)Long.parseLong(org)), new QFilter("isleaf", "=", (Object)true), new QFilter("enable", "=", (Object)true)});
        HashSet<Long> ids2 = new HashSet<Long>(cates.size());
        for (DynamicObject cate : cates) {
            ids2.add(cate.getLong("id"));
        }
        DynamicObject[] cateObjes = BusinessDataServiceHelper.load((Object[])ids2.toArray(new Long[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fa_assetcategory"));
        DynamicObject[] realCards = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fa_initcard_real"));
        List books = FaBizUtils.getEnableAsstBooksByOrg((Long)Long.valueOf(org));
        long startTime = System.currentTimeMillis();
        for (DynamicObject realcard : realCards) {
            for (DynamicObject cate : cateObjes) {
                FaGenBigDataUtils.genCards((DynamicObject)realcard, (DynamicObject)cate, (int)0, (int)count, (int)count, (List)books);
            }
        }
        long usedTime = System.currentTimeMillis() - startTime;
        logger.info(String.format("------\u7528\u65f6\uff1a\u751f\u6210\u5df2\u5ba1\u6838\u7684\u8d22\u52a1\u5361\u7247\uff0c\u603b\u8017\u65f6\uff1a%s  ms\uff01", usedTime));
    }

    private void unlock() {
        DynamicObject assetbook = (DynamicObject)this.getModel().getValue("assetbookf7");
        if (assetbook != null) {
            FunctionMutexHelper.forceUnlock((String)FunctionMutexHelper.key((Object)assetbook.getPkValue()));
        }
    }

    private void cleanCache() {
        String param = (String)this.getModel().getValue("param");
        if (StringUtils.isEmpty((CharSequence)param)) {
            return;
        }
        String[] split = param.split(":");
        DataEntityCacheManager cacheManager = new DataEntityCacheManager(split[0]);
        if (split.length == 1) {
            cacheManager.removeByDt();
        } else {
            cacheManager.removeByPrimaryKey(new Object[]{Long.parseLong(split[1])});
        }
    }

    private void unlockcardstatuslock() {
        String param = (String)this.getModel().getValue("param");
        String[] params = param.split(";");
        String orgId = params[0].split(":")[1];
        Object[] numbers = params[1].split(":")[1].split(",");
        HashSet<Long> masterIds = new HashSet<Long>(16);
        SqlBuilder sbReal = new SqlBuilder();
        sbReal.append("select fmasterid FROM t_fa_card_real where ", new Object[0]);
        sbReal.append("forgid = ? ", new Object[]{Long.parseLong(orgId)});
        sbReal.appendIn("and fnumber", numbers);
        DataSet sbRealDS = DB.queryDataSet((String)"FetchDepreData_unlockcardstatuslock", (DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)sbReal);
        for (Row row : sbRealDS) {
            masterIds.add(row.getLong("fmasterid"));
        }
        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"fa_card_bus_ctr"), (Object[])masterIds.toArray());
    }

    private void unlockclearapplybilllock() {
        String param = (String)this.getModel().getValue("param");
        String[] params = param.split(";");
        String orgId = params[0].split(":")[1];
        Object[] numbers = params[1].split(":")[1].split(",");
        HashSet<Long> masterIds = new HashSet<Long>(16);
        SqlBuilder sbReal = new SqlBuilder();
        sbReal.append("select fmasterid FROM t_fa_card_real where ", new Object[0]);
        sbReal.append("forgid = ? ", new Object[]{Long.parseLong(orgId)});
        sbReal.appendIn("and fnumber", numbers);
        DataSet sbRealDS = DB.queryDataSet((String)"FetchDepreData_unlockcardstatuslock", (DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)sbReal);
        for (Row row : sbRealDS) {
            masterIds.add(row.getLong("fmasterid"));
        }
        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"fa_card_biz_ctr"), (Object[])masterIds.toArray());
    }

    private void unlockPcLock() {
        String param = (String)this.getModel().getValue("param");
        String[] params = param.split(";");
        String lockedEntityName = params[0].split(":")[1];
        String usePurpose = params[1].split(":")[1];
        String[] lockedMasterIdsStr = params[2].split(":")[1].split(",");
        PcForceUnLockParameter parameter = new PcForceUnLockParameter();
        parameter.setLockedEntityName(lockedEntityName);
        parameter.setUsePurpose(usePurpose);
        HashSet<Long> lockedMasterIds = new HashSet<Long>(lockedMasterIdsStr.length, 1.0f);
        for (String lockedMasterId : lockedMasterIdsStr) {
            lockedMasterIds.add(Long.valueOf(lockedMasterId));
        }
        parameter.setLockedMasterIds(lockedMasterIds);
        PcLockUtils.forceUnlock((PcForceUnLockParameter)parameter);
    }

    private void upgradeAssetCardFinEntry() {
        CodeEdit sqlEditor = (CodeEdit)this.getControl("ksqltext");
        String param = sqlEditor.getText();
        if (param == null) {
            param = "";
        }
        new AssetCardFinEntryUpgradeServiceImpl(param).executeUpgradeService();
    }

    private void unlockFinEntryUpgradeLock() {
        new AssetCardFinEntryUpgradeServiceImpl("").unlockUpgradeLock();
    }

    private void updateFinIsneeddepre() {
        FaHisFinIsneeddepreUpgradeUtil.hisFinIsneeddepreUpgrade();
    }

    private void updateBillRealCardMasterId() {
        String billTypeParam = (String)this.getModel().getValue("param");
        FaUpgradeMasterIdBillTypeEnum billTypeEnum = FaUpgradeMasterIdBillTypeEnum.getEnumByEntityName((String)billTypeParam);
        if (null == billTypeEnum) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u5355\u636e\u7c7b\u578b\u3002", (String)"FetchDepreDataPlugin_4", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            return;
        }
        FaBillUpdateCardMasterIdUpgradeServiceImpl service = new FaBillUpdateCardMasterIdUpgradeServiceImpl(billTypeEnum);
        service.executeUpgradeService();
    }

    private void upgradeRealCardOriData() {
        new RealCardOriginalDataUpgradeServiceImpl().executeUpgradeService();
    }

    private void unlockOriDataUpgradeLock() {
        new RealCardOriginalDataUpgradeServiceImpl().unlockUpgradeLock();
    }

    private void upgradeStartBusyRecordPeriod() {
        DynamicObject assetBook = (DynamicObject)this.getModel().getValue("assetbookf7");
        QFilter[] filters = null;
        if (assetBook != null) {
            filters = new QFilter[]{new QFilter("id", "=", assetBook.get("id"))};
        }
        String selectBookFields = Fa.comma((String[])new String[]{"org", "id", "depreuse"});
        DynamicObjectCollection books = QueryServiceHelper.query((String)"fa_assetbook", (String)selectBookFields, (QFilter[])filters);
        FaBusyChgRecordUtil.upgradeStartBusyRecordPeriod((DynamicObjectCollection)books);
    }

    private void findErrContract() {
        String param = (String)this.getModel().getValue("param");
        CodeEdit sqlEditor = (CodeEdit)this.getControl("ksqltext");
        StringBuilder info = new StringBuilder();
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("status", "=", (Object)BillStatus.C.name()));
        filters.add(new QFilter("isbak", "=", (Object)Boolean.FALSE));
        if (StringUtils.isBlank((CharSequence)param)) {
            logger.info("\u5206\u6790\u5f02\u5e38\u5408\u540c\uff1a\u53c2\u6570\u4e3a\u7a7a\uff0c\u5206\u6790\u6240\u6709\u7ec4\u7ec7");
        } else {
            logger.info("\u5206\u6790\u5f02\u5e38\u5408\u540c\uff1a\u5206\u6790\u6307\u5b9a\u7ec4\u7ec7[{}]", (Object)param);
            filters.add(new QFilter("org.number", "=", (Object)param));
        }
        DynamicObjectCollection queryContracts = QueryServiceHelper.query((String)"fa_lease_contract", (String)"id, org.number", (QFilter[])filters.toArray(new QFilter[0]));
        Map<String, List<DynamicObject>> groupContract = queryContracts.stream().collect(Collectors.groupingBy(v -> v.getString("org.number")));
        for (Map.Entry<String, List<DynamicObject>> group : groupContract.entrySet()) {
            String orgNumber = group.getKey();
            logger.info("\u5206\u6790\u5f02\u5e38\u5408\u540c\uff1a\u5f00\u59cb\u5904\u7406\u5355\u4e2a\u7ec4\u7ec7[{}]", (Object)orgNumber);
            Object[] contractIds = group.getValue().stream().map(v -> v.getLong("id")).toArray();
            DynamicObject[] contracts = BusinessDataServiceHelper.load((Object[])contractIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fa_lease_contract"));
            QFilter filter = new QFilter("leasecontract", "in", (Object)contractIds);
            DynamicObjectCollection queryInterestDetails = QueryServiceHelper.query((String)"fa_interest_detail", (String)"id", (QFilter[])filter.toArray());
            Object[] interestDetailIds = queryInterestDetails.stream().map(v -> v.getLong("id")).toArray();
            DynamicObject[] interestDetails = BusinessDataServiceHelper.load((Object[])interestDetailIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fa_interest_detail"));
            Map<Long, DynamicObject> interestMap = Arrays.stream(interestDetails).collect(Collectors.toMap(v -> v.getLong(Fa.id((String)"leasecontract")), v -> v));
            for (DynamicObject contract : contracts) {
                long contractId = contract.getLong("id");
                String contractNumber = contract.getString("number");
                DynamicObject interestDetail = interestMap.get(contractId);
                if (interestDetail == null) {
                    logger.info("\u5206\u6790\u5f02\u5e38\u5408\u540c\uff1a\u5408\u540c[{}]\u672a\u8ba1\u606f\uff0c\u8df3\u8fc7", (Object)contractNumber);
                    continue;
                }
                ArrayList<String> errDateList = new ArrayList<String>();
                Map<String, BigDecimal> amountMap = this.getLeaseLiabPayAmountMap(contract);
                DynamicObjectCollection detailEntry = interestDetail.getDynamicObjectCollection("detailentry");
                for (DynamicObject row : detailEntry) {
                    String sourceType = row.getString("sourcetype");
                    if (!InterestDetailSourceType.A.name().equals(sourceType)) continue;
                    Date date = row.getDate("date");
                    String dateStr = this.formatDate4Interest(date);
                    BigDecimal leaseLiabPay = row.getBigDecimal("leaseliabpay");
                    BigDecimal amount = amountMap.get(dateStr);
                    if (amount == null) {
                        if (BigDecimal.ZERO.compareTo(leaseLiabPay) >= 0) continue;
                        errDateList.add(dateStr);
                        continue;
                    }
                    if (amount.compareTo(leaseLiabPay) == 0) continue;
                    errDateList.add(dateStr);
                }
                if (errDateList.isEmpty()) continue;
                info.append(String.format("error => orgNumber:[%1$s], contract:[%2$s], errDate:[%3$s]\r\n", orgNumber, contractNumber, errDateList));
                logger.info("\u5206\u6790\u5f02\u5e38\u5408\u540c\uff1a\u53d1\u73b0\u5f02\u5e38\u5408\u540c[{}], orgNumber[{}]", (Object)contractNumber, (Object)orgNumber);
            }
        }
        info.append("========finish========\r\n");
        sqlEditor.setText(info.toString());
    }

    private Map<String, BigDecimal> getLeaseLiabPayAmountMap(DynamicObject leaseContract) {
        DynamicObject org = leaseContract.getDynamicObject("org");
        DynamicObject currency = leaseContract.getDynamicObject("currency");
        int amtPrecision = currency.getInt("amtprecision");
        String interestAmortizeSchema = SystemParamHelper.getStringParam((String)"interest_amortize_schema", (long)((Long)org.getPkValue()), (String)InterestAmortizeSchema.A.name());
        DynamicObjectCollection planEntry = leaseContract.getDynamicObjectCollection("payplanentryentity");
        Date detailBeginDate = this.getDetailBeginDate(leaseContract);
        HashMap<String, BigDecimal> amountMap = new HashMap<String, BigDecimal>(planEntry.size());
        for (DynamicObject row : planEntry) {
            Date planPayDate;
            DynamicObject payItem = row.getDynamicObject("plan_payitem");
            String acctClass = payItem.getString("accountingclass");
            if (!"A".equals(acctClass) || DateUtil.compareDate((Date)(planPayDate = row.getDate("planpaydate")), (Date)detailBeginDate) < 0) continue;
            BigDecimal amount = row.getBigDecimal("unpaidrent");
            Date planStartDate = row.getDate("plan_startdate");
            Date planEndDate = row.getDate("plan_enddate");
            DynamicObject payRuleRow = LeaseUtil.getPayRuleRow((DynamicObject)leaseContract, (long)payItem.getLong("id"), (Date)planStartDate);
            String frequency = payRuleRow.getString("frequency");
            if (InterestAmortizeSchema.A.name().equals(interestAmortizeSchema) || PayFrequency.F.name().equals(frequency)) {
                String dateStr = this.formatDate4Interest(planPayDate);
                amountMap.put(dateStr, amount);
                continue;
            }
            String payPoint = payRuleRow.getString("paypoint");
            int relativePayDate = payRuleRow.getInt("relativepaydate");
            Date startDate = planStartDate;
            ArrayList<String> payDateList = new ArrayList<String>();
            while (DateUtil.compareDate((Date)startDate, (Date)planEndDate) <= 0) {
                Date endDate = DateUtil.addNaturalMonth((Date)startDate, (int)1);
                if (DateUtil.compareDate((Date)(endDate = DateUtil.addDay((Date)endDate, (int)-1)), (Date)planEndDate) > 0) {
                    endDate = planEndDate;
                }
                Date payDate = LeaseUtil.calPlanPayDate((Date)startDate, (Date)endDate, (String)payPoint, (int)relativePayDate);
                startDate = DateUtil.addDay((Date)endDate, (int)1);
                if (DateUtil.compareDate((Date)payDate, (Date)detailBeginDate) < 0) continue;
                String payDateStr = this.formatDate4Interest(payDate);
                if (amountMap.containsKey(payDateStr) || payDateList.contains(payDateStr)) {
                    logger.error(String.format("\u751f\u6210\u8ba1\u606f\u660e\u7ec6\u8868\u5931\u8d25\uff0c\u6682\u4e0d\u652f\u6301\u591a\u7b14\u4ed8\u6b3e\u8ba1\u5212\u644a\u9500\u5230\u540c\u4e00\u5929\u7684\u573a\u666f\uff0c\u652f\u4ed8\u65e5[%s]", payDateStr));
                    throw new KDBizException(ResManager.loadKDString((String)"\u751f\u6210\u8ba1\u606f\u660e\u7ec6\u8868\u5931\u8d25\uff0c\u6682\u4e0d\u652f\u6301\u591a\u7b14\u4ed8\u6b3e\u8ba1\u5212\u644a\u9500\u5230\u540c\u4e00\u5929\u7684\u573a\u666f\u3002", (String)"FetchDepreDataPlugin_5", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                }
                payDateList.add(payDateStr);
            }
            int payTimes = payDateList.size();
            if (payTimes == 0) {
                logger.info(String.format("\u4ed8\u6b3e\u8ba1\u5212[%s]\u6309\u6708\u644a\u9500\u65f6\uff0c\u672a\u627e\u5230\u4ed8\u6b3e\u65e5\u671f\u3002", row.getString("plannumber")));
                continue;
            }
            BigDecimal tempAmount = amount.divide(new BigDecimal(payTimes), amtPrecision, LeaseUtil.getRoundingMode4CalAmount());
            BigDecimal sumAmount = tempAmount.multiply(new BigDecimal(payTimes - 1)).setScale(amtPrecision, LeaseUtil.getRoundingMode4CalAmount());
            BigDecimal tailDiff = amount.subtract(sumAmount);
            for (int i = 0; i < payTimes; ++i) {
                String payDateStr = (String)payDateList.get(i);
                if (i == payTimes - 1) {
                    amountMap.put(payDateStr, tailDiff);
                    continue;
                }
                amountMap.put(payDateStr, tempAmount);
            }
        }
        return amountMap;
    }

    private void upgradeClearBillAccumDepre2Fin() {
        String year = (String)this.getModel().getValue("param");
        if (year != null && year.length() > 0) {
            Integer yearInt = Integer.parseInt(year);
            FaMonthAccumDepreChgUpgradeUtils.upgradeAccumDepre2ClearBill((Integer)yearInt, (Integer)yearInt);
        } else {
            FaMonthAccumDepreChgUpgradeUtils.upgradeAccumDepre2ClearBill(null, null);
        }
    }

    private Date getDetailBeginDate(DynamicObject leaseContract) {
        String sourceType = leaseContract.getString("sourcetype");
        Date initConfirmDate = leaseContract.getDate("initconfirmdate");
        Date sysSwitchDate = leaseContract.getDate("sysswitchdate");
        return LeaseContractSourceType.A.name().equals(sourceType) ? initConfirmDate : sysSwitchDate;
    }

    private String formatDate4Interest(Date date) {
        if (date == null) {
            return "";
        }
        return new SimpleDateFormat("yyyyMMdd").format(date);
    }
}

