/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.entity.plugin.support.util.ReflectionUtils;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.fi.fa.business.dao.factory.FaAssetBookDaoFactory;
import kd.fi.fa.business.utils.FaBizUtils;
import kd.fi.fa.common.util.ContextUtil;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.common.util.ThrowableHelper;
import kd.fi.fa.formplugin.DataSource;
import kd.fi.fa.formplugin.ItemDataResult;
import kd.fi.fa.utils.FaFormUtils;

public class MainPageAssetDistributionCard
extends AbstractFormPlugin
implements TabSelectListener {
    private static final Log log = LogFactory.getLog(MainPageAssetDistributionCard.class);
    private static final String ASSETDISTRITABAP = "assetdistritabap";
    private static final String PANEL_TYPE = "typepanel";
    private static final String PANEL_TYPE_EMPTY = "typeemptypanel";
    private static final String PANEL_DEPT = "deptpanel";
    private static final String PANEL_DEPT_EMPTY = "deptemptypanel";
    private static final String TYPETAB = "typetab";
    private static final String DEPTTAB = "depttab";
    private static final String TYPECHART = "typechart";
    private static final String DEPTCHART = "deptchart";
    private static final String LABELAP = "labelap";
    private final BigDecimal THOUSAND = new BigDecimal(10000);
    private static final int LIMIT_COUNT = 7;
    private Format currencyFormat;
    private Format numberFormat;

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.init(false);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getControl(ASSETDISTRITABAP);
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void tabSelected(TabSelectEvent e) {
        String key;
        switch (key = e.getTabKey()) {
            case "typetab": {
                this.init(false);
                break;
            }
            case "depttab": {
                this.init(true);
                break;
            }
        }
    }

    private void init(boolean isDept) {
        DynamicObject mainBook;
        IDataModel idm = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId()).getModel();
        long orgId = FaFormUtils.getCardOrg(idm);
        long depreUseId = FaFormUtils.getCardDepreUse(idm);
        ((Label)this.getView().getControl(LABELAP)).setText(new LocaleString(ResManager.loadKDString((String)"\uff08\u4e07\u5143\uff09", (String)"MainPageAssetDistributionCard_0", (String)"fi-fa-formplugin", (Object[])new Object[0])).getLocaleValue());
        if (orgId == 0L || depreUseId == 0L) {
            this.setDataPanelVisible(true);
            return;
        }
        try {
            mainBook = FaAssetBookDaoFactory.getInstance().queryMainBookByOrg((Object)orgId);
        }
        catch (KDBizException e) {
            this.setDataPanelVisible(true);
            return;
        }
        DynamicObject basecurrency = mainBook.getDynamicObject("basecurrency");
        this.initFormat(basecurrency);
        Long bookid = mainBook.getLong("id");
        DynamicObject curperiod = mainBook.getDynamicObject("curperiod");
        DynamicObject enableperiod = mainBook.getDynamicObject("startperiod");
        if (curperiod == null || enableperiod == null) {
            this.setDataPanelVisible(true);
            return;
        }
        this.initChart(orgId, depreUseId, curperiod, isDept, basecurrency, enableperiod);
    }

    private void initFormat(DynamicObject basecurrency) {
        String currencySign = "";
        int currencyAmtprecision = 2;
        if (basecurrency != null) {
            currencySign = basecurrency.getString("sign");
        }
        FormatObject fobj = InteServiceHelper.getUserFormat((Long)ContextUtil.getUserId());
        fobj.getCurrencyFormat().setCurrencySymbols(currencySign);
        fobj.getCurrencyFormat().setMinimumFractionDigits(currencyAmtprecision);
        fobj.getNumberFormat().setMinimumFractionDigits(2);
        this.currencyFormat = FormatFactory.get((FormatTypes)FormatTypes.Currency).getFormat(fobj);
        this.numberFormat = FormatFactory.get((FormatTypes)FormatTypes.Number).getFormat(fobj);
    }

    private void initChart(Long orgId, Long depreUseId, DynamicObject curperiod, boolean isDept, DynamicObject basecurrency, DynamicObject enableperiod) {
        if (isDept) {
            this.showChart(DEPTCHART, orgId, depreUseId, curperiod, true, basecurrency, enableperiod);
        } else {
            this.showChart(TYPECHART, orgId, depreUseId, curperiod, false, basecurrency, enableperiod);
        }
    }

    private void showChart(String charName, Long orgId, Long depreUseId, DynamicObject curperiod, Boolean isDept, DynamicObject basecurrency, DynamicObject enableperiod) {
        PieChart chart = (PieChart)this.getControl(charName);
        chart.clearData();
        String seriesName = String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u5206\u5e03(%s)", (String)"MainPageAssetDistributionCard_11", (String)"fi-fa-formplugin", (Object[])new Object[0]), isDept != false ? ResManager.loadKDString((String)"\u90e8\u95e8", (String)"MainPageAssetDistributionCard_12", (String)"fi-fa-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5206\u7c7b", (String)"MainPageAssetDistributionCard_3", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        PieSeries series = chart.createSeries(seriesName);
        DataSource dataSource = this.getChartData(orgId, depreUseId, curperiod, isDept, basecurrency, enableperiod);
        List<ItemValue> itemList = dataSource.itemList;
        this.setDataPanelVisible(itemList.isEmpty());
        ItemValue[] itemArr = itemList.toArray(new ItemValue[itemList.size()]);
        series.setData(itemArr);
        Map itemNormalStyle = series.getItemNormalStyle();
        HashMap<String, Object> lableMap = new HashMap<String, Object>();
        lableMap.put("show", false);
        lableMap.put("position", "center");
        itemNormalStyle.put("label", lableMap);
        HashMap<String, Boolean> lableLineMap = new HashMap<String, Boolean>();
        lableLineMap.put("show", false);
        itemNormalStyle.put("labelLine", lableLineMap);
        series.setRadius("50%", "70%");
        series.setCenter("32%", "50%");
        Map<String, Object> values = this.getValues(series);
        this.setEmphasisLabel(values);
        chart.setShowTooltip(true);
        chart.addTooltip("trigger", (Object)"item");
        chart.addTooltip("formatter", (Object)"function(a,b,c){if(a.name.substr(a.name.length-1,1)!='}'){return a.name}else { return  a.name.substr(0,a.name.length-5)+' '+a.name.substr(a.name.length-2,1); }}");
        ArrayList<String> list = new ArrayList<String>();
        list.add("tooltip");
        list.add("formatter");
        chart.addFuncPath(list);
        chart.setLegendAlign(XAlign.right, YAlign.center);
        chart.setLegendPropValue("padding", (Object)new Integer[]{90, 5, 85, 33});
        chart.setLegendPropValue("align", (Object)"left");
        chart.setLegendPropValue("orient", (Object)"vertical");
        chart.setLegendPropValue("formatter", (Object)"{name}");
        Map<String, Object> legendStyleMap = this.getLegendStyleMap();
        chart.setLegendPropValue("textStyle", legendStyleMap);
        chart.setLegendPropValue("type", (Object)"scroll");
        chart.setShowTitle(true);
        chart.setTitlePropValue("text", (Object)ResManager.loadKDString((String)"\u8d44\u4ea7\u603b\u91d1\u989d", (String)"MainPageAssetDistributionCard_4", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        if (this.THOUSAND.compareTo(new BigDecimal(10000)) == 0) {
            chart.setTitlePropValue("subtext", (Object)String.format(ResManager.loadKDString((String)"%1$s%2$s", (String)"MainPageAssetDistributionCard_5", (String)"fi-fa-formplugin", (Object[])new Object[0]), "", this.currencyFormat.format(dataSource.total)));
        } else {
            chart.setTitlePropValue("subtext", (Object)String.format(ResManager.loadKDString((String)"%1$s%2$s", (String)"MainPageAssetDistributionCard_6", (String)"fi-fa-formplugin", (Object[])new Object[0]), "", this.currencyFormat.format(dataSource.total)));
        }
        chart.setTitlePropValue("x", (Object)"32%");
        chart.setTitlePropValue("y", (Object)"center");
        chart.setTitlePropValue("textAlign", (Object)"center");
        chart.refresh();
    }

    private Map<String, Object> getLegendStyleMap() {
        HashMap<String, Object> legendStyleMap = new HashMap<String, Object>();
        HashMap rich = new HashMap();
        HashMap<String, String> firstStyle = new HashMap<String, String>();
        firstStyle.put("color", "red");
        firstStyle.put("fontWeight", "'bold'");
        HashMap<String, String> secondStyle = new HashMap<String, String>();
        secondStyle.put("color", "green");
        secondStyle.put("fontWeight", "bold");
        rich.put("r", firstStyle);
        rich.put("g", secondStyle);
        legendStyleMap.put("rich", rich);
        return legendStyleMap;
    }

    private Map<String, Object> getValues(PieSeries series) {
        try {
            Class<?> clazz = Class.forName("kd.bos.form.chart.Series");
            Method getValues = clazz.getDeclaredMethod("getValues", new Class[0]);
            ReflectionUtils.makeAccessible((Method)getValues);
            return (Map)getValues.invoke((Object)series, (Object[])null);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new KDBizException(ThrowableHelper.toString((Throwable)e));
        }
    }

    private void setEmphasisLabel(Map<String, Object> values) {
        if (values == null) {
            return;
        }
        Map itemStyle = (Map)values.get("itemStyle");
        HashMap emphasisMap = new HashMap();
        HashMap<String, Serializable> labelMap = new HashMap<String, Serializable>();
        HashMap<String, String> textStyleMap = new HashMap<String, String>();
        textStyleMap.put("fontSize", "24");
        textStyleMap.put("fontWeight", "bold");
        labelMap.put("show", Boolean.valueOf(false));
        labelMap.put("textStyle", textStyleMap);
        emphasisMap.put("label", labelMap);
        HashMap<String, Boolean> labelLineMap = new HashMap<String, Boolean>();
        labelLineMap.put("show", false);
        emphasisMap.put("labelLine", labelLineMap);
        itemStyle.put("emphasis", emphasisMap);
    }

    private DataSource getChartData(Long orgId, Long depreUseId, DynamicObject curperiod, Boolean isDept, DynamicObject basecurrency, DynamicObject enableperiod) {
        DataSource result = new DataSource();
        int amtprecision = 2;
        ArrayList<String> colorList = new ArrayList<String>(){
            {
                this.add("#F2637B");
                this.add("#975FE4");
                this.add("#3AA0FF");
                this.add("#36CBCB");
                this.add("#4DCB73");
                this.add("#FFAE8B");
                this.add("#FAD337");
            }
        };
        ItemDataResult curData = this.getItemValue(orgId, depreUseId, curperiod, isDept, enableperiod, 0);
        curData = this.adjustDataChartData(curData, amtprecision);
        ItemDataResult prevData = this.getPreItemValue(orgId, depreUseId, curperiod, isDept, enableperiod, new ArrayList<String>(curData.itemMap.keySet()), 0);
        prevData = this.adjustDataChartData(prevData, amtprecision);
        BigDecimal totalValue = curData.total;
        String format = "";
        format = this.THOUSAND.compareTo(new BigDecimal(10000)) == 0 ? ResManager.loadKDString((String)"%1$s:%n%2$s%%    (%3$s%4$s)   %5$s%6$s", (String)"MainPageAssetDistributionCard_7", (String)"fi-fa-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"%1$s:%n%2$s%%    (%3$s%4$s)   %s5$%6$s", (String)"MainPageAssetDistributionCard_8", (String)"fi-fa-formplugin", (Object[])new Object[0]);
        int curPos = 0;
        ArrayList<ItemValue> itemList = new ArrayList<ItemValue>(curData.itemMap.size());
        for (String type : curData.itemMap.keySet()) {
            BigDecimal curValue = (BigDecimal)curData.itemMap.get(type).getValue();
            String curTypeName = curData.itemMap.get(type).getName();
            BigDecimal curPer = totalValue.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : curValue.multiply(new BigDecimal(100)).divide(totalValue, 2, RoundingMode.HALF_UP);
            String curPerStr = this.numberFormat.format(curPer);
            Boolean existst = false;
            BigDecimal curPrevData = new BigDecimal(0);
            BigDecimal ratioValue = new BigDecimal(0);
            if (prevData.itemMap.containsKey(type)) {
                curPrevData = (BigDecimal)prevData.itemMap.get(type).getValue();
                existst = true;
            }
            String ratioValueStr = "";
            if (curPrevData.compareTo(BigDecimal.ZERO) == 0) {
                ratioValueStr = "-";
            } else {
                ratioValue = curValue.subtract(curPrevData).multiply(new BigDecimal(100)).divide(curPrevData, 2, RoundingMode.HALF_UP);
                ratioValueStr = String.format("%s%%(%s) ", ResManager.loadKDString((String)"\u540c\u6bd4", (String)"MainPageAssetDistributionCard_9", (String)"fi-fa-formplugin", (Object[])new Object[0]), this.numberFormat.format(ratioValue));
            }
            String directionStr = this.getCurDirectionStr(existst, curPrevData, curValue);
            String legendName = String.format(format, curTypeName, curPerStr, "", this.currencyFormat.format(curValue), ratioValueStr, directionStr);
            String color = (String)colorList.get(curPos % colorList.size());
            ItemValue item = new ItemValue(legendName, (Number)curValue, color);
            itemList.add(item);
            ++curPos;
        }
        result.total = totalValue;
        result.itemList = itemList;
        return result;
    }

    private String getCurDirectionStr(Boolean existst, BigDecimal curPrevData, BigDecimal curValue) {
        String incStr = "{r|\u2191}";
        String redStr = "{g|\u2193}";
        if (!existst.booleanValue() || curPrevData.compareTo(BigDecimal.ZERO) == 0) {
            return "";
        }
        if (curValue.compareTo(curPrevData) > 0) {
            return incStr;
        }
        if (curValue.compareTo(curPrevData) < 0) {
            return redStr;
        }
        return "";
    }

    private ItemDataResult getItemValue(Long orgId, Long depreUseId, DynamicObject curperiod, boolean isDept, DynamicObject enableperiod, int limitCount) {
        ItemDataResult result = new ItemDataResult();
        if (curperiod == null || curperiod.getLong("id") < enableperiod.getLong("id")) {
            return result;
        }
        LinkedHashMap<String, ItemValue> itemMap = new LinkedHashMap<String, ItemValue>();
        List<HashMap<String, Object>> dataList = this.queryFinCard(orgId, depreUseId, curperiod, isDept, true);
        int size = dataList.size();
        BigDecimal totalValue = new BigDecimal(0);
        BigDecimal otherValue = new BigDecimal(0);
        ArrayList<String> otherType = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            HashMap<String, Object> dataMap = dataList.get(i);
            ItemValue value = null;
            String typename = (String)dataMap.get("typename");
            String type = dataMap.get("type").toString();
            BigDecimal curValue = (BigDecimal)dataMap.get("total");
            totalValue = totalValue.add(curValue);
            if (limitCount != 0 && i > limitCount) {
                otherValue = otherValue.add(curValue);
                otherType.add(type);
                continue;
            }
            value = new ItemValue(typename, (Number)curValue);
            itemMap.put(type, value);
        }
        if (limitCount != 0 && size > limitCount) {
            String otherName = ResManager.loadKDString((String)"\u5176\u4f59", (String)"MainPageAssetDistributionCard_10", (String)"fi-fa-formplugin", (Object[])new Object[0]);
            ItemValue endValue = new ItemValue(otherName, (Number)otherValue);
            itemMap.put(otherName, endValue);
        }
        result.total = totalValue;
        result.itemMap = itemMap;
        result.otherType = otherType;
        return result;
    }

    private ItemDataResult getPreItemValue(Long orgId, Long depreUseId, DynamicObject curperiodDy, boolean isDept, DynamicObject enableperiod, List<String> keys, int limitCount) {
        ItemDataResult result = new ItemDataResult();
        DynamicObject curperiod = FaBizUtils.queryYoYPeriod((Object)curperiodDy.getPkValue(), (int)0);
        if (curperiod == null || curperiod.getLong("id") < enableperiod.getLong("id")) {
            return result;
        }
        LinkedHashMap<String, ItemValue> itemMap = new LinkedHashMap<String, ItemValue>();
        List<HashMap<String, Object>> dataList = this.queryFinCard(orgId, depreUseId, curperiod, isDept, false);
        HashMap<String, HashMap<String, Object>> dataMap = new HashMap<String, HashMap<String, Object>>(dataList.size());
        for (HashMap<String, Object> hash : dataList) {
            dataMap.put(hash.get("type").toString(), hash);
        }
        int size = dataList.size();
        BigDecimal otherValue = new BigDecimal(0);
        BigDecimal totalValue = new BigDecimal(0);
        ArrayList<String> otherType = new ArrayList<String>();
        int curPos = 0;
        for (String type : keys) {
            HashMap curDataMap = (HashMap)dataMap.get(type);
            BigDecimal curValue = curDataMap == null ? new BigDecimal(0) : (BigDecimal)curDataMap.get("total");
            String curTypename = curDataMap == null ? "" : curDataMap.get("typename").toString();
            totalValue = totalValue.add(curValue);
            if (limitCount != 0 && curPos > limitCount) {
                otherValue = otherValue.add(curValue);
                otherType.add(type);
            } else {
                ItemValue item = new ItemValue(curTypename, (Number)curValue);
                itemMap.put(type, item);
            }
            ++curPos;
        }
        if (limitCount != 0 && size > limitCount) {
            String otherName = ResManager.loadKDString((String)"\u5176\u4f59", (String)"MainPageAssetDistributionCard_10", (String)"fi-fa-formplugin", (Object[])new Object[0]);
            ItemValue endValue = new ItemValue(otherName, (Number)otherValue);
            itemMap.put(otherName, endValue);
        }
        result.total = totalValue;
        result.itemMap = itemMap;
        result.otherType = otherType;
        return result;
    }

    private ItemDataResult adjustDataChartData(ItemDataResult itemData, int amtprecision) {
        ItemDataResult result = itemData;
        BigDecimal totalValue = itemData.total;
        BigDecimal totalForamtValue = new BigDecimal(0);
        for (String type : itemData.itemMap.keySet()) {
            BigDecimal curValue = (BigDecimal)itemData.itemMap.get(type).getValue();
            totalForamtValue = totalForamtValue.add(curValue.divide(this.THOUSAND, amtprecision, RoundingMode.HALF_UP).multiply(this.THOUSAND));
        }
        BigDecimal adjustValue = totalValue.subtract(totalForamtValue);
        int curPos = 0;
        for (String type : result.itemMap.keySet()) {
            ItemValue itemValue = result.itemMap.get(type);
            BigDecimal curValue = (BigDecimal)itemValue.getValue();
            if (curPos == 0) {
                curValue = curValue.divide(this.THOUSAND, amtprecision, RoundingMode.HALF_UP).multiply(this.THOUSAND).add(adjustValue);
            }
            itemValue.setValue((Number)curValue.divide(this.THOUSAND, amtprecision, RoundingMode.HALF_UP));
            ++curPos;
        }
        itemData.total = itemData.total.divide(this.THOUSAND, amtprecision, RoundingMode.HALF_UP);
        return result;
    }

    private List<HashMap<String, Object>> queryFinCard(Long orgId, Long depreUseId, DynamicObject curperiod, boolean isDept, boolean isCurrentPeriod) {
        Long curPeroidId = (Long)curperiod.getPkValue();
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter depreUseFilter = new QFilter("depreuse", "=", (Object)depreUseId);
        QFilter finCurPeroidFilter = new QFilter("bizperiod", "=", (Object)curPeroidId);
        QFilter finEndPeroidFilter = new QFilter("endperiod", ">", (Object)curPeroidId);
        QFilter finStartPeroidFilter = new QFilter("bizperiod", "<=", (Object)curPeroidId);
        QFilter periodFilter = new QFilter("clearperiod", "=", (Object)0L);
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)BillStatus.C.toString());
        QFilter[] filters = null;
        filters = isCurrentPeriod ? new QFilter[]{orgFilter, depreUseFilter, finStartPeroidFilter, finEndPeroidFilter, periodFilter, statusFilter} : new QFilter[]{orgFilter, depreUseFilter, finCurPeroidFilter, periodFilter, statusFilter};
        List<HashMap<String, Object>> dataList = this.countBill("fa_card_fin", filters, isDept);
        Collections.sort(dataList, new Comparator<HashMap<String, Object>>(){

            @Override
            public int compare(HashMap<String, Object> map1, HashMap<String, Object> map2) {
                return ((BigDecimal)map2.get("total")).compareTo((BigDecimal)map1.get("total"));
            }
        });
        return dataList;
    }

    private List<HashMap<String, Object>> countBill(String entityName, QFilter[] filter, boolean isDept) {
        List<Object> dataList = new ArrayList();
        dataList = isDept ? this.getDeptCountBill(entityName, filter) : this.getTypeCountBill(entityName, filter);
        return dataList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<HashMap<String, Object>> getDeptCountBill(String entityName, QFilter[] filter) {
        ArrayList<HashMap<String, Object>> dataList = new ArrayList<HashMap<String, Object>>();
        String type = "depredept type,depredept.name typename";
        try (DataSet fincard_dataset = null;){
            String sic = Fa.join((String)",", (String[])new String[]{"realcard rcardid", "netamount", type});
            fincard_dataset = QueryServiceHelper.queryDataSet((String)"fa.MainPageAssetDistributionCard.countBill", (String)entityName, (String)sic, (QFilter[])filter, (String)"id");
            DataSet endDataSet = fincard_dataset.groupBy(new String[]{"type", "typename"}).sum("netamount").finish();
            while (endDataSet.hasNext()) {
                HashMap<String, Object> dataMap = new HashMap<String, Object>();
                Row row = endDataSet.next();
                Long typeId = row.getLong("type");
                String typename = row.getString("typename");
                BigDecimal total = row.getBigDecimal("netamount");
                dataMap.put("type", typeId);
                dataMap.put("typename", typename);
                dataMap.put("total", total);
                dataList.add(dataMap);
            }
        }
        return dataList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<HashMap<String, Object>> getTypeCountBill(String entityName, QFilter[] filter) {
        ArrayList<HashMap<String, Object>> dataList = new ArrayList<HashMap<String, Object>>();
        String type = "assetcat type";
        DynamicObject[] categroys = BusinessDataServiceHelper.load((String)"fa_assetcategory", (String)"id,parent,name", null);
        Map<Long, DynamicObject> catagoryMap = Arrays.asList(categroys).stream().collect(Collectors.toMap(key -> key.getLong("id"), val -> val));
        Map<Long, Long> rootCategoryMap = this.getRootCategorys(categroys);
        try (DataSet fincard_dataset = null;){
            String sic = Fa.join((String)",", (String[])new String[]{"realcard rcardid", "netamount", type});
            fincard_dataset = QueryServiceHelper.queryDataSet((String)"fa.MainPageAssetDistributionCard.countBill", (String)entityName, (String)sic, (QFilter[])filter, (String)"id");
            HashMap<Long, BigDecimal> typeValueMap = new HashMap<Long, BigDecimal>();
            while (fincard_dataset.hasNext()) {
                Row row = fincard_dataset.next();
                Long typeId = row.getLong("type");
                if (!rootCategoryMap.containsKey(typeId)) continue;
                Long roottypeId = rootCategoryMap.get(typeId) == null ? typeId : rootCategoryMap.get(typeId);
                BigDecimal curValue = row.getBigDecimal("netamount");
                if (typeValueMap.containsKey(roottypeId)) {
                    curValue = row.getBigDecimal("netamount").add((BigDecimal)typeValueMap.get(roottypeId));
                }
                typeValueMap.put(roottypeId, curValue);
            }
            for (Map.Entry kv : typeValueMap.entrySet()) {
                HashMap<String, Object> dataMap = new HashMap<String, Object>();
                Long rootTypeId = (Long)kv.getKey();
                String typeName = catagoryMap.get(rootTypeId).getString("name");
                dataMap.put("type", rootTypeId);
                dataMap.put("typename", typeName);
                dataMap.put("total", kv.getValue());
                dataList.add(dataMap);
            }
        }
        return dataList;
    }

    private Map<Long, Long> getRootCategorys(DynamicObject[] categroys) {
        HashMap<Long, Long> rootLeafs = new HashMap<Long, Long>();
        int length = categroys.length;
        HashMap<Long, Long> tempMap = new HashMap<Long, Long>(length);
        for (int i = 0; i < length; ++i) {
            Long id = categroys[i].getLong("id");
            Long parent = categroys[i].getLong("parent.id");
            if (parent == null || parent == 0L) {
                parent = null;
            }
            tempMap.put(id, parent);
        }
        for (Map.Entry entry : tempMap.entrySet()) {
            Long key = (Long)entry.getKey();
            Long value = (Long)entry.getValue();
            if (value == null) {
                rootLeafs.put(key, value);
                continue;
            }
            Long rootid = this.getRootCategory(key, tempMap);
            rootLeafs.put(key, rootid);
        }
        return rootLeafs;
    }

    private Long getRootCategory(Long nowid, Map<Long, Long> typeMap) {
        Long parent = typeMap.get(nowid);
        if (parent != null) {
            return this.getRootCategory(parent, typeMap);
        }
        return nowid;
    }

    private void setDataPanelVisible(boolean isEmptyData) {
        this.getView().setVisible(Boolean.valueOf(isEmptyData), new String[]{PANEL_TYPE_EMPTY, PANEL_DEPT_EMPTY});
        this.getView().setVisible(Boolean.valueOf(!isEmptyData), new String[]{PANEL_TYPE, PANEL_DEPT});
    }
}

