/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.assetcard;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.AssistantProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.UserProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.calc.DynamicObjectWrapper;
import kd.fi.fa.business.calc.FinCardCalc;
import kd.fi.fa.business.calc.IObjWrapper;
import kd.fi.fa.business.cardgenerate.CardGenerateHelper;
import kd.fi.fa.cache.FaImportCardThreadCacheUtil;
import kd.fi.fa.common.util.Fa;

public class FaAssetCardImportPlugin
extends AbstractFormPlugin {
    public void initImportData(InitImportDataEventArgs e) {
        super.initImportData(e);
        List sourceDataList = e.getSourceDataList();
        int i = -1;
        for (Map dataMap : sourceDataList) {
            ++i;
            List finentry = (List)dataMap.get("finentry");
            int j = -1;
            for (Map finMap : finentry) {
                ++j;
                Object finPreusingamount = finMap.get("fin_preusingamount");
                BigDecimal preusingAmount = finPreusingamount instanceof BigDecimal ? (BigDecimal)finPreusingamount : new BigDecimal((String)finPreusingamount);
                if (BigDecimal.ZERO.compareTo(preusingAmount) != 0) continue;
                e.addCancelMessage(Integer.valueOf(i), Integer.valueOf(j), Integer.valueOf(0), ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u9884\u8ba1\u5bff\u547d\u3002", (String)"FaAssetCardImportPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        DynamicObject assetCard = this.getModel().getDataEntity(Boolean.TRUE.booleanValue());
        if (assetCard.getDataEntityType().getName().equals("fa_asset_initcard")) {
            assetCard.set("initialcard", (Object)true);
        }
        DynamicObjectCollection finentry = assetCard.getDynamicObjectCollection("finentry");
        ArrayList<DynamicObject> realCardList = new ArrayList<DynamicObject>(1);
        realCardList.add(assetCard);
        String entityName = this.getModel().getDataEntity().getDynamicObjectType().getName();
        Map finCardMap = CardGenerateHelper.generateFinCardForAssetCard(realCardList, (String)entityName);
        Map depreUseCardMap = (Map)finCardMap.get(assetCard.getLong("id"));
        if (finentry.size() > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8d44\u4ea7\u5361\u7247\u8d22\u52a1\u5206\u5f55\u6682\u4e0d\u652f\u6301\u5f55\u5165\u591a\u5f20\u8d22\u52a1\u5361\u7247\u3002", (String)"FaAssetCardImportPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"fa_assetbook", (String)"depreuse", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)assetCard.getLong(Fa.id((String)"org")))});
        Set depreUseIds = collection.stream().map(v -> v.getLong("depreuse")).collect(Collectors.toSet());
        if (!assetCard.getDataEntityState().getFromDatabase()) {
            assetCard.set("mergedcard", (Object)Boolean.TRUE);
        }
        assetCard.set("isimport", (Object)Boolean.TRUE);
        for (DynamicObject row : finentry) {
            DynamicObject periodType;
            DynamicObject depreUseFinCard;
            DataEntityPropertyCollection assetEntryImportProps = row.getDynamicObjectType().getProperties();
            long depreuseId = row.getLong("fin_depreuse.id");
            if (0L == depreuseId) continue;
            if (!depreUseIds.contains(depreuseId)) {
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u7684\u6240\u6709\u8d44\u4ea7\u8d26\u7c3f\u4e2d\u4e0d\u5b58\u5728\u5f55\u5165\u7684\u6298\u65e7\u7528\u9014\u3002", (String)"FaAssetCardImportPlugin_2", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            if (null != depreUseCardMap && depreUseCardMap.containsKey(depreuseId)) {
                depreUseFinCard = (DynamicObject)depreUseCardMap.get(depreuseId);
            } else {
                depreUseFinCard = row.getDynamicObject("fincard");
                depreUseFinCard.set("depredept", assetCard.get("headusedept"));
                depreUseFinCard.set("assetcat", assetCard.get("assetcat"));
            }
            Set finImpotyProps = ((List)e.getSourceData().get("finentry")).stream().map(Map::keySet).flatMap(Collection::stream).filter(v -> v.contains("fin_")).collect(Collectors.toSet());
            for (IDataEntityProperty importProp : assetEntryImportProps) {
                String importPropName = importProp.getName();
                if (!importPropName.contains("fin_") || importPropName.equals("fin_basecurrency") || importPropName.equals("fin_basecurrency_id") || !finImpotyProps.contains(importPropName)) continue;
                String[] finFieldSplit = importPropName.split("fin_");
                String finField = finFieldSplit[finFieldSplit.length - 1];
                if (importProp instanceof BasedataProp || importProp instanceof OrgProp || importProp instanceof UserProp || importProp instanceof AssistantProp) {
                    depreUseFinCard.set(finField + "_id", (Object)row.getLong(importPropName + ".id"));
                    depreUseFinCard.set(finField, (Object)row.getDynamicObject(importPropName));
                    continue;
                }
                if (importProp instanceof DateProp) {
                    depreUseFinCard.set(finField, (Object)row.getDate(importPropName));
                    continue;
                }
                if (importProp instanceof AmountProp || importProp instanceof DecimalProp) {
                    depreUseFinCard.set(finField, (Object)row.getBigDecimal(importPropName));
                    continue;
                }
                if (importProp instanceof BooleanProp) {
                    depreUseFinCard.set(finField, (Object)row.getBoolean(importPropName));
                    continue;
                }
                if (importProp instanceof LongProp) {
                    depreUseFinCard.set(finField, (Object)row.getLong(importPropName));
                    continue;
                }
                if (importProp instanceof IntegerProp) {
                    depreUseFinCard.set(finField, (Object)row.getInt(importPropName));
                    continue;
                }
                depreUseFinCard.set(finField, (Object)row.getString(importPropName));
            }
            DynamicObjectWrapper objWrapper = new DynamicObjectWrapper(depreUseFinCard);
            FinCardCalc.setNetWorth((IObjWrapper)objWrapper);
            FinCardCalc.setNetAmount((IObjWrapper)objWrapper);
            row.set("fincard", (Object)depreUseFinCard);
            row.set("fincard_id", (Object)depreUseFinCard.getLong("id"));
            if (!"fa_asset_card".equals(entityName)) continue;
            DynamicObject assetBook = depreUseFinCard.getDynamicObject("assetbook");
            if (assetBook.getDataEntityType().getProperties().containsKey((Object)"periodtype")) {
                periodType = depreUseFinCard.getDynamicObject("assetbook").getDynamicObject("periodtype");
            } else {
                DynamicObject loadAssetBook = FaImportCardThreadCacheUtil.getAssetBookById(assetBook.getPkValue());
                periodType = loadAssetBook.getDynamicObject("periodtype");
            }
            Date finAccountDate = depreUseFinCard.getDate("finaccountdate");
            DynamicObject bizPeriod = FaImportCardThreadCacheUtil.getBizPeriod(periodType.getPkValue(), finAccountDate);
            if (bizPeriod == null) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d22\u52a1\u5165\u8d26\u65e5\u671f\u201d%s\u201c\u5728\u7cfb\u7edf\u4e2d\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u671f\u95f4\uff0c\u8bf7\u7ef4\u62a4\u671f\u95f4\u540e\u518d\u8bd5\u3002", (String)"FaAssetCardImportPlugin_3", (String)"fi-fa-formplugin", (Object[])new Object[0]), dateFormat.format(finAccountDate)));
            }
            depreUseFinCard.set(Fa.id((String)"period"), bizPeriod.get("id"));
            depreUseFinCard.set(Fa.id((String)"bizperiod"), bizPeriod.get("id"));
            BigDecimal yearDepre = depreUseFinCard.getBigDecimal("addupyeardepre");
            if (yearDepre == null || BigDecimal.ZERO.compareTo(yearDepre) == 0) continue;
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u8d44\u4ea7\u5361\u7247\u3001\u8d22\u52a1\u5361\u7247\u4e0d\u652f\u6301\u5f15\u5165\u672c\u5e74\u7d2f\u8ba1\u6298\u65e7\u3002", (String)"FaAssetCardImportPlugin_4", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        new DataEntityCacheManager("t_fa_card_fin").removeByDt();
    }
}

