/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.assetcard;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AmountPrecision;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.datamodel.NumberPrecision;
import kd.bos.entity.list.QueryBuilder;
import kd.bos.entity.list.QueryResult;
import kd.bos.entity.list.SummaryResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.utils.AddUpYearDepreUtils;

public class FaAssetCardListFinDataProvider
extends ListDataProvider {
    private static final String FIN_PREFIX = "fin_";
    private static final String ENTRY_FIN_PREFIX = "finentry.fin_";
    private final String entryFinCardPropPrefix;
    private static final String PAGE_CACHE_CURRENCY = "fa_page_cache_currency";
    private final IFormView view;
    private static final String ENTRY_FIN = "finentry.";
    private final String finCardField;

    public FaAssetCardListFinDataProvider(IFormView view) {
        this.view = view;
        this.finCardField = "fa_asset_initcard".equals(((ListView)view).getBillFormId()) ? "originalfincard" : "fincard";
        this.entryFinCardPropPrefix = ENTRY_FIN + this.finCardField + ".";
    }

    public void setListFields(List<ListField> listFields) {
        super.setListFields(listFields);
        boolean containsFinProp = false;
        HashSet<String> hasFields = new HashSet<String>(listFields.size());
        for (ListField field : listFields) {
            String fieldName = field.getFieldName();
            hasFields.add(fieldName);
            if (!fieldName.startsWith(ENTRY_FIN_PREFIX)) continue;
            containsFinProp = true;
        }
        boolean containsFinCard = hasFields.contains(ENTRY_FIN + this.finCardField);
        if (containsFinProp && !containsFinCard) {
            ListField field;
            field = new ListField(this.finCardField);
            field.setFieldName(ENTRY_FIN + this.finCardField);
            listFields.add(field);
        }
    }

    public DynamicObjectCollection getData(int start, int limit) {
        DynamicObjectCollection dataRows = super.getData(start, limit);
        List listFields = this.getListFields();
        ArrayList<String> finFields = new ArrayList<String>(listFields.size());
        HashMap<String, String> fieldKeyMap = new HashMap<String, String>(listFields.size());
        for (ListField field : listFields) {
            String fieldKey = field.getKey();
            if (!fieldKey.startsWith(FIN_PREFIX)) continue;
            finFields.add(fieldKey);
            String listFieldKey = field.getFieldName();
            fieldKeyMap.put(fieldKey, listFieldKey);
        }
        if (finFields.isEmpty()) {
            return dataRows;
        }
        DataEntityPropertyCollection listProperties = dataRows.getDynamicObjectType().getProperties();
        Set listPropNameSet = listProperties.stream().map(IMetadata::getName).collect(Collectors.toSet());
        if (!listPropNameSet.contains(Fa.dot((String[])new String[]{"finentry", this.finCardField}))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5728\u5217\u8868\u4e0a\u914d\u7f6e \u8d22\u52a1\u5206\u5f55-\u8d22\u52a1\u5361\u7247\u57fa\u7840\u8d44\u6599 \u7684\u76f8\u5173\u5b57\u6bb5\u3002", (String)"FaAssetCardListFinDataProvider_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        String cacheCurrencyStr = this.view.getPageCache().get(PAGE_CACHE_CURRENCY);
        Map cacheCurrencyMap = 0 == start || StringUtils.isBlank((CharSequence)cacheCurrencyStr) ? new HashMap(4) : (Map)SerializationUtils.deSerializeFromBase64((String)cacheCurrencyStr);
        for (DynamicObject row : dataRows) {
            DynamicObject finCard = row.getDynamicObject(Fa.dot((String[])new String[]{"finentry", this.finCardField}));
            if (finCard == null) continue;
            DynamicObjectType finCardDt = finCard.getDynamicObjectType();
            for (String fieldKey : finFields) {
                DynamicObject currency;
                long currencyId;
                String finFieldKey = fieldKey.substring(FIN_PREFIX.length());
                DynamicProperty property = finCardDt.getProperty(finFieldKey);
                if (property == null) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5728\u8d22\u52a1\u5361\u7247\u57fa\u7840\u8d44\u6599\u4e2d\uff0c\u672a\u627e\u5230\u5b57\u6bb5[%s]\uff0c\u8bf7\u5728\u5f00\u53d1\u5e73\u53f0\u914d\u7f6e\u57fa\u7840\u8d44\u6599\u5f15\u7528\u8be5\u5c5e\u6027\u3002", (String)"FaAssetCardListFinDataProvider_1", (String)"fi-fa-formplugin", (Object[])new Object[0]), finFieldKey));
                }
                Object value = finCard.get(finFieldKey);
                String listFieldKey = (String)fieldKeyMap.get(fieldKey);
                row.set(listFieldKey, value);
                if (!"basecurrency".equals(finFieldKey) || cacheCurrencyMap.containsKey(currencyId = (currency = (DynamicObject)value).getLong("id"))) continue;
                cacheCurrencyMap.put(currencyId, currency);
            }
        }
        String formId = this.getQueryBuilder().getEntityName();
        AddUpYearDepreUtils.handleAddupYeardepreListField(dataRows, formId);
        cacheCurrencyStr = SerializationUtils.serializeToBase64(cacheCurrencyMap);
        this.view.getPageCache().put(PAGE_CACHE_CURRENCY, cacheCurrencyStr);
        return dataRows;
    }

    public QueryBuilder getQueryBuilder() {
        QFilter[] filters;
        QueryBuilder queryBuilder = super.getQueryBuilder();
        for (QFilter filter : filters = queryBuilder.getFilters()) {
            String property;
            if (filter == null || !(property = filter.getProperty()).startsWith(ENTRY_FIN_PREFIX)) continue;
            String finFieldKey = property.substring(ENTRY_FIN_PREFIX.length());
            filter.__setProperty(this.entryFinCardPropPrefix + finFieldKey);
        }
        return queryBuilder;
    }

    public String getOrderByExpr() {
        String orderByExpr = super.getOrderByExpr();
        if (orderByExpr != null) {
            orderByExpr = orderByExpr.replaceAll(ENTRY_FIN_PREFIX, this.entryFinCardPropPrefix);
        }
        return orderByExpr;
    }

    public QueryResult getQueryResult() {
        QueryResult rs = super.getQueryResult();
        String cacheCurrencyStr = this.view.getPageCache().get(PAGE_CACHE_CURRENCY);
        HashMap cacheCurrencyMap = StringUtils.isBlank((CharSequence)cacheCurrencyStr) ? new HashMap(4) : (HashMap)SerializationUtils.deSerializeFromBase64((String)cacheCurrencyStr);
        List summaryResults = rs.getSummaryResults();
        for (SummaryResult result : summaryResults) {
            NumberPrecision numberPrecision = result.getNumberPrecision();
            if (!(numberPrecision instanceof AmountPrecision) || cacheCurrencyMap.size() != 1) continue;
            DynamicObject currency = (DynamicObject)cacheCurrencyMap.values().iterator().next();
            String sign = currency.getString("sign");
            int precision = currency.getInt("amtprecision");
            NumberPrecision summary = result.getNumberPrecision();
            summary.setGroupingUsed(true);
            summary.setShowSign(true);
            summary.setPrecision(precision);
            summary.setSign(sign);
            summary.setStripTrailingZeros(false);
        }
        return rs;
    }

    public List<SummaryResult> getSummaryResults() {
        List summaryResults = super.getSummaryResults();
        List listFields = this.getListFields();
        HashSet<Object> summaryFields = new HashSet<Object>(listFields.size());
        for (ListField field : listFields) {
            int summary;
            String fieldKey = field.getKey();
            if (!fieldKey.startsWith(FIN_PREFIX) || 1 != (summary = field.getSummary())) continue;
            Object finFieldKey = fieldKey.substring(FIN_PREFIX.length());
            finFieldKey = this.entryFinCardPropPrefix + (String)finFieldKey;
            summaryFields.add(finFieldKey);
        }
        if (summaryFields.isEmpty()) {
            return summaryResults;
        }
        QFilter[] filters = this.getQueryBuilder().getFilters();
        String selectFields = String.join((CharSequence)",", summaryFields);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)FaAssetCardListFinDataProvider.class.getName(), (String)"fa_asset_card", (String)selectFields, (QFilter[])filters, null);
        GroupbyDataSet groupbyDataSet = dataSet.groupBy(null);
        for (String string : summaryFields) {
            groupbyDataSet.sum(string);
        }
        DataSet resultDataSet = groupbyDataSet.finish();
        if (!resultDataSet.hasNext()) {
            return summaryResults;
        }
        Row row = resultDataSet.next();
        for (SummaryResult result : summaryResults) {
            String fieldName = result.getFieldName();
            if (!fieldName.startsWith(FIN_PREFIX)) continue;
            String finFieldKey = fieldName.substring(FIN_PREFIX.length());
            String assetFinEntryFieldKey = this.entryFinCardPropPrefix + finFieldKey;
            BigDecimal sumValue = row.getBigDecimal(assetFinEntryFieldKey);
            NumberPrecision summary = new NumberPrecision(sumValue);
            result.setNumberPrecision(summary);
        }
        return summaryResults;
    }
}

