/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.assetcard;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.AssistantProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.UserProp;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.JSONUtils;
import kd.fi.fa.business.utils.FaPermissionUtils;
import kd.fi.fa.business.utils.FaUtils;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.formplugin.assetcard.FaAssetCardListFinDataProvider;
import kd.fi.fa.utils.AddUpYearDepreUtils;

public class FaAssetCardListPlugin
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(FaAssetCardListPlugin.class);
    private static final String CALL_BACK_CLOSE_ASSET_CARD = "closeAssetCardForm";
    static final String SHOW_FORM_PARAM_FIN_ID = "finCardId";
    private static final String BTN_CLEAR_FIN_CACHE = "clearfincache";
    private static final String IS_CLICK_ORG = "isClickOrg";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{BTN_CLEAR_FIN_CACHE});
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List filters = e.getQFilters();
        QFilter cardFilter = new QFilter("mergedcard", "=", (Object)Boolean.TRUE).or(new QFilter("mergedcard", "=", (Object)Boolean.FALSE).and("billstatus", "=", (Object)BillStatus.C.name()));
        filters.add(cardFilter);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        String mainPageFilterStr = (String)paramMap.get("defortFilter");
        if (mainPageFilterStr != null) {
            QFilter mainPageFilter = QFilter.fromSerializedString((String)mainPageFilterStr);
            filters.add(mainPageFilter);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new FaAssetCardListFinDataProvider(this.getView()));
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName = args.getFieldName();
        if (String.join((CharSequence)"_", "fincard", "depreuse", "name").equals(fieldName)) {
            args.setCancel(true);
            this.showAssetCardEditForm(args);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if (CALL_BACK_CLOSE_ASSET_CARD.equals(actionId)) {
            this.getView().updateView("billlistap");
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (BTN_CLEAR_FIN_CACHE.equals(itemKey)) {
            new DataEntityCacheManager("t_fa_card_fin").removeByDt();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6e05\u9664\u8d22\u52a1\u5361\u7247\u7f13\u5b58\u6210\u529f\u3002", (String)"FaAssetCardListPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        Object sFilter = paramMap.get("filter");
        if (sFilter == null) {
            sFilter = paramMap.get("defortFilter");
        }
        QFilter filters = null;
        QFilter[] filters2 = null;
        if (sFilter != null) {
            filters = QFilter.fromSerializedString((String)(sFilter + ""));
            filters2 = filters.recombine();
        }
        List listFilterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn listFilter : listFilterColumns) {
            List billStatusFilters;
            CommonFilterColumn commFilter = (CommonFilterColumn)listFilter;
            String field = commFilter.getFieldName();
            if ("org.name".equals(field) || "org.number".equals(field) || "org.id".equals(field)) {
                List<Long> linkQueryOrgIds = this.getLinkQueryId("org");
                String defaultOrgid = "";
                String orgFilterObjId = (String)paramMap.get("org");
                String entityId = ((FilterContainer)args.getFilterContainerInitEvent().getSource()).getEntityId();
                List comboItems = FaPermissionUtils.getAllEnableBookAndPermissionOrgsCombosV2((String)this.getView().getPageId(), (String)entityId);
                commFilter.setComboItems(comboItems);
                if (comboItems.size() <= 0) continue;
                if (orgFilterObjId != null) {
                    defaultOrgid = orgFilterObjId;
                } else if (linkQueryOrgIds.size() > 0) {
                    defaultOrgid = linkQueryOrgIds.get(0).toString();
                    commFilter.setComboItems(FaPermissionUtils.getLeafOrgCombos(linkQueryOrgIds));
                    commFilter.setDefaultValue(defaultOrgid);
                } else {
                    defaultOrgid = FaUtils.getDefaultOrgId((List)comboItems);
                }
                this.getPageCache().put("org", defaultOrgid);
                if (!StringUtils.isEmpty((CharSequence)this.getPageCache().get(IS_CLICK_ORG))) continue;
                if (sFilter != null) {
                    String transOrg = Stream.of(filters2).filter(v -> v.getProperty().equalsIgnoreCase("org")).map(v -> v.getValue()).map(Object::toString).reduce("", String::concat);
                    commFilter.setDefaultValue(transOrg);
                    continue;
                }
                commFilter.setDefaultValue(defaultOrgid);
                continue;
            }
            if ("realaccountdate".equals(field)) {
                if (sFilter == null) continue;
                commFilter.setDefValue("");
                commFilter.setDefaultValue("");
                continue;
            }
            if (!"billstatus".equals(field) || filters2 == null || (billStatusFilters = Stream.of(filters2).filter(v -> v.getProperty().equals("billstatus")).collect(Collectors.toList())).isEmpty()) continue;
            String cp = ((QFilter)billStatusFilters.get(0)).getCP();
            String value = ((QFilter)billStatusFilters.get(0)).getValue().toString();
            ArrayList defaultVals = new ArrayList(4);
            if ("!=".equals(cp)) {
                commFilter.getComboItems().stream().filter(item -> !item.getValue().equals(value)).forEach(item -> defaultVals.add(item.getValue()));
            } else {
                commFilter.getComboItems().stream().filter(item -> item.getValue().equals(value)).forEach(item -> defaultVals.add(item.getValue()));
            }
            commFilter.setDefaultValues(defaultVals);
        }
    }

    private void showAssetCardEditForm(HyperLinkClickArgs args) {
        BillListHyperLinkClickEvent evt = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        Object assetCardId = evt.getCurrentRow().getPrimaryKeyValue();
        long entryId = (Long)evt.getCurrentRow().getEntryPrimaryKeyValue();
        String billFormId = ((ListView)this.getView()).getEntityTypeId();
        boolean isInitAssetCardView = "fa_asset_initcard".equals(billFormId);
        String finCardField = isInitAssetCardView ? "originalfincard" : "fincard";
        String selectFields = Fa.dot((String[])new String[]{"finentry", finCardField});
        DynamicObject assetCard = BusinessDataServiceHelper.loadSingleFromCache((Object)assetCardId, (String)"fa_asset_card", (String)selectFields);
        long finCardId = 0L;
        DynamicObjectCollection finEntry = assetCard.getDynamicObjectCollection("finentry");
        if (CollectionUtils.isEmpty((Collection)finEntry)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8d22\u52a1\u5361\u7247\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u6838\u5b9e\u3002", (String)"FaAssetCardListPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        for (DynamicObject row : finEntry) {
            DynamicObject finCard = row.getDynamicObject(finCardField);
            if (finCard == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8d22\u52a1\u5361\u7247\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u6838\u5b9e\u3002", (String)"FaAssetCardListPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            }
            long rowPkValue = (Long)row.getPkValue();
            if (rowPkValue != entryId) continue;
            finCardId = finCard.getLong("id");
        }
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(billFormId);
        showParameter.setPkId(assetCardId);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALL_BACK_CLOSE_ASSET_CARD));
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.setCustomParam(SHOW_FORM_PARAM_FIN_ID, (Object)finCardId);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void afterQueryOfExport(AfterQueryOfExportEvent e) {
        DynamicObject[] assertCards;
        DynamicObject[] datas = e.getQueryValues();
        HashMap<Long, DynamicObject> realFinMap = new HashMap<Long, DynamicObject>(1);
        ArrayList<Long> realCardIds = new ArrayList<Long>(1);
        String billId = "";
        for (DynamicObject data : datas) {
            long realCardId = data.getLong("id");
            realCardIds.add(realCardId);
            billId = data.getDataEntityType().getName();
        }
        String finCardField = "fincard";
        if ("fa_asset_initcard".equals(billId)) {
            finCardField = "originalfincard";
        }
        for (DynamicObject assertCard : assertCards = BusinessDataServiceHelper.load((String)billId, (String)("id,finentry,finentry." + finCardField), (QFilter[])new QFilter("id", "in", realCardIds).toArray())) {
            DynamicObjectCollection finCardEntry = assertCard.getDynamicObjectCollection("finentry");
            for (DynamicObject row : finCardEntry) {
                DynamicObject finCard = row.getDynamicObject(finCardField);
                realFinMap.put(row.getLong("id"), finCard);
            }
        }
        HashMap<Long, DynamicObject> id2FinCardMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject data : datas) {
            DynamicObjectCollection finCardEntry = (DynamicObjectCollection)data.get(Fa.dot((String[])new String[]{"finentry"}));
            if (finCardEntry.isEmpty()) continue;
            boolean isHaveAddupyeardepreField = ((DynamicObject)finCardEntry.get(0)).containsProperty("fin_addupyeardepre");
            for (DynamicObject row : finCardEntry) {
                if (!realFinMap.containsKey(row.getLong("id"))) continue;
                DynamicObject finCard = (DynamicObject)realFinMap.get(row.getLong("id"));
                if (isHaveAddupyeardepreField) {
                    id2FinCardMap.put((Long)finCard.getPkValue(), row);
                }
                DataEntityPropertyCollection assetEntryExportProps = row.getDynamicObjectType().getProperties();
                for (IDataEntityProperty exportProp : assetEntryExportProps) {
                    String exportPropName = exportProp.getName();
                    String[] finFieldSplit = exportPropName.split("fin_");
                    String finField = finFieldSplit[finFieldSplit.length - 1];
                    if (!exportPropName.contains("fin_")) continue;
                    if (exportProp instanceof BasedataProp || exportProp instanceof OrgProp || exportProp instanceof UserProp || exportProp instanceof AssistantProp) {
                        row.set(exportPropName, (Object)finCard.getDynamicObject(finField));
                        continue;
                    }
                    if (exportProp instanceof DateProp) {
                        row.set(exportPropName, (Object)finCard.getDate(finField));
                        continue;
                    }
                    if (exportProp instanceof AmountProp || exportProp instanceof DecimalProp) {
                        row.set(exportPropName, (Object)finCard.getBigDecimal(finField));
                        continue;
                    }
                    if (exportProp instanceof BooleanProp) {
                        row.set(exportPropName, (Object)finCard.getBoolean(finField));
                        continue;
                    }
                    if (exportProp instanceof LongProp) {
                        row.set(exportPropName, (Object)finCard.getLong(finField));
                        continue;
                    }
                    if (exportProp instanceof IntegerProp) {
                        row.set(exportPropName, (Object)finCard.getInt(finField));
                        continue;
                    }
                    row.set(exportPropName, (Object)finCard.getString(finField));
                }
                DynamicObject currency = BusinessDataServiceHelper.loadSingleFromCache((Object)finCard.getLong(Fa.id((String)"basecurrency")), (String)"bd_currency");
                if (assetEntryExportProps.containsKey((Object)"fin_basecurrency")) {
                    row.set("fin_basecurrency", (Object)currency);
                }
                if (!assetEntryExportProps.containsKey((Object)"fin_currency")) continue;
                DynamicObject currency1 = BusinessDataServiceHelper.loadSingleFromCache((Object)finCard.getLong(Fa.id((String)"currency")), (String)"bd_currency");
                row.set("fin_currency", (Object)currency1);
            }
        }
        List<Long> addupyeardepreSetZeroFinCardIdList = AddUpYearDepreUtils.getAddupyeardepreSetZeroFinCardIdList(id2FinCardMap);
        for (Long findCardId : addupyeardepreSetZeroFinCardIdList) {
            DynamicObject findCard = (DynamicObject)id2FinCardMap.get(findCardId);
            if (Objects.isNull(findCard)) continue;
            findCard.set("fin_addupyeardepre", (Object)BigDecimal.ZERO);
        }
    }

    private List<Long> getLinkQueryId(String type) {
        String linkQueryInfoJson = this.getPageCache().get("filtercontainerap_linkQueryPkIdCollection");
        List linkQueryInfoList = Collections.EMPTY_LIST;
        ArrayList<Long> rsList = new ArrayList<Long>();
        HashSet<Long> orgSet = new HashSet<Long>();
        try {
            if (!kd.bos.util.StringUtils.isBlank((String)linkQueryInfoJson)) {
                linkQueryInfoList = (List)JSONUtils.cast((String)linkQueryInfoJson, List.class);
            }
        }
        catch (IOException e) {
            logger.error("kd.fi.fa.formplugin.FaAssetCardListPlugin\uff1a\u8f6c\u6362\u7f13\u5b58\u4e2d\u7684\u8054\u67e5\u4fe1\u606f\u65f6\u51fa\u9519", (Throwable)e);
        }
        if (!linkQueryInfoList.isEmpty()) {
            DynamicObject[] finCards;
            HashSet pkIds = new HashSet();
            linkQueryInfoList.stream().forEach(r -> {
                Long pkId = (Long)((Map)r).get("pkId");
                pkIds.add(pkId);
            });
            QFilter[] filters = new QFilter[]{new QFilter("id", "in", pkIds)};
            for (DynamicObject finCard : finCards = BusinessDataServiceHelper.load((String)"fa_asset_card", (String)"org", (QFilter[])filters)) {
                orgSet.add(finCard.getLong("org.id"));
            }
            if ("org".equals(type)) {
                rsList.addAll(orgSet);
            }
        }
        return rsList;
    }
}

